/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.InfoMessage;
import at.cdes.impl.dao.GenInfoMessageDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcInfoMessageDAO
extends AbstrIdDAO<InfoMessage>
implements GenInfoMessageDAO {
    public AbstractJdbcInfoMessageDAO() {
        super(InfoMessage.class, "id", "info_message", new String[]{"id", "record_date", "start_date", "end_date", "headline", "content"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcInfoMessageDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "record_date") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "start_date") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "end_date") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "headline") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "content") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcInfoMessageDAO.getSelectClauseForDto("info_message", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcInfoMessageDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".record_date" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "record_date") + "," + entityLocalName + ".start_date" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "start_date") + "," + entityLocalName + ".end_date" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "end_date") + "," + entityLocalName + ".headline" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "headline") + "," + entityLocalName + ".content" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "content") + " ";
    }

    protected InfoMessage fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        InfoMessage infoMessage = new InfoMessage();
        infoMessage.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        infoMessage.setRecordDate(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        infoMessage.setStartDate(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        infoMessage.setEndDate(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        infoMessage.setHeadline(rs.getString(++columnIndex));
        infoMessage.setContent(AbstractJdbcInfoMessageDAO.getStringWithoutException(rs.getBytes(++columnIndex)));
        return infoMessage;
    }

    public static InfoMessage fillInfoMessageFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        InfoMessage infoMessage = new InfoMessage();
        infoMessage.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        infoMessage.setRecordDate(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        infoMessage.setStartDate(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        infoMessage.setEndDate(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        infoMessage.setHeadline(rs.getString(columnIndex.incrementAndGet()));
        infoMessage.setContent(AbstractJdbcInfoMessageDAO.getStringWithoutException(rs.getBytes(columnIndex.incrementAndGet())));
        return infoMessage;
    }

    public static InfoMessage fillInfoMessageFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcInfoMessageDAO.fillInfoMessageFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 6;
    }

    public int update(InfoMessage dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<InfoMessage> dtos) {
        Iterator<InfoMessage> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, InfoMessage infoMessage) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)infoMessage.getId());
        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)2, (Double)infoMessage.getRecordDate());
        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)3, (Double)infoMessage.getStartDate());
        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)4, (Double)infoMessage.getEndDate());
        statement.setString(5, infoMessage.getHeadline());
        statement.setBytes(6, infoMessage.getContent() == null ? null : AbstractJdbcInfoMessageDAO.getBytesWithoutException(infoMessage.getContent()));
    }
}

