/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.service;

import at.cdes.api.certificate.CertificateGenerator;
import at.cdes.api.compositeDto.CertificateSearchResult;
import at.cdes.api.compositeDto.EmailContext;
import at.cdes.api.dto.Ca;
import at.cdes.api.dto.Certificate;
import at.cdes.api.dto.CertificateRequest;
import at.cdes.api.dto.CertificateSearchModel;
import at.cdes.api.dto.Country;
import at.cdes.api.dto.Email;
import at.cdes.api.dto.EmailAttachment;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.SupportContact;
import at.cdes.api.guiService.CertificateService;
import at.cdes.api.joinDto.CertificateJoin;
import at.cdes.api.joinDto.CertificateRequestJoin;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.sec.PasswordStatus;
import at.cdes.api.sec.PasswordStatusChecker;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.CaDAO;
import at.cdes.impl.dao.CertificateDAO;
import at.cdes.impl.dao.CertificateRequestDAO;
import at.cdes.impl.dao.EmailAttachmentDAO;
import at.cdes.impl.dao.NetworkDAO;
import at.cdes.impl.dao.OrganisationDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.PersonDAO;
import at.cdes.impl.dao.SupportContactDAO;
import at.cdes.impl.dao.unionComponent.CertificateJoinComponent;
import at.cdes.impl.email.EmailUtils;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.sec.util.SecurityHelper;
import at.cdes.impl.util.ActionHelper;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.PersonHelper;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.clazzes.util.aop.ThreadLocalManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateServiceImpl
implements CertificateService {
    private static final Logger log = LoggerFactory.getLogger(CertificateServiceImpl.class);
    private ActionDAO actionDAO;
    private String applicationUrlThreadLocalKey;
    private CaDAO caDAO;
    private String cdesTapestryAppPath;
    private CertificateDAO certificateDAO;
    private CertificateRequestDAO certificateRequestDAO;
    private Integer certUserCertYears;
    private CertificateGenerator certificateGenerator;
    private EmailUtils emailUtils;
    private NetworkDAO networkDAO;
    private EmailAttachmentDAO emailAttachmentDAO;
    private String manualLink;
    private OrganisationPersonDAO organisationPersonDAO;
    private OrganisationDAO organisationDAO;
    private PersonDAO personDAO;
    private Boolean enableCustomerLogo;
    private String costumerLabel;
    private String userPolicyPath;
    private Integer userPolicyVersion;
    private String userPolicyEmail;
    private Instant userPolicyDeadline;
    private Boolean certificateAdministrationGlobal;
    private SupportContactDAO supportContactDAO;
    private PasswordStatusChecker passwordStatusChecker;
    private Integer passwordExpireExtendInterval;

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setApplicationUrlThreadLocalKey(String applicationUrlThreadLocalKey) {
        this.applicationUrlThreadLocalKey = applicationUrlThreadLocalKey;
    }

    public void setCaDAO(CaDAO caDAO) {
        this.caDAO = caDAO;
    }

    public void setCdesTapestryAppPath(String cdesTapestryAppPath) {
        this.cdesTapestryAppPath = cdesTapestryAppPath;
    }

    public void setCertificateDAO(CertificateDAO certificateDAO) {
        this.certificateDAO = certificateDAO;
    }

    public void setCertificateRequestDAO(CertificateRequestDAO certificateRequestDAO) {
        this.certificateRequestDAO = certificateRequestDAO;
    }

    public void setCertUserCertYears(Integer certUserCertYears) {
        this.certUserCertYears = certUserCertYears;
    }

    public void setCertificateGenerator(CertificateGenerator certificateGenerator) {
        this.certificateGenerator = certificateGenerator;
    }

    public void setEmailUtils(EmailUtils emailUtils) {
        this.emailUtils = emailUtils;
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    public void setEmailAttachmentDAO(EmailAttachmentDAO emailAttachmentDAO) {
        this.emailAttachmentDAO = emailAttachmentDAO;
    }

    public void setManualLink(String manualLink) {
        this.manualLink = manualLink;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setOrganisationDAO(OrganisationDAO organisationDAO) {
        this.organisationDAO = organisationDAO;
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    public void setEnableCustomerLogo(Boolean enableCustomerLogo) {
        this.enableCustomerLogo = enableCustomerLogo;
    }

    public void setCostumerLabel(String costumerLabel) {
        this.costumerLabel = costumerLabel;
    }

    public void setUserPolicyPath(String userPolicyPath) {
        this.userPolicyPath = userPolicyPath;
    }

    public void setUserPolicyVersion(Integer userPolicyVersion) {
        this.userPolicyVersion = userPolicyVersion;
    }

    public void setUserPolicyEmail(String userPolicyEmail) {
        this.userPolicyEmail = userPolicyEmail;
    }

    public void setUserPolicyDeadline(String userPolicyDeadline) {
        if (userPolicyDeadline != null && userPolicyDeadline.length() > 0) {
            this.userPolicyDeadline = LocalDate.parse(userPolicyDeadline, DateTimeFormatter.ofPattern("dd.MM.yyyy")).plusDays(1L).atStartOfDay(ZoneId.systemDefault()).toInstant();
        }
    }

    public void setCertificateAdministrationGlobal(Boolean certificateAdministrationGlobal) {
        this.certificateAdministrationGlobal = certificateAdministrationGlobal;
    }

    public void setSupportContactDAO(SupportContactDAO supportContactDAO) {
        this.supportContactDAO = supportContactDAO;
    }

    public void setPasswordStatusChecker(PasswordStatusChecker passwordStatusChecker) {
        this.passwordStatusChecker = passwordStatusChecker;
    }

    public void setPasswordExpireExtendInterval(Integer passwordExpireExtendInterval) {
        this.passwordExpireExtendInterval = passwordExpireExtendInterval;
    }

    public List<Ca> getValidUserCas(Long organisationPersonId, Long certificateRequestId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        CertificateRequest certificateRequest = null;
        Long certificateRequestNetworkId = null;
        if (certificateRequestId != null) {
            certificateRequest = (CertificateRequest)this.certificateRequestDAO.get(certificateRequestId);
            certificateRequestNetworkId = certificateRequest.getNetworkId();
        }
        List<Network> networksToAdmin = this.networkDAO.getNetworksToAdmin(organisationPersonId);
        ArrayList<Ca> ret = new ArrayList<Ca>();
        for (Network networkToAdmin : networksToAdmin) {
            if (certificateRequestNetworkId != null && !certificateRequestNetworkId.equals(networkToAdmin.getId())) continue;
            ret.addAll(this.caDAO.getValidUserCas(networkToAdmin.getId()));
        }
        return ret;
    }

    public CertificateSearchResult getCertificateJoin(Long contextOrganisationPersonId, CertificateSearchModel searchModel) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, contextOrganisationPersonId);
        Map<Long, Set<Action>> networkIdToActions = this.actionDAO.getNetworkActions(contextOrganisationPersonId, Action.EDIT_PERSON, Action.EDIT_ORGANISATION_PERSON);
        Set<Action> globalActions = this.actionDAO.getGlobalActions(contextOrganisationPersonId, Action.ADMINISTRATE_CERTIFICATE);
        List<CertificateJoin> certificatesBeforeFilter = this.certificateDAO.getCertificateJoin(searchModel);
        HashSet<Long> foundCertificates = new HashSet<Long>();
        ArrayList<CertificateJoin> certificates = new ArrayList<CertificateJoin>();
        for (CertificateJoin certificateJoin : certificatesBeforeFilter) {
            if (certificateJoin.getUnionClause().intValue() == CertificateJoinComponent.CERTIFICATES.getValue()) {
                if (foundCertificates.contains(certificateJoin.getCertificateId())) continue;
                Long networkId = certificateJoin.getNetworkId();
                if (this.certificateAdministrationGlobal.booleanValue() && !globalActions.contains(Action.ADMINISTRATE_CERTIFICATE) || !this.certificateAdministrationGlobal.booleanValue() && (!networkIdToActions.containsKey(networkId) || !networkIdToActions.get(networkId).contains(Action.EDIT_PERSON))) continue;
                foundCertificates.add(certificateJoin.getCertificateId());
                certificates.add(certificateJoin);
                continue;
            }
            certificates.add(certificateJoin);
        }
        HashMap<Object, Double> organisationPersonIdToMaxValidFrom = new HashMap<Object, Double>();
        HashMap<Object, Long> organisationPersonIdToCertificateId = new HashMap<Object, Long>();
        HashSet<Long> organisationPersonIds = new HashSet<Long>();
        for (CertificateJoin certificateJoin : certificates) {
            Long organisationPersonId = certificateJoin.getOrganisationPersonId();
            if (certificateJoin.getUnionClause().intValue() != CertificateJoinComponent.WITHOUT_CERTIFICATE.getValue()) {
                organisationPersonIds.add(certificateJoin.getOrganisationPersonId());
                continue;
            }
            Double certValidFrom = certificateJoin.getCertificateCertValidFrom();
            Long certificateId = certificateJoin.getCertificateId();
            if (certificateId == null || certValidFrom == null) continue;
            if (organisationPersonIdToCertificateId.containsKey(organisationPersonId)) {
                Double oldValue = (Double)organisationPersonIdToMaxValidFrom.get(organisationPersonId);
                organisationPersonIdToMaxValidFrom.put(organisationPersonId, Math.max(oldValue, certValidFrom));
                organisationPersonIdToCertificateId.put(organisationPersonId, certificateId);
                continue;
            }
            organisationPersonIdToMaxValidFrom.put(organisationPersonId, certValidFrom);
            organisationPersonIdToCertificateId.put(organisationPersonId, certificateId);
        }
        ArrayList<CertificateJoin> returnedJoins = new ArrayList<CertificateJoin>();
        HashSet<Long> organisationPersonIdsAlreadyAdded = new HashSet<Long>();
        for (CertificateJoin certificateJoin : certificates) {
            List<CertificateJoin> previousCertificates;
            Long organisationPersonId = certificateJoin.getOrganisationPersonId();
            if (certificateJoin.getUnionClause().intValue() == CertificateJoinComponent.WITHOUT_CERTIFICATE.getValue() && (organisationPersonIds.contains(certificateJoin.getOrganisationPersonId()) || !organisationPersonIdToCertificateId.containsKey(organisationPersonId) || certificateJoin.getCertificateCertValidFrom() == null || ((Long)organisationPersonIdToCertificateId.get(organisationPersonId)).longValue() != certificateJoin.getCertificateId().longValue()) && (certificateJoin.getCertificateId() != null || organisationPersonIdToCertificateId.containsKey(certificateJoin.getOrganisationPersonId()))) continue;
            if (certificateJoin.getPersonPassword() != null && certificateJoin.getPersonPassword().length() > 0) {
                PasswordStatus passwordStatus = this.passwordStatusChecker.checkPasswordStatus(certificateJoin.getPersonId(), certificateJoin.getPersonLastPasswordChangeTs());
                if (passwordStatus == PasswordStatus.EXPIRED) {
                    certificateJoin.setPersonPassword("EXPIRED");
                } else if (passwordStatus == PasswordStatus.WARN) {
                    certificateJoin.setPersonPassword("WILL_EXPIRE");
                } else {
                    certificateJoin.setPersonPassword("Given");
                }
            } else {
                certificateJoin.setPersonPassword(null);
            }
            if (certificateJoin.getNetworkName() == null && certificateJoin.getNetworkOrganisationNetworkId() != null) {
                Network organisationPersonsNetwork = (Network)this.networkDAO.get(certificateJoin.getNetworkOrganisationNetworkId());
                certificateJoin.setNetworkName(organisationPersonsNetwork.getName());
            }
            if (certificateJoin.getCertificateId() == null && certificateJoin.getUnionClause().intValue() == CertificateJoinComponent.WITHOUT_CERTIFICATE.getValue()) {
                previousCertificates = this.certificateDAO.getCertificateJoinByPerson(certificateJoin.getPerson().getId());
                CertificateJoin previousCertificateJoin = null;
                if (!previousCertificates.isEmpty()) {
                    previousCertificateJoin = previousCertificates.get(0);
                    certificateJoin.setCertificateId(previousCertificateJoin.getCertificateId());
                    if (previousCertificateJoin.getCertificateRequestId() != null) {
                        certificateJoin.setCertificateRequestId(previousCertificateJoin.getCertificateRequestId());
                        certificateJoin.setCertificateRequestRequestType(previousCertificateJoin.getCertificateRequestRequestType());
                        certificateJoin.setCertificateRequestCreatedFor(previousCertificateJoin.getCertificateRequestCreatedFor());
                    } else {
                        certificateJoin.setCertificateRequestId(previousCertificateJoin.getCertificateId());
                    }
                    certificateJoin.setUnionClause(Integer.valueOf(CertificateJoinComponent.WITHOUT_CERTIFICATE_OlDREQUEST.getValue()));
                }
            }
            if (certificateJoin.getCertificateId() != null && certificateJoin.getCertificateRequestId() == null && certificateJoin.getUnionClause().intValue() == CertificateJoinComponent.CERTIFICATES.getValue()) {
                log.info("---WARNING--- certificateRequestId == null for certificateId = " + certificateJoin.getCertificateId());
                previousCertificates = this.certificateDAO.getCertificateRequestJoinsWithRequestsByPerson(certificateJoin.getPerson().getId());
                boolean found = false;
                if (!previousCertificates.isEmpty()) {
                    Certificate cert;
                    for (CertificateRequestJoin certificateRequestJoin : previousCertificates) {
                        log.info("previousCertificate: certificateId = " + certificateRequestJoin.getCertificateId() + " certificateRequestId = " + certificateRequestJoin.getCertificateRequestId() + " certificateRequestRequestType = " + certificateRequestJoin.getCertificateRequestRequestType());
                        if (certificateRequestJoin.getCertificateId() == null || certificateRequestJoin.getCertificateId().equals(certificateJoin.getCertificateId()) || !certificateRequestJoin.getCertificateOrganisationPersonId().equals(certificateJoin.getOrganisationPersonId()) || certificateRequestJoin.getCertificateRequestId() == null || !certificateRequestJoin.getCertificateRequestRequestType().equals("Accepted")) continue;
                        log.info("updating missing certificateRequestId for certificateId = " + certificateJoin.getCertificateId());
                        certificateJoin.setCertificateRequestId(certificateRequestJoin.getCertificateRequestId());
                        cert = (Certificate)this.certificateDAO.get(certificateJoin.getCertificateId());
                        cert.setCertificateRequestId(certificateRequestJoin.getCertificateRequestId());
                        this.certificateDAO.update(cert);
                        found = true;
                        break;
                    }
                    if (!found) {
                        for (CertificateRequestJoin certificateRequestJoin : previousCertificates) {
                            log.info("previousCertificate: certificateId = " + certificateRequestJoin.getCertificateId() + " certificateRequestId = " + certificateRequestJoin.getCertificateRequestId() + " certificateRequestRequestType = " + certificateRequestJoin.getCertificateRequestRequestType());
                            if (certificateRequestJoin.getCertificateId() == null || certificateRequestJoin.getCertificateId().equals(certificateJoin.getCertificateId()) || certificateRequestJoin.getCertificateRequestId() == null || !certificateRequestJoin.getCertificateRequestRequestType().equals("Accepted")) continue;
                            log.info("updating missing certificateRequestId for certificateId = " + certificateJoin.getCertificateId());
                            certificateJoin.setCertificateRequestId(certificateRequestJoin.getCertificateRequestId());
                            cert = (Certificate)this.certificateDAO.get(certificateJoin.getCertificateId());
                            cert.setCertificateRequestId(certificateRequestJoin.getCertificateRequestId());
                            this.certificateDAO.update(cert);
                            break;
                        }
                    }
                }
            }
            returnedJoins.add(certificateJoin);
            organisationPersonIdsAlreadyAdded.add(certificateJoin.getOrganisationPersonId());
        }
        CertificateSearchResult result = new CertificateSearchResult();
        result.setCertificateJoins(returnedJoins);
        result.setNetworkActions(ActionHelper.convertEnumToString(networkIdToActions));
        result.setGlobalActions(ActionHelper.convertEnumToString(globalActions));
        result.setUserPolicyPath(this.userPolicyPath);
        result.setUserPolicyVersion(this.userPolicyVersion);
        result.setCertificateAdministrationGlobal(this.certificateAdministrationGlobal);
        result.setPasswordExpireExtendInterval(this.passwordExpireExtendInterval);
        return result;
    }

    public CertificateJoin getCertificateJoinForOrganisationPersonPerson(Long organisationPersonId, Long personId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> globalActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.ADMINISTRATE_CERTIFICATE);
        List<CertificateJoin> joins = this.certificateDAO.getCertificateJoinByPerson(personId);
        CertificateJoin certificateJoin = joins.size() > 0 ? joins.get(0) : null;
        Long networkId = certificateJoin.getNetworkId();
        if (this.certificateAdministrationGlobal.booleanValue() && !globalActions.contains(Action.ADMINISTRATE_CERTIFICATE) || !this.certificateAdministrationGlobal.booleanValue() && !ActionHelper.hasActionsForNetwork(this.actionDAO, organisationPersonId, networkId, Action.EDIT_PERSON)) {
            return null;
        }
        return certificateJoin;
    }

    public void deleteCertificateRequest(Long certificateRequestId, Long organisationPersonId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.ADMINISTRATE_CERTIFICATE);
        CertificateRequest certificateRequest = (CertificateRequest)this.certificateRequestDAO.get(certificateRequestId);
        if (certificateRequest.getNetworkId() == null) {
            throw new SecurityException("CertificateRequest [" + certificateRequest.getId() + "] has no networkId, thus no security check is possible, thus deleting the certificate request is not allowed.");
        }
        if (this.certificateAdministrationGlobal.booleanValue() && !actions.contains(Action.ADMINISTRATE_CERTIFICATE) || !this.certificateAdministrationGlobal.booleanValue() && !ActionHelper.hasActionsForNetwork(this.actionDAO, organisationPersonId, certificateRequest.getNetworkId(), Action.EDIT_PERSON, Action.EDIT_ORGANISATION_PERSON)) {
            throw new SecurityException("No privileges [editPerson, editOrganisationPerson or administrateCertificate] for networkId [" + certificateRequest.getNetworkId() + "] of certificateRequest [" + certificateRequest.getId() + "] exists for organisationPerson [" + organisationPersonId + "].  Thus deleting the certificate request is not allowed.");
        }
        List<Certificate> certificates = this.certificateDAO.getByCertificateRequest(certificateRequestId);
        ArrayList<Long> certificateIds = new ArrayList<Long>();
        for (Certificate certificate : certificates) {
            certificateIds.add(certificate.getId());
        }
        this.certificateDAO.deleteBatch(certificateIds);
        this.certificateRequestDAO.delete(certificateRequestId);
    }

    public void extendChangePassword(Long certificateId, Long organisationPersonId) {
        PasswordStatus passwordStatus;
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.ADMINISTRATE_CERTIFICATE);
        Certificate certificate = (Certificate)this.certificateDAO.get(certificateId);
        OrganisationPerson orgPerson = (OrganisationPerson)this.organisationPersonDAO.get(certificate.getOrganisationPersonId());
        Person person = (Person)this.personDAO.get(orgPerson.getPersonId());
        if (person.getPassword() != null && person.getPassword().length() > 0 && (passwordStatus = this.passwordStatusChecker.checkPasswordStatus(person.getId(), person.getLastPasswordChangeTs())) == PasswordStatus.EXPIRED) {
            Long newLastPasswordChangeTs = this.passwordStatusChecker.extendLastPasswordChangeTs(person.getId());
            person.setLastPasswordChangeTs(newLastPasswordChangeTs);
            this.personDAO.update(person);
        }
    }

    public List<Network> getNetworksForInvitation(Long organisationPersonId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        return this.networkDAO.getNetworksToAdmin(organisationPersonId);
    }

    public List<CertificateJoin> renewCertificate(Long certificateId, Long userCaId, String password, Long organisationPersonId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Ca ca = (Ca)this.caDAO.get(userCaId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.ADMINISTRATE_CERTIFICATE);
        if (ca.getNetworkId() == null) {
            throw new SecurityException("Ca [" + ca.getId() + "] has no network id, thus no privilege check can be performed, thus renewing certificate [" + certificateId + "] is not allowed.");
        }
        if (this.certificateAdministrationGlobal.booleanValue() && !actions.contains(Action.ADMINISTRATE_CERTIFICATE) || !this.certificateAdministrationGlobal.booleanValue() && !ActionHelper.hasActionsForNetwork(this.actionDAO, organisationPersonId, ca.getNetworkId(), Action.EDIT_PERSON)) {
            throw new SecurityException("No privilege [editPerson or administrateCertificate] for networkId [" + ca.getNetworkId() + "] of ca [" + userCaId + "] exists for organisationPerson [" + organisationPersonId + "].  Thus renewing certificate [" + certificateId + "] is not allowed.");
        }
        ArrayList<Certificate> touchedCertificates = new ArrayList<Certificate>();
        try {
            Certificate oldCertificate = (Certificate)this.certificateDAO.get(certificateId);
            Certificate newCertificate = new Certificate();
            newCertificate.setCertificateRequestId(oldCertificate.getCertificateRequestId());
            newCertificate.setCertificate(null);
            newCertificate.setSubjectDn(oldCertificate.getSubjectDn());
            newCertificate.setCreatedById(oldCertificate.getCreatedById());
            newCertificate.setMayLogin(Boolean.valueOf(false));
            newCertificate.setMaySign(Boolean.valueOf(false));
            newCertificate.setOrganisationPersonId(oldCertificate.getOrganisationPersonId());
            newCertificate.setPrivateKey(oldCertificate.getPrivateKey());
            newCertificate.setCertSerial(null);
            newCertificate.setCertValidFrom(Double.valueOf((double)System.currentTimeMillis() / 1000.0));
            newCertificate.setCertValidTo(null);
            this.certificateGenerator.renewCertificate(oldCertificate, newCertificate, ca, password, organisationPersonId, this.certUserCertYears.intValue());
            oldCertificate.setMayLogin(Boolean.valueOf(false));
            oldCertificate.setMaySign(Boolean.valueOf(false));
            this.certificateDAO.update(oldCertificate);
            touchedCertificates.add(oldCertificate);
            newCertificate = (Certificate)this.certificateDAO.save(newCertificate);
            this.sendCertificateSignedEmail(organisationPersonId, newCertificate.getOrganisationPersonId(), true);
            ArrayList<Long> certificateIds = new ArrayList<Long>();
            certificateIds.add(oldCertificate.getId());
            certificateIds.add(newCertificate.getId());
            List<CertificateJoin> resultJoins = this.certificateDAO.getCertificateJoinById(certificateIds);
            return resultJoins;
        }
        catch (Exception e) {
            log.warn("Exception while renewCertificate()", (Throwable)e);
            return null;
        }
    }

    public Certificate invalidateCertificate(Long certificateId, Long organisationPersonId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Certificate certificate = (Certificate)this.certificateDAO.get(certificateId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.ADMINISTRATE_CERTIFICATE);
        Ca ca = (Ca)this.caDAO.get(certificate.getCaCertId());
        if (ca.getNetworkId() == null) {
            throw new SecurityException("Ca [" + ca.getId() + "] has no network id, thus no privilege check can be performed, thus invalidating certificate [" + certificateId + "] is not allowed.");
        }
        if (this.certificateAdministrationGlobal.booleanValue() && !actions.contains(Action.ADMINISTRATE_CERTIFICATE) || !this.certificateAdministrationGlobal.booleanValue() && !ActionHelper.hasActionsForNetwork(this.actionDAO, organisationPersonId, ca.getNetworkId(), Action.EDIT_PERSON)) {
            throw new SecurityException("No privilege [editPerson or administrateCertificate] for networkId [" + ca.getNetworkId() + "] of ca [" + certificate.getCaCertId() + "] of certificate [" + certificate.getId() + "] exists for organisationPerson [" + organisationPersonId + "].  Thus invalidating the certificate is not allowed.");
        }
        certificate.setMaySign(Boolean.valueOf(false));
        certificate.setMayLogin(Boolean.valueOf(false));
        this.certificateDAO.update(certificate);
        return certificate;
    }

    public void sendCertificateConfirmation(Long certificateRequestId, Long certificateOrganisationPersonId, Long contextOrganisationPersonId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, contextOrganisationPersonId);
        CertificateRequest certificateRequest = (CertificateRequest)this.certificateRequestDAO.get(certificateRequestId);
        Long networkId = certificateRequest.getNetworkId();
        Set<Action> actions = this.actionDAO.getGlobalActions(contextOrganisationPersonId, Action.ADMINISTRATE_CERTIFICATE);
        if (certificateRequest.getCreatedFor() == null || certificateRequest.getCreatedFor().longValue() != certificateOrganisationPersonId.longValue()) {
            throw new SecurityException("Trying to send certificate confirmation for certificate request [" + certificateRequestId + "]; it does not belong to given organisationPerson [" + certificateOrganisationPersonId + "].  Thus this is not allowed.");
        }
        if (this.certificateAdministrationGlobal.booleanValue() && !actions.contains(Action.ADMINISTRATE_CERTIFICATE) || !this.certificateAdministrationGlobal.booleanValue() && !ActionHelper.hasActionsForNetwork(this.actionDAO, contextOrganisationPersonId, networkId, Action.EDIT_PERSON)) {
            throw new SecurityException("No privilege [editPerson or administrateCertificate] for network [" + networkId + "] of certificateRequest [" + certificateRequest.getId() + "] for organisationPerson [" + contextOrganisationPersonId + "].  Thus sending the certificate confirmation is not allowed.");
        }
        EmailContext emailContext = this.getEmailContextForOrganisationPersonIds(contextOrganisationPersonId, certificateOrganisationPersonId);
        OrganisationPerson senderOrganisationPerson = emailContext.getSenderOrganisationPerson();
        Organisation senderOrganisation = emailContext.getSenderOrganisation();
        Person senderPerson = emailContext.getSenderPerson();
        OrganisationPerson receiverOrganisationPerson = emailContext.getReceiverOrganisationPerson();
        Organisation receiverOrganisation = emailContext.getReceiverOrganisation();
        Person receiverPerson = emailContext.getReceiverPerson();
        OrganisationPersonJoin receiverOrganisationPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(receiverOrganisationPerson.getId());
        String locale = receiverOrganisationPersonJoin.getPersonVariablesUserLocale();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(locale);
        String message = MessageFormat.format(resourceBundle.getString("certificateConfirmationMailBody"), receiverOrganisation.getName(), receiverOrganisation.getName()) + "\n\n";
        String salutation = PersonHelper.getSalutation(receiverPerson, resourceBundle) + "\n\n\n";
        String signature = PersonHelper.getSignature(senderOrganisation, senderPerson, resourceBundle);
        String body = salutation + message + signature;
        String subject = resourceBundle.getString("certificateConfirmationMailSubject");
        if (!locale.equals("de") && !locale.equals("en")) {
            String secondLocale = "en";
            resourceBundle = CdesImplMessages.getResourceBundle(secondLocale);
            message = MessageFormat.format(resourceBundle.getString("certificateConfirmationMailBody"), receiverOrganisation.getName(), receiverOrganisation.getName()) + "\n\n";
            salutation = PersonHelper.getSalutation(receiverPerson, resourceBundle) + "\n\n\n";
            signature = PersonHelper.getSignature(senderOrganisation, senderPerson, resourceBundle);
            body = body + "\n____________________________\n" + salutation + message + signature;
            subject = subject + " / " + resourceBundle.getString("certificateConfirmationMailSubject");
        }
        String replyTo = senderOrganisationPerson.getEmailAddress();
        this.emailUtils.createMail(receiverOrganisationPerson, receiverPerson, subject, body, replyTo, null, null);
        receiverOrganisationPerson.setDirectCertificationRequestIssuer(senderOrganisationPerson.getId());
        this.organisationPersonDAO.update(receiverOrganisationPerson);
    }

    private void sendCertificateRequestInvitationMail(Long certificateRequestId) {
        CertificateRequest certificateRequest = (CertificateRequest)this.certificateRequestDAO.get(certificateRequestId);
        EmailContext emailContext = this.getEmailContextForCertificateOrCertificateRequest(certificateRequest);
        this.sendCertificateRequestInvitationMailMail(emailContext, certificateRequest, 1);
    }

    public void sendCertificateInvitationMail(Long organisationPersonId, Long certificateId, Long certificateRequestId, int type) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Certificate certificate = null;
        CertificateRequest certificateRequest = null;
        if (certificateId != null) {
            certificate = (Certificate)this.certificateDAO.get(certificateId);
            certificateRequest = (CertificateRequest)this.certificateRequestDAO.get(certificate.getCertificateRequestId());
        } else {
            certificateRequest = (CertificateRequest)this.certificateRequestDAO.get(certificateRequestId);
        }
        Long networkId = certificateRequest.getNetworkId();
        Set<Action> globalActions = this.actionDAO.getGlobalActions(organisationPersonId, Action.ADMINISTRATE_CERTIFICATE);
        if (this.certificateAdministrationGlobal.booleanValue() && !globalActions.contains(Action.ADMINISTRATE_CERTIFICATE) || !this.certificateAdministrationGlobal.booleanValue() && !ActionHelper.hasActionsForNetwork(this.actionDAO, organisationPersonId, networkId, Action.EDIT_PERSON)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] may not sendCertificateInvitationEmail. Reason: Missing actions.  Either global, or for network [" + networkId + "]");
        }
        EmailContext emailContext = this.getEmailContextForCertificateOrCertificateRequest(certificate != null ? certificate : certificateRequest);
        this.sendCertificateRequestInvitationMailMail(emailContext, certificateRequest, type);
    }

    private void sendCertificateRequestInvitationMailMail(EmailContext emailContext, CertificateRequest certificateRequest, int type) {
        OrganisationPerson senderOrganisationPerson = emailContext.getSenderOrganisationPerson();
        Organisation senderOrganisation = emailContext.getSenderOrganisation();
        Person senderPerson = emailContext.getSenderPerson();
        OrganisationPerson receiverOrganisationPerson = emailContext.getReceiverOrganisationPerson();
        Person receiverPerson = emailContext.getReceiverPerson();
        Organisation receiverOrganisation = emailContext.getReceiverOrganisation();
        Country receiverOpCountry = emailContext.getReceiverOpCountry();
        OrganisationPersonJoin receiverOrganisationPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(receiverOrganisationPerson.getId());
        String locale = receiverOrganisationPersonJoin.getPersonVariablesUserLocale();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(locale);
        String signature = null;
        String supportContactEMail = null;
        String supportContactTitle = "c.des Support";
        supportContactEMail = this.certificateAdministrationGlobal == false ? senderOrganisationPerson.getEmailAddress() : this.userPolicyEmail;
        signature = MessageFormat.format(resourceBundle.getString("signature"), "", supportContactTitle, "");
        if (type == 1 || type == 3) {
            String applicationUrl = (String)ThreadLocalManager.getBoundResource((String)this.applicationUrlThreadLocalKey);
            String challengeLink = applicationUrl + "/cdes/frame.html#page=challengeLogin";
            String userName = certificateRequest.getChallenge1();
            String manualLinkString = this.manualLink != null && this.manualLink.length() > 0 ? this.manualLink : null;
            String bodyPostfix = MessageFormat.format(resourceBundle.getString("certificateInvitationMailBodyPostfix"), supportContactEMail, challengeLink, userName) + "\n\n";
            bodyPostfix = bodyPostfix + MessageFormat.format(resourceBundle.getString("certificateInvitationuserPolicyBroadcastEmailBody"), receiverOrganisation.getName()) + "\n\n";
            String bodyPrefix = resourceBundle.getString("certificateInvitationMailBodyPrefix");
            String salutation = PersonHelper.getSalutation(receiverPerson, resourceBundle) + "\n\n\n";
            String body = salutation + bodyPrefix + bodyPostfix + "\n" + signature;
            String subject = resourceBundle.getString("certificateInvitationMailSubject");
            if (!locale.equals("de") && !locale.equals("en")) {
                String secondLocale = "en";
                resourceBundle = CdesImplMessages.getResourceBundle(secondLocale);
                bodyPostfix = MessageFormat.format(resourceBundle.getString("certificateInvitationMailBodyPostfix"), supportContactEMail, challengeLink, userName) + "\n\n";
                bodyPostfix = bodyPostfix + MessageFormat.format(resourceBundle.getString("certificateInvitationuserPolicyBroadcastEmailBody"), receiverOrganisation.getName()) + "\n\n";
                if (manualLinkString != null) {
                    bodyPostfix = bodyPostfix + MessageFormat.format(resourceBundle.getString("certificateInvitationMailBodyManual"), manualLinkString);
                }
                bodyPrefix = resourceBundle.getString("certificateInvitationMailBodyPrefix");
                salutation = PersonHelper.getSalutation(receiverPerson, resourceBundle) + "\n\n\n";
                signature = MessageFormat.format(resourceBundle.getString("signature"), "", supportContactTitle, "");
                body = body + "\n____________________________\n" + salutation + bodyPrefix + bodyPostfix + "\n" + signature;
                subject = subject + " / " + resourceBundle.getString("certificateInvitationMailSubject");
            }
            List<Email> emails = this.emailUtils.createMail(receiverOrganisationPerson, receiverPerson, subject, body, supportContactEMail, null, null);
            this.emailAttachmentDAO.saveBatch(emails.stream().map(email -> this.makeUserPolicyAttachment((Email)email, receiverOrganisationPerson.getId())).collect(Collectors.toList()));
            if (type == 3) {
                this.sendSecurityCode(emailContext, certificateRequest.getChallenge2());
            }
        } else {
            Stream<Email> emails = this.createUserPolicyBroadcastEmails(senderOrganisationPerson, receiverOrganisationPersonJoin);
            this.emailAttachmentDAO.saveBatch(emails.map(email -> this.makeUserPolicyAttachment((Email)email, receiverOrganisationPerson.getId())).collect(Collectors.toList()));
        }
    }

    private EmailAttachment makeUserPolicyAttachment(Email email, Long organisationPersonId) {
        EmailAttachment attachment = new EmailAttachment();
        attachment.setEmailId(email.getId());
        attachment.setMimeSource("userPolicyMimeSource");
        attachment.setParameters("L" + organisationPersonId);
        return attachment;
    }

    private Stream<Email> createUserPolicyBroadcastEmails(OrganisationPerson senderOrganisationPerson, OrganisationPersonJoin receiver) {
        String locale = receiver.getPersonVariablesUserLocale();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(locale);
        String subject = this.enableCustomerLogo != false ? resourceBundle.getString("userPolicyBroadcastEmailSubject_oebb") : resourceBundle.getString("userPolicyBroadcastEmailSubject");
        Organisation senderOrg = (Organisation)this.organisationDAO.get(senderOrganisationPerson.getOrganisationId());
        Person senderPerson = (Person)this.personDAO.get(senderOrganisationPerson.getPersonId());
        String recipientBCCEMail = null;
        String recipientBCCTitle = "c.des Support";
        recipientBCCEMail = this.certificateAdministrationGlobal == false ? senderOrganisationPerson.getEmailAddress() : this.userPolicyEmail;
        String bodyPrefix1 = this.enableCustomerLogo != false ? resourceBundle.getString("userPolicyBroadcastEmailBodyP1_oebb") : resourceBundle.getString("userPolicyBroadcastEmailBodyP1");
        String bodyPrefix2 = "";
        if (this.userPolicyDeadline != null) {
            Instant shownDeadline = ChronoUnit.DAYS.addTo(this.userPolicyDeadline, -8L);
            String userPolicyDeadlineString = DateHelper.formatUtcSeconds(Long.valueOf(shownDeadline.getEpochSecond()).doubleValue(), "Europe/Vienna", resourceBundle.getString("yearToDayFormat"));
            bodyPrefix2 = MessageFormat.format(resourceBundle.getString("userPolicyBroadcastEmailBodyP2"), userPolicyDeadlineString);
        }
        String bodyPrefix3 = MessageFormat.format(resourceBundle.getString("userPolicyBroadcastEmailBodyP3"), receiver.getOrganisationName());
        String salutation = PersonHelper.getSalutation(receiver.getPerson(), resourceBundle) + "\n\n\n";
        String signature = MessageFormat.format(resourceBundle.getString("signature"), "", recipientBCCTitle, "");
        String body = salutation + bodyPrefix1 + bodyPrefix2 + bodyPrefix3 + "\n\n" + signature;
        if (!locale.equals("de") && !locale.equals("en")) {
            String secondLocale = "en";
            resourceBundle = CdesImplMessages.getResourceBundle(secondLocale);
            bodyPrefix1 = this.enableCustomerLogo != false ? resourceBundle.getString("userPolicyBroadcastEmailBodyP1_oebb") : resourceBundle.getString("userPolicyBroadcastEmailBodyP1");
            bodyPrefix2 = "";
            if (this.userPolicyDeadline != null) {
                Instant shownDeadline = ChronoUnit.DAYS.addTo(this.userPolicyDeadline, -8L);
                String userPolicyDeadlineString = DateHelper.formatUtcSeconds(Long.valueOf(shownDeadline.getEpochSecond()).doubleValue(), "Europe/Vienna", resourceBundle.getString("yearToDayFormat"));
                bodyPrefix2 = MessageFormat.format(resourceBundle.getString("userPolicyBroadcastEmailBodyP2"), userPolicyDeadlineString);
            }
            bodyPrefix3 = MessageFormat.format(resourceBundle.getString("userPolicyBroadcastEmailBodyP3"), receiver.getOrganisationName());
            salutation = PersonHelper.getSalutation(receiver.getPerson(), resourceBundle) + "\n\n\n";
            signature = MessageFormat.format(resourceBundle.getString("signature"), "", recipientBCCTitle, "");
            body = body + "\n____________________________\n" + salutation + bodyPrefix1 + bodyPrefix2 + bodyPrefix3 + "\n\n" + signature;
            subject = subject + " / " + resourceBundle.getString("userPolicyBroadcastEmailSubject");
        }
        return this.emailUtils.createMail(receiver.getOrganisationPerson(), receiver.getPerson(), subject, body, recipientBCCEMail, null, recipientBCCEMail).stream();
    }

    public boolean isBroadcastUserPolicyButtonAvailable(Long organisationPersonId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (this.userPolicyPath == null || this.userPolicyPath.length() <= 0) {
            return false;
        }
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.SUPER_ADMIN_RIGHT);
        return actions.contains(Action.SUPER_ADMIN_RIGHT);
    }

    public void broadcastUserPolicy(Long organisationPersonId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (this.userPolicyPath == null || this.userPolicyPath.length() <= 0) {
            log.error("broadcastUserPolicy skipped because userPolicyPath is not set!");
            return;
        }
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.SUPER_ADMIN_RIGHT);
        if (!actions.contains(Action.SUPER_ADMIN_RIGHT)) {
            throw new SecurityException("Users that are not super admins are not allowed to broadcast the user policy.");
        }
        OrganisationPerson thisOrganisationPerson = (OrganisationPerson)this.organisationPersonDAO.get(organisationPersonId);
        this.emailAttachmentDAO.saveBatch(this.organisationPersonDAO.getAllActiveOrganisationPersonJoins().stream().flatMap(join -> this.createUserPolicyBroadcastEmails(thisOrganisationPerson, (OrganisationPersonJoin)join).map(email -> this.makeUserPolicyAttachment((Email)email, join.getOrganisationPersonId()))).collect(Collectors.toList()));
    }

    private void sendSecurityCode(EmailContext emailContext, String securityCode) {
        Organisation senderOrganisation = emailContext.getSenderOrganisation();
        OrganisationPerson senderOrganisationPerson = emailContext.getSenderOrganisationPerson();
        Person senderPerson = emailContext.getSenderPerson();
        OrganisationPerson receiverOrganisationPerson = emailContext.getReceiverOrganisationPerson();
        Person receiverPerson = emailContext.getReceiverPerson();
        OrganisationPersonJoin receiverOrganisationPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(receiverOrganisationPerson.getId());
        String locale = receiverOrganisationPersonJoin.getPersonVariablesUserLocale();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(locale);
        String senderOrganisationName = senderOrganisation.getName();
        String message = MessageFormat.format(resourceBundle.getString("certificateSecurityCodeMailBody"), securityCode);
        String salutation = PersonHelper.getSalutation(receiverPerson, resourceBundle) + "\n\n\n";
        String signature = null;
        String supportContactTitle = "c.des Support";
        String supportContactEMail = null;
        supportContactEMail = this.certificateAdministrationGlobal == false ? senderOrganisationPerson.getEmailAddress() : this.userPolicyEmail;
        signature = MessageFormat.format(resourceBundle.getString("signature"), "", supportContactTitle, "");
        String body = salutation + message + signature;
        String subject = resourceBundle.getString("certificateSecurityCodeMailSubject");
        if (!locale.equals("de") && !locale.equals("en")) {
            String secondLocale = "en";
            resourceBundle = CdesImplMessages.getResourceBundle(secondLocale);
            message = MessageFormat.format(resourceBundle.getString("certificateSecurityCodeMailBody"), securityCode);
            salutation = PersonHelper.getSalutation(receiverPerson, resourceBundle) + "\n\n\n";
            signature = MessageFormat.format(resourceBundle.getString("signature"), "", supportContactTitle, "");
            body = body + "\n____________________________\n" + salutation + message + signature;
            subject = subject + " / " + resourceBundle.getString("certificateSecurityCodeMailSubject");
        }
        this.emailUtils.createMail(receiverOrganisationPerson, receiverPerson, subject, body, supportContactEMail, null, null);
    }

    private EmailContext getEmailContextForCertificateOrCertificateRequest(Object arg) {
        Long senderOrganisationPersonId = null;
        Long receiverOrganisationPersonId = null;
        if (arg instanceof Certificate) {
            CertificateRequest certificateRequest = (CertificateRequest)this.certificateRequestDAO.get(((Certificate)arg).getCertificateRequestId());
            senderOrganisationPersonId = certificateRequest.getCreatedById();
            receiverOrganisationPersonId = ((Certificate)arg).getOrganisationPersonId();
            certificateRequest.getChallenge2();
        } else if (arg instanceof CertificateRequest) {
            CertificateRequest certificateRequest = (CertificateRequest)this.certificateRequestDAO.get(((CertificateRequest)arg).getId());
            senderOrganisationPersonId = certificateRequest.getCreatedById();
            receiverOrganisationPersonId = certificateRequest.getCreatedFor();
        }
        return this.getEmailContextForOrganisationPersonIds(senderOrganisationPersonId, receiverOrganisationPersonId);
    }

    private EmailContext getEmailContextForOrganisationPersonIds(Long senderOrganisationPersonId, Long receiverOrganisationPersonId) {
        List<OrganisationPersonJoin> organisationPersonJoins = this.organisationPersonDAO.getOrganisationPersonJoin(receiverOrganisationPersonId, senderOrganisationPersonId);
        OrganisationPersonJoin certificateJoin = null;
        OrganisationPersonJoin contextJoin = null;
        for (OrganisationPersonJoin join : organisationPersonJoins) {
            if (join.getOrganisationPersonId().longValue() == receiverOrganisationPersonId.longValue()) {
                certificateJoin = join;
            }
            if (join.getOrganisationPersonId().longValue() != senderOrganisationPersonId.longValue()) continue;
            contextJoin = join;
        }
        if (certificateJoin == null) {
            throw new IllegalArgumentException("Call of sendCertificateConfirmation with certificateOrganisationPersonId = [" + receiverOrganisationPersonId + "] --- cannot find this OrganisationPerson on the DB");
        }
        if (contextJoin == null) {
            throw new IllegalArgumentException("Call of sendCertificateConfirmation with contextOrganisationPersonId = [" + senderOrganisationPersonId + "] --- cannot find this OrganisationPerson on the DB");
        }
        EmailContext emailContext = new EmailContext();
        emailContext.setSenderOrganisationPerson(contextJoin.getOrganisationPerson());
        emailContext.setSenderOrganisation(contextJoin.getOrganisation());
        emailContext.setSenderPerson(contextJoin.getPerson());
        emailContext.setReceiverOrganisationPerson(certificateJoin.getOrganisationPerson());
        emailContext.setReceiverOrganisation(certificateJoin.getOrganisation());
        emailContext.setReceiverPerson(certificateJoin.getPerson());
        emailContext.setReceiverOpCountry(certificateJoin.getOpCountry());
        return emailContext;
    }

    private CertificateRequest createCertificateRequest(Long invitedOrganisationPersonId, Long networkId, Long inviterOrganisationPersonId) {
        CertificateRequest cdes_request = new CertificateRequest();
        cdes_request.setChallenge1(this.certificateGenerator.generateChallenge());
        cdes_request.setChallenge2(this.certificateGenerator.generateChallenge());
        cdes_request.setCreatedById(inviterOrganisationPersonId);
        cdes_request.setCreatedFor(invitedOrganisationPersonId);
        cdes_request.setCreated(Double.valueOf((double)System.currentTimeMillis() / 1000.0));
        cdes_request.setRequest(null);
        cdes_request.setRequestType("Invitation");
        cdes_request.setNetworkId(networkId);
        return cdes_request;
    }

    private void checkInviterAllowedForNetwork(Long networkId, Long inviterOrganisationPersonId) {
        List<Network> allowedNetworks = this.networkDAO.getNetworksToAdmin(inviterOrganisationPersonId);
        boolean found = false;
        for (Network network : allowedNetworks) {
            if (network.getId().longValue() != networkId.longValue()) continue;
            found = true;
        }
        if (!found) {
            throw new SecurityException("Inviter OrganisationPerson is not allowed to invite someone for network [" + networkId + "].");
        }
    }

    public void inviteAndSendAllPerMail(Long invitedOrganisationPersonId, Long networkId, Long inviterOrganisationPersonId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, inviterOrganisationPersonId);
        List<Long> networkIds = this.organisationPersonDAO.getNetworkIdsViaNetworkOrganisation(invitedOrganisationPersonId);
        this.checkInviterAllowedForNetwork(networkId, inviterOrganisationPersonId);
        Set<Action> actions = this.actionDAO.getGlobalActions(inviterOrganisationPersonId, Action.ADMINISTRATE_CERTIFICATE);
        if (this.certificateAdministrationGlobal.booleanValue() && !actions.contains(Action.ADMINISTRATE_CERTIFICATE) || !this.certificateAdministrationGlobal.booleanValue() && !ActionHelper.hasActionsForAnyNetwork(this.actionDAO, inviterOrganisationPersonId, networkIds, Action.EDIT_PERSON)) {
            throw new SecurityException("No privilege [editPerson or administrateCertificate] for any of the " + networkIds.size() + " networks of the invited person [" + invitedOrganisationPersonId + "] exists for organisationPerson [" + inviterOrganisationPersonId + "].  Thus the invitation is not allowed.");
        }
        CertificateRequest certificateRequest = this.createCertificateRequest(invitedOrganisationPersonId, networkId, inviterOrganisationPersonId);
        certificateRequest = (CertificateRequest)this.certificateRequestDAO.save(certificateRequest);
        this.sendCertificateRequestInvitationMail(certificateRequest.getId());
        EmailContext emailContext = this.getEmailContextForCertificateOrCertificateRequest(certificateRequest);
        this.sendSecurityCode(emailContext, certificateRequest.getChallenge2());
    }

    public void signCertificateRequest(Long certificateRequestId, Long caId, Long signerId, String password) {
        Certificate certificate;
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, signerId);
        CertificateRequest certificateRequest = (CertificateRequest)this.certificateRequestDAO.get(certificateRequestId);
        Long networkId = certificateRequest.getNetworkId();
        Long certificateRequestOrgPersonId = certificateRequest.getCreatedFor();
        OrganisationPerson certificateRequestOrgPerson = (OrganisationPerson)this.organisationPersonDAO.get(certificateRequestOrgPersonId);
        List<OrganisationPerson> orgPersonList = this.organisationPersonDAO.getByPerson(certificateRequestOrgPerson.getPersonId());
        Set<Action> actions = this.actionDAO.getGlobalActions(signerId, Action.ADMINISTRATE_CERTIFICATE);
        List<Certificate> certificates = this.certificateDAO.getByCertificateRequest(certificateRequestId);
        Ca ca = (Ca)this.caDAO.get(caId);
        if (ca.getNetworkId() == null || networkId != null && networkId.longValue() != ca.getNetworkId().longValue()) {
            throw new SecurityException("Trying to sign certificate request: The network [" + networkId + "] of the certificate request and the network of the ca [" + ca.getNetworkId() + "] differs.  Thus this is not allowed.");
        }
        if (networkId != null && (this.certificateAdministrationGlobal.booleanValue() && !actions.contains(Action.ADMINISTRATE_CERTIFICATE) || !this.certificateAdministrationGlobal.booleanValue() && !ActionHelper.hasActionsForNetwork(this.actionDAO, signerId, networkId, Action.EDIT_PERSON, Action.EDIT_ORGANISATION_PERSON))) {
            throw new SecurityException("No privileges [editPerson, editOrganisationPerson or administrateCertificate] for network [" + networkId + "] of certificateRequest [" + certificateRequest.getId() + "] for organisationPerson [" + signerId + "].  Thus signing the certificate request is not allowed.");
        }
        if (this.certificateAdministrationGlobal.booleanValue() && !actions.contains(Action.ADMINISTRATE_CERTIFICATE) || !this.certificateAdministrationGlobal.booleanValue() && !ActionHelper.hasActionsForNetwork(this.actionDAO, signerId, ca.getNetworkId(), Action.EDIT_PERSON, Action.EDIT_ORGANISATION_PERSON)) {
            throw new SecurityException("No privileges [editPerson, editOrganisationPerson or administrateCertificate] for ca.networkId [" + ca.getNetworkId() + "] of certificateRequest [" + certificateRequest.getId() + "] for organisationPerson [" + signerId + "].  Thus signing the certificate request is not allowed.");
        }
        if (networkId == null) {
            certificateRequest.setNetworkId(ca.getNetworkId());
        }
        Certificate certificate2 = certificate = certificates.size() > 0 ? certificates.get(0) : null;
        if (certificate == null) {
            throw new IllegalArgumentException("No certificate found for certificateRequest [" + certificateRequest.getId() + "]");
        }
        this.certificateGenerator.signCertificateRequest(certificate, certificateRequest, ca, password, signerId, this.certUserCertYears.intValue());
        this.certificateDAO.update(certificate);
        this.certificateRequestDAO.update(certificateRequest);
        double now = (double)System.currentTimeMillis() / 1000.0;
        double yesterday = now - 86400.0;
        for (OrganisationPerson orgPerson : orgPersonList) {
            if (orgPerson.getId().equals(certificateRequestOrgPersonId)) {
                List<Certificate> certificatesOfOrgPerson = this.certificateDAO.getByOrganisationPerson(certificateRequestOrgPersonId);
                for (Certificate certificateOfOrgPerson : certificatesOfOrgPerson) {
                    if (certificate.getId().equals(certificateOfOrgPerson.getId()) || !certificateOfOrgPerson.isMaySign().booleanValue() || !(certificateOfOrgPerson.getCertValidTo() > now)) continue;
                    certificateOfOrgPerson.setMayLogin(Boolean.valueOf(false));
                    certificateOfOrgPerson.setMaySign(Boolean.valueOf(false));
                    certificateOfOrgPerson.setCertValidTo(Double.valueOf(yesterday));
                    this.certificateDAO.update(certificateOfOrgPerson);
                }
                continue;
            }
            List<Certificate> otherCertificatesOfPerson = this.certificateDAO.getByOrganisationPerson(orgPerson.getId());
            boolean atLeastOneValid = false;
            for (int i = 0; i < otherCertificatesOfPerson.size(); ++i) {
                Certificate otherCertificateOfPerson = otherCertificatesOfPerson.get(i);
                if (!(otherCertificateOfPerson.getCertValidFrom() < now) || otherCertificateOfPerson.getCertValidTo() == null || !(otherCertificateOfPerson.getCertValidTo() >= now) || !otherCertificateOfPerson.isMaySign().booleanValue() && (atLeastOneValid || i != otherCertificatesOfPerson.size() - 1 || otherCertificateOfPerson.isMaySign().booleanValue() || otherCertificateOfPerson.isMayLogin().booleanValue())) continue;
                otherCertificateOfPerson.setPrivateKey(certificate.getPrivateKey());
                if (!orgPerson.isRetiredFlag().booleanValue()) {
                    otherCertificateOfPerson.setMayLogin(Boolean.valueOf(true));
                    otherCertificateOfPerson.setMaySign(Boolean.valueOf(true));
                }
                this.certificateDAO.update(otherCertificateOfPerson);
                atLeastOneValid = true;
            }
        }
        this.sendCertificateSignedEmail(signerId, certificate.getOrganisationPersonId(), false);
    }

    public void signCertificateRequestDirectly(Long certificateId, Long organisationPersonId, Long caId, Long signerId, String password) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Certificate oldCertificate = (Certificate)this.certificateDAO.get(certificateId);
        List<OrganisationPersonJoin> opJoins = this.organisationPersonDAO.getOrganisationPersonJoin(organisationPersonId, oldCertificate.getOrganisationPersonId(), signerId);
        OrganisationPersonJoin signerJoin = null;
        OrganisationPersonJoin givenOrgPersonJoin = null;
        OrganisationPersonJoin oldCertificateJoin = null;
        for (OrganisationPersonJoin join : opJoins) {
            if (join.getOrganisationPersonId().longValue() == signerId.longValue()) {
                signerJoin = join;
            }
            if (join.getOrganisationPersonId().longValue() == organisationPersonId.longValue()) {
                givenOrgPersonJoin = join;
            }
            if (join.getOrganisationPersonId().longValue() != oldCertificate.getOrganisationPersonId().longValue()) continue;
            oldCertificateJoin = join;
        }
        if (givenOrgPersonJoin == null || oldCertificateJoin == null || givenOrgPersonJoin.getPersonId().longValue() != oldCertificateJoin.getPersonId().longValue()) {
            throw new SecurityException("While trying to create a certificate for orgPerson [" + organisationPersonId + "], based on certificate [" + certificateId + "] for [" + oldCertificate.getOrganisationPersonId() + "]: Either the organisationPersons could not be fetched, or they don't refer to the same Person.");
        }
        Ca ca = (Ca)this.caDAO.get(caId);
        Set<Action> actions = this.actionDAO.getGlobalActions(signerId, Action.ADMINISTRATE_CERTIFICATE);
        if (ca.getNetworkId() == null) {
            throw new SecurityException("Ca [" + ca.getId() + "] has no network id, thus no privilege check can be performed, thus signing certificate based on [" + oldCertificate.getId() + "] is not allowed.");
        }
        if (this.certificateAdministrationGlobal.booleanValue() && !actions.contains(Action.ADMINISTRATE_CERTIFICATE) || !this.certificateAdministrationGlobal.booleanValue() && !ActionHelper.hasActionsForNetwork(this.actionDAO, signerId, ca.getNetworkId(), Action.EDIT_PERSON, Action.EDIT_ORGANISATION_PERSON)) {
            throw new SecurityException("OrganisationPerson [" + signerId + "] is not allowed to sign certificate [" + oldCertificate.getId() + "] based on Ca [" + ca.getId() + "] with network [" + ca.getNetworkId() + "], with action editOrganisationPerson or administrateCertificate");
        }
        OrganisationPerson signer = signerJoin.getOrganisationPerson();
        signer.setDirectCertificationRequestIssuer(null);
        this.organisationPersonDAO.update(signer);
        Certificate certificateToSign = this.certificateGenerator.generateDirectCertificate(signerJoin, oldCertificate.getPrivateKey());
        this.certificateGenerator.signCertificateDirectly(certificateToSign, ca, password, signerId, this.certUserCertYears.intValue(), oldCertificate);
        certificateToSign.setCertificateRequestId(oldCertificate.getCertificateRequestId());
        certificateToSign.setOrganisationPersonId(organisationPersonId);
        this.certificateDAO.save(certificateToSign);
        this.sendCertificateSignedEmail(signerId, certificateToSign.getOrganisationPersonId(), false);
    }

    private void sendCertificateSignedEmail(Long signerOrganisationPersonId, Long certificateOrganisationPersonId, boolean renew) {
        String subject;
        EmailContext emailContext = this.getEmailContextForOrganisationPersonIds(signerOrganisationPersonId, certificateOrganisationPersonId);
        OrganisationPerson senderOrganisationPerson = emailContext.getSenderOrganisationPerson();
        Organisation senderOrganisation = emailContext.getSenderOrganisation();
        Person senderPerson = emailContext.getSenderPerson();
        OrganisationPerson receiverOrganisationPerson = emailContext.getReceiverOrganisationPerson();
        Person receiverPerson = emailContext.getReceiverPerson();
        OrganisationPersonJoin receiverOrganisationPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(receiverOrganisationPerson.getId());
        String locale = receiverOrganisationPersonJoin.getPersonVariablesUserLocale();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(locale);
        String salutation = PersonHelper.getSalutation(receiverPerson, resourceBundle) + "\n\n\n";
        String message = renew ? resourceBundle.getString("certificateRequestRenewBody") : resourceBundle.getString("certificateRequestSignedBody");
        String signature = null;
        String supportContactTitle = "c.des Support";
        List supportContacts = this.supportContactDAO.getAll();
        if (supportContacts != null && !supportContacts.isEmpty()) {
            SupportContact supportContact = (SupportContact)supportContacts.get(0);
            supportContactTitle = supportContact.getTitle();
        }
        signature = MessageFormat.format(resourceBundle.getString("signature"), "", supportContactTitle, "");
        String body = salutation + message + signature;
        String string = subject = renew ? resourceBundle.getString("certificateRequestRenewSubject") : resourceBundle.getString("certificateRequestSignedSubject");
        if (!locale.equals("de") && !locale.equals("en")) {
            String secondLocale = "en";
            resourceBundle = CdesImplMessages.getResourceBundle(secondLocale);
            message = renew ? resourceBundle.getString("certificateRequestRenewBody") : resourceBundle.getString("certificateRequestSignedBody");
            salutation = PersonHelper.getSalutation(receiverPerson, resourceBundle) + "\n\n\n";
            signature = MessageFormat.format(resourceBundle.getString("signature"), "", supportContactTitle, "");
            body = body + "\n____________________________\n" + salutation + message + signature;
            subject = subject + " / " + (renew ? resourceBundle.getString("certificateRequestRenewBody") : resourceBundle.getString("certificateRequestSignedBody"));
        }
        String replyTo = senderOrganisationPerson.getEmailAddress();
        this.emailUtils.createMail(receiverOrganisationPerson, receiverPerson, subject, body, replyTo, null, null);
    }

    public void declareCertificateRequestPdfUploaded(Long organisationPersonId, Long certificateRequestId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        CertificateRequest certificateRequest = (CertificateRequest)this.certificateRequestDAO.get(certificateRequestId);
        if (!this.certificateAdministrationGlobal.booleanValue() && !ActionHelper.hasActionsForNetwork(this.actionDAO, organisationPersonId, certificateRequest.getNetworkId(), Action.EDIT_PERSON, Action.EDIT_ORGANISATION_PERSON)) {
            throw new SecurityException("The organisation person " + organisationPersonId + " is trying to upload a certificate request pdf for certificate request " + certificateRequestId + " but it does not have the permissions for it. No privileges [editPerson, editOrganisationPerson or administrateCertificate] for network [" + certificateRequest.getNetworkId() + "]");
        }
        certificateRequest.setRequestPdfUploaded(Boolean.valueOf(true));
        certificateRequest.setRequestPdfUploadTs(Long.valueOf(System.currentTimeMillis()));
        certificateRequest.setRequestPdfUploadVersion(this.userPolicyVersion);
        this.certificateRequestDAO.update(certificateRequest);
    }

    public Certificate unlockCertificate(Long certificateId, Long organisationPersonId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        Certificate certificate = (Certificate)this.certificateDAO.get(certificateId);
        Set<Action> actions = this.actionDAO.getGlobalActions(organisationPersonId, Action.ADMINISTRATE_CERTIFICATE);
        Ca ca = (Ca)this.caDAO.get(certificate.getCaCertId());
        if (ca.getNetworkId() == null) {
            throw new SecurityException("Ca [" + ca.getId() + "] has no network id, thus no privilege check can be performed, thus unlocking certificate [" + certificate.getId() + "] is not allowed.");
        }
        if (this.certificateAdministrationGlobal.booleanValue() && !actions.contains(Action.ADMINISTRATE_CERTIFICATE) || !this.certificateAdministrationGlobal.booleanValue() && !ActionHelper.hasActionsForNetwork(this.actionDAO, organisationPersonId, ca.getNetworkId(), Action.EDIT_PERSON)) {
            throw new SecurityException("No privilege [editPerson or administrateCertificate] for networkId [" + ca.getNetworkId() + "] of ca [" + certificate.getCaCertId() + "] of certificate [" + certificate.getId() + "] exists for organisationPerson [" + organisationPersonId + "].  Thus unlocking the certificate is not allowed.");
        }
        certificate.setMaySign(Boolean.valueOf(true));
        certificate.setMayLogin(Boolean.valueOf(true));
        this.certificateDAO.update(certificate);
        return certificate;
    }
}

