/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.ReviewTask;
import at.cdes.api.joinDto.GenReviewTaskBaseJoin;
import at.cdes.api.joinDto.GenReviewTaskPositionJoin;
import at.cdes.api.joinDto.ReviewJoin;
import at.cdes.api.joinDto.SmallReviewTaskJoin;
import at.cdes.impl.dao.ReviewTaskDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcReviewTaskDAO;
import at.cdes.impl.dao.unionComponent.GenReviewTaskBaseComponent;
import at.cdes.impl.dao.unionComponent.ReviewJoinComponent;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.clazzes.util.aop.DAOException;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcReviewTaskDAO
extends AbstractJdbcReviewTaskDAO
implements ReviewTaskDAO {
    private static final Logger log = LoggerFactory.getLogger(JdbcReviewTaskDAO.class);

    @Override
    public List<ReviewTask> getByDocumentVersionAndReviewCycleNodeInstance(final Long documentVersionId, final Long reviewCycleNodeInstanceId) {
        String sql = "SELECT " + JdbcReviewTaskDAO.getSelectClauseForDto() + "FROM           review_task JOIN document_version_task         ON review_task.task_id = document_version_task.task_id WHERE     review_task.review_cycle_node_instance_id = ? AND document_version_task.document_version_id = ? ";
        List reviewTasks = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ReviewTask>>(){

            public List<ReviewTask> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)reviewCycleNodeInstanceId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<ReviewTask> ret = new ArrayList<ReviewTask>();
                while (resultSet.next()) {
                    ret.add(JdbcReviewTaskDAO.this.fillDtoFromResultSet(resultSet));
                }
                return ret;
            }
        });
        return reviewTasks;
    }

    @Override
    public List<ReviewTask> getObsoleteReviewTasks(final Long documentVersionId, final Long reviewCycleNodeInstanceReleasedId) {
        String sql = "SELECT " + JdbcReviewTaskDAO.getSelectClauseForDto() + "FROM ((     review_cycle_node_instance_released JOIN review_cycle_node_instance           ON review_cycle_node_instance_released.review_cycle_node_instance_id = review_cycle_node_instance.id) JOIN review_task                          ON review_task.review_cycle_node_instance_id = review_cycle_node_instance.id) JOIN document_version_task                ON review_task.task_id = document_version_task.task_id) JOIN document_version                     ON document_version_task.document_version_id = document_version.id) WHERE     review_cycle_node_instance_released.id = ? AND document_version.id = ? AND NOT EXISTS (SELECT 1 FROM  (    review_cycle_node_instance_released local_node_instance_released JOIN review_cycle_node_position_released    ON review_cycle_node_position_released.review_cycle_node_instance_id = local_node_instance_rreleased.id) WHERE review_cycle_node_position_released.project_participation_id = review_task.project_participation_id) ";
        List reviewTasks = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ReviewTask>>(){

            public List<ReviewTask> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)reviewCycleNodeInstanceReleasedId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<ReviewTask> ret = new ArrayList<ReviewTask>();
                while (resultSet.next()) {
                    ret.add(JdbcReviewTaskDAO.this.fillDtoFromResultSet(resultSet));
                }
                return ret;
            }
        });
        return reviewTasks;
    }

    public static GenReviewTaskBaseJoin fillGenReviewTaskBaseJoinFromResultSet(ResultSet rs) throws SQLException {
        GenReviewTaskBaseJoin ret = AbstractJdbcReviewTaskDAO.fillGenReviewTaskBaseJoinFromResultSet(rs);
        ret.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)(JdbcReviewTaskDAO.getNumberOfGenReviewTaskBaseJoinAttributes() + 1)));
        return ret;
    }

    @Override
    public List<GenReviewTaskBaseJoin> getGenReviewTaskBaseJoin(Long documentVersionId, Long reviewCycleNodeInstanceReleasedId) {
        String sql = "(SELECT " + this.getReviewTaskBaseUnionSelectClause(GenReviewTaskBaseComponent.DOCUMENT_VERSION, "documentVersion", "objectPlanner", "object", "subProject", "documentRelease") + "FROM           document_version JOIN document                        ON document_version.document_id = document.id JOIN object_planner                  ON document.object_planner_id = object_planner.id JOIN object                          ON object_planner.object_id = object.id JOIN document_list                   ON document.document_list_id = document_list.id JOIN sub_project                     ON document_list.sub_project_id = sub_project.id JOIN project                         ON sub_project.project_id = project.id LEFT JOIN document_list_release           ON     document_list_release.sub_project_id = sub_project.id AND document_list_release.version = (SELECT max(local_document_list_release.version) FROM document_list_release local_document_list_release WHERE local_document_list_release.sub_project_id = sub_project.id) LEFT JOIN document_release                     ON     document_release.document_list_id = document_list_release.id AND document_release.document_id = document.id WHERE document_version.id = ? ) UNION ALL (SELECT " + this.getReviewTaskBaseUnionSelectClause(GenReviewTaskBaseComponent.NODE_INSTANCE_RELEASED, "reviewCycleNodeInstanceReleased", "reviewCycleNodeInstance", "reviewCycleNode", "reviewCyclePositionType") + "FROM        review_cycle_node_instance_released JOIN review_cycle_node_instance          ON review_cycle_node_instance.id = review_cycle_node_instance_released.review_cycle_node_instance_id JOIN review_cycle_node                   ON review_cycle_node_instance_released.review_cycle_node_id = review_cycle_node.id JOIN review_cycle_position_type          ON review_cycle_node.review_cycle_position_type_id = review_cycle_position_type.id WHERE review_cycle_node_instance_released.id = ?) ";
        List<GenReviewTaskBaseJoin> ret = QueryHelper.getListWithSqlFiller((JdbcDAOSupport)this, sql, JdbcReviewTaskDAO::fillGenReviewTaskBaseJoinFromResultSet, filler -> filler.addLong(documentVersionId).addLong(reviewCycleNodeInstanceReleasedId));
        if (log.isDebugEnabled()) {
            log.debug("getGenReviewTaskBase ret = {}", ret);
        }
        return ret;
    }

    private String getReviewTaskBaseUnionSelectClause(GenReviewTaskBaseComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForGenReviewTaskBaseJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : "") + component.getValue() + " ";
    }

    public static List<GenReviewTaskBaseJoin> extractForComponent(GenReviewTaskBaseComponent component, List<GenReviewTaskBaseJoin> joins) {
        ArrayList<GenReviewTaskBaseJoin> retJoins = new ArrayList<GenReviewTaskBaseJoin>();
        for (GenReviewTaskBaseJoin join : joins) {
            if (join.getUnionClause().intValue() != component.getValue()) continue;
            retJoins.add(join);
        }
        return retJoins;
    }

    public static GenReviewTaskBaseJoin extractUniqueForComponent(GenReviewTaskBaseComponent component, List<GenReviewTaskBaseJoin> joins) {
        List<GenReviewTaskBaseJoin> componentJoins = JdbcReviewTaskDAO.extractForComponent(component, joins);
        if (componentJoins.size() == 0) {
            return null;
        }
        if (componentJoins.size() == 1) {
            return componentJoins.get(0);
        }
        throw new DAOException("Expected at most one join for component [" + (Object)((Object)component) + "], received [" + componentJoins.size() + "]");
    }

    @Override
    public List<GenReviewTaskPositionJoin> getReviewTaskPositionJoins(final Long documentVersionId, final Long reviewCycleNodeInstanceReleasedId, final Long reviewCycleNodeResultId, final Long participationId) {
        String sql = "SELECT " + JdbcReviewTaskDAO.getGenReviewTaskPositionJoinSelectClause() + "FROM (((((((((((((((((( review_cycle_node_instance_released JOIN document_version                     ON 1=1) JOIN document                             ON document_version.document_id = document.id) JOIN document_list                        ON document.document_list_id = document_list.id) JOIN review_cycle_node_instance           ON review_cycle_node_instance_released.review_cycle_node_instance_id = review_cycle_node_instance.id) JOIN review_cycle_node                    ON review_cycle_node_instance_released.review_cycle_node_id = review_cycle_node.id) JOIN review_cycle_node_position_released  ON review_cycle_node_position_released.review_cycle_node_instance_id = review_cycle_node_instance_released.id) JOIN project_participation                ON review_cycle_node_position_released.project_participation_id = project_participation.id) JOIN project                              ON project_participation.project_id = project.id) JOIN network                              ON project.network_id = network.id) JOIN realm                                ON review_cycle_node_position_released.realm_id = realm.id) LEFT JOIN project_participant                  ON     project_participant.participation_id = project_participation.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag != 1) LEFT JOIN organisation_person                  ON project_participant.organisation_person_id = organisation_person.id) LEFT JOIN person                               ON organisation_person.person_id = person.id) LEFT JOIN person_variables                     ON person_variables.person_id = person.id) LEFT JOIN localisation                         ON project.localisation_id = localisation.id) LEFT JOIN countries                            ON localisation.country_id = countries.id) LEFT JOIN ((      review_task JOIN document_version_task    ON review_task.task_id = document_version_task.task_id) JOIN review_task_position_map ON review_task_position_map.review_task_id = review_task.task_id) ON      document_version_task.document_version_id = document_version.id AND review_task.review_cycle_node_instance_id = review_cycle_node_instance.id AND review_task_position_map.review_cycle_node_position_released_id = review_cycle_node_position_released.id) LEFT JOIN (       review_cycle_position_result JOIN project_participant p2   ON review_cycle_position_result.project_participant_id = p2.id) ON     p2.participation_id = project_participation.id AND review_cycle_position_result.review_cycle_node_id = review_cycle_node.id AND review_cycle_position_result.realm_id = realm.id AND review_cycle_position_result.document_version_id = document_version.id ";
        if (reviewCycleNodeResultId != null) {
            sql = sql + "AND review_cycle_position_result.review_cycle_node_result_id = ? ";
        }
        sql = sql + "AND review_cycle_position_result.digest IS NOT NULL AND review_cycle_position_result.comment_reference_id IS NULL) WHERE     document_version.id = ? AND review_cycle_node_instance_released.id = ? ";
        if (participationId != null) {
            sql = sql + "AND project_participation.id = ? ";
        }
        List genReviewTaskJoins = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<GenReviewTaskPositionJoin>>(){

            public List<GenReviewTaskPositionJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                if (reviewCycleNodeResultId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)reviewCycleNodeResultId);
                }
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)reviewCycleNodeInstanceReleasedId);
                if (participationId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)participationId);
                }
                ResultSet resultSet = statement.executeQuery();
                ArrayList<GenReviewTaskPositionJoin> ret = new ArrayList<GenReviewTaskPositionJoin>();
                while (resultSet.next()) {
                    ret.add(AbstractJdbcReviewTaskDAO.fillGenReviewTaskPositionJoinFromResultSet(resultSet));
                }
                return ret;
            }
        });
        return genReviewTaskJoins;
    }

    @Override
    public List<GenReviewTaskPositionJoin> getAttachedReviewTaskPositionJoins(final Long documentVersionId, final Long reviewCycleNodeInstanceReleasedId, final Long reviewCycleNodeResultId) {
        String sql = "SELECT " + JdbcReviewTaskDAO.getGenReviewTaskPositionJoinSelectClause() + "FROM (((((((((((((((((( review_cycle_node_instance_released JOIN document_version) JOIN document                             ON document_version.document_id = document.id) JOIN document_list                        ON document.document_list_id = document_list.id) JOIN review_cycle_node_instance           ON review_cycle_node_instance_released.review_cycle_node_instance_id = review_cycle_node_instance.id) JOIN review_cycle_node                    ON review_cycle_node_instance_released.review_cycle_node_id = review_cycle_node.id) JOIN attached_review_cycle_node_position  ON (attached_review_cycle_node_position.review_cycle_node_instance_id = review_cycle_node_instance.id AND document_version.id = attached_review_cycle_node_position.document_version_id)) JOIN project_participation                ON attached_review_cycle_node_position.project_participation_id = project_participation.id) JOIN project                              ON project_participation.project_id = project.id) JOIN network                              ON project.network_id = network.id) JOIN realm                                ON attached_review_cycle_node_position.realm_id = realm.id) LEFT JOIN project_participant                  ON     project_participant.participation_id = project_participation.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag != 1) LEFT JOIN organisation_person                  ON project_participant.organisation_person_id = organisation_person.id) LEFT JOIN person                               ON organisation_person.person_id = person.id) LEFT JOIN person_variables                     ON person_variables.person_id = person.id) LEFT JOIN localisation                         ON project.localisation_id = localisation.id) LEFT JOIN countries                            ON localisation.country_id = countries.id) LEFT JOIN (( attached_review_task JOIN document_version_task             ON attached_review_task.task_id = document_version_task.task_id) JOIN attached_review_task_position_map ON attached_review_task_position_map.attached_review_task_id = attached_review_task.task_id) ON      document_version_task.document_version_id = document_version.id AND attached_review_task.review_cycle_node_instance_id = review_cycle_node_instance.id AND attached_review_task_position_map.attached_review_cycle_node_position_id = attached_review_cycle_node_position.id) LEFT JOIN (       review_cycle_position_result JOIN project_participant local_participant ON review_cycle_position_result.project_participant_id = local_participant.id) ON     local_participant.participation_id = project_participation.id AND review_cycle_position_result.review_cycle_node_id = review_cycle_node.id AND review_cycle_position_result.realm_id = realm.id AND review_cycle_position_result.document_version_id = document_version.id " + (reviewCycleNodeResultId != null ? "AND review_cycle_position_result.review_cycle_node_result_id = ? " : "") + "AND review_cycle_position_result.digest IS NOT NULL AND review_cycle_position_result.comment_reference_id IS NULL) LEFT JOIN review_cycle_node_position_released  ON 1=0 WHERE     document_version.id = ? AND review_cycle_node_instance_released.id = ? ";
        List genReviewTaskJoins = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<GenReviewTaskPositionJoin>>(){

            public List<GenReviewTaskPositionJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                if (reviewCycleNodeResultId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)reviewCycleNodeResultId);
                }
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)reviewCycleNodeInstanceReleasedId);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<GenReviewTaskPositionJoin> ret = new ArrayList<GenReviewTaskPositionJoin>();
                while (resultSet.next()) {
                    ret.add(AbstractJdbcReviewTaskDAO.fillGenReviewTaskPositionJoinFromResultSet(resultSet));
                }
                return ret;
            }
        });
        return genReviewTaskJoins;
    }

    private static String getTaskToReviewCycleNodeJoinsSql(boolean reviewTaskCase) {
        String taskTableName = reviewTaskCase ? "review_task" : "attached_review_task";
        String sql = "JOIN " + taskTableName + "                         ON " + taskTableName + ".task_id = task.id\n     JOIN review_cycle_node_instance          ON review_cycle_node_instance.id = " + taskTableName + ".review_cycle_node_instance_id\n     JOIN review_cycle_node                   ON review_cycle_node.id = review_cycle_node_instance.review_cycle_node_id\n";
        sql = reviewTaskCase ? sql + "JOIN review_task_position_map            ON review_task_position_map.review_task_id = task.id\nJOIN review_cycle_node_position_released ON review_cycle_node_position_released.id = review_task_position_map.review_cycle_node_position_released_id\n" : sql + "JOIN attached_review_task_position_map   ON attached_review_task_position_map.attached_review_task_id = task.id\nJOIN attached_review_cycle_node_position ON attached_review_cycle_node_position.id = attached_review_task_position_map.attached_review_cycle_node_position_id\n";
        return sql;
    }

    private String getReviewCycleNodeToPositionResultJoinsSql(boolean reviewTaskCase) {
        String taskTableName = reviewTaskCase ? "review_task" : "attached_review_task";
        String nodePositionTableName = reviewTaskCase ? "review_cycle_node_position_released" : "attached_review_cycle_node_position";
        return "     JOIN document_version_task               ON document_version_task.task_id = " + taskTableName + ".task_id\n     JOIN document_version                    ON document_version.id = document_version_task.document_version_id\n     JOIN review_cycle_node_instance          active_node_instance\n                                              ON active_node_instance.id = " + taskTableName + ".review_cycle_node_instance_id\nLEFT JOIN review_cycle_node_result            ON review_cycle_node_result.review_cycle_node_id = active_node_instance.review_cycle_node_id\n                                             AND review_cycle_node_result.document_version_id = document_version.id\nLEFT JOIN project_participant overriding_part ON overriding_part.id = ?\nLEFT JOIN (review_cycle_position_result\n     JOIN project_participant result_pant     ON result_pant.id = review_cycle_position_result.project_participant_id\n                                            ) ON review_cycle_position_result.realm_id = " + nodePositionTableName + ".realm_id\n                                             AND review_cycle_position_result.document_version_id = document_version.id\n                                             AND ((review_cycle_node_result.id IS NULL) OR review_cycle_position_result.review_cycle_node_result_id = review_cycle_node_result.id)\n                                             AND (review_cycle_position_result.signature_id IS NULL)\n                                             AND (review_cycle_position_result.comment_reference_id IS NULL)\n                                             AND review_cycle_position_result.review_cycle_node_id = review_cycle_node.id\n                                             AND ((overriding_part.id IS NULL) OR review_cycle_position_result.overriding_project_participant_id = overriding_part.id)\n                                             AND result_pant.participation_id = " + nodePositionTableName + ".project_participation_id\n";
    }

    @Override
    public List<ReviewJoin> getReviewJoins(Long reviewTaskId, Long overridingProjectParticipantId, boolean reviewTaskCase) {
        String nodePositionTableName = reviewTaskCase ? "review_cycle_node_position_released" : "attached_review_cycle_node_position";
        String sql = "SELECT " + this.getSelectClauseForReviewJoinUnion(reviewTaskCase ? "reviewCycleNodePositionReleased" : "attachedReviewCycleNodePosition", "reviewCyclePositionResult", "reviewCycleNode", "projectParticipation", "projectParticipant", "organisationPerson", "organisation", "person", "realm") + ", " + ReviewJoinComponent.POSITION.getValue() + "\n     FROM task\n" + JdbcReviewTaskDAO.getTaskToReviewCycleNodeJoinsSql(reviewTaskCase) + this.getReviewCycleNodeToPositionResultJoinsSql(reviewTaskCase) + "     JOIN project_participation               ON project_participation.id = " + nodePositionTableName + ".project_participation_id\n     JOIN project_participant                 ON project_participant.participation_id = project_participation.id\n                                             AND project_participant.inactive_flag = 0\n                                             AND project_participant.main_participant_flag = 1\n     JOIN organisation_person                 ON organisation_person.id = project_participant.organisation_person_id\n     JOIN person                              ON person.id = organisation_person.person_id\n     JOIN organisation                        ON organisation.id = organisation_person.organisation_id\n     JOIN realm                               ON realm.id = " + nodePositionTableName + ".realm_id\nWHERE task.id = ?\nUNION ALL\nSELECT " + this.getSelectClauseForReviewJoinUnion("positionResultAttachmentMap", "attachment", "attachmentPerson") + ", " + ReviewJoinComponent.ATTACHMENT.getValue() + "\n     FROM task\n" + JdbcReviewTaskDAO.getTaskToReviewCycleNodeJoinsSql(reviewTaskCase) + this.getReviewCycleNodeToPositionResultJoinsSql(reviewTaskCase) + "     JOIN position_result_attachment_map      ON position_result_attachment_map.result_id = review_cycle_position_result.id\n     JOIN attachment                          ON attachment.id = position_result_attachment_map.attachment_id\n     JOIN project_participant attachment_part ON attachment_part.id = attachment.project_participant_id\n     JOIN organisation_person att_org_per     ON att_org_per.id = attachment_part.organisation_person_id\n     JOIN person attachment_person            ON attachment_person.id = att_org_per.person_id\nWHERE task.id = ?\nUNION ALL\nSELECT DISTINCT " + this.getSelectClauseForReviewJoinUnion("reviewCycleResultOption", "documentVersion") + ", " + ReviewJoinComponent.RESULT_OPTION.getValue() + "\n     FROM task\n" + JdbcReviewTaskDAO.getTaskToReviewCycleNodeJoinsSql(reviewTaskCase) + "     JOIN document_version_task               ON document_version_task.task_id = task.id\n     JOIN document_version                    ON document_version_task.document_version_id = document_version.id\n     JOIN review_cycle_result_option          ON review_cycle_result_option.review_cycle_position_type_id = review_cycle_node.review_cycle_position_type_id\n                                             AND review_cycle_result_option.sample_control_review = 0\nWHERE task.id = ?\nUNION ALL\nSELECT " + this.getSelectClauseForReviewJoinUnion("reviewCycleNode", "objectListRelease", "objectPlannerRelease", "objectRelease", "documentListRelease", "documentVersion", "reviewCycleNodeResult", "project") + ", " + ReviewJoinComponent.NODE.getValue() + "\n     FROM task\n" + JdbcReviewTaskDAO.getTaskToReviewCycleNodeJoinsSql(reviewTaskCase) + "     JOIN document_version_task               ON document_version_task.task_id = task.id\n     JOIN document_version                    ON document_version.id = document_version_task.document_version_id\nLEFT JOIN review_cycle_node_result            ON review_cycle_node_result.review_cycle_node_id = review_cycle_node_instance.review_cycle_node_id\n                                             AND review_cycle_node_result.document_version_id = document_version.id\n     JOIN document                            ON document.id = document_version.document_id\n     JOIN document_list                       ON document_list.id = document.document_list_id\nLEFT JOIN document_list_release               ON document_list_release.document_list_id = document_list.id\n                                             AND document_list_release.version = (document_list.version - 1)\n     JOIN sub_project                         ON sub_project.id = COALESCE(document_list_release.sub_project_id, document_list.sub_project_id)\n     JOIN project                             ON project.id = sub_project.project_id\n     JOIN object_planner                      ON object_planner.id = document.object_planner_id\n" + "     JOIN object                 ON object.id = object_planner.object_id\n     JOIN object_list            ON object_list.id = object.object_list_id\n     JOIN object_list_release    ON object_list_release.object_list_id = object_list.id\n                                AND object_list_release.version = (object_list.version - 1)\n     JOIN object_release         ON object_release.object_list_release_id = object_list_release.id\n                                AND object_release.object_id = object.id\n     JOIN object_planner_release ON object_planner_release.object_id = object_release.id\n                                AND object_planner_release.object_planner_id = object_planner.id\n" + "WHERE task.id = ?\nUNION ALL\nSELECT " + this.getSelectClauseForReviewJoinUnion("commentedNodeResult", "commentedNode", "commentedVersion") + ", " + ReviewJoinComponent.COMMENT_NODE.getValue() + "\n     FROM task\n" + JdbcReviewTaskDAO.getTaskToReviewCycleNodeJoinsSql(reviewTaskCase) + this.getReviewCycleNodeToPositionResultJoinsSql(reviewTaskCase) + "     JOIN review_cycle_cell_result            ON review_cycle_cell_result.id = review_cycle_node_result.review_cycle_cell_result_id\n     JOIN node_cross_comment_connection       ON node_cross_comment_connection.commenter_id = review_cycle_node.id\n     JOIN review_cycle_node_result commented_node_result\n                                              ON commented_node_result.review_cycle_cell_result_id = review_cycle_cell_result.id\n                                             AND commented_node_result.review_cycle_node_id = node_cross_comment_connection.commented_id\n     JOIN document_version commented_version  ON commented_version.id = commented_node_result.document_version_id\n     JOIN review_cycle_node commented_node    ON commented_node.id = commented_node_result.review_cycle_node_id\nWHERE task.id = ?\nUNION ALL\nSELECT " + this.getSelectClauseForReviewJoinUnion("commentResult", "commentedResult", "commentedOrganisationPerson", "commentedPerson", "commentedOrganisation", "commentedOption", "commentedRealm") + ", " + ReviewJoinComponent.COMMENT_RESULT.getValue() + "\n     FROM task\n" + JdbcReviewTaskDAO.getTaskToReviewCycleNodeJoinsSql(reviewTaskCase) + this.getReviewCycleNodeToPositionResultJoinsSql(reviewTaskCase) + "     JOIN review_cycle_cell_result            ON review_cycle_cell_result.id = review_cycle_node_result.review_cycle_cell_result_id\n     JOIN node_cross_comment_connection       ON node_cross_comment_connection.commenter_id = review_cycle_node.id\n     JOIN review_cycle_node_result commented_node_result\n                                              ON commented_node_result.review_cycle_cell_result_id = review_cycle_cell_result.id\n                                             AND commented_node_result.review_cycle_node_id = node_cross_comment_connection.commented_id\n     JOIN review_cycle_node commented_node      ON commented_node.id = commented_node_result.review_cycle_node_id\n     JOIN review_cycle_position_result commented_result\n                                              ON commented_result.review_cycle_node_result_id = commented_node_result.id\n                                             AND (commented_result.comment_reference_id IS NULL)\n                                             AND (commented_result.digest IS NOT NULL)\nLEFT JOIN review_cycle_result_option commented_option\n                                              ON commented_option.id = commented_result.review_cycle_result_option_id\n     JOIN project_participant commented_participant\n                                              ON commented_participant.id = commented_result.project_participant_id\n     JOIN organisation_person commented_organisation_person\n                                              ON commented_organisation_person.id = commented_participant.organisation_person_id\n     JOIN person commented_person\n                                              ON commented_person.id = commented_organisation_person.person_id\n     JOIN organisation commented_organisation\n                                              ON commented_organisation.id = commented_organisation_person.organisation_id\n     JOIN realm commented_realm               ON commented_realm.id = commented_result.realm_id\nLEFT JOIN (review_cycle_position_result comment_result\n     JOIN project_participant comment_result_pant\n                                              ON comment_result_pant.id = comment_result.project_participant_id\n                                            ) ON comment_result.comment_reference_id = commented_result.id\n                                             AND comment_result.review_cycle_node_id = review_cycle_node.id\n                                             AND (comment_result.digest IS NULL)\n                                             AND comment_result_pant.participation_id = document_version_task.project_participation_id\nWHERE task.id = ?\n  AND ((commented_option.id IS NULL) OR commented_option.value >= 0)\nUNION ALL\nSELECT DISTINCT " + this.getSelectClauseForReviewJoinUnion("reviewCycleCommentOption") + ", " + ReviewJoinComponent.COMMENT_OPTION.getValue() + "\n     FROM task\n" + JdbcReviewTaskDAO.getTaskToReviewCycleNodeJoinsSql(reviewTaskCase) + "     JOIN review_cycle_comment_option         ON review_cycle_comment_option.review_cycle_comment_type_id = review_cycle_node.review_cycle_comment_type_id\nWHERE task.id = ?\n";
        List<ReviewJoin> rawJoins = QueryHelper.getListWithSqlFiller((JdbcDAOSupport)this, sql, rs -> {
            ReviewJoin dto = JdbcReviewTaskDAO.fillReviewJoinFromResultSet(rs);
            dto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)(AbstractJdbcReviewTaskDAO.getNumberOfReviewJoinAttributes() + 1)));
            return dto;
        }, filler -> filler.addLong(overridingProjectParticipantId).addLong(reviewTaskId).addLong(overridingProjectParticipantId).addLong(reviewTaskId).addLong(reviewTaskId).addLong(reviewTaskId).addLong(overridingProjectParticipantId).addLong(reviewTaskId).addLong(overridingProjectParticipantId).addLong(reviewTaskId).addLong(reviewTaskId));
        ArrayList<ReviewJoin> joins = new ArrayList<ReviewJoin>();
        HashMap<Long, ReviewJoin> reviewCycleNodeIdToJoin = new HashMap<Long, ReviewJoin>();
        for (ReviewJoin rawJoin : rawJoins) {
            if (rawJoin.getUnionClause().intValue() == ReviewJoinComponent.NODE.getValue().intValue()) {
                reviewCycleNodeIdToJoin.put(rawJoin.getReviewCycleNodeId(), rawJoin);
                continue;
            }
            joins.add(rawJoin);
        }
        joins.addAll(reviewCycleNodeIdToJoin.values());
        return joins;
    }

    @Override
    public List<ReviewTask> getByReviewTaskWithSameNodeAndVersion(Long reviewTaskId) {
        String sql = "SELECT " + JdbcReviewTaskDAO.getSelectClauseForDto() + "FROM review_task ref_review_task JOIN document_version_task ref_document_version_task ON ref_review_task.task_id = ref_document_version_task.task_id JOIN document_version_task   ON document_version_task.document_version_id = ref_document_version_task.document_version_id JOIN review_task             ON     document_version_task.task_id = review_task.task_id AND review_task.review_cycle_node_instance_id = ref_review_task.review_cycle_node_instance_id WHERE ref_review_task.task_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)reviewTaskId);
        });
    }

    @Override
    public List<SmallReviewTaskJoin> getSmallReviewTaskJoinsBySubProject(Long subProjectId, Integer taskStatus) {
        String sql = "SELECT " + JdbcReviewTaskDAO.getSmallReviewTaskJoinSelectClause() + "FROM task JOIN document_version_task               ON document_version_task.task_id = task.id JOIN review_task                         ON review_task.task_id = task.id JOIN object_planner                      ON document_version_task.object_planner_id = object_planner.id JOIN object                              ON object_planner.object_id = object.id JOIN object_list                         ON object.object_list_id = object_list.id JOIN document_version                    ON document_version_task.document_version_id = document_version.id WHERE object_list.sub_project_id = ? ";
        if (taskStatus != null) {
            sql = sql + "AND review_task.task_status = ? ";
        }
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcReviewTaskDAO::fillSmallReviewTaskJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
            if (taskStatus != null) {
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)taskStatus);
            }
        });
    }
}

