/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.debug;

import at.cdes.api.debug.DebugNode;
import at.cdes.api.dto.AttachedReviewCycleNodePosition;
import at.cdes.api.dto.AttachedReviewTask;
import at.cdes.api.dto.AttachedReviewTaskPositionMap;
import at.cdes.api.dto.BaseTask;
import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentTask;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.DocumentVersionStatusChange;
import at.cdes.api.dto.DocumentVersionTask;
import at.cdes.api.dto.Email;
import at.cdes.api.dto.EmailAttachment;
import at.cdes.api.dto.EmailSnippet;
import at.cdes.api.dto.FutureEmail;
import at.cdes.api.dto.NodelistenerEmailSnippet;
import at.cdes.api.dto.ObjectPlannerRelease;
import at.cdes.api.dto.PlottOrder;
import at.cdes.api.dto.ReviewCycleCellInstanceReleased;
import at.cdes.api.dto.ReviewCycleCellResult;
import at.cdes.api.dto.ReviewCycleEntryTask;
import at.cdes.api.dto.ReviewCycleInstanceReleased;
import at.cdes.api.dto.ReviewCycleNodeInstanceReleased;
import at.cdes.api.dto.ReviewCycleNodePositionReleased;
import at.cdes.api.dto.ReviewCycleNodeResult;
import at.cdes.api.dto.ReviewCyclePlottTask;
import at.cdes.api.dto.ReviewCyclePositionResult;
import at.cdes.api.dto.ReviewTask;
import at.cdes.api.dto.ReviewTaskPositionMap;
import at.cdes.api.dto.SelectCellConnectionMap;
import at.cdes.api.dto.SelectCellConnectionTask;
import at.cdes.api.dto.Signature;
import at.cdes.api.dto.StatusEmailSnippet;
import at.cdes.api.dto.TaskEmailSnippet;
import at.cdes.api.joinDto.ProjectParticipationJoin;
import at.cdes.api.joinDto.TaskTreeJoin;
import java.util.ArrayList;
import java.util.List;

public class DebugContext {
    private List<DebugNode> debugNodes = new ArrayList<DebugNode>();
    private List<DebugNode> currDebugNodePath = new ArrayList<DebugNode>();

    public void openDebugNode(String message) {
        DebugNode debugNode = new DebugNode(message);
        if (this.currDebugNodePath.size() == 0) {
            this.debugNodes.add(debugNode);
        } else {
            DebugNode parentNode = this.currDebugNodePath.get(this.currDebugNodePath.size() - 1);
            parentNode.appendNode(debugNode);
        }
        this.currDebugNodePath.add(debugNode);
    }

    public void closeDebugNode(String message) {
        this.addDebugMessage(message);
        this.closeDebugNode();
    }

    public void closeDebugNode() {
        if (this.currDebugNodePath.size() > 0) {
            this.currDebugNodePath.remove(this.currDebugNodePath.size() - 1);
        }
    }

    public void addDebugMessage(String message) {
        this.openDebugNode(message);
        this.closeDebugNode();
    }

    public List<DebugNode> getDebugNodes() {
        return this.debugNodes;
    }

    public void addMessage(Long id, MessageType messageType, String table, String message) {
        if (messageType == MessageType.SAVE) {
            this.addSaveMessage(id, table, message);
        } else if (messageType == MessageType.UPDATE) {
            this.addUpdateMessage(id, table, message);
        } else if (messageType == MessageType.DELETE) {
            this.addDeleteMessage(id, table, message);
        } else if (messageType == MessageType.REGISTER_SAVE) {
            this.addRegisterAddMessage(id, table, message);
        } else if (messageType == MessageType.REGISTER_DELETE) {
            this.addRegisterDeleteMessage(id, table, message);
        } else {
            throw new IllegalArgumentException("Unsupported messageType [" + (Object)((Object)messageType) + "]");
        }
    }

    public void addSaveUpdateMessage(Long id, String table, boolean save, String message) {
        if (save) {
            this.addSaveMessage(id, table, message);
        } else {
            this.addUpdateMessage(id, table, message);
        }
    }

    public void addSaveMessage(Long id, String table, String message) {
        this.addDebugMessage("[SAVE][" + table + "][id = " + id + "] " + message);
    }

    public void addUpdateMessage(Long id, String table, String message) {
        this.addDebugMessage("[UPDATE][" + table + "][id = " + id + "] " + message);
    }

    public void addDeleteMessage(Long id, String table, String message) {
        this.addDebugMessage("[DELETE][" + table + "][id = " + id + "] " + message);
    }

    public void addRegisterAddMessage(Long id, String table, String message) {
        this.addDebugMessage("[REGISTER-FOR-ADD][" + table + "][id = " + id + "] " + message);
    }

    public void addRegisterDeleteMessage(Long id, String table, String message) {
        this.addDebugMessage("[REGISTER-FOR-DELETE][" + table + "][id = " + id + "] " + message);
    }

    public void addUpdateAttachedReviewCycleNodePositionMessage(AttachedReviewCycleNodePosition attachedReviewCycleNodePosition) {
        Long id = attachedReviewCycleNodePosition.getId();
        Long realmId = attachedReviewCycleNodePosition.getRealmId();
        Long participationId = attachedReviewCycleNodePosition.getProjectParticipationId();
        Long documentVersionId = attachedReviewCycleNodePosition.getDocumentVersionId();
        Long nodeInstanceId = attachedReviewCycleNodePosition.getReviewCycleNodeInstanceId();
        this.addUpdateMessage(id, "AttachedReviewCycleNodePosition", "--> documentVersion [" + documentVersionId + "], participationId [" + participationId + "], realmId [" + realmId + "], nodeInstanceId [" + nodeInstanceId + "]");
    }

    public void addSaveAttachedReviewTaskMessage(AttachedReviewTask attachedReviewTask) {
        Long taskId = attachedReviewTask.getTaskId();
        String realmDescription = attachedReviewTask.getRealmDescription();
        Long nodeInstanceId = attachedReviewTask.getReviewCycleNodeInstanceId();
        Integer taskStatus = attachedReviewTask.getTaskStatus();
        this.addSaveMessage(taskId, "AttachedReviewTask", "taskStatus [" + taskStatus + "], realmDescription [" + realmDescription + "] --> nodeInstanceId [" + nodeInstanceId + "]");
    }

    public void addUpdateAttachedReviewTaskMessage(AttachedReviewTask attachedReviewTask) {
        Long taskId = attachedReviewTask.getTaskId();
        String realmDescription = attachedReviewTask.getRealmDescription();
        Long nodeInstanceId = attachedReviewTask.getReviewCycleNodeInstanceId();
        Integer taskStatus = attachedReviewTask.getTaskStatus();
        this.addUpdateMessage(taskId, "AttachedReviewTask", "taskStatus [" + taskStatus + "], realmDescription [" + realmDescription + "] --> nodeInstanceId [" + nodeInstanceId + "]");
    }

    public void addSaveAttachedReviewTaskPositionMapMessage(AttachedReviewTaskPositionMap positionMap) {
        Long attachedReviewTaskId = positionMap.getAttachedReviewTaskId();
        Long attachedReviewCycleNodePositionId = positionMap.getAttachedReviewCycleNodePositionId();
        this.addSaveMessage(null, "AttachedReviewTaskPositionMap", "--> taskId [" + attachedReviewTaskId + "], attachedReviewCycleNodePositionId [" + attachedReviewCycleNodePositionId + "]");
    }

    public void addUpdateAttachedReviewTaskPositionMapMessage(AttachedReviewTaskPositionMap positionMap) {
        Long attachedReviewTaskId = positionMap.getAttachedReviewTaskId();
        Long attachedReviewCycleNodePositionId = positionMap.getAttachedReviewCycleNodePositionId();
        this.addUpdateMessage(null, "AttachedReviewTaskPositionMap", "--> taskId [" + attachedReviewTaskId + "], attachedReviewCycleNodePositionId [" + attachedReviewCycleNodePositionId + "]");
    }

    public void addUpdateDocumentVersionMessage(DocumentVersion documentVersion) {
        Long id = documentVersion.getId();
        String name = documentVersion.getName();
        Integer status = documentVersion.getStatus();
        Long activeNodeInstanceId = documentVersion.getActiveNodeInstanceId();
        this.addUpdateMessage(id, "DocumentVersion", "name [" + name + "], status [" + name + "] --> activeNodeInstanceId [" + activeNodeInstanceId + "]");
    }

    public void addUpdateDocumentVersionStatusStatusChange(DocumentVersion documentVersion) {
        Long id = documentVersion.getId();
        Integer status = documentVersion.getStatus();
        this.addUpdateMessage(id, "DocumentVersion", "--> status [" + status + "]");
    }

    public void addSaveDocumentVersionStatusChange(DocumentVersionStatusChange documentVersionStatusChange) {
        Long id = documentVersionStatusChange.getId();
        Long documentVersionId = documentVersionStatusChange.getDocumentVersionId();
        Integer oldStatus = documentVersionStatusChange.getOldStatus();
        Integer newStatus = documentVersionStatusChange.getNewStatus();
        this.addSaveMessage(id, "DocumentVersionStatusChange", "oldStatus [" + oldStatus + "] --> newStatus [" + newStatus + "]; --> documentVersionId [" + documentVersionId + "]");
    }

    public void addUpdateObjectPlannerReleasedMessage(ObjectPlannerRelease objectPlannerRelease) {
        Long id = objectPlannerRelease.getId();
        Long objectPlannerId = objectPlannerRelease.getObjectPlannerId();
        Long objectReleaseId = objectPlannerRelease.getObjectId();
        Long plannerId = objectPlannerRelease.getPlannerId();
        String code = objectPlannerRelease.getCode();
        String area = objectPlannerRelease.getArea();
        this.addUpdateMessage(id, "ObjectPlannerRelease", "code = [" + code + "], area = [" + area + "] --> objectPlannerId [" + objectPlannerId + "], objectReleaseId = [" + objectReleaseId + "], plannerId = [" + plannerId + "]");
    }

    public void addUpdatePlotOrderMessage(PlottOrder plotOrder) {
        Long id = plotOrder.getId();
        Long jobNumber = plotOrder.getJobNumber();
        Long plotterId = plotOrder.getPlotterId();
        Long templateId = plotOrder.getTemplateId();
        Long requestId = plotOrder.getRequestId();
        Long acceptanceId = plotOrder.getAcceptanceId();
        Long completedId = plotOrder.getCompletedId();
        Long chargedStepId = plotOrder.getChargedStepId();
        this.addUpdateMessage(id, "PlotOrder", "jobNumber [" + jobNumber + "] --> plotterId [" + plotterId + "], templateId [" + templateId + "], requestId [" + requestId + "], acceptanceId [" + acceptanceId + "], completedId [" + completedId + "], chargedStepId [" + chargedStepId + "]");
    }

    public void addUpdateDocumentInvalidateMessage(Document document) {
        this.addUpdateMessage(document.getId(), "Document", "name = [" + document.getName() + "]");
    }

    public void addSaveDocumentTaskMessage(DocumentTask documentTask) {
        this.addDocumentTaskMessage(documentTask, MessageType.SAVE);
    }

    public void addDeleteDocumentTaskMessage(DocumentTask documentTask) {
        this.addDocumentTaskMessage(documentTask, MessageType.DELETE);
    }

    private void addDocumentTaskMessage(DocumentTask documentTask, MessageType messageType) {
        Long taskId = documentTask.getTaskId();
        Long projectParticipationId = documentTask.getProjectParticipationId();
        Long documentId = documentTask.getDocumentId();
        Long objectPlannerId = documentTask.getObjectPlannerId();
        this.addMessage(taskId, messageType, "DocumentTask (--> ReviewCycleEntryTask)", "--> projectParticipationId [" + projectParticipationId + "], documentId [" + documentId + "], objectPlannerId [" + objectPlannerId + "]");
    }

    public void addSaveDocumentVersionTaskMessage(DocumentVersionTask documentVersionTask) {
        Long taskId = documentVersionTask.getTaskId();
        Long projectParticipationId = documentVersionTask.getProjectParticipationId();
        Long documentVersionId = documentVersionTask.getDocumentVersionId();
        Long objectPlannerId = documentVersionTask.getObjectPlannerId();
        this.addSaveMessage(taskId, "DocumentVersionTask", "--> projectParticipationId [" + projectParticipationId + "], documentVersionId [" + documentVersionId + "], objectPlannerId [" + objectPlannerId + "]");
    }

    public void addUpdateDocumentVersionTaskMessage(DocumentVersionTask documentVersionTask) {
        Long taskId = documentVersionTask.getTaskId();
        Long projectParticipationId = documentVersionTask.getProjectParticipationId();
        Long documentVersionId = documentVersionTask.getDocumentVersionId();
        Long objectPlannerId = documentVersionTask.getObjectPlannerId();
        this.addUpdateMessage(taskId, "DocumentVersionTask", "--> projectParticipationId [" + projectParticipationId + "], documentVersionId [" + documentVersionId + "], objectPlannerId [" + objectPlannerId + "]");
    }

    public void addSaveEmailMessage(Email email) {
        Long id = email.getId();
        String toAdr = email.getToAdr();
        String toName = email.getToName();
        String subject = email.getSubject();
        Long receiverOrgPersonId = email.getOrganisationPersonId();
        this.addSaveMessage(id, "Email", "toAdr [" + toAdr + "], toName [" + toName + "], receiverOrgPerson [" + receiverOrgPersonId + "], subject [" + subject + "]");
    }

    public void addSaveEmailAttachmentMessage(EmailAttachment emailAttachment) {
        Long id = emailAttachment.getId();
        Long emailId = emailAttachment.getEmailId();
        String mimeSource = emailAttachment.getMimeSource();
        String parameters = emailAttachment.getParameters();
        this.addSaveMessage(id, "EmailAttachment", "mimeSource [" + mimeSource + "], parameters [" + parameters + "] --> emailId [" + emailId + "]");
    }

    public void addSaveEmailSnippetMessage(EmailSnippet emailSnippet, ProjectParticipationJoin participationJoin) {
        Long id = emailSnippet.getId();
        Long organisationPersonId = emailSnippet.getOrganisationPersonId();
        Double sendTime = emailSnippet.getSendTime();
        Long participationId = participationJoin != null ? participationJoin.getProjectParticipationId() : null;
        String givenName = participationJoin != null ? participationJoin.getPersonGivenName() : null;
        String surName = participationJoin != null ? participationJoin.getPersonSurName() : null;
        String organisationName = participationJoin != null ? participationJoin.getOrganisationName() : null;
        this.addSaveMessage(id, "EmailSnippet", "orgPersonId [" + organisationPersonId + "], sendTime [" + sendTime + "] --> participationId [" + participationId + "], givenName [" + givenName + "], surName [" + surName + "], organisationName [" + organisationName + "]");
    }

    public void addUpdateEmailSnippetMessage(EmailSnippet emailSnippet) {
        Long id = emailSnippet.getId();
        Long organisationPersonId = emailSnippet.getOrganisationPersonId();
        Double sendTime = emailSnippet.getSendTime();
        this.addUpdateMessage(id, "EmailSnippet", "orgPersonId [" + organisationPersonId + "], sendTime [" + sendTime + "]");
    }

    public void addSaveNodeResultMessage(ReviewCycleNodeResult nodeResult) {
        this.addNodeResultMessage(nodeResult, MessageType.SAVE);
    }

    public void addUpdateNodeResultMessage(ReviewCycleNodeResult nodeResult) {
        this.addNodeResultMessage(nodeResult, MessageType.UPDATE);
    }

    public void addDeleteNodeResultMessage(ReviewCycleNodeResult nodeResult) {
        this.addNodeResultMessage(nodeResult, MessageType.DELETE);
    }

    public void addNodeResultMessage(ReviewCycleNodeResult nodeResult, MessageType messageType) {
        Long id = nodeResult.getId();
        Boolean finished = nodeResult.getFinished();
        Double arrivalDate = nodeResult.getArrivalDate();
        Double departureDate = nodeResult.getDepartureDate();
        Long documentVersionId = nodeResult.getDocumentVersionId();
        Long arrivalObjectListReleaseId = nodeResult.getArrivalObjectListId();
        Long departureObjectListReleaseId = nodeResult.getDepartureObjectListId();
        Long resultOptionId = nodeResult.getReviewCycleResultOptionId();
        Long cellResultId = nodeResult.getReviewCycleCellResultId();
        Long nodeId = nodeResult.getReviewCycleNodeId();
        this.addMessage(id, messageType, "NodeResult", "finished [" + finished + ", arrivalObjListRelease [" + arrivalObjectListReleaseId + "], arrivalDate [" + arrivalDate + "], departureObjListRelease [" + departureObjectListReleaseId + "], departureDate [" + departureDate + "], resultOptionId [" + resultOptionId + "] --> documentVersionId [" + documentVersionId + "], cellResultId [" + cellResultId + "], nodeId [" + nodeId + "]");
    }

    public void addSaveStatusEmailSnippetMessage(StatusEmailSnippet statusEmailSnippet) {
        Long emailSnippetId = statusEmailSnippet.getEmailSnippetId();
        Integer type = statusEmailSnippet.getType();
        Long documentVersionId = statusEmailSnippet.getDocumentVersionId();
        this.addSaveMessage(emailSnippetId, "StatusEmailSnippet", "type [" + type + "], documentVersionId [" + documentVersionId + "]");
    }

    public void addSaveNodeListenerEmailSnippetMessage(NodelistenerEmailSnippet nodeListenerEmailSnippet) {
        Long emailSnippetId = nodeListenerEmailSnippet.getEmailSnippetId();
        Long nodeListenerId = nodeListenerEmailSnippet.getNodelistenerId();
        Long documentVersionId = nodeListenerEmailSnippet.getDocumentVersionId();
        this.addSaveMessage(emailSnippetId, "NodeListenerEmailSnippet", "nodeListenerId [" + nodeListenerId + "], documentVersionId [" + documentVersionId + "]");
    }

    public void addSavePlotOrderMessage(PlottOrder plotOrder) {
        Long id = plotOrder.getId();
        Long jobNumber = plotOrder.getJobNumber();
        Long plotterId = plotOrder.getPlotterId();
        Long templateId = plotOrder.getTemplateId();
        Long requestId = plotOrder.getRequestId();
        Long acceptanceId = plotOrder.getAcceptanceId();
        Long completedId = plotOrder.getCompletedId();
        Long chargedStepId = plotOrder.getChargedStepId();
        this.addSaveMessage(id, "PlotOrder", "jobNumber [" + jobNumber + "] --> plotterId [" + plotterId + "], templateId [" + templateId + "], requestId [" + requestId + "], acceptanceId [" + acceptanceId + "], completedId [" + completedId + "], chargedStepId [" + chargedStepId + "]");
    }

    public void addSaveReviewCyclePlotTaskMessage(ReviewCyclePlottTask reviewCyclePlotTask) {
        Long id = reviewCyclePlotTask.getTaskId();
        Long orderId = reviewCyclePlotTask.getOrderId();
        Long orderStepId = reviewCyclePlotTask.getOrderStepId();
        this.addSaveMessage(id, "ReviewCyclePlotTask", "--> orderId [" + orderId + "], orderStepId [" + orderStepId + "]");
    }

    public void addSaveTaskEmailSnippetMessage(TaskEmailSnippet taskEmailSnippet) {
        Long emailSnippetId = taskEmailSnippet.getEmailSnippetId();
        Long taskId = taskEmailSnippet.getTaskId();
        Integer type = taskEmailSnippet.getType();
        this.addSaveMessage(taskId, "TaskEmailSnippet", "emailSnippetId [" + emailSnippetId + "],taskId [" + taskId + "], type [" + type + "]");
    }

    public void addUpdateTaskEmailSnippetMessage(TaskEmailSnippet taskEmailSnippet) {
        Long emailSnippetId = taskEmailSnippet.getEmailSnippetId();
        Long taskId = taskEmailSnippet.getTaskId();
        Integer type = taskEmailSnippet.getType();
        this.addUpdateMessage(taskId, "TaskEmailSnippet", "emailSnippetId [" + emailSnippetId + "],taskId [" + taskId + "], type [" + type + "]");
    }

    public void addSaveTaskMessage(BaseTask task) {
        Long id = task.getId();
        String name = task.getName();
        Double beginDate = task.getBeginDate();
        Double endDate = task.getEndDate();
        Integer deltaT = task.getDeltaT();
        Integer beginDelay = task.getBeginDelay();
        this.addSaveMessage(id, "Task", "name [" + name + "], beginDate [" + beginDate + "], endDate [" + endDate + "], deltaT [" + deltaT + "], beginDelay [" + beginDelay + "]");
    }

    public void addUpdateTaskMessage(BaseTask task) {
        Long id = task.getId();
        String name = task.getName();
        Double beginDate = task.getBeginDate();
        Double endDate = task.getEndDate();
        Integer deltaT = task.getDeltaT();
        Integer beginDelay = task.getBeginDelay();
        this.addUpdateMessage(id, "Task", "name [" + name + "], beginDate [" + beginDate + "], endDate [" + endDate + "], deltaT [" + deltaT + "], beginDelay [" + beginDelay + "]");
    }

    public void addRegisterAddEmailSnippetMessage(EmailSnippet emailSnippet) {
        Long id = emailSnippet.getId();
        Long organisationPersonId = emailSnippet.getOrganisationPersonId();
        Double sendTime = emailSnippet.getSendTime();
        this.addRegisterAddMessage(id, "EmailSnippet", "orgPersonId [" + organisationPersonId + "], sendTime [" + sendTime + "]");
    }

    public void addRegisterAddFutureEmailMessage(FutureEmail futureEmail) {
        Long id = futureEmail.getId();
        Long participationId = futureEmail.getProjectParticipationId();
        Long taskId = futureEmail.getTaskId();
        Integer type = futureEmail.getType();
        Boolean mainParticipantOnly = futureEmail.getMainParticipantOnly();
        Double sendTime = futureEmail.getSendTime();
        this.addRegisterAddMessage(id, "FutureEmail", "type [" + type + "], mainParticipantOnly [" + mainParticipantOnly + "], sendTime [" + sendTime + "] --> taskId [" + taskId + "], participationId [" + participationId + "]");
    }

    public void addRegisterAddTaskEmailSnippetMessage(TaskEmailSnippet taskEmailSnippet) {
        Long emailSnippetId = taskEmailSnippet.getEmailSnippetId();
        Long taskId = taskEmailSnippet.getTaskId();
        Integer type = taskEmailSnippet.getType();
        this.addRegisterAddMessage(taskId, "TaskEmailSnippet", "emailSnippetId [" + emailSnippetId + "],taskId [" + taskId + "], type [" + type + "]");
    }

    public void addRegisterDeleteFutureEmailMessage(FutureEmail futureEmail) {
        Long id = futureEmail.getId();
        Long participationId = futureEmail.getProjectParticipationId();
        Long taskId = futureEmail.getTaskId();
        Integer type = futureEmail.getType();
        Boolean mainParticipantOnly = futureEmail.getMainParticipantOnly();
        Double sendTime = futureEmail.getSendTime();
        this.addRegisterDeleteMessage(id, "FutureEmail", "type [" + type + "], mainParticipantOnly [" + mainParticipantOnly + "], sendTime [" + sendTime + "] --> taskId [" + taskId + "], participationId [" + participationId + "]");
    }

    public void addDeleteFutureEmailMessage(Long id) {
        this.addDeleteMessage(id, "FutureEmail", "");
    }

    public void addDeleteDocumentVersionTaskMessage(TaskTreeJoin taskTreeJoin, String taskType) {
        Long taskId = taskTreeJoin.getTaskId();
        Long projectParticipationId = taskTreeJoin.getDocumentVersionTaskProjectParticipationId();
        Long documentVersionId = taskTreeJoin.getDocumentVersionTaskDocumentVersionId();
        Long objectPlannerId = taskTreeJoin.getDocumentVersionTaskObjectPlannerId();
        this.addDeleteMessage(taskId, taskType, "--> projectParticipationId [" + projectParticipationId + "], documentVersionId [" + documentVersionId + "], objectPlannerId [" + objectPlannerId + "]");
    }

    public void addSaveFutureEmailMessage(FutureEmail futureEmail) {
        Long id = futureEmail.getId();
        Long participationId = futureEmail.getProjectParticipationId();
        Long taskId = futureEmail.getTaskId();
        Integer type = futureEmail.getType();
        Boolean mainParticipantOnly = futureEmail.getMainParticipantOnly();
        Double sendTime = futureEmail.getSendTime();
        this.addSaveMessage(id, "FutureEmail", "type [" + type + "], mainParticipantOnly [" + mainParticipantOnly + "], sendTime [" + sendTime + "] --> taskId [" + taskId + "], participationId [" + participationId + "]");
    }

    public void addUpdateFutureEmailMessage(FutureEmail futureEmail) {
        Long id = futureEmail.getId();
        Long participationId = futureEmail.getProjectParticipationId();
        Long taskId = futureEmail.getTaskId();
        Integer type = futureEmail.getType();
        Boolean mainParticipantOnly = futureEmail.getMainParticipantOnly();
        Double sendTime = futureEmail.getSendTime();
        this.addUpdateMessage(id, "FutureEmail", "type [" + type + "], mainParticipantOnly [" + mainParticipantOnly + "], sendTime [" + sendTime + "] --> taskId [" + taskId + "], participationId [" + participationId + "]");
    }

    public void addSaveReviewCycleInstanceReleasedMessage(ReviewCycleInstanceReleased instanceReleased) {
        Long id = instanceReleased.getId();
        Long objectListReleaseId = instanceReleased.getObjectListId();
        Integer duration = instanceReleased.getDuration();
        Integer durationMin = instanceReleased.getDurationMin();
        Integer durationPre = instanceReleased.getDurationPre();
        String name = instanceReleased.getName();
        this.addSaveMessage(id, "InstanceReleased", "duration = [" + duration + "], durationMin = [" + durationMin + "], durationPre = [" + durationPre + "], [name = " + name + "] --> objectListReleaseId [" + objectListReleaseId + "]");
    }

    public void addSaveReviewCycleCellInstanceReleasedMessage(ReviewCycleCellInstanceReleased cellInstanceReleased) {
        Long id = cellInstanceReleased.getId();
        Long instanceReleasedId = cellInstanceReleased.getReviewCycleCellInstanceId();
        Long cellId = cellInstanceReleased.getReviewCycleCellId();
        Boolean startCell = cellInstanceReleased.getStartCell();
        this.addSaveMessage(id, "CellInstanceReleased", "startCell = [" + startCell + "] --> instanceReleasedId [" + instanceReleasedId + "], cellId [" + cellId + "]");
    }

    public void addUpdateReviewCycleCellResultMessage(ReviewCycleCellResult cellResult) {
        Long id = cellResult.getId();
        Boolean finished = cellResult.getFinished();
        Double arrivalDate = cellResult.getArrivalDate();
        Double departureDate = cellResult.getDepartureDate();
        Long documentVersionId = cellResult.getDocumentVersionId();
        Long cellId = cellResult.getReviewCycleCellId();
        Long nextCellId = cellResult.getNextReviewCycleCellId();
        Long prevCellId = cellResult.getPreviousReviewCycleCellId();
        this.addUpdateMessage(id, "ReviewCycleCellResult", "finished = [" + finished + "], arrivalDate [" + arrivalDate + "], departureDate [" + departureDate + "] --> documentVersion [" + documentVersionId + "], cellId [" + cellId + "], nextCell [" + nextCellId + "], prevCellId [" + prevCellId + "]");
    }

    public void addSaveReviewCycleNodeInstanceReleasedMessage(ReviewCycleNodeInstanceReleased nodeInstanceReleased) {
        Long id = nodeInstanceReleased.getId();
        Long cellInstanceReleasedId = nodeInstanceReleased.getReviewCycleCellInstanceId();
        Long nodeId = nodeInstanceReleased.getReviewCycleNodeId();
        Integer duration = nodeInstanceReleased.getDuration();
        Integer durationMin = nodeInstanceReleased.getDurationMin();
        Boolean free = nodeInstanceReleased.getFree();
        this.addSaveMessage(id, "NodeInstanceReleased", "free = [" + free + "], duration = [" + duration + "], durationMin = [" + durationMin + "] --> cellInstanceReleasedId [" + cellInstanceReleasedId + "], nodeId [" + nodeId + "]");
    }

    public void addSaveReviewTaskMessage(ReviewTask reviewTask) {
        Long taskId = reviewTask.getTaskId();
        String realmDescription = reviewTask.getRealmDescription();
        Long nodeInstanceId = reviewTask.getReviewCycleNodeInstanceId();
        Integer taskStatus = reviewTask.getTaskStatus();
        this.addSaveMessage(taskId, "ReviewTask", "taskStatus [" + taskStatus + "], realmDescription [" + realmDescription + "] --> nodeInstanceId [" + nodeInstanceId + "]");
    }

    public void addUpdateReviewTaskMessage(ReviewTask reviewTask) {
        Long taskId = reviewTask.getTaskId();
        String realmDescription = reviewTask.getRealmDescription();
        Long nodeInstanceId = reviewTask.getReviewCycleNodeInstanceId();
        Integer taskStatus = reviewTask.getTaskStatus();
        this.addUpdateMessage(taskId, "ReviewTask", "taskStatus [" + taskStatus + "], realmDescription [" + realmDescription + "] --> nodeInstanceId [" + nodeInstanceId + "]");
    }

    public void addDeleteReviewTaskMessage(ReviewTask reviewTask) {
        Long taskId = reviewTask.getTaskId();
        String realmDescription = reviewTask.getRealmDescription();
        Long nodeInstanceId = reviewTask.getReviewCycleNodeInstanceId();
        Integer taskStatus = reviewTask.getTaskStatus();
        this.addDeleteMessage(taskId, "ReviewTask", "taskStatus [" + taskStatus + "], realmDescription [" + realmDescription + "] --> nodeInstanceId [" + nodeInstanceId + "]");
    }

    public void addSaveReviewTaskPositionMapMessage(ReviewTaskPositionMap positionMap) {
        this.addReviewTaskPositionMapMessage(positionMap, MessageType.SAVE);
    }

    public void addUpdateReviewTaskPositionMapMessage(ReviewTaskPositionMap positionMap) {
        this.addReviewTaskPositionMapMessage(positionMap, MessageType.UPDATE);
    }

    public void addDeleteReviewTaskPositionMapMessage(ReviewTaskPositionMap positionMap) {
        this.addReviewTaskPositionMapMessage(positionMap, MessageType.DELETE);
    }

    public void addReviewTaskPositionMapMessage(ReviewTaskPositionMap positionMap, MessageType messageType) {
        Long taskId = positionMap.getReviewTaskId();
        Long nodePositionReleasedId = positionMap.getReviewCycleNodePositionReleasedId();
        this.addMessage(null, messageType, "ReviewTaskPositionMap", "--> taskId [" + taskId + "], nodePositionReleasedId [" + nodePositionReleasedId + "]");
    }

    public void addSaveNodePositionReleasedMessage(ReviewCycleNodePositionReleased nodePositionReleased) {
        Long id = nodePositionReleased.getId();
        Long nodeInstanceReleased = nodePositionReleased.getReviewCycleNodeInstanceId();
        Long realmId = nodePositionReleased.getRealmId();
        Long participationId = nodePositionReleased.getProjectParticipationId();
        this.addSaveMessage(id, "PositionReleased", "--> nodeInstanceReleased = [" + nodeInstanceReleased + "], realmId [" + realmId + "], participationId [" + participationId + "]");
    }

    public void addSavePositionResultMessage(ReviewCyclePositionResult positionResult) {
        Long id = positionResult.getId();
        Long activeObjectListId = positionResult.getActiveObjectListId();
        Long activeDocumentListId = positionResult.getActiveDocumentListId();
        Long documentVersionId = positionResult.getDocumentVersionId();
        Long participantId = positionResult.getProjectParticipantId();
        Long nodeId = positionResult.getReviewCycleNodeId();
        Long nodeResultId = positionResult.getReviewCycleNodeResultId();
        Long resultOptionId = positionResult.getReviewCycleResultOptionId();
        this.addSaveMessage(id, "PositionResult", "--> objectListRelease [" + activeObjectListId + "]; documentListRelease [" + activeDocumentListId + "]; documentVersionId [" + documentVersionId + "]; participantId [" + participantId + "]; nodeId [" + nodeId + "]; nodeResultId [" + nodeResultId + "]; resultOptionId [" + resultOptionId + "]");
    }

    public void addSaveReviewCycleEntryTaskMessage(ReviewCycleEntryTask task) {
        Long taskId = task.getTaskId();
        this.addSaveMessage(taskId, "ReviewCycleEntryTask", "");
    }

    public void addSaveSelectCellConnectionMapMessage(SelectCellConnectionMap map) {
        Long cellConnectionId = map.getReviewCycleCellConnectionId();
        Long taskId = map.getSelectCellConnectionTaskId();
        this.addSaveMessage(null, "SelectCellConnectionMap", "--> cellConnectionId [" + cellConnectionId + "], taskId [" + taskId + "]");
    }

    public void addSaveSelectCellConnectionTaskMessage(SelectCellConnectionTask task) {
        Long id = task.getTaskId();
        Long nodeInstanceId = task.getReviewCycleNodeInstanceId();
        this.addSaveMessage(id, "SelectCellConnectionTask", "--> nodeInstanceId [" + nodeInstanceId + "]");
    }

    public void addMessageSaveSignature(Signature signature) {
        Long id = signature.getId();
        Long participantId = signature.getProjectParticipantId();
        this.addSaveMessage(id, "Signature", "--> ParticipantId [" + participantId + "]");
    }

    private static enum MessageType {
        SAVE,
        UPDATE,
        DELETE,
        REGISTER_SAVE,
        REGISTER_UPDATE,
        REGISTER_DELETE;

    }
}

