/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.obj;

import at.cdes.api.dto.ExportResult;
import at.cdes.api.dto.ObjectList;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.ObjectListReleaseJoin;
import at.cdes.api.obj.dto.ObjectInfo;
import at.cdes.api.obj.dto.ObjectPlannerInfo;
import at.cdes.api.obj.dto.ObjectPlannerPositionInfo;
import at.cdes.api.obj.dto.ObjectSearchModel;
import at.cdes.api.obj.voc.ObjectListChangedState;
import at.cdes.api.voc.OdfExportSlot;
import at.cdes.api.voc.misc.SortDirection;
import at.cdes.api.voc.misc.SortOrder;
import at.cdes.impl.dao.ObjectListDAO;
import at.cdes.impl.dao.ObjectListReleaseDAO;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.dao.SubProjectDAO;
import at.cdes.impl.export.obj.ObjectListChangedStyles;
import at.cdes.impl.export.obj.ObjectListCols;
import at.cdes.impl.export.obj.ObjectListExportHelper;
import at.cdes.impl.export.planning.CompareHelper;
import at.cdes.impl.export.planning.PlanningReportXlsExporter;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.util.SearchHelper;
import at.cdes.impl.util.odf.OdfHelper;
import java.io.File;
import java.text.Collator;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.odf.util.table.FancyOdfTable;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.odf.util.text.TextFactory;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sched.cache.ScratchFile;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.w3c.dom.Node;

public class ObjectListXlsExporter {
    private ObjectListDAO objectListDAO;
    private ObjectListReleaseDAO objectListReleaseDAO;
    private String odfStylePrefix;
    private Long odfTimeout;
    private OOoFileEngine oooFileEngine = null;
    private PersonVariablesDAO personVariablesDAO;
    private SubProjectDAO subProjectDAO;
    private String tempDirName;

    public void setObjectListDAO(ObjectListDAO objectListDAO) {
        this.objectListDAO = objectListDAO;
    }

    public void setObjectListReleaseDAO(ObjectListReleaseDAO objectListReleaseDAO) {
        this.objectListReleaseDAO = objectListReleaseDAO;
    }

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    public void setTempDir(String tempDirName) {
        this.tempDirName = tempDirName;
    }

    public ScratchFile export(Long loginOrganisationPersonId, List<ObjectInfo> objectInfos, ObjectSearchModel searchModel, SortOrder sortOrder, boolean enableCustomerLogo) throws Exception {
        OdfSpreadsheetDocument document = DocumentFactory.constructSpreadsheetDocument((String)"export/emptyOdsTemplate.ods", PlanningReportXlsExporter.class, (Locale)ThreadLocalManager.getLoginLocale());
        OdfContext context = new OdfContext((OdfDocument)document, this.odfStylePrefix);
        String personVariablesUserLocale = OdfHelper.getPersonVariablesUserLocaleByPrincipal(this.personVariablesDAO);
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariablesUserLocale);
        this.fillDocument(objectInfos, searchModel, context, resourceBundle, document, sortOrder, personVariablesUserLocale);
        String xlsFileName = OdfFileHelper.saveAndConvert((String)this.tempDirName, (String)"cdes_Objektliste_", (OdfSpreadsheetDocument)document, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.MSEXCEL_2007_XML, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout, (Integer)OdfExportSlot.DEFAULT.getValue(), null);
        ExportResult exportResult = OdfHelper.constructExportResult(xlsFileName);
        String tmpFileName = exportResult.getTmpFileName();
        String encodedFileName = "Test";
        ScratchFile scratchFile = new ScratchFile(new File(tmpFileName), "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "attachment; filename*=UTF-8''" + encodedFileName);
        return scratchFile;
    }

    private void fillDocument(List<ObjectInfo> objectInfos, ObjectSearchModel searchModel, OdfContext context, ResourceBundle resourceBundle, OdfSpreadsheetDocument document, SortOrder sortOrder, String personVariablesUserLocale) {
        String versionLabel;
        boolean released = searchModel.isReleased();
        Long objectListReleaseId = null;
        ContextJoin contextJoin = null;
        ObjectListReleaseJoin objectListReleaseJoin = null;
        ObjectList objectList = null;
        if (released) {
            objectListReleaseId = searchModel.getObjectListReleaseId();
            contextJoin = this.objectListReleaseDAO.getContextJoin(objectListReleaseId);
            objectListReleaseJoin = this.objectListReleaseDAO.getObjectListReleaseJoinById(objectListReleaseId);
            versionLabel = ObjectListExportHelper.getReleasedVersionLabel(objectListReleaseJoin, resourceBundle);
        } else {
            Long subProjectId = searchModel.getSourceSubProjectId();
            contextJoin = this.subProjectDAO.getSubProjectContextJoin(subProjectId);
            List<ObjectList> objectLists = this.objectListDAO.getBySubProject(subProjectId);
            objectList = objectLists.get(0);
            versionLabel = ObjectListExportHelper.getUnreleasedVersionLabel(objectList, resourceBundle);
        }
        List tableElements = document.getTables();
        TableTableElement tableElement = (TableTableElement)tableElements.get(0);
        tableElement.setTableNameAttribute(resourceBundle.getString("objectListXlsTableName"));
        TableFactory.cleanTableElementBeforeUsage((TableTableElement)tableElement);
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        String standardParagraphStyle = OdfHelper.constructStandardParagraphStyle(stylesOfficeStyles);
        String dataRowStyle = OdfHelper.getDataTableRowStyle(contentAutomaticStyles);
        String dataCellStyle = OdfHelper.getDataTableDataCellStyle(contentAutomaticStyles);
        String dataCellStyleNoWrapHidden = OdfHelper.getDataTableDataCellStyleNoWrapHidden(contentAutomaticStyles);
        String dataBoldCellStyle = OdfHelper.getDataTableDataBoldCellStyle(contentAutomaticStyles);
        String dataBoldCellStyleNoWrap = OdfHelper.getDataTableDataBoldCellStyleNoWrap(contentAutomaticStyles);
        String dataBoldCellStyleNoWrapHidden = OdfHelper.getDataTableDataBoldCellStyleNoWrapHidden(contentAutomaticStyles);
        String dataTextStyle = OdfHelper.getDataTableDataTextStyle(contentAutomaticStyles, standardParagraphStyle);
        String dataBoldTextStyle = OdfHelper.getDataTableDataTextBoldStyle(contentAutomaticStyles, standardParagraphStyle);
        this.appendProjectInfo(contextJoin, versionLabel, resourceBundle, tableElement, dataRowStyle, dataCellStyleNoWrapHidden, dataBoldCellStyle, dataBoldCellStyleNoWrap, dataBoldCellStyleNoWrapHidden, dataTextStyle, dataBoldTextStyle);
        this.appendSearchFieldInfos(tableElement, searchModel, resourceBundle, dataRowStyle, dataCellStyleNoWrapHidden, dataBoldCellStyle, dataBoldCellStyleNoWrap, dataBoldCellStyleNoWrapHidden, dataTextStyle, dataBoldTextStyle);
        this.appendTable(objectInfos, sortOrder, tableElement, resourceBundle, contentAutomaticStyles, context, standardParagraphStyle, personVariablesUserLocale);
    }

    private void appendProjectInfo(ContextJoin contextJoin, String versionLabel, ResourceBundle resourceBundle, TableTableElement tableElement, String dataRowStyle, String dataCellStyleNoWrapHidden, String dataBoldCellStyle, String dataBoldCellStyleNoWrap, String dataBoldCellStyleNoWrapHidden, String dataTextStyle, String dataBoldTextStyle) {
        OdfHelper.appendLabelledTableLine(tableElement, dataRowStyle, dataCellStyleNoWrapHidden, dataTextStyle, null, null, resourceBundle.getString("objectListXlsTableFirstLine"), null);
        OdfHelper.appendEmptyTableLine(tableElement, dataRowStyle, dataCellStyleNoWrapHidden, dataTextStyle);
        String secondLine = resourceBundle.getString("objectListXlsTableFirstLine") + " " + versionLabel;
        OdfHelper.appendLabelledTableLine(tableElement, dataRowStyle, dataBoldCellStyleNoWrap, dataTextStyle, null, null, secondLine, null);
        OdfHelper.appendEmptyTableLine(tableElement, dataRowStyle, dataCellStyleNoWrapHidden, dataTextStyle);
        String projectCode = contextJoin.getProjectCode() != null ? contextJoin.getProjectCode() : "";
        String projectName = contextJoin.getProjectName() != null ? contextJoin.getProjectName() : "";
        String projectLabel = projectCode + " " + projectName;
        String stretchName = contextJoin.getProjectStretchName();
        String kmString = ObjectListExportHelper.getProjectKmString(contextJoin);
        String projectComment = contextJoin.getProjectComment() != null ? contextJoin.getProjectComment() : "";
        String subProjectCode = contextJoin.getSubProjectCode() != null ? contextJoin.getSubProjectCode() : "";
        String subProjectNumber = contextJoin.getSubProjectNumber() != null ? contextJoin.getSubProjectNumber().toString() : "";
        String subProjectName = contextJoin.getSubProjectName() != null ? contextJoin.getSubProjectName() : "";
        String subProjectLabel = subProjectCode + subProjectNumber + " " + subProjectName;
        OdfHelper.appendLabelledTableLine(tableElement, dataRowStyle, dataBoldCellStyleNoWrapHidden, dataTextStyle, dataCellStyleNoWrapHidden, dataTextStyle, resourceBundle.getString("objectListXlsProjectLabel"), projectLabel);
        OdfHelper.appendLabelledTableLine(tableElement, dataRowStyle, dataBoldCellStyleNoWrapHidden, dataTextStyle, dataCellStyleNoWrapHidden, dataTextStyle, resourceBundle.getString("objectListXlsRouteLabel"), stretchName);
        OdfHelper.appendLabelledTableLine(tableElement, dataRowStyle, dataBoldCellStyleNoWrapHidden, dataTextStyle, dataCellStyleNoWrapHidden, dataTextStyle, resourceBundle.getString("objectListXlsKmLabel"), kmString);
        OdfHelper.appendLabelledTableLine(tableElement, dataRowStyle, dataBoldCellStyleNoWrapHidden, dataTextStyle, dataCellStyleNoWrapHidden, dataTextStyle, resourceBundle.getString("objectListXlsCommentLabel"), projectComment);
        OdfHelper.appendLabelledTableLine(tableElement, dataRowStyle, dataBoldCellStyleNoWrapHidden, dataTextStyle, dataCellStyleNoWrapHidden, dataTextStyle, resourceBundle.getString("objectListXlsSubProjectLabel"), subProjectLabel);
        OdfHelper.appendEmptyTableLine(tableElement, dataRowStyle, dataCellStyleNoWrapHidden, dataTextStyle);
    }

    private void appendSearchFieldInfos(TableTableElement tableElement, ObjectSearchModel searchModel, ResourceBundle resourceBundle, String dataRowStyle, String dataCellStyleNoWrapHidden, String dataBoldCellStyle, String dataBoldCellStyleNoWrap, String dataBoldCellStyleNoWrapHidden, String dataTextStyle, String dataBoldTextStyle) {
        String obj = searchModel.getObj();
        String objectPlanner = searchModel.getObjectPlanner();
        String responsible = searchModel.getResponsible();
        String caption = resourceBundle.getString("objectListPdfFilterCaption");
        boolean first = true;
        if (SearchHelper.isStringFilled(obj)) {
            OdfHelper.appendLabelledTableLine(tableElement, dataRowStyle, dataBoldCellStyleNoWrapHidden, dataTextStyle, dataCellStyleNoWrapHidden, dataTextStyle, first ? caption : "", resourceBundle.getString("objectListPdfFilterObject"), obj);
            first = false;
        }
        if (SearchHelper.isStringFilled(objectPlanner)) {
            OdfHelper.appendLabelledTableLine(tableElement, dataRowStyle, dataBoldCellStyleNoWrapHidden, dataTextStyle, dataCellStyleNoWrapHidden, dataTextStyle, first ? caption : "", resourceBundle.getString("objectListPdfFilterObjectPlanner"), objectPlanner);
            first = false;
        }
        if (SearchHelper.isStringFilled(responsible)) {
            OdfHelper.appendLabelledTableLine(tableElement, dataRowStyle, dataBoldCellStyleNoWrapHidden, dataTextStyle, dataCellStyleNoWrapHidden, dataTextStyle, first ? caption : "", resourceBundle.getString("objectListPdfFilterObjectResponsible"), responsible);
            first = false;
        }
        if (first) {
            OdfHelper.appendLabelledTableLine(tableElement, dataRowStyle, dataBoldCellStyleNoWrapHidden, dataTextStyle, dataCellStyleNoWrapHidden, dataTextStyle, first ? caption : "", resourceBundle.getString("objectListPdfFilterNone"));
        }
        OdfHelper.appendEmptyTableLine(tableElement, dataRowStyle, dataCellStyleNoWrapHidden, dataTextStyle);
    }

    private List<XlsRow> constructRowList(List<ObjectInfo> objectInfos) {
        ArrayList<XlsRow> xlsRows = new ArrayList<XlsRow>();
        for (ObjectInfo objectInfo : objectInfos) {
            List objectPlannerInfos = objectInfo.getObjectPlannerInfos();
            if (objectPlannerInfos != null && objectPlannerInfos.size() > 0) {
                for (ObjectPlannerInfo objectPlannerInfo : objectPlannerInfos) {
                    List positionInfos = objectPlannerInfo.getPositionInfos();
                    if (positionInfos != null && positionInfos.size() > 0) {
                        for (ObjectPlannerPositionInfo positionInfo : positionInfos) {
                            xlsRows.add(new XlsRow(objectInfo, objectPlannerInfo, positionInfo));
                        }
                        continue;
                    }
                    xlsRows.add(new XlsRow(objectInfo, objectPlannerInfo, null));
                }
                continue;
            }
            xlsRows.add(new XlsRow(objectInfo, null, null));
        }
        return xlsRows;
    }

    private void appendTable(List<ObjectInfo> objectInfos, SortOrder sortOrder, TableTableElement tableElement, ResourceBundle resourceBundle, Styles contentAutomaticStyles, OdfContext context, String standardParagraphStyle, String personVariablesUserLocale) {
        String headerCellStyle = OdfHelper.getDataTableHeaderCellStyle(contentAutomaticStyles);
        String headerTextStyle = OdfHelper.getDataTableHeaderTextStyle(contentAutomaticStyles, standardParagraphStyle);
        String dataCellStyle = OdfHelper.getDataTableDataCellStyleNoWrap(contentAutomaticStyles);
        String dataTextStyle = OdfHelper.getDataTableCellWithTextStyle(contentAutomaticStyles, standardParagraphStyle, null);
        String dataRowStyle = OdfHelper.getDataTableRowStyle(contentAutomaticStyles);
        ArrayList<ColumnSortSpec> columnSortSpecs = new ArrayList<ColumnSortSpec>();
        if (sortOrder != null) {
            columnSortSpecs.add(new ColumnSortSpec(sortOrder.getId(), Boolean.valueOf(sortOrder.getDirection() != SortDirection.ASCENDING)));
        }
        List<XlsRow> rows = this.constructRowList(objectInfos);
        FancyOdfTable<XlsRow> table = this.constructTable(resourceBundle, contentAutomaticStyles, standardParagraphStyle, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, dataRowStyle);
        table.setDataRowStyle(contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableRowPropertiesWithOptimalRowHeight()}));
        table.renderIntoTableElement(tableElement, rows, columnSortSpecs, true);
    }

    private FancyOdfTable<XlsRow> constructTable(ResourceBundle resourceBundle, Styles contentAutomaticStyles, String standardParagraphStyle, String headerCellStyle, String headerTextStyle, String dataCellStyle, String dataTextStyle, String dataRowStyle) {
        Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        List<FancyOdfTableColumn<XlsRow>> columns = this.constructDataColumns(resourceBundle, collator, contentAutomaticStyles, standardParagraphStyle, dataCellStyle, dataTextStyle);
        Map<String, Double> columnIdToAbsoluteWidth = this.constructAbsoluteColumnWidths();
        String rowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableRowPropertiesWithBackgroundColor("#ffffff", "always")});
        FancyOdfTable table = new FancyOdfTable(contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, null, null, columns);
        table.setDataRowStyle(dataRowStyle);
        table.setAbsoluteColumnWidths(columnIdToAbsoluteWidth);
        return table;
    }

    private Map<String, Double> constructAbsoluteColumnWidths() {
        HashMap<String, Double> columnIdToAbsoluteWidth = new HashMap<String, Double>();
        columnIdToAbsoluteWidth.put(ObjectListCols.CODE.getValue(), 3.0);
        columnIdToAbsoluteWidth.put(ObjectListCols.NAME.getValue(), 6.0);
        columnIdToAbsoluteWidth.put(ObjectListCols.KM.getValue(), 3.0);
        columnIdToAbsoluteWidth.put(ObjectListCols.OBJECT_PLANNER.getValue(), 6.0);
        columnIdToAbsoluteWidth.put(ObjectListCols.REVIEW_CYCLE_INSTANCE.getValue(), 6.0);
        columnIdToAbsoluteWidth.put(ObjectListCols.PLANNER.getValue(), 10.0);
        columnIdToAbsoluteWidth.put(ObjectListCols.POSITION_NAME.getValue(), 5.0);
        columnIdToAbsoluteWidth.put(ObjectListCols.POSITION_PERSON.getValue(), 10.0);
        return columnIdToAbsoluteWidth;
    }

    private int compareXlsRowsByObjectPlanner(Collator collator, XlsRow rowOne, XlsRow rowTwo, boolean descending) {
        ObjectPlannerInfo objectPlannerInfoOne = rowOne.objectPlannerInfo;
        ObjectPlannerInfo objectPlannerInfoTwo = rowTwo.objectPlannerInfo;
        if (objectPlannerInfoOne == null || objectPlannerInfoTwo == null) {
            return 0;
        }
        Long opIdOne = objectPlannerInfoOne.getId();
        Long opIdTwo = objectPlannerInfoTwo.getId();
        if (opIdOne.longValue() == opIdTwo.longValue()) {
            ObjectPlannerPositionInfo posInfoOne = rowOne.positionInfo;
            ObjectPlannerPositionInfo posInfoTwo = rowTwo.positionInfo;
            if (posInfoOne == null || posInfoTwo == null) {
                return 0;
            }
            String posOne = posInfoOne.getPositionDefinitionName();
            String posTwo = posInfoTwo.getPositionDefinitionName();
            return CompareHelper.defaultStringCompare(collator, posOne, posTwo, false);
        }
        String codeOne = objectPlannerInfoOne.getCode();
        String codeTwo = objectPlannerInfoTwo.getCode();
        return CompareHelper.defaultStringCompare(collator, codeOne, codeTwo, false);
    }

    public List<FancyOdfTableColumn<XlsRow>> constructDataColumns(final ResourceBundle resourceBundle, final Collator collator, Styles contentAutomaticStyles, String standardParagraphStyle, final String dataCellStyle, final String dataTextStyle) {
        String dataNewTextStyle = OdfHelper.getDataTableCellWithTextStyle(contentAutomaticStyles, standardParagraphStyle, "#0000ff");
        String dataModifiedInstanceTextStyle = OdfHelper.getDataTableCellWithTextStyle(contentAutomaticStyles, standardParagraphStyle, "#ff0000");
        String dataModifiedGeneralTextStyle = OdfHelper.getDataTableCellWithTextStyle(contentAutomaticStyles, standardParagraphStyle, "#00ff00");
        final ObjectListChangedStyles changedStyles = new ObjectListChangedStyles(dataTextStyle, dataNewTextStyle, dataModifiedInstanceTextStyle, dataModifiedGeneralTextStyle);
        ArrayList<FancyOdfTableColumn<XlsRow>> columns = new ArrayList<FancyOdfTableColumn<XlsRow>>();
        columns.add(new FancyOdfTableColumn<XlsRow>(ObjectListCols.CODE.getValue(), resourceBundle.getString("objectListXlsObjectCodeCaption")){

            public void appendCell(TableTableRowElement rowElement, XlsRow row) {
                ObjectListChangedState changedState = row.objectInfo.getChangedState();
                String textStyle = changedStyles.getChangedStyle(changedState);
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)textStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                String text = this.getText(row);
                TextFactory.constructTextNode((Node)cellElement, (String)text, (String)textStyle);
            }

            public int compare(XlsRow rowOne, XlsRow rowTwo, boolean descending) {
                Long objectIdOne = rowOne.objectInfo.getId();
                Long objectIdTwo = rowTwo.objectInfo.getId();
                if (objectIdOne.longValue() == objectIdTwo.longValue()) {
                    return ObjectListXlsExporter.this.compareXlsRowsByObjectPlanner(collator, rowOne, rowTwo, descending);
                }
                String textOne = this.getText(rowOne);
                String textTwo = this.getText(rowTwo);
                return CompareHelper.defaultStringCompare(collator, textOne, textTwo, descending);
            }

            private String getText(XlsRow row) {
                ObjectInfo objectInfo = row.objectInfo;
                String code = objectInfo.getCode() != null ? objectInfo.getCode() : "";
                String type = objectInfo.getObjectTypeCode() != null ? objectInfo.getObjectTypeCode() : "";
                return code + type;
            }
        });
        columns.add(new FancyOdfTableColumn<XlsRow>(ObjectListCols.NAME.getValue(), resourceBundle.getString("objectListXlsObjectNameCaption")){

            public void appendCell(TableTableRowElement rowElement, XlsRow row) {
                ObjectListChangedState changedState = row.objectInfo.getChangedState();
                String cellStyle = changedStyles.getChangedStyle(changedState);
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                String text = this.getText(row);
                TextFactory.constructTextNode((Node)cellElement, (String)text, null);
            }

            public int compare(XlsRow rowOne, XlsRow rowTwo, boolean descending) {
                Long objectIdOne = rowOne.objectInfo.getId();
                Long objectIdTwo = rowTwo.objectInfo.getId();
                if (objectIdOne.longValue() == objectIdTwo.longValue()) {
                    return ObjectListXlsExporter.this.compareXlsRowsByObjectPlanner(collator, rowOne, rowTwo, descending);
                }
                String textOne = this.getText(rowOne);
                String textTwo = this.getText(rowTwo);
                return CompareHelper.defaultStringCompare(collator, textOne, textTwo, descending);
            }

            private String getText(XlsRow row) {
                ObjectInfo objectInfo = row.objectInfo;
                String name = objectInfo.getName() != null ? objectInfo.getName() : "";
                return name;
            }
        });
        columns.add(new FancyOdfTableColumn<XlsRow>(ObjectListCols.KM.getValue(), resourceBundle.getString("objectListPdfKmCaption")){

            public void appendCell(TableTableRowElement rowElement, XlsRow row) {
                ObjectListChangedState changedState = row.objectInfo.getChangedState();
                String cellStyle = changedStyles.getChangedStyle(changedState);
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                String text = this.getText(row);
                TextFactory.constructTextNode((Node)cellElement, (String)text, null);
            }

            public int compare(XlsRow rowOne, XlsRow rowTwo, boolean descending) {
                Long objectIdOne = rowOne.objectInfo.getId();
                Long objectIdTwo = rowTwo.objectInfo.getId();
                if (objectIdOne.longValue() == objectIdTwo.longValue()) {
                    return ObjectListXlsExporter.this.compareXlsRowsByObjectPlanner(collator, rowOne, rowTwo, descending);
                }
                return (descending ? -1 : 1) * ObjectListExportHelper.compareKms(rowOne.objectInfo, rowTwo.objectInfo);
            }

            private String getText(XlsRow row) {
                ObjectInfo objectInfo = row.objectInfo;
                Double stretchKmFrom = objectInfo.getStretchKmFrom();
                Double stretchKmTo = objectInfo.getStretchKmTo();
                DecimalFormat kmFormat = (DecimalFormat)NumberFormat.getNumberInstance(Locale.GERMAN);
                kmFormat.applyPattern("###,##0.000");
                String kmFromString = kmFormat.format(stretchKmFrom);
                String kmToString = kmFormat.format(stretchKmTo);
                String kmString = kmFromString + " - " + kmToString;
                return kmString;
            }
        });
        columns.add(new FancyOdfTableColumn<XlsRow>(ObjectListCols.OBJECT_PLANNER.getValue(), resourceBundle.getString("objectListPdfObjectPlannerCaption")){

            public void appendCell(TableTableRowElement rowElement, XlsRow row) {
                String text = this.getText(row);
                ObjectPlannerInfo objectPlannerInfo = row.objectPlannerInfo;
                if (objectPlannerInfo != null) {
                    ObjectListChangedState changedState = objectPlannerInfo.getChangedState();
                    String cellStyle = changedStyles.getChangedStyle(changedState);
                    TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                    TextFactory.constructTextNode((Node)cellElement, (String)text, null);
                } else {
                    TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                }
            }

            public int compare(XlsRow rowOne, XlsRow rowTwo, boolean descending) {
                return 0;
            }

            private String getText(XlsRow row) {
                ObjectPlannerInfo objectPlannerInfo = row.objectPlannerInfo;
                if (objectPlannerInfo != null) {
                    String code = objectPlannerInfo.getCode() != null ? objectPlannerInfo.getCode() : "";
                    String area = objectPlannerInfo.getArea() != null ? objectPlannerInfo.getArea() : "";
                    return "(" + code + ") " + area;
                }
                return "";
            }
        });
        columns.add(new FancyOdfTableColumn<XlsRow>(ObjectListCols.REVIEW_CYCLE_INSTANCE.getValue(), resourceBundle.getString("objectListPdfReviewCycleInstanceCaption")){

            public void appendCell(TableTableRowElement rowElement, XlsRow row) {
                String text = this.getText(row);
                ObjectPlannerInfo objectPlannerInfo = row.objectPlannerInfo;
                if (objectPlannerInfo != null) {
                    ObjectListChangedState changedState = objectPlannerInfo.getChangedState();
                    String cellStyle = changedStyles.getChangedStyle(changedState);
                    TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                    TextFactory.constructTextNode((Node)cellElement, (String)text, null);
                } else {
                    TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                }
            }

            public int compare(XlsRow rowOne, XlsRow rowTwo, boolean descending) {
                return 0;
            }

            private String getText(XlsRow row) {
                ObjectPlannerInfo objectPlannerInfo = row.objectPlannerInfo;
                if (objectPlannerInfo != null) {
                    String instanceName = objectPlannerInfo.getReviewCycleInstanceName() != null ? objectPlannerInfo.getReviewCycleInstanceName() : "";
                    return instanceName;
                }
                return "";
            }
        });
        columns.add(new FancyOdfTableColumn<XlsRow>(ObjectListCols.PLANNER.getValue(), resourceBundle.getString("objectListXlsPlannerCaption")){

            public void appendCell(TableTableRowElement rowElement, XlsRow row) {
                String text = this.getText(row);
                ObjectPlannerInfo objectPlannerInfo = row.objectPlannerInfo;
                if (objectPlannerInfo != null) {
                    ObjectListChangedState changedState = objectPlannerInfo.getChangedState();
                    String cellStyle = changedStyles.getChangedStyle(changedState);
                    TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                    TextFactory.constructTextNode((Node)cellElement, (String)text, null);
                } else {
                    TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                }
            }

            public int compare(XlsRow rowOne, XlsRow rowTwo, boolean descending) {
                return 0;
            }

            private String getText(XlsRow row) {
                ObjectPlannerInfo objectPlannerInfo = row.objectPlannerInfo;
                if (objectPlannerInfo != null) {
                    String organisationName = objectPlannerInfo.getPlannerOrganisationName();
                    String givenName = objectPlannerInfo.getPlannerPersonGivenName();
                    String surName = objectPlannerInfo.getPlannerPersonSurName();
                    String participationComment = objectPlannerInfo.getPlannerParticipationComment();
                    String plannerString = MessageFormat.format(resourceBundle.getString("objectListPdfPlannerLabel"), organisationName, surName, givenName);
                    if (participationComment != null) {
                        plannerString = plannerString + " - " + participationComment;
                    }
                    return plannerString;
                }
                return "";
            }
        });
        columns.add(new FancyOdfTableColumn<XlsRow>(ObjectListCols.POSITION_NAME.getValue(), resourceBundle.getString("objectListXlsPositionCaption")){

            public void appendCell(TableTableRowElement rowElement, XlsRow row) {
                ObjectPlannerInfo objectPlannerInfo = row.objectPlannerInfo;
                if (objectPlannerInfo != null) {
                    String text = this.getText(row);
                    ObjectListChangedState changedState = objectPlannerInfo.getChangedState();
                    String cellStyle = changedStyles.getChangedStyle(changedState);
                    TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                    TextFactory.constructTextNode((Node)cellElement, (String)text, null);
                } else {
                    TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                }
            }

            public int compare(XlsRow rowOne, XlsRow rowTwo, boolean descending) {
                return 0;
            }

            private String getText(XlsRow row) {
                ObjectPlannerPositionInfo positionInfo = row.positionInfo;
                if (positionInfo != null) {
                    return positionInfo.getPositionDefinitionName() != null ? positionInfo.getPositionDefinitionName() : "";
                }
                return "";
            }
        });
        columns.add(new FancyOdfTableColumn<XlsRow>(ObjectListCols.POSITION_PERSON.getValue(), resourceBundle.getString("objectListXlsPositionResponsibleCaption")){

            public void appendCell(TableTableRowElement rowElement, XlsRow row) {
                ObjectPlannerInfo objectPlannerInfo = row.objectPlannerInfo;
                if (objectPlannerInfo != null) {
                    String text = this.getText(row);
                    ObjectListChangedState changedState = objectPlannerInfo.getChangedState();
                    String cellStyle = changedStyles.getChangedStyle(changedState);
                    TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                    TextFactory.constructTextNode((Node)cellElement, (String)text, null);
                } else {
                    TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                }
            }

            public int compare(XlsRow rowOne, XlsRow rowTwo, boolean descending) {
                return 0;
            }

            private String getText(XlsRow row) {
                ObjectPlannerPositionInfo positionInfo = row.positionInfo;
                if (positionInfo != null) {
                    String organisation = positionInfo.getMainOrganisationName() != null ? positionInfo.getMainOrganisationName() : "";
                    String currGivenName = positionInfo.getMainPersonGivenName() != null ? positionInfo.getMainPersonGivenName() : "";
                    String currSurName = positionInfo.getMainPersonSurName() != null ? positionInfo.getMainPersonSurName() : "";
                    String participationComment = positionInfo.getProjectParticipationComment();
                    String positionLabel = organisation + " (" + currSurName + " " + currGivenName + ")";
                    if (participationComment != null) {
                        positionLabel = positionLabel + " - " + participationComment;
                    }
                    return positionLabel;
                }
                return "";
            }
        });
        return columns;
    }

    private class XlsRow {
        ObjectInfo objectInfo;
        ObjectPlannerInfo objectPlannerInfo;
        ObjectPlannerPositionInfo positionInfo;

        XlsRow(ObjectInfo objectInfo, ObjectPlannerInfo objectPlannerInfo, ObjectPlannerPositionInfo positionInfo) {
            this.objectInfo = objectInfo;
            this.objectPlannerInfo = objectPlannerInfo;
            this.positionInfo = positionInfo;
        }
    }
}

