/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Certificate;
import at.cdes.api.dto.ProjectParticipant;
import at.cdes.api.dto.Signature;
import at.cdes.api.dto.SignatureCalculator;
import at.cdes.impl.dao.SignatureDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcSignatureDAO
extends AbstrIdDAO<Signature>
implements SignatureDAO {
    public JdbcSignatureDAO() {
        super(Signature.class, "id", "signature", new String[]{"id", "content", "signature", "signature_calculator_id", "certificate_id", "project_participant_id", "time", "create_trx", "mut_trx", "mut_ts"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcSignatureDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "content") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "signature") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "signature_calculator_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "certificate_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_participant_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "time") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "create_trx") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_trx") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_ts") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcSignatureDAO.getSelectClauseForDto("signature", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcSignatureDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".content" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "content") + "," + entityLocalName + ".signature" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "signature") + "," + entityLocalName + ".signature_calculator_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "signature_calculator_id") + "," + entityLocalName + ".certificate_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "certificate_id") + "," + entityLocalName + ".project_participant_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_participant_id") + "," + entityLocalName + ".time" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "time") + "," + entityLocalName + ".create_trx" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "create_trx") + "," + entityLocalName + ".mut_trx" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_trx") + "," + entityLocalName + ".mut_ts" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_ts") + " ";
    }

    protected Signature fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        Signature signature = new Signature();
        signature.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        signature.setContent(rs.getBytes(++columnIndex));
        signature.setSignature(rs.getBytes(++columnIndex));
        signature.setSignatureCalculatorId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        signature.setCertificateId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        signature.setProjectParticipantId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        signature.setTime(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        signature.setCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        signature.setMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        signature.setMutTs(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return signature;
    }

    public static Signature fillSignatureFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        Signature signature = new Signature();
        signature.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        signature.setContent(rs.getBytes(columnIndex.incrementAndGet()));
        signature.setSignature(rs.getBytes(columnIndex.incrementAndGet()));
        signature.setSignatureCalculatorId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        signature.setCertificateId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        signature.setProjectParticipantId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        signature.setTime(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        signature.setCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        signature.setMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        signature.setMutTs(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return signature;
    }

    public static Signature fillSignatureFromResultSet(ResultSet rs) throws SQLException {
        return JdbcSignatureDAO.fillSignatureFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 10;
    }

    public int update(Signature dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<Signature> dtos) {
        Iterator<Signature> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, Signature signature) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)signature.getId());
        statement.setBytes(2, signature.getContent());
        statement.setBytes(3, signature.getSignature());
        JDBCHelper.setLong((PreparedStatement)statement, (int)4, (Number)signature.getSignatureCalculatorId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)5, (Number)signature.getCertificateId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)6, (Number)signature.getProjectParticipantId());
        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)7, (Double)signature.getTime());
        JDBCHelper.setLong((PreparedStatement)statement, (int)8, (Number)(signature.getCreateTrx() != null ? signature.getCreateTrx() : (Long)ThreadLocalManager.getBoundResource((String)"at.cdes.impl.db.trx::TrxId")));
        JDBCHelper.setLong((PreparedStatement)statement, (int)9, (Number)((Long)ThreadLocalManager.getBoundResource((String)"at.cdes.impl.db.trx::TrxId")));
        JDBCHelper.setLong((PreparedStatement)statement, (int)10, (Number)System.currentTimeMillis());
    }

    @Override
    public List<Signature> getBySignatureCalculator(SignatureCalculator signatureCalculator) {
        return this.getBySignatureCalculator(signatureCalculator.getId());
    }

    @Override
    public List<Signature> getBySignatureCalculator(final Long signatureCalculatorId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"signature_calculator_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, signatureCalculatorId);
            }
        });
    }

    @Override
    public List<Signature> getByCertificate(Certificate certificate) {
        return this.getByCertificate(certificate.getId());
    }

    @Override
    public List<Signature> getByCertificate(final Long certificateId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"certificate_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, certificateId);
            }
        });
    }

    @Override
    public List<Signature> getByProjectParticipant(ProjectParticipant projectParticipant) {
        return this.getByProjectParticipant(projectParticipant.getId());
    }

    @Override
    public List<Signature> getByProjectParticipant(final Long projectParticipantId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project_participant_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, projectParticipantId);
            }
        });
    }

    @Override
    public List<Signature> getBySignatureCalculators(Collection<Long> signatureCalculatorId) {
        if (signatureCalculatorId.isEmpty()) {
            return new ArrayList<Signature>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[signatureCalculatorId.size()];
        int n = 0;
        Iterator<Long> it = signatureCalculatorId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"signature_calculator_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<Signature> getByCertificates(Collection<Long> certificateId) {
        if (certificateId.isEmpty()) {
            return new ArrayList<Signature>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[certificateId.size()];
        int n = 0;
        Iterator<Long> it = certificateId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"certificate_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<Signature> getByProjectParticipants(Collection<Long> projectParticipantId) {
        if (projectParticipantId.isEmpty()) {
            return new ArrayList<Signature>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[projectParticipantId.size()];
        int n = 0;
        Iterator<Long> it = projectParticipantId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project_participant_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

