/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.person;

import at.cdes.api.dto.Network;
import at.cdes.api.organisation.compositeDto.OrganisationInfo;
import at.cdes.impl.export.CdesExportHelper;
import at.cdes.impl.export.planning.CellTextStyles;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.odf.util.text.TextFactory;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.w3c.dom.Node;

public class ExportPersonHelper {
    public static void addAddressBlock(TableTableCellElement cellElement, String textStyle, String postalAddress, String postalCode, String localityName, String country) {
        CdesExportHelper.constructTextNodeWithLineBreaks((OdfElement)cellElement, postalAddress, textStyle);
        TextPElement localityElement = TextFactory.constructTextNode((Node)cellElement, (String)"", (String)textStyle);
        TextFactory.constructTextSpan((Node)localityElement, (String)(postalCode + " " + localityName), (String)textStyle);
        TextPElement countryElement = TextFactory.constructTextNode((Node)cellElement, (String)"", (String)textStyle);
        TextFactory.constructTextSpan((Node)countryElement, (String)country, (String)textStyle);
    }

    public static void addContactBlock(TableTableCellElement cellElement, String textStyle, ResourceBundle resourceBundle, String unitName, String postalAddress, String postalCode, String localityName, String countryDescDe, String mail, String phone, String mobile, String fax) {
        if (postalAddress != null && postalAddress.length() > 0) {
            if (unitName != null && unitName.length() > 0) {
                TextPElement unitNameElement = TextFactory.constructTextNode((Node)cellElement, (String)"", (String)textStyle);
                String unitNameString = MessageFormat.format(resourceBundle.getString("personListUnit"), unitName);
                TextFactory.constructTextSpan((Node)unitNameElement, (String)unitNameString, (String)textStyle);
            }
            TextPElement postalAddressElement = TextFactory.constructTextNode((Node)cellElement, (String)"", (String)textStyle);
            TextFactory.constructTextSpan((Node)postalAddressElement, (String)postalAddress, (String)textStyle);
            TextPElement localityNameElement = TextFactory.constructTextNode((Node)cellElement, (String)"", (String)textStyle);
            TextFactory.constructTextSpan((Node)localityNameElement, (String)(postalCode + " " + localityName), (String)textStyle);
            TextPElement countryDescDeElement = TextFactory.constructTextNode((Node)cellElement, (String)"", (String)textStyle);
            TextFactory.constructTextSpan((Node)countryDescDeElement, (String)countryDescDe, (String)textStyle);
        }
        TextPElement mailElement = TextFactory.constructTextNode((Node)cellElement, (String)"", (String)textStyle);
        String mailString = MessageFormat.format(resourceBundle.getString("personListMail"), mail);
        TextFactory.constructTextSpan((Node)mailElement, (String)mailString, (String)textStyle);
        TextPElement phoneElement = TextFactory.constructTextNode((Node)cellElement, (String)"", (String)textStyle);
        String phoneString = MessageFormat.format(resourceBundle.getString("personListPhone"), phone);
        TextFactory.constructTextSpan((Node)phoneElement, (String)phoneString, (String)textStyle);
        TextPElement mobileElement = TextFactory.constructTextNode((Node)cellElement, (String)"", (String)textStyle);
        String mobileString = MessageFormat.format(resourceBundle.getString("personListMobile"), mobile);
        TextFactory.constructTextSpan((Node)mobileElement, (String)mobileString, (String)textStyle);
        TextPElement faxElement = TextFactory.constructTextNode((Node)cellElement, (String)"", (String)textStyle);
        String faxString = MessageFormat.format(resourceBundle.getString("personListFax"), fax);
        TextFactory.constructTextSpan((Node)faxElement, (String)faxString, (String)textStyle);
    }

    public static void addOrganisationNameColumn(List<FancyOdfTableColumn<OrganisationInfo>> columns, ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final CellTextStyles normalCellTextStyles, final CellTextStyles invalidatedCellTextStyles, boolean isConsortium) {
        columns.add(new FancyOdfTableColumn<OrganisationInfo>("name", isConsortium ? resourceBundle.getString("consortiumListNameColumnCaption") : resourceBundle.getString("organisationListNameColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, OrganisationInfo organisationInfo) {
                CellTextStyles cellTextStyles = ExportPersonHelper.getOrganisationCellTextStyles(organisationInfo, normalCellTextStyles, invalidatedCellTextStyles);
                TableFactory.appendCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(organisationInfo)});
            }

            public int compare(OrganisationInfo organisationInfoOne, OrganisationInfo organisationInfoTwo, boolean descending) {
                String nameOne = this.getOutput(organisationInfoOne);
                String nameTwo = this.getOutput(organisationInfoTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)nameOne, (String)nameTwo, (boolean)descending);
            }

            private String getOutput(OrganisationInfo organisationInfo) {
                return organisationInfo.getOrganisationJoin().getOrganisationName();
            }
        });
    }

    public static void addOrganisationAddressColumn(List<FancyOdfTableColumn<OrganisationInfo>> columns, ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final CellTextStyles normalCellTextStyles, final CellTextStyles invalidatedCellTextStyles) {
        columns.add(new FancyOdfTableColumn<OrganisationInfo>("address", resourceBundle.getString("organisationListAddressColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, OrganisationInfo organisationInfo) {
                CellTextStyles cellTextStyles = ExportPersonHelper.getOrganisationCellTextStyles(organisationInfo, normalCellTextStyles, invalidatedCellTextStyles);
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement);
                String postalAddress = ExportPersonHelper.getNonNullString(organisationInfo.getOrganisationJoin().getOrganisationPostalAddress());
                String postalCode = ExportPersonHelper.getNonNullString(organisationInfo.getOrganisationJoin().getOrganisationPostalCode());
                String localityName = ExportPersonHelper.getNonNullString(organisationInfo.getOrganisationJoin().getOrganisationLocalityName());
                String country = ExportPersonHelper.getNonNullString(organisationInfo.getOrganisationJoin().getCountryDescDe());
                ExportPersonHelper.addAddressBlock(cellElement, cellTextStyles.getDataTextStyle(), postalAddress, postalCode, localityName, country);
            }

            public int compare(OrganisationInfo organisationInfoOne, OrganisationInfo organisationInfoTwo, boolean descending) {
                String sOne = this.getSortString(organisationInfoOne);
                String sTwo = this.getSortString(organisationInfoTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)sOne, (String)sTwo, (boolean)descending);
            }

            private String getSortString(OrganisationInfo organisationInfo) {
                return ExportPersonHelper.getNonNullString(organisationInfo.getOrganisationJoin().getOrganisationPostalAddress()) + ExportPersonHelper.getNonNullString(organisationInfo.getOrganisationJoin().getOrganisationPostalCode()) + ExportPersonHelper.getNonNullString(organisationInfo.getOrganisationJoin().getOrganisationLocalityName()) + ExportPersonHelper.getNonNullString(organisationInfo.getOrganisationJoin().getCountryDescDe());
            }
        });
    }

    public static void addOrganisationContactColumn(List<FancyOdfTableColumn<OrganisationInfo>> columns, final ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final CellTextStyles normalCellTextStyles, final CellTextStyles invalidatedCellTextStyles) {
        columns.add(new FancyOdfTableColumn<OrganisationInfo>("phone", resourceBundle.getString("organisationListContactColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, OrganisationInfo organisationInfo) {
                CellTextStyles cellTextStyles = ExportPersonHelper.getOrganisationCellTextStyles(organisationInfo, normalCellTextStyles, invalidatedCellTextStyles);
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement);
                String mail = ExportPersonHelper.getNonNullString(organisationInfo.getOrganisationJoin().getOrganisationEmailAddress());
                String phone = ExportPersonHelper.getNonNullString(organisationInfo.getOrganisationJoin().getOrganisationTelephoneNumber());
                String mobile = ExportPersonHelper.getNonNullString(organisationInfo.getOrganisationJoin().getOrganisationMobileTelephoneNumber());
                String fax = ExportPersonHelper.getNonNullString(organisationInfo.getOrganisationJoin().getOrganisationFacsimileTelephoneNumber());
                ExportPersonHelper.addContactBlock(cellElement, cellTextStyles.getDataTextStyle(), resourceBundle, null, null, null, null, null, mail, phone, mobile, fax);
            }

            public int compare(OrganisationInfo organisationInfoOne, OrganisationInfo organisationInfoTwo, boolean descending) {
                String sOne = this.getSortString(organisationInfoOne);
                String sTwo = this.getSortString(organisationInfoTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)sOne, (String)sTwo, (boolean)descending);
            }

            private String getSortString(OrganisationInfo organisationInfo) {
                return ExportPersonHelper.getNonNullString(organisationInfo.getOrganisationJoin().getOrganisationEmailAddress().trim()) + ExportPersonHelper.getNonNullString(organisationInfo.getOrganisationJoin().getOrganisationTelephoneNumber()).trim() + ExportPersonHelper.getNonNullString(organisationInfo.getOrganisationJoin().getOrganisationMobileTelephoneNumber()).trim() + ExportPersonHelper.getNonNullString(organisationInfo.getOrganisationJoin().getOrganisationFacsimileTelephoneNumber()).trim();
            }
        });
    }

    public static void addOrganisationNetworksColumn(List<FancyOdfTableColumn<OrganisationInfo>> columns, final ResourceBundle resourceBundle, final Collator collator, final String dataCellStyle, final CellTextStyles normalCellTextStyles, final CellTextStyles invalidatedCellTextStyles) {
        columns.add(new FancyOdfTableColumn<OrganisationInfo>("networks", resourceBundle.getString("organisationListNetworksColumnCaption")){

            public void appendCell(TableTableRowElement rowElement, OrganisationInfo organisationInfo) {
                CellTextStyles cellTextStyles = ExportPersonHelper.getOrganisationCellTextStyles(organisationInfo, normalCellTextStyles, invalidatedCellTextStyles);
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, (String)cellTextStyles.getDataTextStyle(), (TableTableRowElement)rowElement);
                List networks = organisationInfo.getNetworks();
                networks.sort(new Comparator<Network>(){

                    @Override
                    public int compare(Network networkOne, Network networkTwo) {
                        String nameOne = ExportPersonHelper.getNonNullString(networkOne.getName());
                        String nameTwo = ExportPersonHelper.getNonNullString(networkTwo.getName());
                        return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)nameOne, (String)nameTwo, (boolean)false);
                    }
                });
                ExportPersonHelper.addNetworkBlock(cellElement, cellTextStyles.getDataTextStyle(), resourceBundle, networks);
            }

            public int compare(OrganisationInfo organisationInfoOne, OrganisationInfo organisationInfoTwo, boolean descending) {
                String sOne = this.getSortString(organisationInfoOne);
                String sTwo = this.getSortString(organisationInfoTwo);
                return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)sOne, (String)sTwo, (boolean)descending);
            }

            private String getSortString(OrganisationInfo organisationInfo) {
                String networksString = "";
                List networks = organisationInfo.getNetworks();
                networks.sort(new Comparator<Network>(){

                    @Override
                    public int compare(Network networkOne, Network networkTwo) {
                        String nameOne = ExportPersonHelper.getNonNullString(networkOne.getName());
                        String nameTwo = ExportPersonHelper.getNonNullString(networkTwo.getName());
                        return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)nameOne, (String)nameTwo, (boolean)false);
                    }
                });
                for (int n = 0; n < networks.size(); ++n) {
                    Network network = (Network)networks.get(n);
                    networksString = networksString + (n == 0 ? "" : " ") + network.getName();
                }
                return ExportPersonHelper.getNonNullString(networksString).trim();
            }
        });
    }

    protected static void addNetworkBlock(TableTableCellElement cellElement, String textStyle, ResourceBundle resourceBundle, List<Network> networks) {
        for (Network network : networks) {
            TextPElement addressElement = TextFactory.constructTextNode((Node)cellElement, (String)"", (String)textStyle);
            TextFactory.constructTextSpan((Node)addressElement, (String)network.getName(), (String)textStyle);
        }
    }

    public static CellTextStyles getOrganisationCellTextStyles(OrganisationInfo organisationInfo, CellTextStyles normalTextStyles, CellTextStyles invalidatedTextStyles) {
        return normalTextStyles;
    }

    private static String getNonNullString(String s) {
        return s != null && s.trim().length() > 0 ? s.trim() : "---";
    }
}

