/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.plot;

import at.cdes.api.dto.ExportResult;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.Project;
import at.cdes.api.joinDto.PlotOrderJoin;
import at.cdes.api.voc.OdfExportSlot;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.service.ChallengeLoginServiceImpl;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.odf.OdfHelper;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sched.cache.ScratchFile;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableHeaderRowsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlotOrderPdfExporter {
    private static final Logger log = LoggerFactory.getLogger(PlotOrderPdfExporter.class);
    private OrganisationPersonDAO organisationPersonDAO;
    private String odfStylePrefix;
    private OOoFileEngine oooFileEngine;
    private Long odfTimeout;
    private String tempDir;
    private Boolean enableCustomerLogo;
    private String costumerLabel;

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public void setEnableCustomerLogo(Boolean enableCustomerLogo) {
        this.enableCustomerLogo = enableCustomerLogo;
    }

    public void setCostumerLabel(String costumerLabel) {
        this.costumerLabel = costumerLabel;
    }

    public ScratchFile export(Long organisationPersonId, Network network, Project project, List<PlotOrderJoin> plotOrderJoins, String personVariablesUserLocale) throws Exception {
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariablesUserLocale);
        OdfTextDocument document = DocumentFactory.constructTextDocument((String)"export/emptyLandscapeTemplate.odt", ChallengeLoginServiceImpl.class, (Locale)ThreadLocalManager.getLoginLocale());
        OfficeTextElement officeText = document.getContentRoot();
        OdfContext context = new OdfContext((OdfDocument)document, this.odfStylePrefix);
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        String standardParagraphStyle = OdfHelper.constructStandardParagraphStyle(stylesOfficeStyles);
        OdfHelper.constructHeader(context, document, standardParagraphStyle, null, this.enableCustomerLogo);
        String projectString = resourceBundle.getString("plotOrderListFooterInfo");
        String formattedProjectString = MessageFormat.format(projectString, project.getName());
        OdfHelper.constructFooter(context, document, standardParagraphStyle, formattedProjectString, null, null, resourceBundle);
        OdfHelper.constructCaptionTable(context, officeText, standardParagraphStyle, resourceBundle.getString("plotOrderListCaption"));
        TableTableElement tableElement = officeText.newTableTableElement();
        String dataTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructParagraphPropertiesWithVerticalAlign("auto", false), contentAutomaticStyles.constructTextPropertiesWithFontSize("9pt")});
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"2.5cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"4.5cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"4.6cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"3.1cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"3.1cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"3.0cm");
        TableFactory.appendColumnWithAbsoluteSize((Styles)contentAutomaticStyles, (TableTableElement)tableElement, (String)"3.1cm");
        TableTableHeaderRowsElement headerRowsElement = tableElement.newTableTableHeaderRowsElement();
        TableTableRowElement headerRowElement = headerRowsElement.newTableTableRowElement();
        String headerCellStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{contentAutomaticStyles.constructParagraphPropertiesWithBackgroundColor("#4c4c4c"), contentAutomaticStyles.constructTextPropertiesWithColorAndFontSize("#ffffff", "9pt")});
        TableFactory.appendTextStyledCell((String)headerCellStyle, (TableTableRowElement)headerRowElement, (String[])new String[]{resourceBundle.getString("plotOrderListJobNumberCaption")});
        TableFactory.appendTextStyledCell((String)headerCellStyle, (TableTableRowElement)headerRowElement, (String[])new String[]{resourceBundle.getString("plotOrderListContractorCaption")});
        TableFactory.appendTextStyledCell((String)headerCellStyle, (TableTableRowElement)headerRowElement, (String[])new String[]{resourceBundle.getString("plotOrderListCustomerCaption")});
        TableFactory.appendTextStyledCell((String)headerCellStyle, (TableTableRowElement)headerRowElement, (String[])new String[]{resourceBundle.getString("plotOrderListCreationCaption")});
        TableFactory.appendTextStyledCell((String)headerCellStyle, (TableTableRowElement)headerRowElement, (String[])new String[]{resourceBundle.getString("plotOrderListReceiptCaption")});
        TableFactory.appendTextStyledCell((String)headerCellStyle, (TableTableRowElement)headerRowElement, (String[])new String[]{resourceBundle.getString("plotOrderListDeliveryCaption")});
        TableFactory.appendTextStyledCell((String)headerCellStyle, (TableTableRowElement)headerRowElement, (String[])new String[]{resourceBundle.getString("plotOrderListDeliveredAmountCaption")});
        TableFactory.appendTextStyledCell((String)headerCellStyle, (TableTableRowElement)headerRowElement, (String[])new String[]{resourceBundle.getString("plotOrderListChargedCaption")});
        String cellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableCellPropertiesWithPaddingAndBorders("0.097cm", "0.05pt solid #ffffff")});
        String rowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableRowPropertiesWithBackgroundColor("#e6e6e6", "always")});
        for (PlotOrderJoin plotOrderJoin : plotOrderJoins) {
            String completedStepFinishedMode;
            String completedStepFinishedDate;
            String acceptanceStepFinishedMode;
            String acceptanceStepFinishedDate;
            TableTableRowElement rowElement = TableFactory.appendRow((TableTableElement)tableElement, (String)rowStyle);
            String jobNumberString = this.formatJobNumber(resourceBundle, plotOrderJoin);
            TableFactory.appendCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{jobNumberString});
            String plotterName = plotOrderJoin.getPlotterName();
            String plotterPostalAddress = plotOrderJoin.getPlotterPostalAddress();
            String plotterLocalityName = this.formatLocalityName(resourceBundle, plotOrderJoin.getPlotterPostalCode(), plotOrderJoin.getPlotterLocalityName());
            String countryDescDe = plotOrderJoin.getPlotterCountryDescDe();
            TableFactory.appendCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{plotterName, plotterPostalAddress, plotterLocalityName, countryDescDe});
            String organisationName = plotOrderJoin.getBillingAddressOrganisationName();
            String orderAddressPostalAddress = plotOrderJoin.getBillingAddressPostalAddress();
            String orderAddressLocalityName = this.formatLocalityName(resourceBundle, plotOrderJoin.getBillingAddressPostalCode(), plotOrderJoin.getBillingAddressLocalityName());
            String orderAddressCountryDescDe = plotOrderJoin.getOrderAddressCountryDescDe();
            TableFactory.appendCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{organisationName, orderAddressPostalAddress, orderAddressLocalityName, orderAddressCountryDescDe});
            String dateFormatPattern = resourceBundle.getString("yearToSecondFormat");
            this.appendDateCell(cellStyle, dataTextStyle, resourceBundle, rowElement, plotOrderJoin.getRequestStepFinished(), "Europe/Vienna");
            if (plotOrderJoin.getAcceptanceStepFinished() != null) {
                acceptanceStepFinishedDate = DateHelper.formatUtcSeconds(plotOrderJoin.getAcceptanceStepFinished(), "Europe/Vienna", dateFormatPattern);
                acceptanceStepFinishedMode = this.getAcceptanceModeString(resourceBundle, plotOrderJoin);
            } else {
                acceptanceStepFinishedDate = null;
                acceptanceStepFinishedMode = null;
            }
            TableFactory.appendCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{acceptanceStepFinishedDate, acceptanceStepFinishedMode});
            if (plotOrderJoin.getCompletedStepFinished() != null) {
                completedStepFinishedDate = DateHelper.formatUtcSeconds(plotOrderJoin.getCompletedStepFinished(), "Europe/Vienna", dateFormatPattern);
                completedStepFinishedMode = this.getCompletedModeString(resourceBundle, plotOrderJoin);
            } else {
                completedStepFinishedDate = null;
                completedStepFinishedMode = null;
            }
            TableFactory.appendCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{completedStepFinishedDate, completedStepFinishedMode});
            String receivedString = this.formatReceivedString(resourceBundle, plotOrderJoin);
            TableFactory.appendCell((String)cellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{receivedString});
            this.appendDateCell(cellStyle, dataTextStyle, resourceBundle, rowElement, plotOrderJoin.getChargedStepFinished(), "Europe/Vienna");
        }
        String pdfFileName = OdfFileHelper.saveAndConvert((String)this.tempDir, (String)"cdes_Plotauftraege_", (OdfTextDocument)document, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.PDF, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout, (Integer)OdfExportSlot.DEFAULT.getValue(), null);
        ExportResult exportResult = OdfHelper.constructExportResult(pdfFileName);
        String pdfTempFileName = exportResult.getTmpFileName();
        String encodedFileName = "Test";
        return new ScratchFile(new File(pdfTempFileName), "application/pdf", "attachment; filename*=UTF-8''" + encodedFileName);
    }

    private String formatJobNumber(ResourceBundle resourceBundle, PlotOrderJoin plotOrderJoin) {
        return plotOrderJoin.getPlotOrderJobNumber() != null ? plotOrderJoin.getPlotOrderJobNumber().toString() : resourceBundle.getString("emptyListItem");
    }

    private String formatLocalityName(ResourceBundle resourceBundle, String postalCode, String localityName) {
        if (postalCode != null) {
            if (localityName != null) {
                return postalCode + " " + localityName;
            }
            return postalCode;
        }
        if (localityName != null) {
            return localityName;
        }
        return null;
    }

    private String getAcceptanceModeString(ResourceBundle resourceBundle, PlotOrderJoin plotOrderJoin) {
        if (plotOrderJoin.getAcceptanceStepAcceptedMode() == 0) {
            return null;
        }
        if (plotOrderJoin.getAcceptanceStepAcceptedMode() == 1) {
            return resourceBundle.getString("plotOrderListReceivedState");
        }
        if (plotOrderJoin.getAcceptanceStepAcceptedMode() == 2) {
            return resourceBundle.getString("plotOrderListDeclinedState");
        }
        return null;
    }

    private String getCompletedModeString(ResourceBundle resourceBundle, PlotOrderJoin plotOrderJoin) {
        if (plotOrderJoin.getCompletedStepAcceptedMode() == 0) {
            return null;
        }
        if (plotOrderJoin.getCompletedStepAcceptedMode() == 1) {
            return resourceBundle.getString("plotOrderListOkState");
        }
        if (plotOrderJoin.getCompletedStepAcceptedMode() == 2) {
            return resourceBundle.getString("plotOrderListNotOkState");
        }
        return null;
    }

    private String formatReceivedString(ResourceBundle resourceBundle, PlotOrderJoin plotOrderJoin) {
        Integer countTotal = plotOrderJoin.getPlotOrderCountsCountTotal();
        Integer countSigned = plotOrderJoin.getPlotOrderCountsCountSigned();
        Integer countDeclined = plotOrderJoin.getPlotOrderCountsCountDeclined();
        if (countSigned == countTotal && countDeclined == 0) {
            return resourceBundle.getString("plotOrderListAllOk");
        }
        if (countSigned == countTotal && countDeclined != 0) {
            return resourceBundle.getString("plotOrderListNotOk");
        }
        String receivedString = resourceBundle.getString("plotOrderListSomeOk");
        return MessageFormat.format(receivedString, new Integer(countSigned).toString(), new Integer(countTotal).toString());
    }

    private void appendDateCell(String cellStyle, String textStyle, ResourceBundle resourceBundle, TableTableRowElement rowElement, Double utcSeconds, String timeZone) {
        String dateFormatPattern = resourceBundle.getString("yearToSecondFormat");
        if (utcSeconds == null) {
            TableFactory.appendCell((String)cellStyle, (String)textStyle, (TableTableRowElement)rowElement, (String[])new String[]{""});
        } else {
            TableFactory.appendDateCellAsString((String)cellStyle, (String)textStyle, (TableTableRowElement)rowElement, (Double)utcSeconds, (String)timeZone, (String)dateFormatPattern);
        }
    }
}

