/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.digest.impl;

import at.cdes.api.dto.ObjectListRelease;
import at.cdes.api.dto.ObjectPlannerPositionRelease;
import at.cdes.api.dto.ObjectPlannerRelease;
import at.cdes.api.dto.ObjectRelease;
import at.cdes.api.dto.ReviewCycleCellInstanceReleased;
import at.cdes.api.dto.ReviewCycleInstanceReleased;
import at.cdes.api.dto.ReviewCycleNodeInstanceReleased;
import at.cdes.api.dto.ReviewCycleNodePositionReleased;
import at.cdes.impl.digest.AbstractDigester;
import at.cdes.impl.objects.ObjectReleaseContext;
import at.cdes.impl.util.ContainerHelper;
import java.util.Collections;
import java.util.List;

public class ObjectReleaseDigester
extends AbstractDigester {
    public String getDigest(ObjectListRelease objectListRelease, List<ObjectRelease> objectReleases) {
        return this.getHash(stream -> {
            stream.write(("id=" + objectListRelease.getId()).getBytes());
            stream.write(("objectListId=" + objectListRelease.getObjectListId()).getBytes());
            stream.write(("subprojectId=" + objectListRelease.getSubProjectId()).getBytes());
            stream.write(("version=" + objectListRelease.getVersion()).getBytes());
            stream.write("objects".getBytes());
            List<Long> objectReleaseIds = ContainerHelper.getPersistentIdsList(objectReleases);
            Collections.sort(objectReleaseIds);
            for (Long objectReleaseId : objectReleaseIds) {
                stream.write(objectReleaseId.toString().getBytes());
            }
        });
    }

    public String getDigest(ObjectRelease objectRelease) {
        return this.getHash(stream -> {
            stream.write(("id=" + objectRelease.getId()).getBytes());
            stream.write(("objectListId=" + objectRelease.getObjectListReleaseId()).getBytes());
            stream.write(("code=" + objectRelease.getCode()).getBytes());
            stream.write(("name=" + objectRelease.getName()).getBytes());
            stream.write(("comment=" + objectRelease.getComment()).getBytes());
            stream.write(("stretchKmFrom=" + objectRelease.getStretchKmFrom()).getBytes());
            stream.write(("stretchKmTo=" + objectRelease.getStretchKmTo()).getBytes());
            stream.write(("version=" + objectRelease.getObjectId()).getBytes());
            stream.write(("version=" + objectRelease.getCode()).getBytes());
            stream.write("objects".getBytes());
        });
    }

    public String getDigest(ObjectPlannerRelease objectPlannerRelease, List<ObjectPlannerPositionRelease> positionReleases) {
        return this.getHash(stream -> {
            stream.write(("id=" + objectPlannerRelease.getId()).getBytes());
            stream.write(("objectId=" + objectPlannerRelease.getObjectId()).getBytes());
            stream.write(("objectPlannerId=" + objectPlannerRelease.getObjectPlannerId()).getBytes());
            stream.write(("code=" + objectPlannerRelease.getCode()).getBytes());
            stream.write(("area=" + objectPlannerRelease.getArea()).getBytes());
            if (objectPlannerRelease.getReviewCycleInstanceId() != null) {
                stream.write(("reviewCycleInstanceId=" + objectPlannerRelease.getReviewCycleInstanceId()).getBytes());
            }
            if (objectPlannerRelease.getPlannerId() != null) {
                stream.write(("plannerId=" + objectPlannerRelease.getPlannerId()).getBytes());
            }
            for (ObjectPlannerPositionRelease positionRelease : positionReleases) {
                stream.write(("position" + positionRelease.getId() + "=" + positionRelease.getProjectParticipationId() + " " + positionRelease.getRoleId()).getBytes());
            }
        });
    }

    public String getDigest(ReviewCycleInstanceReleased instanceReleased, ObjectReleaseContext context) {
        return this.getHash(stream -> {
            stream.write(("id=" + instanceReleased.getId()).getBytes());
            stream.write(("name=" + instanceReleased.getName()).getBytes());
            stream.write(("subprojectId=" + instanceReleased.getSubProjectId()).getBytes());
            stream.write(("version=" + instanceReleased.getReviewCycleId()).getBytes());
            stream.write(("version=" + instanceReleased.getReviewCycleInstanceId()).getBytes());
            stream.write(("label=" + (instanceReleased.getLabelId() != null ? instanceReleased.getLabelId() : "null")).getBytes());
            Long instanceReleasedId = instanceReleased.getId();
            List<ReviewCycleCellInstanceReleased> cellInstanceReleaseds = context.getCellInstanceReleasedsByInstanceReleasedId(instanceReleasedId);
            for (ReviewCycleCellInstanceReleased cellInstanceReleased : cellInstanceReleaseds) {
                stream.write(("cell-id=" + cellInstanceReleased.getId()).getBytes());
                stream.write(("cell-cellId=" + cellInstanceReleased.getReviewCycleCellId()).getBytes());
                stream.write(("cell-cellInstanceId=" + cellInstanceReleased.getReviewCycleCellInstanceId()).getBytes());
                stream.write(("cell-instanceId=" + cellInstanceReleased.getReviewCycleInstanceId()).getBytes());
                stream.write(("cell-startCell" + cellInstanceReleased.isStartCell()).getBytes());
                Long cellInstanceReleasedId = cellInstanceReleased.getId();
                List<ReviewCycleNodeInstanceReleased> nodeInstanceReleaseds = context.getNodeInstanceReleasedsByCellInstanceReleasedId(cellInstanceReleasedId);
                for (ReviewCycleNodeInstanceReleased nodeInstanceReleased : nodeInstanceReleaseds) {
                    stream.write(("node-id=" + nodeInstanceReleased.getId()).getBytes());
                    stream.write(("node-duration=" + nodeInstanceReleased.getDuration()).getBytes());
                    stream.write(("node-cellInstanceId=" + nodeInstanceReleased.getReviewCycleCellInstanceId()).getBytes());
                    stream.write(("node-nodeId=" + nodeInstanceReleased.getReviewCycleNodeId()).getBytes());
                    stream.write(("node-nodeInstanceId=" + nodeInstanceReleased.getReviewCycleNodeInstanceId()).getBytes());
                    Long nodeInstanceReleasedId = nodeInstanceReleased.getId();
                    List<ReviewCycleNodePositionReleased> nodePositionReleaseds = context.getNodePositionReleasedsByNodeInstanceReleasedId(nodeInstanceReleasedId);
                    for (ReviewCycleNodePositionReleased nodePositionReleased : nodePositionReleaseds) {
                        stream.write(("postion-id=" + nodePositionReleased.getId()).getBytes());
                        stream.write(("postion-projectParticipationId=" + nodePositionReleased.getProjectParticipationId()).getBytes());
                        stream.write(("postion-realmId=" + nodePositionReleased.getRealmId()).getBytes());
                        stream.write(("postion-reviewCycleNodeInstanceId=" + nodePositionReleased.getReviewCycleNodeInstanceId()).getBytes());
                    }
                }
            }
        });
    }
}

