/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.util;

import at.cdes.api.dto.ActionInfo;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ActionDAO;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ActionHelper {
    public static boolean isObjectPlannerActionAllowed(Map<Long, Set<Action>> allowedObjectPlannerActions, Long objectPlannerId, Action actionName) {
        return allowedObjectPlannerActions.containsKey(objectPlannerId) && allowedObjectPlannerActions.get(objectPlannerId).contains(actionName);
    }

    public static ActionInfo constructActionInfo(at.cdes.api.dto.Action action) {
        ActionInfo actionInfo = new ActionInfo();
        actionInfo.setId(action.getId());
        actionInfo.setName(action.getName());
        actionInfo.setDescription(action.getDescription());
        actionInfo.setReadOnly(action.getReadOnly());
        return actionInfo;
    }

    public static boolean hasActionsForAnyNetwork(Map<Long, Set<Action>> networkIdToActions, Action ... queriedActionNames) {
        for (Set<Action> actionNames : networkIdToActions.values()) {
            boolean success = true;
            for (Action queriedActionName : queriedActionNames) {
                if (actionNames.contains(queriedActionName)) continue;
                success = false;
            }
            if (!success) continue;
            return true;
        }
        return false;
    }

    public static boolean hasActionsForAllNetworks(Map<Long, Set<Action>> networkIdToActions, Action ... queriedActionNames) {
        for (Set<Action> actionNames : networkIdToActions.values()) {
            for (Action queriedActionName : queriedActionNames) {
                if (actionNames.contains(queriedActionName)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean hasActionsForNetwork(ActionDAO actionDAO, Long organisationPersonId, Long networkId, Action ... actionNames) {
        Map<Long, Set<Action>> networkIdToActions = actionDAO.getNetworkToActionMap(organisationPersonId, networkId, actionNames);
        return ActionHelper.hasActionsForAnyNetwork(networkIdToActions, actionNames);
    }

    public static boolean hasActionsForAnyNetwork(ActionDAO actionDAO, Long organisationPersonId, List<Long> networkIds, Action ... actionNames) {
        Map<Long, Set<Action>> networkIdToActions = actionDAO.getNetworkToActionMap(organisationPersonId, networkIds, actionNames);
        return ActionHelper.hasActionsForAnyNetwork(networkIdToActions, actionNames);
    }

    public static boolean hasActionsForAllNetworks(ActionDAO actionDAO, Long organisationPersonId, List<Long> networkIds, Action ... actionNames) {
        Map<Long, Set<Action>> networkIdToActions = actionDAO.getNetworkToActionMap(organisationPersonId, networkIds, actionNames);
        return ActionHelper.hasActionsForAllNetworks(networkIdToActions, actionNames);
    }

    public static boolean hasActionsForProject(ActionDAO actionDAO, Long organisationPersonId, Long projectId, Action ... actionNames) {
        Set<Action> projectIdToActions = actionDAO.getActionsForProject(organisationPersonId, projectId, actionNames);
        return projectIdToActions.containsAll(Arrays.asList(actionNames));
    }

    public static boolean hasActionForAnyProject(Map<Long, Set<Action>> projectIdToAllowedAction, Action action) {
        boolean found = false;
        for (Long projectId : projectIdToAllowedAction.keySet()) {
            Set<Action> allowedActions = projectIdToAllowedAction.get(projectId);
            found |= allowedActions.contains(action);
        }
        return found;
    }

    public static Map<Long, Map<String, Boolean>> transformToMap(Map<Long, Set<Action>> rawObjectPlannerIdToActions) {
        HashMap<Long, Map<String, Boolean>> objectPlannerIdToActions = new HashMap<Long, Map<String, Boolean>>();
        for (Long objectPlannerId : rawObjectPlannerIdToActions.keySet()) {
            Set<Action> rawActions = rawObjectPlannerIdToActions.get(objectPlannerId);
            HashMap<String, Boolean> actions = new HashMap<String, Boolean>();
            for (Action action : rawActions) {
                actions.put(action.getName(), true);
            }
            objectPlannerIdToActions.put(objectPlannerId, actions);
        }
        return objectPlannerIdToActions;
    }

    public static Map<Long, Set<String>> convertEnumToString(Map<Long, Set<Action>> idToActionEnumSet) {
        HashMap<Long, Set<String>> idToActionNameSet = new HashMap<Long, Set<String>>();
        for (Long id : idToActionEnumSet.keySet()) {
            Set<Action> actionEnums = idToActionEnumSet.get(id);
            HashSet<String> actionNames = new HashSet<String>();
            for (Action actionEnum : actionEnums) {
                actionNames.add(actionEnum.getName());
            }
            idToActionNameSet.put(id, actionNames);
        }
        return idToActionNameSet;
    }

    public static Set<String> convertEnumToString(Set<Action> actions) {
        HashSet<String> actionNames = new HashSet<String>();
        for (Action action : actions) {
            actionNames.add(action.getName());
        }
        return actionNames;
    }

    public static Set<Action> convertStringToEnum(String[] actionNames) {
        HashSet<Action> actions = new HashSet<Action>();
        for (String actionName : actionNames) {
            actions.add(Action.getByName((String)actionName));
        }
        return actions;
    }

    public static Map<String, ActionInfo> convertEnumToActionInfoToString(Map<Action, ActionInfo> actionToActionInfo) {
        HashMap<String, ActionInfo> nameToActionInfo = new HashMap<String, ActionInfo>();
        for (Action action : actionToActionInfo.keySet()) {
            nameToActionInfo.put(action.getName(), actionToActionInfo.get(action));
        }
        return nameToActionInfo;
    }
}

