/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.PersonVariables;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcPersonVariablesDAO;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcPersonVariablesDAO
extends AbstractJdbcPersonVariablesDAO
implements PersonVariablesDAO {
    @Override
    public PersonVariables getByOrganisationPerson(final Long organisationPersonId) {
        String sql = "SELECT " + JdbcPersonVariablesDAO.getSelectClauseForDto() + "FROM ((    organisation_person JOIN person                  ON organisation_person.person_id = person.id) JOIN person_variables        ON person_variables.person_id = person.id) WHERE organisation_person.id = ?";
        return (PersonVariables)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<PersonVariables>(){

            public PersonVariables perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
                ResultSet rs = statement.executeQuery();
                PersonVariables personVariables = null;
                while (rs.next()) {
                    personVariables = JdbcPersonVariablesDAO.this.fillDtoFromResultSet(rs);
                }
                return personVariables;
            }
        });
    }

    @Override
    public PersonVariables getUniqueByPerson(Long personId) {
        List<PersonVariables> personVariablesList = this.getByPerson(personId);
        if (personVariablesList.size() != 1) {
            throw new RuntimeException("Illegal number of PersonVariables for person [" + personId + "]");
        }
        return personVariablesList.get(0);
    }

    @Override
    public PersonVariables getByParticipationViaMainParticipant(final Long participationId) {
        String sql = "SELECT " + JdbcPersonVariablesDAO.getSelectClauseForDto() + "FROM project_participation JOIN project_participant      ON project_participant.participation_id = project_participation.id AND project_participant.main_participant_flag = 1 JOIN organisation_person      ON project_participant.organisation_person_id = organisation_person.id JOIN person                   ON organisation_person.person_id = person.id JOIN person_variables         ON person_variables.person_id = person.id WHERE project_participation.id = ? ";
        return (PersonVariables)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<PersonVariables>(){

            public PersonVariables perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)participationId);
                ResultSet rs = statement.executeQuery();
                PersonVariables personVariables = null;
                while (rs.next()) {
                    personVariables = JdbcPersonVariablesDAO.this.fillDtoFromResultSet(rs);
                }
                return personVariables;
            }
        });
    }
}

