/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.digest.impl;

import at.cdes.api.dto.DocumentListRelease;
import at.cdes.api.dto.DocumentRelease;
import at.cdes.api.dto.OrderStep;
import at.cdes.api.dto.OrganisationOrderStep;
import at.cdes.api.dto.OrganisationPersonOrderStep;
import at.cdes.api.dto.ProjectParticipationOrderStep;
import at.cdes.impl.digest.AbstractDigester;
import at.cdes.impl.digest.DigestWriter;
import at.cdes.impl.digest.DocumentDigester;
import java.io.IOException;
import java.security.DigestOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class DocumentDigesterImpl
extends AbstractDigester
implements DocumentDigester {
    @Override
    public String getDocumentListHash(final DocumentListRelease documentList, final List<DocumentRelease> documents) {
        return this.getHash(new DigestWriter(){

            @Override
            public void write(DigestOutputStream stream) throws IOException {
                stream.write(("id=" + documentList.getId()).getBytes());
                stream.write(("documentListId=" + documentList.getDocumentListId()).getBytes());
                stream.write(("subprojectId=" + documentList.getSubProjectId()).getBytes());
                stream.write(("version=" + documentList.getVersion()).getBytes());
                stream.write("documents".getBytes());
                HashSet<Long> documentIds = new HashSet<Long>();
                for (DocumentRelease documentRelease : documents) {
                    documentIds.add(documentRelease.getId());
                }
                Object[] documentIdsArray = documentIds.toArray();
                Arrays.sort(documentIdsArray);
                for (int n = 0; n < documentIdsArray.length; ++n) {
                    stream.write(((Long)documentIdsArray[n]).toString().getBytes());
                }
            }
        });
    }

    @Override
    public String getDocumentHash(final DocumentRelease document) {
        return this.getHash(new DigestWriter(){

            @Override
            public void write(DigestOutputStream stream) throws IOException {
                stream.write(("id=" + document.getId()).getBytes());
                stream.write(("documentListId=" + document.getDocumentListId()).getBytes());
                stream.write(("name=" + document.getName()).getBytes());
                stream.write(("number=" + document.getNumber()).getBytes());
                stream.write(("scale=" + document.getScale()).getBytes());
                stream.write(("document=" + document.getDocumentId()).getBytes());
            }
        });
    }

    @Override
    public String getDocumentListCompositeHash(DocumentListRelease documentList, List<DocumentRelease> documents) {
        ArrayList<String> digests = new ArrayList<String>();
        digests.add(documentList.getDigest());
        for (DocumentRelease documentRelease : documents) {
            digests.add(documentRelease.getDigest());
        }
        return this.digestListToString(digests);
    }

    @Override
    public String getOrderStepHash(final OrderStep orderStep, final OrganisationPersonOrderStep organisationPersonOrderStep) {
        return this.getHash(new DigestWriter(){

            @Override
            public void write(DigestOutputStream stream) throws IOException {
                stream.write(("id=" + orderStep.getId()).getBytes());
                stream.write(("created=" + orderStep.getCreated()).getBytes());
                stream.write(("finished=" + orderStep.getFinished()).getBytes());
                stream.write(("organisationPersonId=" + organisationPersonOrderStep.getOrganisationPersonId()).getBytes());
                stream.write(("comment=" + orderStep.getComment()).getBytes());
            }
        });
    }

    @Override
    public String getOrderStepHash(final OrderStep orderStep, final OrganisationOrderStep organisationOrderStep) {
        return this.getHash(new DigestWriter(){

            @Override
            public void write(DigestOutputStream stream) throws IOException {
                stream.write(("id=" + orderStep.getId()).getBytes());
                stream.write(("created=" + orderStep.getCreated()).getBytes());
                stream.write(("finished=" + orderStep.getFinished()).getBytes());
                stream.write(("organisationPersonId=" + organisationOrderStep.getOrganisationPersonId()).getBytes());
                stream.write(("comment=" + orderStep.getComment()).getBytes());
            }
        });
    }

    @Override
    public String getOrderStepHash(final OrderStep orderStep, final ProjectParticipationOrderStep projectParticipationOrderStep) {
        return this.getHash(new DigestWriter(){

            @Override
            public void write(DigestOutputStream stream) throws IOException {
                stream.write(("id=" + orderStep.getId()).getBytes());
                stream.write(("created=" + orderStep.getCreated()).getBytes());
                stream.write(("finished=" + orderStep.getFinished()).getBytes());
                stream.write(("projectParticipationId=" + projectParticipationOrderStep.getProjectParticipationId()).getBytes());
                stream.write(("comment=" + orderStep.getComment()).getBytes());
            }
        });
    }
}

