/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.review;

import at.cdes.api.dto.ExportResult;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.sec.CdesPrincipal;
import at.cdes.api.task.dto.Task;
import at.cdes.api.task.searchModel.TaskSearchModel;
import at.cdes.api.task.voc.TaskDeputyMode;
import at.cdes.api.task.voc.TaskSearchMode;
import at.cdes.api.voc.OdfExportSlot;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.export.review.ReviewTaskExportHelper;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.service.ChallengeLoginServiceImpl;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.odf.OdfHelper;
import java.io.File;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.style.AutomaticStyles;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.odf.util.table.FancyOdfTable;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sched.cache.ScratchFile;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableRowPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class ReviewTaskPdfExporter {
    private String odfStylePrefix;
    private Long odfTimeout;
    private OOoFileEngine oooFileEngine = null;
    private OrganisationPersonDAO organisationPersonDAO;
    private PersonVariablesDAO personVariablesDAO;
    private String tempDirName;
    private static final Logger log = LoggerFactory.getLogger(ReviewTaskPdfExporter.class);

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    public void setTempDir(String tempDirName) {
        this.tempDirName = tempDirName;
    }

    public ScratchFile export(Long loginOrganisationPersonId, TaskSearchModel searchModel, List<Task> tasks, Map<String, Double> columnToWidth, List<ColumnSortSpec> columnSortSpecs, boolean enableCustomerLogo, Set<Long> taskIdsAfterQuickFilter, String quickFilter) throws Exception {
        OdfTextDocument document = DocumentFactory.constructTextDocument((String)"export/emptyLandscapeTemplate.odt", ChallengeLoginServiceImpl.class, (Locale)ThreadLocalManager.getLoginLocale());
        String personVariablesUserLocale = OdfHelper.getPersonVariablesUserLocaleByPrincipal(this.personVariablesDAO);
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariablesUserLocale);
        OfficeTextElement officeText = document.getContentRoot();
        OdfContext context = new OdfContext((OdfDocument)document, this.odfStylePrefix);
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        String standardParagraphStyle = OdfHelper.constructStandardParagraphStyle(stylesOfficeStyles);
        OdfHelper.constructHeader(context, document, standardParagraphStyle, null, enableCustomerLogo);
        String leftFooterLabelRaw = resourceBundle.getString("reviewTaskLeftFooter");
        String leftFooterLabel = MessageFormat.format(leftFooterLabelRaw, tasks.size());
        AutomaticStyles stylesAutomaticStyles = context.getStylesAutomaticStyles();
        String leftFooterTextStyle = stylesAutomaticStyles.getTextStyle(new OdfStylePropertiesBase[]{stylesAutomaticStyles.constructTextProperties()});
        OdfHelper.constructFooter(context, document, standardParagraphStyle, leftFooterLabel, leftFooterTextStyle, null, resourceBundle);
        TextHElement textHElement = officeText.newTextHElement(2);
        textHElement.setTextContent(this.getHeaderLabel(resourceBundle, searchModel.getSearchMode()));
        officeText.newTextPElement();
        this.constructFilterString(resourceBundle, officeText, searchModel, quickFilter);
        StyleTableCellPropertiesElement headerCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#f0f0f0", "0.097cm", "0.05pt solid #000000");
        String headerCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{headerCellProperties});
        StyleTextPropertiesElement headerTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "8pt", "bold");
        String headerTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{headerTextProperties});
        StyleTableCellPropertiesElement dataCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000");
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{dataCellProperties});
        StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", null);
        String dataTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{dataTextProperties});
        StyleTableRowPropertiesElement properties = contentAutomaticStyles.constructTableRowProperties();
        properties.setFoKeepTogetherAttribute("auto");
        String dataRowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{properties});
        ArrayList<Task> filteredTasks = new ArrayList<Task>();
        for (Task task : tasks) {
            if (taskIdsAfterQuickFilter != null && !taskIdsAfterQuickFilter.contains(task.getTaskId())) continue;
            filteredTasks.add(task);
        }
        List<FancyOdfTableColumn<Task>> columns = this.constructColumns(resourceBundle, dataCellStyle, dataTextStyle, personVariablesUserLocale, loginOrganisationPersonId, searchModel);
        FancyOdfTable<Task> odfTable = this.constructPlanningNotificationTable(loginOrganisationPersonId, contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, columnToWidth, personVariablesUserLocale, columns);
        odfTable.setDataRowStyle(dataRowStyle);
        odfTable.render((Node)officeText, filteredTasks, columnSortSpecs);
        String pdfFileName = OdfFileHelper.saveAndConvert((String)this.tempDirName, (String)"cdes_Aufgaben_", (OdfTextDocument)document, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.PDF, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout, (Integer)OdfExportSlot.DEFAULT.getValue(), null);
        ExportResult exportResult = OdfHelper.constructExportResult(pdfFileName);
        String tmpFileName = exportResult.getTmpFileName();
        String encodedFileName = "Test";
        return new ScratchFile(new File(tmpFileName), "application/pdf", "attachment; filename*=UTF-8''" + encodedFileName);
    }

    private void constructFilterString(ResourceBundle resourceBundle, OfficeTextElement officeText, TaskSearchModel searchModel, String quickFilter) {
        TaskSearchMode searchMode = searchModel.getSearchMode();
        TaskDeputyMode deputyMode = searchModel.getDeputyMode();
        Double fromTs = searchModel.getFromTs();
        Double toTs = searchModel.getToTs();
        String s = "";
        if (quickFilter != null && quickFilter.trim().length() > 0) {
            s = s + resourceBundle.getString("reviewTaskQuickFilter") + " ";
            s = s + quickFilter;
            s = s + " \u2015 ";
        }
        s = s + resourceBundle.getString("reviewTaskFilterPrefix") + " ";
        if (deputyMode != null) {
            if (searchMode != TaskSearchMode.DONE) {
                s = s + " " + resourceBundle.getString("reviewTaskFilterDeputy");
            }
            s = s + " " + this.getDeputyModeLabel(resourceBundle, deputyMode, searchMode);
        }
        if (fromTs != null && toTs != null) {
            String fromString = DateHelper.formatUtcSeconds(fromTs, "Europe/Vienna", resourceBundle.getString("yearToDayFormat"));
            String toString = DateHelper.formatUtcSeconds(toTs, "Europe/Vienna", resourceBundle.getString("yearToDayFormat"));
            s = s + MessageFormat.format(resourceBundle.getString("reviewTaskFilterDates"), fromString, toString);
        }
        TextPElement textPElement = officeText.newTextPElement();
        textPElement.setTextContent(s);
    }

    private String getHeaderLabel(ResourceBundle resourceBundle, TaskSearchMode searchMode) {
        if (searchMode == TaskSearchMode.BATCH) {
            return resourceBundle.getString("reviewTaskModeSignatureFolder");
        }
        if (searchMode == TaskSearchMode.DONE) {
            return resourceBundle.getString("reviewTaskModeDoneTasks");
        }
        if (searchMode == TaskSearchMode.LATE) {
            return resourceBundle.getString("reviewTaskModeBelatedTasks");
        }
        if (searchMode == TaskSearchMode.OWN) {
            return resourceBundle.getString("reviewTaskModeOpenTasks");
        }
        throw new IllegalArgumentException("Unsupported TaskSearchMode [" + searchMode + "]");
    }

    private String getDeputyModeLabel(ResourceBundle resourceBundle, TaskDeputyMode deputyMode, TaskSearchMode searchMode) {
        if (deputyMode == TaskDeputyMode.MAIN_PARTICIPANT) {
            return searchMode == TaskSearchMode.DONE ? resourceBundle.getString("reviewTaskDeputyDONEModeMain") : resourceBundle.getString("reviewTaskDeputyModeMain");
        }
        if (deputyMode == TaskDeputyMode.DEPUTY) {
            return searchMode == TaskSearchMode.DONE ? resourceBundle.getString("reviewTaskDeputyDONEModeDeputy") : resourceBundle.getString("reviewTaskDeputyModeDeputy");
        }
        throw new IllegalArgumentException("Unsupported TaskDeputyMode [" + deputyMode + "]");
    }

    private List<FancyOdfTableColumn<Task>> constructColumns(ResourceBundle resourceBundle, String dataCellStyle, String dataTextStyle, String personVariablesUserLocale, Long loginOrganisationPersonId, TaskSearchModel searchModel) {
        Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        TaskSearchMode searchMode = searchModel.getSearchMode();
        OrganisationPersonJoin organisationPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(loginOrganisationPersonId);
        CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long loginPersonId = loginPrincipal.getPersonId();
        ArrayList<FancyOdfTableColumn<Task>> columns = new ArrayList<FancyOdfTableColumn<Task>>();
        columns.add(ReviewTaskExportHelper.constructNameColumn(resourceBundle, collator, dataCellStyle, dataTextStyle, personVariablesUserLocale));
        columns.add(ReviewTaskExportHelper.constructDocumentColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(ReviewTaskExportHelper.constructResponsibleColumn(resourceBundle, collator, loginPersonId, organisationPersonJoin, searchMode, dataCellStyle, dataTextStyle));
        columns.add(ReviewTaskExportHelper.constructObjectColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(ReviewTaskExportHelper.constructProjectColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(ReviewTaskExportHelper.constructNetworkColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        FancyOdfTableColumn<Task> taskStatusColumn = ReviewTaskExportHelper.constructTaskStatusColumn(resourceBundle, collator, searchMode, dataCellStyle, dataTextStyle);
        FancyOdfTableColumn<Task> uploadedColumn = ReviewTaskExportHelper.constructUploadedColumn(resourceBundle, collator, dataCellStyle, dataTextStyle);
        if (searchMode == TaskSearchMode.OWN) {
            columns.add(uploadedColumn);
            columns.add(taskStatusColumn);
        } else if (searchMode == TaskSearchMode.DONE) {
            columns.add(ReviewTaskExportHelper.constructDoneDateColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
            columns.add(ReviewTaskExportHelper.constructDoneResultColumn(resourceBundle, collator, dataCellStyle, dataTextStyle, personVariablesUserLocale));
        } else if (searchMode == TaskSearchMode.LATE) {
            columns.add(uploadedColumn);
            columns.add(taskStatusColumn);
            columns.add(ReviewTaskExportHelper.constructReviewStatusColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        } else if (searchMode == TaskSearchMode.BATCH) {
            columns.add(ReviewTaskExportHelper.constructReviewDateColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
            columns.add(ReviewTaskExportHelper.constructReviewResultColumn(resourceBundle, collator, dataCellStyle, dataTextStyle, personVariablesUserLocale));
        }
        return columns;
    }

    private FancyOdfTable<Task> constructPlanningNotificationTable(Long loginOrganisationPersonId, Styles contentAutomaticStyles, String headerCellStyle, String headerTextStyle, String dataCellStyle, String dataTextStyle, Map<String, Double> relativeColumnWidths, String personVariablesUserLocale, List<FancyOdfTableColumn<Task>> columns) {
        String rowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableRowPropertiesWithBackgroundColor("#ffffff", "always")});
        FancyOdfTable table = new FancyOdfTable(contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, Double.valueOf(23.9), relativeColumnWidths, columns);
        table.setDataRowStyle(rowStyle);
        return table;
    }
}

