/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.file;

import at.cdes.api.dto.Attachment;
import at.cdes.api.dto.CertificateRequest;
import at.cdes.api.dto.DocumentReference;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.Job;
import at.cdes.api.dto.ObjectPlanner;
import at.cdes.api.dto.PlanningNotification;
import at.cdes.api.dto.PlanningNotificationAttachment;
import at.cdes.api.dto.PlanningNotificationProjectMap;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.sec.CdesPrincipal;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.AttachmentDAO;
import at.cdes.impl.dao.CertificateRequestDAO;
import at.cdes.impl.dao.DocumentReferenceDAO;
import at.cdes.impl.dao.DocumentVersionDAO;
import at.cdes.impl.dao.JobDAO;
import at.cdes.impl.dao.ObjectPlannerDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.PlanningNotificationAttachmentDAO;
import at.cdes.impl.dao.PlanningNotificationDAO;
import at.cdes.impl.dao.PlanningNotificationProjectMapDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.file.RepositoryHelper;
import at.cdes.impl.sec.util.SecurityHelper;
import at.cdes.impl.util.ActionHelper;
import at.cdes.impl.util.PathFromJobResultGetter;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.http.PathGetterWithRequest;
import org.clazzes.util.http.sec.HttpLoginService;
import org.clazzes.util.sched.IOneTimeScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRepositoryPathGetter
implements PathGetterWithRequest {
    private String planRepository;
    private ActionDAO actionDAO;
    private AttachmentDAO attachmentDAO;
    private String attachmentRepository;
    private CertificateRequestDAO certificateRequestDAO;
    private DocumentReferenceDAO documentReferenceDAO;
    private String documentReferenceRepository;
    private DocumentVersionDAO documentVersionDAO;
    private HttpLoginService httpLoginService;
    private JobDAO jobDAO;
    private ObjectPlannerDAO objectPlannerDAO;
    private IOneTimeScheduler oneTimeScheduler;
    private OrganisationPersonDAO organisationPersonDAO;
    private PlanningNotificationDAO planningNotificationDAO;
    private PlanningNotificationProjectMapDAO planningNotificationProjectMapDAO;
    private String planningNotificationRepository;
    private PlanningNotificationAttachmentDAO planningNotificationAttachmentDAO;
    private String planningNotificationAttachmentRepository;
    private ProjectDAO projectDAO;
    private String requestRepository;
    private String tempRepository;
    private Boolean certificateAdministrationGlobal;
    private static final String ATTACHMENT_PREFIX = "attachments";
    private static final String DOCUMENT_REFERENCE_PREFIX = "documentRef";
    private static final String JOB_TEMP_PREFIX = "jobTemp";
    private static final String PLAN_PREFIX = "final";
    private static final String PLANNING_NOTIFICATION_PREFIX = "planning";
    private static final String PLANNING_NOTIFICATION_ATTACHMENT_PREFIX = "planningAttachment";
    private static final String REQUEST_PREFIX = "requests";
    private static final String TEMP_PREFIX = "temp";
    private static final Logger log = LoggerFactory.getLogger(FileRepositoryPathGetter.class);

    public void setPlanRepository(String planRepository) {
        this.planRepository = planRepository;
    }

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setAttachmentDAO(AttachmentDAO attachmentDAO) {
        this.attachmentDAO = attachmentDAO;
    }

    public void setAttachmentRepository(String attachmentRepository) {
        this.attachmentRepository = attachmentRepository;
    }

    public void setCertificateRequestDAO(CertificateRequestDAO certificateRequestDAO) {
        this.certificateRequestDAO = certificateRequestDAO;
    }

    public void setDocumentReferenceDAO(DocumentReferenceDAO documentReferenceDAO) {
        this.documentReferenceDAO = documentReferenceDAO;
    }

    public void setDocumentReferenceRepository(String documentReferenceRepository) {
        this.documentReferenceRepository = documentReferenceRepository;
    }

    public void setDocumentVersionDAO(DocumentVersionDAO documentVersionDAO) {
        this.documentVersionDAO = documentVersionDAO;
    }

    public void setHttpLoginService(HttpLoginService httpLoginService) {
        this.httpLoginService = httpLoginService;
    }

    public void setJobDAO(JobDAO jobDAO) {
        this.jobDAO = jobDAO;
    }

    public void setObjectPlannerDAO(ObjectPlannerDAO objectPlannerDAO) {
        this.objectPlannerDAO = objectPlannerDAO;
    }

    public void setOneTimeScheduler(IOneTimeScheduler oneTimeScheduler) {
        this.oneTimeScheduler = oneTimeScheduler;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setPlanningNotificationDAO(PlanningNotificationDAO planningNotificationDAO) {
        this.planningNotificationDAO = planningNotificationDAO;
    }

    public void setPlanningNotificationProjectMapDAO(PlanningNotificationProjectMapDAO planningNotificationProjectMapDAO) {
        this.planningNotificationProjectMapDAO = planningNotificationProjectMapDAO;
    }

    public void setPlanningNotificationRepository(String planningNotificationRepository) {
        this.planningNotificationRepository = planningNotificationRepository;
    }

    public void setPlanningNotificationAttachmentDAO(PlanningNotificationAttachmentDAO planningNotificationAttachmentDAO) {
        this.planningNotificationAttachmentDAO = planningNotificationAttachmentDAO;
    }

    public void setPlanningNotificationAttachmentRepository(String planningNotificationAttachmentRepository) {
        this.planningNotificationAttachmentRepository = planningNotificationAttachmentRepository;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setRequestRepository(String requestRepository) {
        this.requestRepository = requestRepository;
    }

    public void setTempRepository(String tempRepository) {
        this.tempRepository = tempRepository;
    }

    public void setCertificateAdministrationGlobal(Boolean certificateAdministrationGlobal) {
        this.certificateAdministrationGlobal = certificateAdministrationGlobal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPath(String finalPath, HttpServletRequest request) {
        if (log.isDebugEnabled()) {
            log.debug("Called getPath for path [" + finalPath + "]");
        }
        boolean boundLoginPrincipal = false;
        try {
            CdesPrincipal loginPrincipal;
            Principal principalFromThreadLocal = ThreadLocalManager.getLoginPrincipal();
            if (principalFromThreadLocal == null) {
                loginPrincipal = (CdesPrincipal)this.httpLoginService.checkLogin(request);
                ThreadLocalManager.bindLoginPrincipal((Principal)loginPrincipal);
                boundLoginPrincipal = true;
            } else {
                loginPrincipal = (CdesPrincipal)principalFromThreadLocal;
            }
            String jobId = request.getParameter("jobId");
            if (jobId != null) {
                String organisationPersonId = request.getParameter("opId");
                finalPath = "temp/" + organisationPersonId + "/" + PathFromJobResultGetter.getPath(this.oneTimeScheduler, jobId);
            }
            String string = this.doGetPath(loginPrincipal, finalPath);
            return string;
        }
        finally {
            if (boundLoginPrincipal) {
                ThreadLocalManager.unbindLoginPrincipal();
            }
        }
    }

    private String doGetPath(CdesPrincipal loginPrincipal, String finalPath) {
        if (finalPath.startsWith("/")) {
            finalPath = finalPath.substring(1);
        }
        File foundFile = null;
        if (finalPath.startsWith(ATTACHMENT_PREFIX)) {
            String suffix = finalPath.substring(DOCUMENT_REFERENCE_PREFIX.length());
            String[] suffixTokens = this.getAndStripSuffixTokens(suffix);
            Long organisationPersonId = Long.parseLong(suffixTokens[0]);
            Long attachmentId = Long.parseLong(suffixTokens[1]);
            String path = this.getAndCheckAttachmentPath(loginPrincipal, organisationPersonId, attachmentId);
            foundFile = RepositoryHelper.getFileInRepository(this.attachmentRepository, path);
        } else if (finalPath.startsWith(DOCUMENT_REFERENCE_PREFIX)) {
            String suffix = finalPath.substring(DOCUMENT_REFERENCE_PREFIX.length());
            String[] suffixTokens = this.getAndStripSuffixTokens(suffix);
            Long organisationPersonId = Long.parseLong(suffixTokens[0]);
            Long documentReferenceId = Long.parseLong(suffixTokens[1]);
            String path = this.getAndCheckDocumentReferencePath(loginPrincipal, organisationPersonId, documentReferenceId);
            foundFile = RepositoryHelper.getFileInRepository(this.documentReferenceRepository, path);
        } else if (finalPath.startsWith(JOB_TEMP_PREFIX)) {
            String suffix = finalPath.substring(JOB_TEMP_PREFIX.length());
            String[] suffixTokens = this.getAndStripSuffixTokens(suffix);
            Long organisationPersonId = Long.parseLong(suffixTokens[0]);
            Long jobId = Long.parseLong(suffixTokens[1]);
            String path = this.getAndCheckJobTempPath(loginPrincipal, organisationPersonId, jobId);
            foundFile = RepositoryHelper.getFileInRepository(this.tempRepository, path);
        } else if (finalPath.startsWith(PLAN_PREFIX)) {
            String suffix = finalPath.substring(PLAN_PREFIX.length());
            String[] suffixTokens = this.getAndStripSuffixTokens(suffix);
            Long organisationPersonId = Long.parseLong(suffixTokens[0]);
            Long documentVersionId = Long.parseLong(suffixTokens[1]);
            String path = this.getAndCheckDocumentVersionPath(loginPrincipal, organisationPersonId, documentVersionId);
            foundFile = RepositoryHelper.getFileInRepository(this.planRepository, path);
        } else if (finalPath.startsWith(PLANNING_NOTIFICATION_ATTACHMENT_PREFIX)) {
            String suffix = finalPath.substring(PLANNING_NOTIFICATION_ATTACHMENT_PREFIX.length());
            String[] suffixTokens = this.getAndStripSuffixTokens(suffix);
            Long organisationPersonId = Long.parseLong(suffixTokens[0]);
            Long planningNotificationAttachmentId = Long.parseLong(suffixTokens[1]);
            String path = this.getAndCheckPlanningNotificationAttachmentPath(loginPrincipal, organisationPersonId, planningNotificationAttachmentId);
            foundFile = RepositoryHelper.getFileInRepository(this.planningNotificationAttachmentRepository, path);
        } else if (finalPath.startsWith(PLANNING_NOTIFICATION_PREFIX)) {
            String suffix = finalPath.substring(PLANNING_NOTIFICATION_PREFIX.length() + 1);
            String[] suffixTokens = this.getAndStripSuffixTokens(suffix);
            Long organisationPersonId = Long.parseLong(suffixTokens[0]);
            Long planningNotificationId = Long.parseLong(suffixTokens[1]);
            String planningNotificationPath = this.getAndCheckPlanningNotificationPath(loginPrincipal, organisationPersonId, planningNotificationId);
            foundFile = RepositoryHelper.getFileInRepository(this.planningNotificationRepository, planningNotificationPath);
        } else if (finalPath.startsWith(REQUEST_PREFIX)) {
            String suffix = finalPath.substring(REQUEST_PREFIX.length() + 1);
            String[] suffixTokens = this.getAndStripSuffixTokens(suffix);
            Long organisationPersonId = Long.parseLong(suffixTokens[0]);
            Long certificateRequestId = Long.parseLong(suffixTokens[1]);
            String directorySuffix = this.getAndCheckCertificateRequestId(loginPrincipal, organisationPersonId, certificateRequestId);
            File directory = RepositoryHelper.getFileInRepository(this.requestRepository, directorySuffix);
            for (File file : directory.listFiles()) {
                if (".".equals(file.getName()) || "..".equals(file.getName())) continue;
                foundFile = file;
                break;
            }
        } else if (finalPath.startsWith(TEMP_PREFIX)) {
            String suffix = finalPath.substring(TEMP_PREFIX.length() + 1);
            String[] suffixTokens = this.getAndStripSuffixTokens(suffix);
            Long organisationPersonId = Long.parseLong(suffixTokens[0]);
            String fileName = this.getAndCheckTempRepositoryFileName(loginPrincipal, organisationPersonId, suffixTokens[1]);
            foundFile = RepositoryHelper.getFileInRepository(this.tempRepository, fileName);
        } else {
            throw new RuntimeException("For finalPath [" + finalPath + "], none of the cases of this FileRepositoryPathGetter matches.");
        }
        return foundFile.getAbsolutePath().replaceAll("\\\\", "/");
    }

    private String[] getAndStripSuffixTokens(String suffix) {
        int slashIndex;
        if (suffix.startsWith("/") || suffix.startsWith("\\")) {
            suffix = suffix.substring(1);
        }
        if (suffix.endsWith("/") || suffix.endsWith("\\")) {
            suffix = suffix.substring(0, suffix.length() - 1);
        }
        if ((slashIndex = suffix.indexOf("/")) != -1) {
            return new String[]{suffix.substring(0, slashIndex), suffix.substring(slashIndex + 1)};
        }
        return new String[]{suffix, null};
    }

    private String getAndCheckDocumentVersionPath(CdesPrincipal loginPrincipal, Long organisationPersonId, Long documentVersionId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(loginPrincipal, this.organisationPersonDAO, organisationPersonId);
        ContextJoin contextJoin = this.documentVersionDAO.getContextJoin(documentVersionId);
        Long objectPlannerId = contextJoin.getObjectPlannerId();
        Set<Action> allowedActions = this.actionDAO.getObjectPlannerActions(organisationPersonId, objectPlannerId, Action.DOWNLOAD_DOCUMENT_VERSION);
        if (!allowedActions.contains(Action.DOWNLOAD_DOCUMENT_VERSION)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] has no privilege to download the file of documentVersion [" + documentVersionId + "]");
        }
        DocumentVersion documentVersion = (DocumentVersion)this.documentVersionDAO.get(documentVersionId);
        return documentVersion.getFileName();
    }

    private String getAndCheckAttachmentPath(CdesPrincipal loginPrincipal, Long organisationPersonId, Long attachmentId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(loginPrincipal, this.organisationPersonDAO, organisationPersonId);
        List<ObjectPlanner> objectPlanners = this.objectPlannerDAO.getByAttachment(attachmentId);
        HashSet<Long> objectPlannerIds = new HashSet<Long>();
        for (ObjectPlanner objectPlanner : objectPlanners) {
            objectPlannerIds.add(objectPlanner.getId());
        }
        Map<Long, Set<Action>> objectPlannerIdToActions = this.actionDAO.getObjectPlannerActions(organisationPersonId, objectPlannerIds, Action.DOWNLOAD_ATTACHMENT);
        boolean actionFound = false;
        for (Long objectPlannerId : objectPlannerIdToActions.keySet()) {
            Set<Action> actions = objectPlannerIdToActions.get(objectPlannerId);
            actionFound |= actions != null && actions.contains(Action.DOWNLOAD_ATTACHMENT);
        }
        if (!actionFound) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] has no privilege to download the attachment file of attachment [" + attachmentId + "]; expected [downloadAttachment] with object planner context.");
        }
        Attachment attachment = (Attachment)this.attachmentDAO.get(attachmentId);
        return attachment.getFilename();
    }

    private String getAndCheckDocumentReferencePath(CdesPrincipal loginPrincipal, Long organisationPersonId, Long documentReferenceId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(loginPrincipal, this.organisationPersonDAO, organisationPersonId);
        ContextJoin contextJoin = this.documentReferenceDAO.getContextJoin(documentReferenceId);
        Long objectPlannerId = contextJoin.getObjectPlannerId();
        Set<Action> allowedActions = this.actionDAO.getObjectPlannerActions(organisationPersonId, objectPlannerId, Action.DOWNLOAD_ATTACHMENT);
        if (!allowedActions.contains(Action.DOWNLOAD_ATTACHMENT)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] has no privilege to download the attachment file of documentReference [" + documentReferenceId + "]");
        }
        DocumentReference documentReference = (DocumentReference)this.documentReferenceDAO.get(documentReferenceId);
        return documentReference.getAttachmentFilename();
    }

    private String getAndCheckJobTempPath(CdesPrincipal loginPrincipal, Long organisationPersonId, Long jobId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(loginPrincipal, this.organisationPersonDAO, organisationPersonId);
        Job job = (Job)this.jobDAO.get(jobId);
        Set<Action> actions = this.actionDAO.getActionsForProject(organisationPersonId, job.getProjectId(), Action.ARCHIVE_DOCUMENT_SEARCH);
        if (!actions.contains(Action.ARCHIVE_DOCUMENT_SEARCH)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] has no privilege [archiveDocumentSearch] for downloading the exported document version archive.");
        }
        String resultJson = job.getResult();
        JsonParser jsonParser = new JsonParser();
        JsonObject resultObject = jsonParser.parse(resultJson).getAsJsonObject();
        String fileName = resultObject.get("fileName").getAsString();
        return fileName;
    }

    private String getAndCheckPlanningNotificationAttachmentPath(CdesPrincipal loginPrincipal, Long organisationPersonId, Long planningNotificationAttachmentId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(loginPrincipal, this.organisationPersonDAO, organisationPersonId);
        List<Long> projectIds = this.projectDAO.getProjectIdsByPlanningNotificationAttachmentIds(planningNotificationAttachmentId);
        Map<Long, Set<Action>> projectIdToAllowedAction = this.actionDAO.getActionsForProjects(organisationPersonId, projectIds, Action.DOWNLOAD_PLANNING_NOTIFICATION);
        if (!ActionHelper.hasActionForAnyProject(projectIdToAllowedAction, Action.DOWNLOAD_PLANNING_NOTIFICATION)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] has no privilege to download the file of planningNotificationAttachment [" + planningNotificationAttachmentId + "]");
        }
        PlanningNotificationAttachment planningNotificationAttachment = (PlanningNotificationAttachment)this.planningNotificationAttachmentDAO.get(planningNotificationAttachmentId);
        String fileName = planningNotificationAttachment.getFileName();
        fileName = fileName.replaceAll("\\\\", "/");
        return fileName;
    }

    private String getAndCheckPlanningNotificationPath(CdesPrincipal loginPrincipal, Long organisationPersonId, Long planningNotificationId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(loginPrincipal, this.organisationPersonDAO, organisationPersonId);
        List<PlanningNotificationProjectMap> projectMaps = this.planningNotificationProjectMapDAO.getByPlanningNotification(planningNotificationId);
        ArrayList<Long> projectIds = new ArrayList<Long>();
        for (PlanningNotificationProjectMap projectMap : projectMaps) {
            projectIds.add(projectMap.getProjectId());
        }
        Map<Long, Set<Action>> projectIdToAllowedAction = this.actionDAO.getActionsForProjects(organisationPersonId, projectIds, Action.DOWNLOAD_PLANNING_NOTIFICATION);
        if (!ActionHelper.hasActionForAnyProject(projectIdToAllowedAction, Action.DOWNLOAD_PLANNING_NOTIFICATION)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] has no privilege to download the attachment of planningNotification [" + planningNotificationId + "]");
        }
        PlanningNotification planningNotification = (PlanningNotification)this.planningNotificationDAO.get(planningNotificationId);
        return planningNotification.getPath();
    }

    private String getAndCheckCertificateRequestId(CdesPrincipal loginPrincipal, Long organisationPersonId, Long certificateRequestId) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(loginPrincipal, this.organisationPersonDAO, organisationPersonId);
        CertificateRequest certificateRequest = (CertificateRequest)this.certificateRequestDAO.get(certificateRequestId);
        Long networkId = certificateRequest.getNetworkId();
        if (!this.certificateAdministrationGlobal.booleanValue() && !ActionHelper.hasActionsForNetwork(this.actionDAO, organisationPersonId, networkId, Action.EDIT_PERSON)) {
            throw new SecurityException("OrganisationPerson [" + organisationPersonId + "] is not allowed to download certificate request [" + certificateRequestId + "] in network [" + networkId + "]");
        }
        return certificateRequest.getId() + "/";
    }

    private String getAndCheckTempRepositoryFileName(CdesPrincipal loginPrincipal, Long organisationPersonId, String fileName) {
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(loginPrincipal, this.organisationPersonDAO, organisationPersonId);
        return fileName;
    }
}

