/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.CdesRole;
import at.cdes.api.dto.CdesRoleDefault;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.RoleType;
import at.cdes.api.joinDto.RoleListJoin;
import at.cdes.impl.dao.GenCdesRoleDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcCdesRoleDAO
extends AbstrIdDAO<CdesRole>
implements GenCdesRoleDAO {
    public AbstractJdbcCdesRoleDAO() {
        super(CdesRole.class, "id", "cdes_role", new String[]{"id", "name", "network_id", "description", "project_flag", "context_default_role_flag", "cdes_role_default_id", "type_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcCdesRoleDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_flag") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "context_default_role_flag") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "cdes_role_default_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "type_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcCdesRoleDAO.getSelectClauseForDto("cdes_role", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcCdesRoleDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".name" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + "," + entityLocalName + ".network_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + "," + entityLocalName + ".description" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + "," + entityLocalName + ".project_flag" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_flag") + "," + entityLocalName + ".context_default_role_flag" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "context_default_role_flag") + "," + entityLocalName + ".cdes_role_default_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "cdes_role_default_id") + "," + entityLocalName + ".type_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "type_id") + " ";
    }

    protected CdesRole fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        CdesRole cdesRole = new CdesRole();
        cdesRole.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        cdesRole.setName(rs.getString(++columnIndex));
        cdesRole.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        cdesRole.setDescription(rs.getString(++columnIndex));
        cdesRole.setProjectFlag(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        cdesRole.setContextDefaultRoleFlag(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        cdesRole.setCdesRoleDefaultId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        cdesRole.setTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return cdesRole;
    }

    public static CdesRole fillCdesRoleFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        CdesRole cdesRole = new CdesRole();
        cdesRole.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        cdesRole.setName(rs.getString(columnIndex.incrementAndGet()));
        cdesRole.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        cdesRole.setDescription(rs.getString(columnIndex.incrementAndGet()));
        cdesRole.setProjectFlag(JDBCHelper.getInt((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        cdesRole.setContextDefaultRoleFlag(JDBCHelper.getInt((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        cdesRole.setCdesRoleDefaultId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        cdesRole.setTypeId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return cdesRole;
    }

    public static CdesRole fillCdesRoleFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcCdesRoleDAO.fillCdesRoleFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 8;
    }

    public static RoleListJoin fillRoleListJoinFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        RoleListJoin roleListJoin = new RoleListJoin();
        roleListJoin.setCdesRoleId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        roleListJoin.setCdesRoleName(rs.getString(++columnIndex));
        roleListJoin.setCdesRoleNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        roleListJoin.setCdesRoleDescription(rs.getString(++columnIndex));
        roleListJoin.setCdesRoleProjectFlag(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        roleListJoin.setCdesRoleContextDefaultRoleFlag(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        roleListJoin.setCdesRoleCdesRoleDefaultId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        roleListJoin.setCdesRoleTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        roleListJoin.setRoleTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        roleListJoin.setRoleTypeName(rs.getString(++columnIndex));
        roleListJoin.setRoleTypeDescription(rs.getString(++columnIndex));
        roleListJoin.setRoleTypeType(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        return roleListJoin;
    }

    public static int getNumberOfRoleListJoinAttributes() {
        return 12;
    }

    @Override
    public void deleteByNetworkId(final Long networkId) {
        String sql = "DELETE FROM cdes_role WHERE network_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, networkId);
                statement.execute();
                return null;
            }
        });
    }

    protected String getSelectClauseForRoleListJoinUnion(String ... localNames) {
        String result = "";
        HashSet<String> localNamesSet = new HashSet<String>();
        for (int n = 0; n < localNames.length; ++n) {
            localNamesSet.add(localNames[n]);
        }
        result = localNamesSet.contains("cdesRole") ? result + "cdes_role.id, cdes_role.name, cdes_role.network_id, cdes_role.description, cdes_role.project_flag, cdes_role.context_default_role_flag, cdes_role.cdes_role_default_id, cdes_role.type_id" : result + "NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("roleType") ? result + "role_type.id, role_type.name, role_type.description, role_type.type" : result + "NULL, NULL, NULL, NULL";
        return result;
    }

    public int update(CdesRole dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<CdesRole> dtos) {
        Iterator<CdesRole> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    public static String getRoleListJoinSelectClause() {
        return "cdes_role.id, cdes_role.name, cdes_role.network_id, cdes_role.description, cdes_role.project_flag, cdes_role.context_default_role_flag, cdes_role.cdes_role_default_id, cdes_role.type_id, role_type.id, role_type.name, role_type.description, role_type.type ";
    }

    public static String getPrefixedRoleListJoinSelectClause() {
        return "cdes_role.id AS cdes_role_id, cdes_role.name AS cdes_role_name, cdes_role.network_id AS cdes_role_network_id, cdes_role.description AS cdes_role_description, cdes_role.project_flag AS cdes_role_project_flag, cdes_role.context_default_role_flag AS cdes_role_context_default_role_flag, cdes_role.cdes_role_default_id AS cdes_role_cdes_role_default_id, cdes_role.type_id AS cdes_role_type_id, role_type.id AS role_type_id, role_type.name AS role_type_name, role_type.description AS role_type_description, role_type.type AS role_type_type ";
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, CdesRole cdesRole) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)cdesRole.getId());
        statement.setString(2, cdesRole.getName());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)cdesRole.getNetworkId());
        statement.setString(4, cdesRole.getDescription());
        JDBCHelper.setInt((PreparedStatement)statement, (int)5, (Number)cdesRole.getProjectFlag());
        JDBCHelper.setInt((PreparedStatement)statement, (int)6, (Number)cdesRole.getContextDefaultRoleFlag());
        JDBCHelper.setLong((PreparedStatement)statement, (int)7, (Number)cdesRole.getCdesRoleDefaultId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)8, (Number)cdesRole.getTypeId());
    }

    @Override
    public List<CdesRole> getByNetwork(Network network) {
        return this.getByNetwork(network.getId());
    }

    @Override
    public List<CdesRole> getByNetwork(final Long networkId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkId);
            }
        });
    }

    @Override
    public List<CdesRole> getByCdesRoleDefault(CdesRoleDefault cdesRoleDefault) {
        return this.getByCdesRoleDefault(cdesRoleDefault.getId());
    }

    @Override
    public List<CdesRole> getByCdesRoleDefault(final Long cdesRoleDefaultId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"cdes_role_default_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, cdesRoleDefaultId);
            }
        });
    }

    @Override
    public List<CdesRole> getByType(RoleType roleType) {
        return this.getByType(roleType.getId());
    }

    @Override
    public List<CdesRole> getByType(final Long roleTypeId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"type_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, roleTypeId);
            }
        });
    }

    @Override
    public List<CdesRole> getByNetworks(Collection<Long> networkId) {
        if (networkId.isEmpty()) {
            return new ArrayList<CdesRole>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkId.size()];
        int n = 0;
        Iterator<Long> it = networkId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<CdesRole> getByCdesRoleDefaults(Collection<Long> cdesRoleDefaultId) {
        if (cdesRoleDefaultId.isEmpty()) {
            return new ArrayList<CdesRole>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[cdesRoleDefaultId.size()];
        int n = 0;
        Iterator<Long> it = cdesRoleDefaultId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"cdes_role_default_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<CdesRole> getByTypes(Collection<Long> roleTypeId) {
        if (roleTypeId.isEmpty()) {
            return new ArrayList<CdesRole>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[roleTypeId.size()];
        int n = 0;
        Iterator<Long> it = roleTypeId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"type_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

