/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Network;
import at.cdes.api.joinDto.NetworkJoin;
import at.cdes.api.network.dto.NetworkSearchModel;
import at.cdes.impl.dao.NetworkDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcNetworkDAO;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.SearchHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcNetworkDAO
extends AbstractJdbcNetworkDAO
implements NetworkDAO {
    @Override
    public List<Network> getNetworksToAdmin(final Long organisationPersonId) {
        String sql = "SELECT " + JdbcNetworkDAO.getSelectClauseForDto() + "FROM      network_person JOIN network                ON network_person.network_id = network.id WHERE network_person.organisation_person_id = ?";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Network>>(){

            public List<Network> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)organisationPersonId);
                ResultSet rs = statement.executeQuery();
                ArrayList<Network> ret = new ArrayList<Network>();
                while (rs.next()) {
                    Network network = JdbcNetworkDAO.fillNetworkFromResultSet(rs);
                    ret.add(network);
                }
                return ret;
            }
        });
    }

    @Override
    public String getContextJoinUnionSelectClause(String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForContextJoinUnion(localNames);
        return selectClauseForUnion;
    }

    @Override
    public Map<Long, List<Network>> getNetworksForOrganisationPersons(final Collection<Long> organisationPersonIds) {
        String sql = "SELECT DISTINCT " + JdbcNetworkDAO.getSelectClauseForDto() + ", organisation_person.id FROM ((((    organisation_person JOIN organisation         ON organisation_person.organisation_id = organisation.id) LEFT JOIN network_organisation ON network_organisation.organisation_id = organisation.id) LEFT JOIN network_person       ON network_person.organisation_person_id = organisation_person.id) LEFT JOIN network              ON    network_person.network_id = network.id OR network_organisation.network_id = network.id) WHERE organisation_person.id IN (" + QueryHelper.getPlaceHolderSequence(organisationPersonIds.size()) + ")";
        return (Map)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Map<Long, List<Network>>>(){

            public Map<Long, List<Network>> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long organisationPersonId : organisationPersonIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
                }
                ResultSet rs = statement.executeQuery();
                HashMap<Long, List<Network>> organisationPersonIdToNetworks = new HashMap<Long, List<Network>>();
                while (rs.next()) {
                    Network network = JdbcNetworkDAO.fillNetworkFromResultSet(rs);
                    int idx = JdbcNetworkDAO.getNumberOfDtoAttributes() + 1;
                    Long organisationPersonId = JDBCHelper.getLong((ResultSet)rs, (int)idx);
                    if (!organisationPersonIdToNetworks.containsKey(organisationPersonId)) {
                        organisationPersonIdToNetworks.put(organisationPersonId, new ArrayList());
                    }
                    ((List)organisationPersonIdToNetworks.get(organisationPersonId)).add(network);
                }
                return organisationPersonIdToNetworks;
            }
        });
    }

    @Override
    public List<Network> getNetworksByOrganisation(final Long organisationId) {
        String sql = "SELECT " + JdbcNetworkDAO.getSelectClauseForDto() + "FROM (          network_organisation JOIN network              ON network_organisation.network_id = network.id) WHERE network_organisation.organisation_id = ?";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Network>>(){

            public List<Network> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationId);
                ResultSet rs = statement.executeQuery();
                ArrayList<Network> networks = new ArrayList<Network>();
                while (rs.next()) {
                    Network network = JdbcNetworkDAO.fillNetworkFromResultSet(rs);
                    networks.add(network);
                }
                return networks;
            }
        });
    }

    @Override
    public List<Network> getNetworksByOrganisationPerson(final Long organisationPersonId) {
        String sql = "SELECT " + JdbcNetworkDAO.getSelectClauseForDto() + "FROM ((         organisation_person JOIN network_organisation ON network_organisation.organisation_id = organisation_person.organisation_id) JOIN network              ON network_organisation.network_id = network.id) WHERE organisation_person.id = ?";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Network>>(){

            public List<Network> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
                ResultSet rs = statement.executeQuery();
                ArrayList<Network> networks = new ArrayList<Network>();
                while (rs.next()) {
                    Network network = JdbcNetworkDAO.fillNetworkFromResultSet(rs);
                    networks.add(network);
                }
                return networks;
            }
        });
    }

    @Override
    public Map<Long, List<Network>> getNetworksByOrganisations(final Collection<Long> organisationIds) {
        String sql = "SELECT " + JdbcNetworkDAO.getSelectClauseForDto() + ", network_organisation.organisation_id FROM (          network_organisation JOIN network              ON network_organisation.network_id = network.id) WHERE network_organisation.organisation_id IN (" + QueryHelper.getPlaceHolderSequence(organisationIds.size()) + ")";
        return (Map)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Map<Long, List<Network>>>(){

            public Map<Long, List<Network>> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long organisationId : organisationIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationId);
                }
                ResultSet rs = statement.executeQuery();
                HashMap<Long, List<Network>> organisationIdToNetworks = new HashMap<Long, List<Network>>();
                while (rs.next()) {
                    Long organisationId;
                    Network network = JdbcNetworkDAO.fillNetworkFromResultSet(rs);
                    currIndex = JdbcNetworkDAO.getNumberOfDtoAttributes() + 1;
                    if (!organisationIdToNetworks.containsKey(organisationId = JDBCHelper.getLong((ResultSet)rs, (int)currIndex++))) {
                        organisationIdToNetworks.put(organisationId, new ArrayList());
                    }
                    ((List)organisationIdToNetworks.get(organisationId)).add(network);
                }
                return organisationIdToNetworks;
            }
        });
    }

    @Override
    public List<Network> getNetworksByPerson(final Long personId) {
        String sql = "SELECT " + JdbcNetworkDAO.getSelectClauseForDto() + "FROM ((        organisation_person JOIN network_organisation ON organisation_person.organisation_id = network_organisation.organisation_id) JOIN network              ON network_organisation.network_id = network.id) WHERE organisation_person.person_id = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Network>>(){

            public List<Network> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)personId);
                ResultSet rs = statement.executeQuery();
                ArrayList<Network> ret = new ArrayList<Network>();
                while (rs.next()) {
                    Network network = JdbcNetworkDAO.fillNetworkFromResultSet(rs);
                    ret.add(network);
                }
                return ret;
            }
        });
    }

    @Override
    public List<Network> getByLabelContentId(Long labelContentId) {
        String sql = "SELECT " + JdbcNetworkDAO.getSelectClauseForDto() + "FROM label_content JOIN label                ON label_content.label_id = label.id JOIN review_cycle         ON label.review_cycle_id = review_cycle.id JOIN network_review_cycle ON network_review_cycle.review_cycle_id = review_cycle.id JOIN network              ON network_review_cycle.network_id = network.id WHERE label_content.id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)labelContentId);
        });
    }

    @Override
    public List<Network> getByLabelId(Long labelId) {
        String sql = "SELECT " + JdbcNetworkDAO.getSelectClauseForDto() + "FROM label JOIN review_cycle         ON label.review_cycle_id = review_cycle.id JOIN network_review_cycle ON network_review_cycle.review_cycle_id = review_cycle.id JOIN network              ON network_review_cycle.network_id = network.id WHERE label.id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)labelId);
        });
    }

    @Override
    public Map<Long, List<Network>> getOPGroupedNetworksByPerson(final Long personId) {
        String sql = "SELECT " + JdbcNetworkDAO.getSelectClauseForDto() + ", organisation_person.id FROM ((        organisation_person JOIN network_organisation ON organisation_person.organisation_id = network_organisation.organisation_id) JOIN network              ON network_organisation.network_id = network.id) WHERE organisation_person.person_id = ? ";
        return (Map)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Map<Long, List<Network>>>(){

            public Map<Long, List<Network>> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)personId);
                ResultSet rs = statement.executeQuery();
                HashMap<Long, List<Network>> organisationPersonIdToNetworks = new HashMap<Long, List<Network>>();
                while (rs.next()) {
                    Network network = JdbcNetworkDAO.fillNetworkFromResultSet(rs);
                    int currIndex = JdbcNetworkDAO.getNumberOfDtoAttributes() + 1;
                    Long organisationPersonId = JDBCHelper.getLong((ResultSet)rs, (int)currIndex);
                    if (!organisationPersonIdToNetworks.containsKey(organisationPersonId)) {
                        organisationPersonIdToNetworks.put(organisationPersonId, new ArrayList());
                    }
                    ((List)organisationPersonIdToNetworks.get(organisationPersonId)).add(network);
                }
                return organisationPersonIdToNetworks;
            }
        });
    }

    @Override
    public Map<Long, List<Network>> getOPGroupedNetworksByOrganisationPersons(final List<Long> organisationPersonIds) {
        String sql = "SELECT " + JdbcNetworkDAO.getSelectClauseForDto() + ", organisation_person.id FROM ((        organisation_person JOIN network_organisation ON organisation_person.organisation_id = network_organisation.organisation_id) JOIN network              ON network_organisation.network_id = network.id) WHERE organisation_person.id IN (" + QueryHelper.getPlaceHolderSequence(organisationPersonIds.size()) + ")";
        return (Map)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Map<Long, List<Network>>>(){

            public Map<Long, List<Network>> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long organisationPersonId : organisationPersonIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
                }
                ResultSet rs = statement.executeQuery();
                HashMap<Long, List<Network>> organisationPersonIdToNetworks = new HashMap<Long, List<Network>>();
                while (rs.next()) {
                    Network network = JdbcNetworkDAO.fillNetworkFromResultSet(rs);
                    int organisationPersonIdIndex = JdbcNetworkDAO.getNumberOfDtoAttributes() + 1;
                    Long organisationPersonId = JDBCHelper.getLong((ResultSet)rs, (int)organisationPersonIdIndex);
                    if (!organisationPersonIdToNetworks.containsKey(organisationPersonId)) {
                        organisationPersonIdToNetworks.put(organisationPersonId, new ArrayList());
                    }
                    ((List)organisationPersonIdToNetworks.get(organisationPersonId)).add(network);
                }
                return organisationPersonIdToNetworks;
            }
        });
    }

    @Override
    public Network getByProjectParticipation(Long projectParticipationId) {
        String sql = "SELECT " + this.getSelectClauseForDto() + "\nFROM project_participation\nJOIN project ON project.id = project_participation.project_id\nJOIN network ON network.id = project.network_id\nWHERE project_participation.id = ?\n";
        return QueryHelper.getUniqueWithSqlFiller((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, filler -> filler.addLong(projectParticipationId));
    }

    @Override
    public List<NetworkJoin> getNetworkJoins(NetworkSearchModel searchModel) {
        String name = searchModel.getName();
        String maintainer = searchModel.getMaintainer();
        String administrator = searchModel.getAdministrator();
        String sql = "SELECT " + JdbcNetworkDAO.getNetworkJoinSelectClause() + "FROM network LEFT JOIN organisation maintainer_organisation ON network.maintainer_id = maintainer_organisation.id LEFT JOIN network_type                         ON network.network_type_id = network_type.id LEFT JOIN cdes_role_default                    ON network_type.network_administrator_id = cdes_role_default.id LEFT JOIN cdes_role                            ON     cdes_role.cdes_role_default_id = cdes_role_default.id AND cdes_role.network_id = network.id LEFT JOIN network_person                       ON     network_person.network_id = network.id AND network_person.role_id = cdes_role.id LEFT JOIN organisation_person                  ON network_person.organisation_person_id = organisation_person.id LEFT JOIN organisation                         ON organisation_person.organisation_id = organisation.id LEFT JOIN person                               ON organisation_person.person_id = person.id WHERE 1=1 ";
        if (SearchHelper.isStringFilled(name)) {
            sql = sql + "AND network.name LIKE ? ";
        }
        if (SearchHelper.isStringFilled(maintainer)) {
            sql = sql + "AND maintainer_organisation.name LIKE ? ";
        }
        if (SearchHelper.isStringFilled(administrator)) {
            sql = sql + "AND EXISTS (SELECT 1 FROM network_person search_network_person JOIN organisation_person search_op    ON search_network_person.organisation_person_id = search_op.id JOIN organisation search_organisation ON search_op.organisation_id = search_organisation.id JOIN person search_person             ON search_op.person_id = search_person.id WHERE search_network_person.network_id = network.id AND CONCAT(search_organisation.name, ' (', search_person.surName, ' ', search_person.givenName, ')') LIKE ?) ";
        }
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcNetworkDAO::fillNetworkJoinFromResultSet, statement -> {
            int currIndex = 1;
            if (SearchHelper.isStringFilled(name)) {
                statement.setString(currIndex++, name);
            }
            if (SearchHelper.isStringFilled(maintainer)) {
                statement.setString(currIndex++, maintainer);
            }
            if (SearchHelper.isStringFilled(administrator)) {
                statement.setString(currIndex++, administrator);
            }
        });
    }
}

