/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.document.searchModel.OriginalDocumentOrderSearchModel;
import at.cdes.api.joinDto.OriginalDocumentOrderJoin;
import at.cdes.api.voc.original.OriginalType;
import at.cdes.api.voc.plot.AcceptedMode;
import at.cdes.impl.dao.OriginalDocumentOrderDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcOriginalDocumentOrderDAO;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcOriginalDocumentOrderDAO
extends AbstractJdbcOriginalDocumentOrderDAO
implements OriginalDocumentOrderDAO {
    private static final Logger log = LoggerFactory.getLogger(JdbcOriginalDocumentOrderDAO.class);

    @Override
    public List<OriginalDocumentOrderJoin> getOriginalDocumentOrderJoins(OriginalDocumentOrderSearchModel searchModel) {
        String prefix = QueryHelper.getLargeQueryPrefix((JdbcDAOSupport)this);
        String sql = "" + prefix + "SELECT " + JdbcOriginalDocumentOrderDAO.getOriginalDocumentOrderJoinSelectClause() + ", self.id AS self_id \n     FROM original_document_order\n     JOIN project_participation document_owner ON document_owner.id = original_document_order.document_owner_id\nLEFT JOIN project_participant document_owner_main_participant\n                                               ON document_owner_main_participant.participation_id = document_owner.id\n                                              AND document_owner_main_participant.main_participant_flag = 1\n                                              AND document_owner_main_participant.inactive_flag = 0\nLEFT JOIN organisation_person document_owner_main_participant_organisation_person\n                                               ON document_owner_main_participant_organisation_person.id = document_owner_main_participant.organisation_person_id\nLEFT JOIN person document_owner_main_participant_person\n                                               ON document_owner_main_participant_person.id = document_owner_main_participant_organisation_person.person_id\nLEFT JOIN organisation document_owner_main_participant_organisation\n                                               ON document_owner_main_participant_organisation.id = document_owner_main_participant_organisation_person.organisation_id\nLEFT JOIN project_participant self             ON self.participation_id = document_owner.id\n                                              AND self.inactive_flag = 0\nLEFT JOIN order_step request                   ON request.id = original_document_order.request_id\nLEFT JOIN organisation_order_step              ON organisation_order_step.order_step_id = request.id\nLEFT JOIN project_participation_order_step     ON project_participation_order_step.order_step_id = request.id\nLEFT JOIN organisation_person_order_step       ON organisation_person_order_step.order_step_id = request.id\nLEFT JOIN project_participant request_main_participant\n                                               ON request_main_participant.participation_id = project_participation_order_step.project_participation_id\n                                              AND request_main_participant.main_participant_flag = 1\n                                              AND request_main_participant.inactive_flag = 0\nLEFT JOIN organisation_person request_organisation_person\n                                               ON request_organisation_person.id IN (request_main_participant.organisation_person_id, organisation_order_step.organisation_person_id, organisation_person_order_step.organisation_person_id)\nLEFT JOIN person request_person                ON request_person.id = request_organisation_person.person_id\nLEFT JOIN organisation request_organisation    ON request_organisation.id IN (request_organisation_person.organisation_id, organisation_order_step.organisation_id)\nLEFT JOIN order_step acceptance                ON acceptance.id = original_document_order.acceptance_id\nLEFT JOIN original_document_task original_document_order_task\n                                               ON acceptance.id = original_document_order_task.order_step_id\nLEFT JOIN order_step completed                 ON completed.id = original_document_order.completed_id\n     JOIN original_document_order_item         ON original_document_order_item.order_contract_id = original_document_order.id\n     JOIN document_version                     ON document_version.id = original_document_order_item.document_version_id\n     JOIN document                             ON document.id = document_version.document_id\n     JOIN document_list                        ON document_list.id = document.document_list_id\nLEFT JOIN document_list_release                ON document_list_release.document_list_id = document_list.id\n                                              AND document_list_release.version = (document_list.version - 1)\nLEFT JOIN document_release                     ON document_release.document_list_id = document_list_release.id\n                                              AND document_release.document_id = document.id\nLEFT JOIN project_participant receiver_main_participant\n                                               ON receiver_main_participant.participation_id = original_document_order_item.receiver_id\n                                              AND original_document_order_item.receiver_type = 0\n                                              AND receiver_main_participant.main_participant_flag = 1\n                                              AND receiver_main_participant.inactive_flag = 0\nLEFT JOIN organisation_person receiver_organisation_person\n                                               ON (receiver_organisation_person.id = receiver_main_participant.organisation_person_id\n                                                   OR (receiver_organisation_person.id = original_document_order_item.receiver_id AND original_document_order_item.receiver_type = 2)\n                                                   OR (receiver_organisation_person.organisation_id IN \n                                                        (select organisation.id from organisation where organisation.id = original_document_order_item.receiver_id AND original_document_order_item.receiver_type = 1))\n                                                   AND receiver_organisation_person.retired_flag = 0) LEFT JOIN person receiver_person               ON receiver_person.id = receiver_organisation_person.person_id\n                                                   AND receiver_person.invalidated = 0 LEFT JOIN organisation receiver_organisation   ON (receiver_organisation.id = receiver_organisation_person.organisation_id)\nWHERE 1=1\n";
        Long organisationPersonId = searchModel.getOrganisationPersonId();
        OriginalType originalType = searchModel.getOriginalType();
        Long documentVersionId = searchModel.getDocumentVersionId();
        Long plannerOrganisationPersonId = searchModel.getPlannerOrganisationPersonId();
        AcceptedMode acceptedMode = searchModel.getAcceptedMode();
        Long requestedByOrganisationId = searchModel.getRequestedByOrganisationId();
        Long requestedByOrganisationPersonId = searchModel.getRequestedByOrganisationPersonId();
        Long requestedForOrganisationId = searchModel.getRequestedForOrganisationId();
        Long requestedForOrganisationPersonId = searchModel.getRequestedForOrganisationPersonId();
        sql = searchModel.getOriginalDocumentOrderId() != null ? sql + "AND original_document_order.id = ?\n" : sql + "AND original_document_order.outdated = 0 ";
        if (searchModel.getOrganisationPersonId() != null) {
            sql = sql + "AND (self.organisation_person_id = ?\n";
            sql = sql + "OR request_organisation_person.id = ?\n";
            sql = sql + "OR receiver_organisation_person.id = ?)\n";
        }
        if (searchModel.getSubProjectId() != null) {
            sql = sql + "AND original_document_order.sub_project_id = ?\n";
        }
        if (documentVersionId != null) {
            sql = sql + "AND EXISTS (SELECT 1 FROM original_document_order_item filter_item WHERE filter_item.order_contract_id = original_document_order.id AND filter_item.document_version_id = ?) ";
        }
        if (plannerOrganisationPersonId != null) {
            sql = sql + "AND document_owner_main_participant_organisation_person.id = ? ";
        }
        if (acceptedMode != null) {
            sql = sql + "AND acceptance.accepted_mode = ? ";
        }
        if (requestedByOrganisationId != null) {
            sql = sql + "AND request_organisation.id = ? ";
        }
        if (requestedByOrganisationPersonId != null) {
            sql = sql + "AND request_organisation_person.id = ? ";
        }
        if (requestedForOrganisationId != null) {
            sql = sql + "AND EXISTS (SELECT 1 FROM original_document_order_item filter_item LEFT JOIN project_participant filter_main_participant\nON filter_main_participant.participation_id = filter_item.receiver_id\nAND filter_item.receiver_type = 0\nAND filter_main_participant.main_participant_flag = 1\nAND filter_main_participant.inactive_flag = 0\nLEFT JOIN organisation_person filter_organisation_person\nON (filter_organisation_person.id = filter_main_participant.organisation_person_id\nOR (filter_organisation_person.id = filter_item.receiver_id AND filter_item.receiver_type = 2))\nLEFT JOIN organisation filter_organisation ON (filter_organisation.id = filter_organisation_person.organisation_id\nOR (filter_organisation.id = filter_item.receiver_id AND filter_item.receiver_type = 1))\nWHERE filter_item.order_contract_id = original_document_order.id AND filter_organisation.id = ?) ";
        }
        if (requestedForOrganisationPersonId != null) {
            String subQuery = "AND EXISTS (SELECT 1 FROM original_document_order_item filter_item LEFT JOIN project_participant filter_main_participant\nON filter_main_participant.participation_id = filter_item.receiver_id\nAND filter_item.receiver_type = 0\nAND filter_main_participant.main_participant_flag = 1\nAND filter_main_participant.inactive_flag = 0\nLEFT JOIN organisation_person filter_organisation_person\nON (filter_organisation_person.id = filter_main_participant.organisation_person_id\nOR (filter_organisation_person.id = filter_item.receiver_id AND filter_item.receiver_type = 2))\nLEFT JOIN organisation filter_organisation ON (filter_organisation.id = filter_item.receiver_id AND filter_item.receiver_type = 1)\nLEFT JOIN organisation_person ref_organisation_person ON ref_organisation_person.id = filter_organisation_person.id OR ref_organisation_person.organisation_id = filter_organisation.id WHERE filter_item.order_contract_id = original_document_order.id AND ref_organisation_person.id = ?) ";
            if (requestedForOrganisationPersonId != null) {
                sql = sql + subQuery;
            }
        }
        if (originalType == OriginalType.FROM_ME) {
            sql = sql + "AND self.id IS NULL ";
        }
        if (originalType == OriginalType.TO_ME) {
            sql = sql + "AND self.id IS NOT NULL ";
        }
        String tempSql = sql;
        return (List)this.performWithPreparedStatement(tempSql, statement -> {
            int currIndex = 1;
            if (searchModel.getOriginalDocumentOrderId() != null) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex, (Number)searchModel.getOriginalDocumentOrderId());
                ++currIndex;
            }
            if (searchModel.getOrganisationPersonId() != null) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex, (Number)searchModel.getOrganisationPersonId());
                JDBCHelper.setLong((PreparedStatement)statement, (int)(++currIndex), (Number)searchModel.getOrganisationPersonId());
                JDBCHelper.setLong((PreparedStatement)statement, (int)(++currIndex), (Number)searchModel.getOrganisationPersonId());
                ++currIndex;
            }
            if (searchModel.getSubProjectId() != null) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex, (Number)searchModel.getSubProjectId());
                ++currIndex;
            }
            if (documentVersionId != null) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
            }
            if (plannerOrganisationPersonId != null) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)plannerOrganisationPersonId);
            }
            if (acceptedMode != null) {
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)acceptedMode.getValue());
            }
            if (requestedByOrganisationId != null) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)requestedByOrganisationId);
            }
            if (requestedByOrganisationPersonId != null) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)requestedByOrganisationPersonId);
            }
            if (requestedForOrganisationId != null) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)requestedForOrganisationId);
            }
            if (requestedForOrganisationPersonId != null) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)requestedForOrganisationPersonId);
            }
            QueryHelper.checkNumberOfWildcards(tempSql, currIndex);
            ArrayList<OriginalDocumentOrderJoin> rawResults = new ArrayList<OriginalDocumentOrderJoin>();
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                Long selfId;
                OriginalDocumentOrderJoin joinDto = JdbcOriginalDocumentOrderDAO.fillOriginalDocumentOrderJoinFromResultSet(rs);
                int columnIndex = JdbcOriginalDocumentOrderDAO.getNumberOfOriginalDocumentOrderJoinAttributes() + 1;
                joinDto.setTransient_Participates(Boolean.valueOf((selfId = JDBCHelper.getLong((ResultSet)rs, (int)columnIndex++)) != null));
                rawResults.add(joinDto);
            }
            HashMap<Long, OriginalDocumentOrderJoin> distinct = new HashMap<Long, OriginalDocumentOrderJoin>();
            for (OriginalDocumentOrderJoin rawResult : rawResults) {
                distinct.put(rawResult.getOriginalDocumentOrderItemId(), rawResult);
            }
            ArrayList distinctRawResults = new ArrayList(distinct.values());
            HashMap<String, OriginalDocumentOrderJoin> keyToJoin = new HashMap<String, OriginalDocumentOrderJoin>();
            for (OriginalDocumentOrderJoin rawResult : distinctRawResults) {
                String key = rawResult.getOriginalDocumentOrderId() != null ? rawResult.getOriginalDocumentOrderId().toString() : ("null " + rawResult.getOriginalDocumentOrderItemId() != null ? rawResult.getOriginalDocumentOrderItemId().toString() : "null");
                keyToJoin.put(key, rawResult);
            }
            ArrayList results = new ArrayList();
            results.addAll(keyToJoin.values());
            return distinctRawResults;
        });
    }
}

