/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.reviewCycle;

import at.cdes.api.dto.Project;
import at.cdes.api.dto.ReviewCycleCell;
import at.cdes.api.dto.ReviewCycleCellConnection;
import at.cdes.api.dto.ReviewCycleCellInstance;
import at.cdes.api.dto.ReviewCycleCellInstanceReleased;
import at.cdes.api.dto.ReviewCycleInstanceReleased;
import at.cdes.api.dto.ReviewCycleNode;
import at.cdes.api.dto.ReviewCycleNodeInstance;
import at.cdes.api.dto.ReviewCycleNodeInstanceReleased;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.reviewCycle.DurationCalcContext;
import at.cdes.impl.reviewCycle.DurationInfo;
import at.cdes.impl.reviewCycle.InstanceDurationCalcContext;
import at.cdes.impl.reviewCycle.ReviewCycleHelper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurationCalculator {
    private static final Logger log = LoggerFactory.getLogger(DurationCalculator.class);
    private Boolean reversePreduration;
    private ProjectDAO projectDAO;

    public void setReversePreduration(Boolean reversePreduration) {
        this.reversePreduration = reversePreduration;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public DurationInfo calculateReviewCycleInstanceRemainingDurations(DurationCalcContext cycleContext, ReviewCycleNodeInstanceReleased nodeInstanceReleased, Long projectId) {
        Long instanceReleasedId;
        ReviewCycleInstanceReleased instanceReleased;
        int preDuration;
        DurationInfo duration = this.recursiveCalculateDurations(cycleContext, nodeInstanceReleased, projectId);
        Long cellInstanceReleasedId = nodeInstanceReleased.getReviewCycleCellInstanceId();
        ReviewCycleCellInstanceReleased cellInstanceReleased = cycleContext.getCellInstanceReleasedById(cellInstanceReleasedId);
        if (cellInstanceReleased != null && (preDuration = (instanceReleased = cycleContext.getInstanceReleasedById(instanceReleasedId = cellInstanceReleased.getReviewCycleInstanceId())).getDurationPre().intValue()) > 0 && this.reversePreduration != null && this.reversePreduration.booleanValue()) {
            duration.addDuration(preDuration);
            duration.addDurationMin(preDuration);
        }
        return duration;
    }

    public DurationInfo recursiveCalculateDurations(DurationCalcContext cycleContext, ReviewCycleNodeInstanceReleased firstNodeInstanceReleased, Long projectId) {
        DurationInfo totalDuration = new DurationInfo();
        Long cellInstanceReleasedId = firstNodeInstanceReleased.getReviewCycleCellInstanceId();
        ReviewCycleCellInstanceReleased cellInstanceReleased = cycleContext.getCellInstanceReleasedById(cellInstanceReleasedId);
        Project project = (Project)this.projectDAO.get(projectId);
        ReviewCycleNodeInstanceReleased nodeInstanceReleased = firstNodeInstanceReleased;
        while (nodeInstanceReleased != null && nodeInstanceReleased.getId() != null) {
            Long nodeId = nodeInstanceReleased.getReviewCycleNodeId();
            ReviewCycleNode node = cycleContext.getNodeById(nodeId);
            if (log.isDebugEnabled()) {
                log.debug("node = [" + node + "]; cycleContext = [" + cycleContext + "]");
            }
            boolean isEndNode = cycleContext.isEndNode(nodeId);
            ReviewCycleCell cell = cycleContext.getCellById(node.getReviewCycleCellId());
            boolean isEndCell = cell.getIsEndCell() != null && cell.getIsEndCell() != false;
            boolean hasNodePositions = cycleContext.hasNodePositionReleased(nodeInstanceReleased.getId());
            boolean skipNode = false;
            if (node.getSkippingRule() != null && !node.getSkippingRule().isEmpty() && ReviewCycleHelper.verifyReviewCycleNodeSkippingRuleForProject(node, project)) {
                skipNode = true;
            }
            if (!skipNode && (hasNodePositions || isEndNode && !isEndCell)) {
                totalDuration.addDuration(nodeInstanceReleased.getDuration());
                totalDuration.addDurationMin(nodeInstanceReleased.getDurationMin());
            }
            nodeInstanceReleased = ReviewCycleHelper.getNextInstance(cycleContext, cellInstanceReleased, nodeInstanceReleased);
        }
        ReviewCycleCellConnection connection = null;
        if (cellInstanceReleased != null && cellInstanceReleased.getId() != null) {
            Long cellId = cellInstanceReleased.getReviewCycleCellId();
            List<ReviewCycleCellConnection> leavingConnections = cycleContext.getLeavingConnectionsForCell(cellId);
            for (ReviewCycleCellConnection leavingConnection : leavingConnections) {
                if (leavingConnection.getIsDefaultConnection() == null || !leavingConnection.getIsDefaultConnection().booleanValue()) continue;
                connection = leavingConnection;
                break;
            }
        }
        if (connection != null) {
            ReviewCycleNodeInstanceReleased nextFirstNodeInstanceReleased;
            Long instanceReleasedId = cellInstanceReleased.getReviewCycleInstanceId();
            Long destinationCellId = connection.getDestinationCellId();
            ReviewCycleCellInstanceReleased nextCellInstanceReleased = null;
            if (instanceReleasedId != null && destinationCellId != null) {
                for (ReviewCycleCellInstanceReleased candidate : cycleContext.getAllCellInstancesReleased()) {
                    if (candidate.getReviewCycleInstanceId() == null || candidate.getReviewCycleInstanceId().longValue() != instanceReleasedId.longValue() || candidate.getReviewCycleCellId() == null || candidate.getReviewCycleCellId().longValue() != destinationCellId.longValue()) continue;
                    nextCellInstanceReleased = candidate;
                    break;
                }
            }
            if (nextCellInstanceReleased != null && (nextFirstNodeInstanceReleased = ReviewCycleHelper.getFirstInstance(cycleContext, nextCellInstanceReleased)) != null) {
                DurationInfo recursiveDuration = this.recursiveCalculateDurations(cycleContext, nextFirstNodeInstanceReleased, projectId);
                totalDuration.addDurationInfo(recursiveDuration);
            }
        }
        return totalDuration;
    }

    public DurationInfo recursiveCalculateInstanceDurations(InstanceDurationCalcContext cycleContext, ReviewCycleNodeInstance firstNodeInstance, Long projectId) {
        DurationInfo totalDuration = new DurationInfo();
        Long cellInstanceId = firstNodeInstance.getReviewCycleCellInstanceId();
        ReviewCycleCellInstance cellInstance = cycleContext.getCellInstanceById(cellInstanceId);
        Project project = (Project)this.projectDAO.get(projectId);
        ReviewCycleNodeInstance nodeInstance = firstNodeInstance;
        while (nodeInstance != null) {
            Long nodeId = nodeInstance.getReviewCycleNodeId();
            ReviewCycleNode node = cycleContext.getNodeById(nodeId);
            if (log.isDebugEnabled()) {
                log.debug("node = [" + node + "]; cycleContext = [" + cycleContext + "]");
            }
            boolean isEndNode = cycleContext.isEndNode(nodeId);
            ReviewCycleCell cell = cycleContext.getCellById(node.getReviewCycleCellId());
            boolean isEndCell = cell.getIsEndCell() != null && cell.getIsEndCell() != false;
            boolean hasNodePositions = cycleContext.hasNodePosition(nodeInstance.getId());
            boolean skipNode = false;
            if (node.getSkippingRule() != null && !node.getSkippingRule().isEmpty() && ReviewCycleHelper.verifyReviewCycleNodeSkippingRuleForProject(node, project)) {
                skipNode = true;
            }
            if (!skipNode && (hasNodePositions || isEndNode && !isEndCell)) {
                totalDuration.addDuration(nodeInstance.getDuration());
                totalDuration.addDurationMin(nodeInstance.getDurationMin());
            }
            nodeInstance = ReviewCycleHelper.getNextInstance(cycleContext, cellInstance, nodeInstance);
        }
        Long cellId = cellInstance.getReviewCycleCellId();
        ReviewCycleCellConnection connection = null;
        List<ReviewCycleCellConnection> leavingConnections = cycleContext.getLeavingConnectionsForCell(cellId);
        for (ReviewCycleCellConnection leavingConnection : leavingConnections) {
            if (leavingConnection.getIsDefaultConnection() == null || !leavingConnection.getIsDefaultConnection().booleanValue()) continue;
            connection = leavingConnection;
            break;
        }
        if (connection != null) {
            ReviewCycleNodeInstance nextFirstNodeInstance;
            Long instanceId = cellInstance.getReviewCycleInstanceId();
            Long destinationCellId = connection.getDestinationCellId();
            ReviewCycleCellInstance nextCellInstance = null;
            if (instanceId != null && destinationCellId != null) {
                for (ReviewCycleCellInstance candidate : cycleContext.getAllCellInstances()) {
                    if (candidate.getReviewCycleInstanceId() == null || candidate.getReviewCycleInstanceId().longValue() != instanceId.longValue() || candidate.getReviewCycleCellId() == null || candidate.getReviewCycleCellId().longValue() != destinationCellId.longValue()) continue;
                    nextCellInstance = candidate;
                    break;
                }
            }
            if (nextCellInstance != null && (nextFirstNodeInstance = ReviewCycleHelper.getFirstInstance(cycleContext, nextCellInstance)) != null) {
                DurationInfo recursiveDuration = this.recursiveCalculateInstanceDurations(cycleContext, nextFirstNodeInstance, projectId);
                totalDuration.addDurationInfo(recursiveDuration);
            }
        }
        return totalDuration;
    }
}

