/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.obj;

import at.cdes.api.dto.ObjectList;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.ObjectListReleaseJoin;
import at.cdes.api.obj.dto.ObjectInfo;
import at.cdes.api.obj.dto.ObjectPlannerInfo;
import at.cdes.api.obj.dto.ObjectPlannerPositionInfo;
import at.cdes.api.obj.voc.ObjectListChangedState;
import at.cdes.impl.export.obj.ObjectListChangedStyles;
import at.cdes.impl.export.obj.ObjectListCols;
import at.cdes.impl.export.planning.CompareHelper;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.odf.OdfHelper;
import at.cdes.impl.util.odf.RowPos;
import java.text.Collator;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.odf.util.text.TextFactory;
import org.clazzes.util.aop.ThreadLocalManager;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.w3c.dom.Node;

public class ObjectListExportHelper {
    public static String getReleasedVersionLabel(ObjectListReleaseJoin objectListReleaseJoin, ResourceBundle resourceBundle) {
        Integer versionInt = objectListReleaseJoin.getObjectListReleaseVersion();
        String versionString = versionInt != null ? versionInt.toString() : "";
        Double signatureTime = objectListReleaseJoin.getSignatureTime();
        String signatureString = DateHelper.formatUtcSeconds(signatureTime, "Europe/Vienna", resourceBundle.getString("yearToSecondFormat"));
        String personGivenName = objectListReleaseJoin.getSignerPersonGivenName();
        String personSurName = objectListReleaseJoin.getSignerPersonSurName();
        String versionLabel = MessageFormat.format(resourceBundle.getString("objectListPdfVersionLabel"), versionString, signatureString, personSurName, personGivenName);
        return versionLabel;
    }

    public static String getUnreleasedVersionLabel(ObjectList objectList, ResourceBundle resourceBundle) {
        Integer versionInt = objectList.getVersion();
        String versionString = versionInt != null ? versionInt.toString() : "";
        String versionLabel = MessageFormat.format(resourceBundle.getString("objectListPdfVersionLabelUnreleased"), versionString);
        return versionLabel;
    }

    public static String getProjectKmString(ContextJoin contextJoin) {
        Double stretchKmFrom = contextJoin.getProjectStretchKmFrom();
        Double stretchKmTo = contextJoin.getProjectStretchKmTo();
        DecimalFormat kmFormat = (DecimalFormat)NumberFormat.getNumberInstance(Locale.GERMAN);
        kmFormat.applyPattern("###,##0.000");
        String kmFromString = kmFormat.format(stretchKmFrom);
        String kmToString = kmFormat.format(stretchKmTo);
        String kmString = kmFromString + " - " + kmToString;
        return kmString;
    }

    public static List<RowPos<ObjectInfo>> constructRowPosList(List<ObjectInfo> infos) {
        ArrayList<RowPos<ObjectInfo>> rowPosList = new ArrayList<RowPos<ObjectInfo>>();
        for (ObjectInfo info : infos) {
            List plannerInfos = info.getObjectPlannerInfos();
            if (plannerInfos == null || plannerInfos.size() == 0) {
                rowPosList.add(new RowPos<ObjectInfo>(info, 0, plannerInfos.size()));
                continue;
            }
            for (int n = 0; n < plannerInfos.size(); ++n) {
                rowPosList.add(new RowPos<ObjectInfo>(info, n, plannerInfos.size()));
            }
        }
        return rowPosList;
    }

    public static int compareKms(ObjectInfo infoOne, ObjectInfo infoTwo) {
        double kmToTwo;
        double kmFromTwo;
        double kmFromOne = infoOne.getStretchKmFrom() != null ? infoOne.getStretchKmFrom() : 0.0;
        double d = kmFromTwo = infoTwo.getStretchKmFrom() != null ? infoTwo.getStretchKmFrom() : 0.0;
        if (kmFromOne < kmFromTwo) {
            return -1;
        }
        if (kmFromOne > kmFromTwo) {
            return 1;
        }
        double kmToOne = infoOne.getStretchKmTo() != null ? infoOne.getStretchKmTo() : 0.0;
        double d2 = kmToTwo = infoTwo.getStretchKmTo() != null ? infoTwo.getStretchKmTo() : 0.0;
        if (kmToOne < kmToTwo) {
            return -1;
        }
        if (kmToOne > kmToTwo) {
            return 1;
        }
        return 0;
    }

    public static List<FancyOdfTableColumn<RowPos<ObjectInfo>>> constructDataColumns(final ResourceBundle resourceBundle, final Collator collator, Styles contentAutomaticStyles, String standardParagraphStyle, final String dataCellStyle, final String dataTextStyle) {
        String dataNewTextStyle = OdfHelper.getDataTableDataTextStyle(contentAutomaticStyles, standardParagraphStyle, "#0000ff");
        String dataModifiedInstanceTextStyle = OdfHelper.getDataTableDataTextStyle(contentAutomaticStyles, standardParagraphStyle, "#ff0000");
        String dataModifiedGeneralTextStyle = OdfHelper.getDataTableDataTextStyle(contentAutomaticStyles, standardParagraphStyle, "#00ff00");
        final ObjectListChangedStyles changedStyles = new ObjectListChangedStyles(dataTextStyle, dataNewTextStyle, dataModifiedInstanceTextStyle, dataModifiedGeneralTextStyle);
        ArrayList<FancyOdfTableColumn<RowPos<ObjectInfo>>> columns = new ArrayList<FancyOdfTableColumn<RowPos<ObjectInfo>>>();
        columns.add(new FancyOdfTableColumn<RowPos<ObjectInfo>>(ObjectListCols.CODE.getValue(), resourceBundle.getString("objectListPdfCodeNameCaption")){

            public void appendCell(TableTableRowElement rowElement, RowPos<ObjectInfo> rowPos) {
                if (rowPos.idx == 0) {
                    String text = this.getText(rowPos);
                    TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                    cellElement.setTableNumberRowsSpannedAttribute(Integer.valueOf(rowPos.count));
                    ObjectListChangedState changedState = ((ObjectInfo)rowPos.info).getChangedState();
                    String textStyle = changedStyles.getChangedStyle(changedState);
                    TextFactory.constructTextNode((Node)cellElement, (String)text, (String)textStyle);
                } else {
                    OdfHelper.appendCoveredTableCell(rowElement);
                }
            }

            public int compare(RowPos<ObjectInfo> rowPosOne, RowPos<ObjectInfo> rowPosTwo, boolean descending) {
                Long idOne = ((ObjectInfo)rowPosOne.info).getId();
                Long idTwo = ((ObjectInfo)rowPosTwo.info).getId();
                if (idOne.longValue() == idTwo.longValue()) {
                    return rowPosOne.idx - rowPosTwo.idx;
                }
                String textOne = this.getText(rowPosOne);
                String textTwo = this.getText(rowPosTwo);
                return CompareHelper.defaultStringCompare(collator, textOne, textTwo, descending);
            }

            private String getText(RowPos<ObjectInfo> rowPos) {
                ObjectInfo objectInfo = (ObjectInfo)rowPos.info;
                String code = objectInfo.getCode() != null ? objectInfo.getCode() : "";
                String type = objectInfo.getObjectTypeCode() != null ? objectInfo.getObjectTypeCode() : "";
                String name = objectInfo.getName() != null ? objectInfo.getName() : "";
                return "(" + code + type + ") " + name;
            }
        });
        columns.add(new FancyOdfTableColumn<RowPos<ObjectInfo>>(ObjectListCols.KM.getValue(), resourceBundle.getString("objectListPdfKmCaption")){

            public void appendCell(TableTableRowElement rowElement, RowPos<ObjectInfo> rowPos) {
                if (rowPos.idx == 0) {
                    String text = this.getText(rowPos);
                    TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                    cellElement.setTableNumberRowsSpannedAttribute(Integer.valueOf(rowPos.count));
                    ObjectListChangedState changedState = ((ObjectInfo)rowPos.info).getChangedState();
                    String textStyle = changedStyles.getChangedStyle(changedState);
                    TextFactory.constructTextNode((Node)cellElement, (String)text, (String)textStyle);
                } else {
                    OdfHelper.appendCoveredTableCell(rowElement);
                }
            }

            public int compare(RowPos<ObjectInfo> rowPosOne, RowPos<ObjectInfo> rowPosTwo, boolean descending) {
                Long idOne = ((ObjectInfo)rowPosOne.info).getId();
                Long idTwo = ((ObjectInfo)rowPosTwo.info).getId();
                if (idOne.longValue() == idTwo.longValue()) {
                    return rowPosOne.idx - rowPosTwo.idx;
                }
                return (descending ? -1 : 1) * ObjectListExportHelper.compareKms((ObjectInfo)rowPosOne.info, (ObjectInfo)rowPosTwo.info);
            }

            private String getText(RowPos<ObjectInfo> rowPos) {
                ObjectInfo objectInfo = (ObjectInfo)rowPos.info;
                Double stretchKmFrom = objectInfo.getStretchKmFrom();
                Double stretchKmTo = objectInfo.getStretchKmTo();
                DecimalFormat kmFormat = (DecimalFormat)NumberFormat.getNumberInstance(Locale.GERMAN);
                kmFormat.applyPattern("###,##0.000");
                String kmFromString = kmFormat.format(stretchKmFrom);
                String kmToString = kmFormat.format(stretchKmTo);
                String kmString = kmFromString + " - " + kmToString;
                return kmString;
            }
        });
        columns.add(new FancyOdfTableColumn<RowPos<ObjectInfo>>(ObjectListCols.OBJECT_PLANNER.getValue(), resourceBundle.getString("objectListPdfObjectPlannerCaption")){

            public void appendCell(TableTableRowElement rowElement, RowPos<ObjectInfo> rowPos) {
                String text = this.getText(rowPos);
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                ObjectPlannerInfo objectPlannerInfo = this.getObjectPlannerInfo(rowPos);
                if (objectPlannerInfo != null) {
                    ObjectListChangedState changedState = objectPlannerInfo.getChangedState();
                    String textStyle = changedStyles.getChangedStyle(changedState);
                    TextFactory.constructTextNode((Node)cellElement, (String)text, (String)textStyle);
                }
            }

            public int compare(RowPos<ObjectInfo> rowPosOne, RowPos<ObjectInfo> rowPosTwo, boolean descending) {
                String textOne = this.getText(rowPosOne);
                String textTwo = this.getText(rowPosTwo);
                return collator.compare(textOne, textTwo);
            }

            private ObjectPlannerInfo getObjectPlannerInfo(RowPos<ObjectInfo> rowPos) {
                if (rowPos.count == 0) {
                    return null;
                }
                ObjectInfo objectInfo = (ObjectInfo)rowPos.info;
                List objectPlannerInfos = objectInfo.getObjectPlannerInfos();
                ObjectPlannerInfo objectPlannerInfo = objectPlannerInfos != null ? (ObjectPlannerInfo)objectPlannerInfos.get(rowPos.idx) : null;
                return objectPlannerInfo;
            }

            private String getText(RowPos<ObjectInfo> rowPos) {
                ObjectPlannerInfo objectPlannerInfo = this.getObjectPlannerInfo(rowPos);
                if (objectPlannerInfo != null) {
                    String code = objectPlannerInfo.getCode() != null ? objectPlannerInfo.getCode() : "";
                    String area = objectPlannerInfo.getArea() != null ? objectPlannerInfo.getArea() : "";
                    return "(" + code + ") " + area;
                }
                return "";
            }
        });
        columns.add(new FancyOdfTableColumn<RowPos<ObjectInfo>>(ObjectListCols.REVIEW_CYCLE_INSTANCE.getValue(), resourceBundle.getString("objectListPdfReviewCycleInstanceCaption")){

            public void appendCell(TableTableRowElement rowElement, RowPos<ObjectInfo> rowPos) {
                String text = this.getText(rowPos);
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                ObjectPlannerInfo objectPlannerInfo = this.getObjectPlannerInfo(rowPos);
                if (objectPlannerInfo != null) {
                    ObjectListChangedState changedState = objectPlannerInfo.getChangedState();
                    String textStyle = changedStyles.getChangedStyle(changedState);
                    TextFactory.constructTextNode((Node)cellElement, (String)text, (String)textStyle);
                }
            }

            public int compare(RowPos<ObjectInfo> rowPosOne, RowPos<ObjectInfo> rowPosTwo, boolean descending) {
                String textOne = this.getText(rowPosOne);
                String textTwo = this.getText(rowPosTwo);
                return collator.compare(textOne, textTwo);
            }

            private ObjectPlannerInfo getObjectPlannerInfo(RowPos<ObjectInfo> rowPos) {
                if (rowPos.count == 0) {
                    return null;
                }
                ObjectInfo objectInfo = (ObjectInfo)rowPos.info;
                List objectPlannerInfos = objectInfo.getObjectPlannerInfos();
                ObjectPlannerInfo objectPlannerInfo = objectPlannerInfos != null ? (ObjectPlannerInfo)objectPlannerInfos.get(rowPos.idx) : null;
                return objectPlannerInfo;
            }

            private String getText(RowPos<ObjectInfo> rowPos) {
                ObjectPlannerInfo objectPlannerInfo = this.getObjectPlannerInfo(rowPos);
                if (objectPlannerInfo != null) {
                    return objectPlannerInfo.getReviewCycleInstanceName() != null ? objectPlannerInfo.getReviewCycleInstanceName() : "";
                }
                return "";
            }
        });
        columns.add(new FancyOdfTableColumn<RowPos<ObjectInfo>>(ObjectListCols.POSITION.getValue(), resourceBundle.getString("objectListPdfPlannerPositionCaption")){

            public void appendCell(TableTableRowElement rowElement, RowPos<ObjectInfo> rowPos) {
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                ObjectPlannerInfo objectPlannerInfo = this.getObjectPlannerInfo(rowPos);
                if (objectPlannerInfo == null) {
                    return;
                }
                ObjectListChangedState changedState = objectPlannerInfo.getChangedState();
                String textStyle = changedStyles.getChangedStyle(changedState);
                if (objectPlannerInfo != null) {
                    String participationComment = objectPlannerInfo.getPlannerParticipationComment();
                    String organisationName = objectPlannerInfo.getPlannerOrganisationName();
                    String givenName = objectPlannerInfo.getPlannerPersonGivenName();
                    String surName = objectPlannerInfo.getPlannerPersonSurName();
                    String plannerString = MessageFormat.format(resourceBundle.getString("objectListPdfPlannerLabel"), organisationName, surName, givenName);
                    if (participationComment != null && participationComment.length() > 0) {
                        plannerString = plannerString + " - " + participationComment;
                    }
                    TextFactory.constructTextNode((Node)cellElement, (String)plannerString, (String)textStyle);
                    final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    List positionInfos = objectPlannerInfo.getPositionInfos();
                    Collections.sort(positionInfos, new Comparator<ObjectPlannerPositionInfo>(){

                        @Override
                        public int compare(ObjectPlannerPositionInfo positionInfoOne, ObjectPlannerPositionInfo positionInfoTwo) {
                            String nameOne = positionInfoOne.getPositionDefinitionName() != null ? positionInfoOne.getPositionDefinitionName() : "";
                            String nameTwo = positionInfoTwo.getPositionDefinitionName() != null ? positionInfoTwo.getPositionDefinitionName() : "";
                            return collator.compare(nameOne, nameTwo);
                        }
                    });
                    for (ObjectPlannerPositionInfo positionInfo : positionInfos) {
                        String positionDefinitionName = positionInfo.getPositionDefinitionName() != null ? positionInfo.getPositionDefinitionName() : "";
                        String organisation = positionInfo.getMainOrganisationName() != null ? positionInfo.getMainOrganisationName() : "";
                        String currGivenName = positionInfo.getMainPersonGivenName() != null ? positionInfo.getMainPersonGivenName() : "";
                        String currSurName = positionInfo.getMainPersonSurName() != null ? positionInfo.getMainPersonSurName() : "";
                        participationComment = positionInfo.getProjectParticipationComment();
                        String positionLabel = positionDefinitionName + " - " + organisation + " (" + currSurName + " " + currGivenName + ")";
                        if (participationComment != null && participationComment.length() > 0) {
                            positionLabel = positionLabel + " - " + participationComment;
                        }
                        TextFactory.constructTextNode((Node)cellElement, (String)positionLabel, (String)textStyle);
                    }
                } else {
                    TextFactory.constructTextNode((Node)cellElement, (String)"", (String)textStyle);
                }
            }

            private ObjectPlannerInfo getObjectPlannerInfo(RowPos<ObjectInfo> rowPos) {
                if (rowPos.count == 0) {
                    return null;
                }
                ObjectInfo objectInfo = (ObjectInfo)rowPos.info;
                List objectPlannerInfos = objectInfo.getObjectPlannerInfos();
                ObjectPlannerInfo objectPlannerInfo = objectPlannerInfos != null && rowPos.idx < objectPlannerInfos.size() ? (ObjectPlannerInfo)objectPlannerInfos.get(rowPos.idx) : null;
                return objectPlannerInfo;
            }

            public int compare(RowPos<ObjectInfo> rowPosOne, RowPos<ObjectInfo> rowPosTwo, boolean descending) {
                return 0;
            }
        });
        return columns;
    }
}

