/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Object;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.ObjectJoin;
import at.cdes.api.joinDto.ObjectShowInstanceJoin;
import at.cdes.api.joinDto.ObjectShowJoin;
import at.cdes.api.obj.dto.ObjectSearchModel;
import at.cdes.impl.dao.ObjectDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcObjectDAO;
import at.cdes.impl.dao.jdbc.JdbcNetworkDAO;
import at.cdes.impl.dao.unionComponent.ObjectReleaseComponent;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.SearchHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcObjectDAO
extends AbstractJdbcObjectDAO
implements ObjectDAO {
    private static final Logger log = LoggerFactory.getLogger(JdbcObjectDAO.class);
    private static final String OBJECT_SHOW_BASE_CLAUSE = "JOIN signature                   ON object_list_release.signature_id = signature.id JOIN sub_project                 ON object_list.sub_project_id = sub_project.id JOIN project                     ON sub_project.project_id = project.id LEFT JOIN object_type                 ON object_release.object_type_id = object_type.id LEFT JOIN project_participation planner_participation ON object_planner_release.planner_id = planner_participation.id LEFT JOIN organisation planner_organisation ON planner_participation.organisation_id = planner_organisation.id LEFT JOIN project_participant planner_main_participant ON planner_main_participant.participation_id = planner_participation.id AND planner_main_participant.main_participant_flag = 1 AND planner_main_participant.inactive_flag = 0 LEFT JOIN organisation_person planner_main_organisation_person ON planner_main_participant.organisation_person_id = planner_main_organisation_person.id LEFT JOIN person planner_main_person  ON planner_main_organisation_person.person_id = planner_main_person.id LEFT JOIN review_cycle_instance_released planner_instance_released ON object_planner_release.review_cycle_instance_id = planner_instance_released.id LEFT JOIN review_cycle planner_instance_cycle ON planner_instance_released.review_cycle_id = planner_instance_cycle.id LEFT JOIN label planner_instance_label ON planner_instance_released.label_id = planner_instance_label.id LEFT JOIN object_planner_position_release planner_position_release ON planner_position_release.object_planner_id = object_planner_release.id LEFT JOIN object_planner_position_definition planner_position_definition ON planner_position_release.definition_id = planner_position_definition.id LEFT JOIN project_participation planner_position_participation ON planner_position_release.project_participation_id = planner_position_participation.id LEFT JOIN organisation planner_position_organisation ON planner_position_participation.organisation_id = planner_position_organisation.id LEFT JOIN project_participant planner_position_participant ON     planner_position_participant.participation_id = planner_position_participation.id AND planner_position_participant.main_participant_flag = 1 AND planner_position_participant.inactive_flag = 0 LEFT JOIN organisation_person planner_position_organisation_person ON planner_position_participant.organisation_person_id = planner_position_organisation_person.id LEFT JOIN person planner_position_main_person ON planner_position_organisation_person.person_id = planner_position_main_person.id ";
    private static final String[] BASE_OBJECT_SHOW_COMPONENTS = new String[]{"object", "objectRelease", "objectType", "objectListRelease", "signature", "subProject", "project", "objectPlannerRelease", "plannerParticipation", "plannerOrganisation", "plannerMainPerson", "plannerPositionRelease", "plannerPositionDefinition", "plannerPositionParticipation", "plannerPositionOrganisation", "plannerPositionMainPerson", "plannerInstanceReleased", "plannerInstanceCycle", "plannerInstanceLabel"};

    @Override
    public ContextJoin getObjectContextJoin(final Long objectId) {
        String sql = "SELECT " + JdbcNetworkDAO.getContextJoinSelectClause() + "FROM ((((((((      object JOIN object_list                       ON object.object_list_id = object_list.id) JOIN sub_project                       ON object_list.sub_project_id = sub_project.id) JOIN sub_project_type                  ON sub_project.sub_project_type_id = sub_project_type.id) JOIN project                           ON sub_project.project_id = project.id) JOIN network                           ON project.network_id = network.id) LEFT JOIN localisation project_localisation ON project.localisation_id = project_localisation.id) LEFT JOIN countries project_country         ON project_localisation.country_id = project_country.id) LEFT JOIN object_planner                    ON 1=0) WHERE object.id = ? ";
        return (ContextJoin)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<ContextJoin>(){

            public ContextJoin perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectId);
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    ContextJoin contextJoin = JdbcNetworkDAO.fillContextJoinFromResultSet(rs);
                    return contextJoin;
                }
                return null;
            }
        });
    }

    @Override
    public List<Object> getBySubProject(Long subProjectId) {
        String sql = "SELECT " + JdbcObjectDAO.getSelectClauseForDto() + "FROM object_list JOIN object         ON object.object_list_id = object_list.id WHERE object_list.sub_project_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)subProjectId));
    }

    @Override
    public List<Object> getByProject(Long projectId) {
        String sql = "SELECT " + JdbcObjectDAO.getSelectClauseForDto() + "FROM sub_project JOIN object_list    ON object_list.sub_project_id = sub_project.id JOIN object         ON object.object_list_id = object_list.id WHERE sub_project.project_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)projectId));
    }

    private String[] getObjectShowComponents(String ... components) {
        int n;
        ArrayList<String> result = new ArrayList<String>();
        for (n = 0; n < BASE_OBJECT_SHOW_COMPONENTS.length; ++n) {
            result.add(BASE_OBJECT_SHOW_COMPONENTS[n]);
        }
        for (n = 0; n < components.length; ++n) {
            result.add(components[n]);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public List<ObjectShowJoin> getObjectShowJoins(Long objectId, Integer version) {
        String sql = "SELECT " + this.getSelectClauseForObjectShowJoinUnion(BASE_OBJECT_SHOW_COMPONENTS) + " FROM object JOIN object_list                 ON object.object_list_id = object_list.id JOIN object_list_release         ON object_list_release.object_list_id = object_list.id JOIN object_release              ON object_release.object_list_release_id = object_list_release.id AND object_release.object_id = object.id LEFT JOIN object_planner_release      ON object_planner_release.object_id = object_release.id " + OBJECT_SHOW_BASE_CLAUSE + "WHERE object.id = ? AND object_list_release.version = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcObjectDAO::fillObjectShowJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectId);
            JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)version);
        });
    }

    @Override
    public List<ObjectShowJoin> getObjectShowJoinsByDocumentVersion(Long documentVersionId) {
        String[] components = this.getObjectShowComponents("documentVersion", "documentRelease", "document");
        String sql = "SELECT " + this.getSelectClauseForObjectShowJoinUnion(components) + " FROM document_version JOIN document                    ON document_version.document_id = document.id JOIN object_planner              ON document.object_planner_id = object_planner.id JOIN object                      ON object_planner.object_id = object.id JOIN object_list                 ON object.object_list_id = object_list.id JOIN object_list_release         ON object_list_release.object_list_id = object_list.id AND object_list_release.version = object_list.version - 1 JOIN object_release              ON object_release.object_list_release_id = object_list_release.id AND object_release.object_id = object.id LEFT JOIN object_planner_release     ON object_planner_release.object_id = object_release.id AND object_planner_release.object_planner_id = object_planner.id " + OBJECT_SHOW_BASE_CLAUSE + "JOIN document_list               ON document.document_list_id = document_list.id LEFT JOIN document_list_release       ON document_list_release.document_list_id = document_list.id AND document_list_release.version = document_list.version - 1 LEFT JOIN document_release            ON document_release.document_id = document.id AND document_release.document_list_id = document_list_release.id WHERE document_version.id = ?";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcObjectDAO::fillObjectShowJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
        });
    }

    @Override
    public List<ObjectShowJoin> getObjectShowJoinsByDocument(Long documentId) {
        String[] components = this.getObjectShowComponents("document", "documentRelease");
        String sql = "SELECT " + this.getSelectClauseForObjectShowJoinUnion(components) + " FROM document JOIN object_planner              ON document.object_planner_id = object_planner.id JOIN object                      ON object_planner.object_id = object.id JOIN object_list                 ON object.object_list_id = object_list.id JOIN object_list_release         ON object_list_release.object_list_id = object_list.id AND object_list_release.version = object_list.version - 1 JOIN object_release              ON object_release.object_list_release_id = object_list_release.id AND object_release.object_id = object.id LEFT JOIN object_planner_release      ON object_planner_release.object_id = object_release.id AND object_planner_release.object_planner_id = object_planner.id " + OBJECT_SHOW_BASE_CLAUSE + "JOIN document_list               ON document.document_list_id = document_list.id LEFT JOIN document_list_release       ON document_list_release.document_list_id = document_list.id AND document_list_release.version = document_list.version - 1 LEFT JOIN document_release            ON document_release.document_id = document.id AND document_release.document_list_id = document_list_release.id WHERE document.id = ?";
        log.info(sql);
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcObjectDAO::fillObjectShowJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentId);
        });
    }

    @Override
    public List<ObjectShowInstanceJoin> getObjectShowInstanceJoins(Long objectId, Integer version) {
        String sql = "SELECT " + JdbcObjectDAO.getObjectShowInstanceJoinSelectClause() + "FROM object JOIN object_list                         ON object.object_list_id = object_list.id JOIN object_list_release                 ON object_list_release.object_list_id = object_list.id JOIN object_release                      ON object_release.object_list_release_id = object_list_release.id AND object_release.object_id = object.id LEFT JOIN object_planner_release              ON object_planner_release.object_id = object_release.id LEFT JOIN review_cycle_instance_released      ON object_planner_release.review_cycle_instance_id = review_cycle_instance_released.id LEFT JOIN review_cycle_cell_instance_released ON review_cycle_cell_instance_released.review_cycle_instance_id = review_cycle_instance_released.id LEFT JOIN review_cycle_cell                   ON review_cycle_cell_instance_released.review_cycle_cell_id = review_cycle_cell.id LEFT JOIN review_cycle_node_instance_released ON review_cycle_node_instance_released.review_cycle_cell_instance_id = review_cycle_cell_instance_released.id LEFT JOIN review_cycle_node_instance          ON review_cycle_node_instance_released.review_cycle_node_instance_id = review_cycle_node_instance.id LEFT JOIN review_cycle_node                   ON review_cycle_node_instance_released.review_cycle_node_id = review_cycle_node.id LEFT JOIN review_cycle_node_listener ON review_cycle_node_listener.review_cycle_node_id = review_cycle_node.id LEFT JOIN review_cycle_node_instance_plott_order_listener ON review_cycle_node_instance_plott_order_listener.review_cycle_node_instance_id = review_cycle_node_instance.id AND review_cycle_node_instance_plott_order_listener.review_cycle_node_listener_id = review_cycle_node_listener.id LEFT JOIN plott_order_template plot_order_template ON review_cycle_node_instance_plott_order_listener.reference_id = plot_order_template.id LEFT JOIN review_cycle_node_instance_notification ON review_cycle_node_instance_notification.review_cycle_node_instance_id = review_cycle_node_instance.id AND review_cycle_node_instance_notification.review_cycle_node_listener_id = review_cycle_node_listener.id LEFT JOIN review_cycle_node_project_participations_notification ON review_cycle_node_project_participations_notification.notification_id = review_cycle_node_instance_notification.id LEFT JOIN project_participation               ON review_cycle_node_project_participations_notification.project_participation_id = project_participation.id LEFT JOIN cdes_role                           ON project_participation.role_id = cdes_role.id LEFT JOIN project_participant                 ON     project_participant.participation_id = project_participation.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag = 0 LEFT JOIN organisation_person                 ON project_participant.organisation_person_id = organisation_person.id LEFT JOIN organisation                        ON organisation_person.organisation_id = organisation.id LEFT JOIN person                              ON organisation_person.person_id = person.id LEFT JOIN review_cycle_position_type          ON review_cycle_node.review_cycle_position_type_id = review_cycle_position_type.id LEFT JOIN review_cycle_position_type end_position_type ON end_position_type.id = review_cycle_position_type.id AND NOT EXISTS (SELECT 1 FROM review_cycle_result_option WHERE review_cycle_result_option.review_cycle_position_type_id = end_position_type.id) WHERE object.id = ? AND object_list_release.version = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcObjectDAO::fillObjectShowInstanceJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectId);
            JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)version);
        });
    }

    @Override
    public List<ObjectJoin> getObjectJoins(ObjectSearchModel searchModel, final Long subProjectId) {
        final String obj = searchModel.getObj();
        final String objectPlanner = searchModel.getObjectPlanner();
        final String responsible = searchModel.getResponsible();
        String whereClause = "object_list.sub_project_id = ? AND object.inactive_flag = 0 ";
        if (SearchHelper.isStringFilled(obj)) {
            whereClause = whereClause + "AND CONCAT(object.code, COALESCE(object_type.code, ''), ' ', object.name) LIKE ? ";
        }
        if (SearchHelper.isStringFilled(objectPlanner)) {
            whereClause = whereClause + "AND EXISTS (SELECT 1 FROM object_planner local_object_planner WHERE local_object_planner.object_id = object.id AND local_object_planner.inactive = 0 AND CONCAT(local_object_planner.code, ' ', local_object_planner.area) LIKE ?) ";
        }
        if (SearchHelper.isStringFilled(responsible)) {
            whereClause = whereClause + "AND (    EXISTS (SELECT 1 FROM object_planner local_object_planner JOIN project_participation local_participation ON local_object_planner.planner_id = local_participation.id JOIN project_participant local_participant     ON     local_participant.participation_id = local_participation.id AND local_participant.main_participant_flag = 1 AND local_participant.inactive_flag = 0 JOIN organisation_person local_org_person      ON local_participant.organisation_person_id = local_org_person.id JOIN organisation local_organisation           ON local_org_person.organisation_id = local_organisation.id JOIN person local_person                       ON local_org_person.person_id = local_person.id WHERE local_object_planner.object_id = object.id AND local_object_planner.inactive = 0 AND CONCAT(local_organisation.name, ' (', local_person.surName, ' ', local_person.givenName, ')') LIKE ?) OR EXISTS (SELECT 1 FROM object_planner local_object_planner JOIN object_planner_position local_position    ON local_position.object_planner_id = local_object_planner.id JOIN project_participation local_participation ON local_position.project_participation_id = local_participation.id JOIN project_participant local_participant     ON     local_participant.participation_id = local_participation.id AND local_participant.main_participant_flag = 1 AND local_participant.inactive_flag = 0 JOIN organisation_person local_org_person      ON local_participant.organisation_person_id = local_org_person.id JOIN organisation local_organisation           ON local_org_person.organisation_id = local_organisation.id JOIN person local_person                       ON local_org_person.person_id = local_person.id WHERE local_object_planner.object_id = object.id AND local_object_planner.inactive = 0 AND CONCAT(local_organisation.name, ' (', local_person.surName, ' ', local_person.givenName, ')') LIKE ?)) ";
        }
        String sql = "SELECT " + this.getObjectUnionSelectClause(ObjectReleaseComponent.BASE, "objectList", "object", "objectType", "objectPlanner", "reviewCycleInstance", "projectParticipation", "organisationPerson", "organisation", "person", "objectPlannerRelease", "plannerHasVersions") + "FROM object_list JOIN object                         ON object.object_list_id = object_list.id LEFT JOIN object_type                    ON object.object_type_id = object_type.id LEFT JOIN object_planner                 ON      object_planner.object_id = object.id AND object_planner.inactive = 0 LEFT JOIN object_list_release            ON      object_list_release.sub_project_id = object_list.sub_project_id AND object_list_release.version = object_list.version - 1 LEFT JOIN object_release                 ON      object_release.object_list_release_id = object_list_release.id AND object_release.object_id = object.id LEFT JOIN object_planner_release         ON      object_planner_release.object_id = object_release.id AND object_planner_release.object_planner_id = object_planner.id LEFT JOIN object_planner planner_has_versions ON planner_has_versions.id = object_planner.id AND EXISTS (SELECT 1 FROM document JOIN document_version ON document_version.document_id = document.id WHERE document.object_planner_id = planner_has_versions.id) LEFT JOIN review_cycle_instance          ON object_planner.review_cycle_instance_id = review_cycle_instance.id LEFT JOIN project_participation          ON object_planner.planner_id = project_participation.id LEFT JOIN project_participant main_participant ON    main_participant.participation_id = project_participation.id AND main_participant.main_participant_flag = 1 AND main_participant.inactive_flag = 0 LEFT JOIN organisation_person            ON main_participant.organisation_person_id = organisation_person.id LEFT JOIN organisation                   ON organisation_person.organisation_id = organisation.id LEFT JOIN person                         ON organisation_person.person_id = person.id WHERE " + whereClause + "UNION ALL SELECT " + this.getObjectUnionSelectClause(ObjectReleaseComponent.CELL_INSTANCE, "object", "objectPlanner", "reviewCycleCellInstance") + "FROM object_list JOIN object                         ON object.object_list_id = object_list.id LEFT JOIN object_type                    ON object.object_type_id = object_type.id LEFT JOIN object_planner                 ON      object_planner.object_id = object.id AND object_planner.inactive = 0 LEFT JOIN review_cycle_instance          ON object_planner.review_cycle_instance_id = review_cycle_instance.id LEFT JOIN review_cycle_cell_instance     ON review_cycle_cell_instance.review_cycle_instance_id = review_cycle_instance.id WHERE " + whereClause + "UNION ALL SELECT " + this.getObjectUnionSelectClause(ObjectReleaseComponent.PLANNER_POSITION, "object", "objectPlanner", "objectPlannerPosition", "objectPlannerPositionDefinition", "projectParticipation", "organisationPerson", "organisation", "person") + "FROM object_list JOIN object                             ON object.object_list_id = object_list.id LEFT JOIN object_type                        ON object.object_type_id = object_type.id LEFT JOIN object_planner                     ON      object_planner.object_id = object.id AND object_planner.inactive = 0 LEFT JOIN object_planner_position            ON object_planner_position.object_planner_id = object_planner.id LEFT JOIN object_planner_position_definition ON object_planner_position.definition_id = object_planner_position_definition.id LEFT JOIN project_participation              ON object_planner_position.project_participation_id = project_participation.id LEFT JOIN project_participant main_participant ON    main_participant.participation_id = project_participation.id AND main_participant.main_participant_flag = 1 AND main_participant.inactive_flag = 0 LEFT JOIN organisation_person            ON main_participant.organisation_person_id = organisation_person.id LEFT JOIN organisation                   ON organisation_person.organisation_id = organisation.id LEFT JOIN person                         ON organisation_person.person_id = person.id WHERE " + whereClause;
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ObjectJoin>>(){

            public List<ObjectJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (int n = 0; n < 3; ++n) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                    if (SearchHelper.isStringFilled(obj)) {
                        statement.setString(currIndex++, SearchHelper.convertForSearch(obj));
                    }
                    if (SearchHelper.isStringFilled(objectPlanner)) {
                        statement.setString(currIndex++, SearchHelper.convertForSearch(objectPlanner));
                    }
                    if (!SearchHelper.isStringFilled(responsible)) continue;
                    statement.setString(currIndex++, SearchHelper.convertForSearch(responsible));
                    statement.setString(currIndex++, SearchHelper.convertForSearch(responsible));
                }
                ArrayList<ObjectJoin> results = new ArrayList<ObjectJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    ObjectJoin joinDto = AbstractJdbcObjectDAO.fillObjectJoinFromResultSet(rs);
                    int attributeCount = AbstractJdbcObjectDAO.getNumberOfObjectJoinAttributes() + 1;
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)attributeCount++));
                    results.add(joinDto);
                }
                return results;
            }
        });
    }

    private String getObjectUnionSelectClause(ObjectReleaseComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForObjectJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : "") + component.getValue() + " ";
    }
}

