/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.planDeliver;

import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentDateHistoryPart;
import at.cdes.api.dto.DocumentList;
import at.cdes.api.dto.DocumentTask;
import at.cdes.impl.dao.DocumentDAO;
import at.cdes.impl.dao.DocumentDateHistoryPartDAO;
import at.cdes.impl.dao.DocumentListDAO;
import at.cdes.impl.dao.DocumentTaskDAO;
import at.cdes.impl.task.TaskUtils;
import at.cdes.impl.util.QueryHelper;
import java.util.ArrayList;
import java.util.List;

public class PlanDeliverUtils {
    private DocumentDAO documentDAO;
    private DocumentDateHistoryPartDAO documentDateHistoryPartDAO;
    private DocumentListDAO documentListDAO;
    private DocumentTaskDAO documentTaskDAO;
    private TaskUtils taskUtils;

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    public void setDocumentDateHistoryPartDAO(DocumentDateHistoryPartDAO documentDateHistoryPartDAO) {
        this.documentDateHistoryPartDAO = documentDateHistoryPartDAO;
    }

    public void setDocumentListDAO(DocumentListDAO documentListDAO) {
        this.documentListDAO = documentListDAO;
    }

    public void setDocumentTaskDAO(DocumentTaskDAO documentTaskDAO) {
        this.documentTaskDAO = documentTaskDAO;
    }

    public void setTaskUtils(TaskUtils taskUtils) {
        this.taskUtils = taskUtils;
    }

    public void deleteNeverReleasedDocumentListBySubProjectId(Long subProjectId) {
        List<DocumentList> documentLists = this.documentListDAO.getBySubProject(subProjectId);
        List<Document> documents = this.documentDAO.getBySubProject(subProjectId);
        List<DocumentDateHistoryPart> documentDateHistoryParts = this.documentDateHistoryPartDAO.getBySubProject(subProjectId);
        List<DocumentTask> documentTasks = this.documentTaskDAO.getBySubProjectId(subProjectId);
        List<Long> documentListIds = QueryHelper.getPersistentIds(documentLists);
        List<Long> documentIds = QueryHelper.getPersistentIds(documents);
        List<Long> documentDateHistoryPartIds = QueryHelper.getPersistentIds(documentDateHistoryParts);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        for (DocumentTask documentTask : documentTasks) {
            taskIds.add(documentTask.getTaskId());
        }
        this.taskUtils.deleteReviewCycleEntryTasks(taskIds);
        if (documentDateHistoryPartIds.size() > 0) {
            this.documentDateHistoryPartDAO.deleteBatch(documentDateHistoryPartIds);
        }
        if (documentIds.size() > 0) {
            this.documentDAO.deleteBatch(documentIds);
        }
        if (documentListIds.size() > 0) {
            this.documentListDAO.deleteBatch(documentListIds);
        }
    }
}

