/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.ObjectPlanner;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.ObjectPlannerWithObject;
import at.cdes.impl.dao.NetworkDAO;
import at.cdes.impl.dao.ObjectPlannerDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcObjectPlannerDAO;
import at.cdes.impl.dao.jdbc.JdbcNetworkDAO;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.SearchHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcObjectPlannerDAO
extends AbstractJdbcObjectPlannerDAO
implements ObjectPlannerDAO {
    private static final Logger log = LoggerFactory.getLogger(JdbcObjectPlannerDAO.class);
    private NetworkDAO networkDAO;

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    @Override
    public List<ObjectPlannerWithObject> getObjectPlannersBySubProject(final Long subProjectId) {
        String sql = "SELECT " + JdbcObjectPlannerDAO.getObjectPlannerWithObjectSelectClause() + "FROM ((((((((( object_list  JOIN object_list_release                                  ON object_list_release.object_list_id = object_list.id AND object_list_release.version = object_list.version - 1) JOIN object_release                                       ON object_release.object_list_release_id = object_list_release.id) JOIN object                                               ON object_release.object_id = object.id) LEFT JOIN object_type                                          ON object.object_type_id = object_type.id) LEFT JOIN object_planner_release                               ON object_planner_release.object_id = object_release.id) LEFT JOIN object_planner                                       ON object_planner_release.object_planner_id = object_planner.id) LEFT JOIN review_cycle_instance_released review_cycle_instance ON object_planner_release.review_cycle_instance_id = review_cycle_instance.id) LEFT JOIN document                                             ON document.object_planner_id = object_planner.id AND (document.invalidated IS NULL OR document.invalidated = 0)) LEFT JOIN project_participation                                ON object_planner_release.planner_id = project_participation.id) WHERE object_list.sub_project_id = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ObjectPlannerWithObject>>(){

            public List<ObjectPlannerWithObject> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)subProjectId);
                ResultSet rs = statement.executeQuery();
                ArrayList<ObjectPlannerWithObject> ret = new ArrayList<ObjectPlannerWithObject>();
                while (rs.next()) {
                    ret.add(AbstractJdbcObjectPlannerDAO.fillObjectPlannerWithObjectFromResultSet(rs));
                }
                return ret;
            }
        });
    }

    @Override
    public ContextJoin getContextJoin(final Long objectPlannerId) {
        String sql = "SELECT " + this.networkDAO.getContextJoinUnionSelectClause("network", "project", "subProject", "object", "objectPlanner") + " FROM (((((( object_planner JOIN object             ON object_planner.object_id = object.id) JOIN object_list        ON object.object_list_id = object_list.id) JOIN sub_project        ON object_list.sub_project_id = sub_project.id) JOIN sub_project_type   ON sub_project.sub_project_type_id = sub_project_type.id) JOIN project            ON sub_project.project_id = project.id) JOIN network            ON project.network_id = network.id) WHERE object_planner.id = ? ";
        return (ContextJoin)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<ContextJoin>(){

            public ContextJoin perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectPlannerId);
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    ContextJoin contextJoin = JdbcNetworkDAO.fillContextJoinFromResultSet(rs);
                    return contextJoin;
                }
                return null;
            }
        });
    }

    @Override
    public List<ObjectPlanner> getByCodes(final String networkName, final String projectCode, final String subProjectCode, final String objectCode, final String objectPlannerCode) {
        String sql = "SELECT " + JdbcObjectPlannerDAO.getSelectClauseForDto() + "FROM ((((( object_planner JOIN object           ON object_planner.object_id = object.id) JOIN object_list      ON object.object_list_id = object_list.id) JOIN sub_project      ON object_list.sub_project_id = sub_project.id) JOIN project          ON sub_project.project_id = project.id) JOIN network          ON project.network_id = network.id) WHERE 1=1 ";
        if (SearchHelper.isStringFilled(networkName)) {
            sql = sql + "AND network.name = ? ";
        }
        if (SearchHelper.isStringFilled(projectCode)) {
            sql = sql + "AND project.code = ? ";
        }
        if (SearchHelper.isStringFilled(subProjectCode)) {
            sql = sql + "AND sub_project.code = ? ";
        }
        if (SearchHelper.isStringFilled(objectCode)) {
            sql = sql + "AND object.code = ? ";
        }
        if (SearchHelper.isStringFilled(objectPlannerCode)) {
            sql = sql + "AND object_planner.code = ? ";
        }
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ObjectPlanner>>(){

            public List<ObjectPlanner> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                if (SearchHelper.isStringFilled(networkName)) {
                    statement.setString(currIndex++, networkName);
                }
                if (SearchHelper.isStringFilled(projectCode)) {
                    statement.setString(currIndex++, projectCode);
                }
                if (SearchHelper.isStringFilled(subProjectCode)) {
                    statement.setString(currIndex++, subProjectCode);
                }
                if (SearchHelper.isStringFilled(objectCode)) {
                    statement.setString(currIndex++, objectCode);
                }
                if (SearchHelper.isStringFilled(objectPlannerCode)) {
                    statement.setString(currIndex++, objectPlannerCode);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<ObjectPlanner> ret = new ArrayList<ObjectPlanner>();
                while (rs.next()) {
                    ret.add(JdbcObjectPlannerDAO.this.fillDtoFromResultSet(rs));
                }
                return ret;
            }
        });
    }

    @Override
    public List<ObjectPlanner> getByProjectObjectAndObjectPlanner(final String projectCodeName, final String projectStatusCodeName, final String objectCode, final String objectPlannerCodeArea) {
        String sql = "SELECT " + JdbcObjectPlannerDAO.getSelectClauseForDto() + "FROM ((((((( object_planner_release JOIN object_planner             ON object_planner_release.object_planner_id = object_planner.id) JOIN object_release             ON object_planner_release.object_id = object_release.id) LEFT JOIN object_type           ON object_release.object_type_id = object_type.id) JOIN object_list_release        ON object_release.object_list_release_id = object_list_release.id) JOIN object_list                ON object_list_release.object_list_id = object_list.id) JOIN sub_project                ON object_list.sub_project_id = sub_project.id) JOIN project                    ON sub_project.project_id = project.id) WHERE object_list_release.version = object_list.version - 1 ";
        if (SearchHelper.isStringFilled(projectCodeName)) {
            sql = sql + "AND CONCAT(project.code, ' ', project.name) = ? ";
        }
        if (SearchHelper.isStringFilled(projectStatusCodeName)) {
            sql = sql + "AND CONCAT(sub_project.code, RTRIM(COALESCE(cast(sub_project.number as CHAR(10)), '')), ' ', sub_project.name) = ? ";
        }
        if (SearchHelper.isStringFilled(objectCode)) {
            sql = sql + "AND CONCAT(object_release.code, COALESCE(object_type.code,'')) = ? ";
        }
        if (SearchHelper.isStringFilled(objectPlannerCodeArea)) {
            sql = sql + "AND CONCAT(object_planner_release.code, ' ', object_planner_release.area) = ? ";
        }
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ObjectPlanner>>(){

            public List<ObjectPlanner> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                if (SearchHelper.isStringFilled(projectCodeName)) {
                    statement.setString(currIndex++, projectCodeName);
                }
                if (SearchHelper.isStringFilled(projectStatusCodeName)) {
                    statement.setString(currIndex++, projectStatusCodeName);
                }
                if (SearchHelper.isStringFilled(objectCode)) {
                    statement.setString(currIndex++, objectCode);
                }
                if (SearchHelper.isStringFilled(objectPlannerCodeArea)) {
                    statement.setString(currIndex++, objectPlannerCodeArea);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<ObjectPlanner> ret = new ArrayList<ObjectPlanner>();
                while (rs.next()) {
                    ret.add(JdbcObjectPlannerDAO.this.fillDtoFromResultSet(rs));
                }
                return ret;
            }
        });
    }

    @Override
    public List<ObjectPlanner> getByAttachment(final Long attachmentId) {
        String sql = "SELECT DISTINCT " + JdbcObjectPlannerDAO.getSelectClauseForDto() + "FROM (((( position_result_attachment_map JOIN review_cycle_position_result ON position_result_attachment_map.result_id = review_cycle_position_result.id) JOIN document_version             ON review_cycle_position_result.document_version_id = document_version.id) JOIN document                     ON document_version.document_id = document.id) JOIN object_planner               ON document.object_planner_id = object_planner.id) WHERE position_result_attachment_map.attachment_id = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ObjectPlanner>>(){

            public List<ObjectPlanner> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)attachmentId);
                ResultSet rs = statement.executeQuery();
                ArrayList<ObjectPlanner> ret = new ArrayList<ObjectPlanner>();
                while (rs.next()) {
                    ret.add(JdbcObjectPlannerDAO.this.fillDtoFromResultSet(rs));
                }
                return ret;
            }
        });
    }

    @Override
    public ObjectPlanner getByDocument(Long documentId) {
        String sql = "SELECT " + this.getSelectClauseForDto() + "\nFROM document\nJOIN object_planner ON object_planner.id = document.object_planner_id\nWHERE document.id = ?\n";
        return QueryHelper.getUniqueWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)documentId));
    }

    @Override
    public List<ObjectPlanner> getBySubProject(Long subProjectId) {
        String sql = "SELECT " + JdbcObjectPlannerDAO.getSelectClauseForDto() + "\nFROM object_list JOIN object         ON object.object_list_id = object_list.id JOIN object_planner ON object_planner.object_id = object.id WHERE object_list.sub_project_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)subProjectId));
    }

    @Override
    public List<ObjectPlanner> getByByAsBuiltReferenceAndSubProject(Long objectPlannerId, Long subProjectId) {
        String sql = "SELECT " + JdbcObjectPlannerDAO.getSelectClauseForDto() + "\nFROM object_list JOIN object         ON object.object_list_id = object_list.id JOIN object_planner ON object_planner.object_id = object.id WHERE object_list.sub_project_id = ? AND object_planner.as_built_reference = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)subProjectId);
            JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)objectPlannerId);
        });
    }

    @Override
    public List<ObjectPlanner> getByOriginalDocumentOrder(Long originalDocumentOrderId) {
        String sql = "SELECT " + JdbcObjectPlannerDAO.getSelectClauseForDto() + "\nFROM original_document_order JOIN original_document_order_item ON original_document_order_item.order_contract_id = original_document_order.id JOIN document_version             ON original_document_order_item.document_version_id = document_version.id JOIN document                     ON document_version.document_id = document.id JOIN object_planner               ON document.object_planner_id = object_planner.id WHERE original_document_order.id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)originalDocumentOrderId));
    }
}

