/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.PlanningNotificationOrder;
import at.cdes.api.dto.SiteType;
import at.cdes.api.dto.SiteTypeMap;
import at.cdes.impl.dao.SiteTypeMapDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcSiteTypeMapDAO
extends AbstrIdDAO<SiteTypeMap>
implements SiteTypeMapDAO {
    public JdbcSiteTypeMapDAO() {
        super(SiteTypeMap.class, "id", "site_type_map", new String[]{"id", "site_type_id", "planning_notification_order_id", "create_trx", "mut_trx", "mut_ts"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcSiteTypeMapDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "site_type_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "planning_notification_order_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "create_trx") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_trx") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_ts") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcSiteTypeMapDAO.getSelectClauseForDto("site_type_map", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcSiteTypeMapDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".site_type_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "site_type_id") + "," + entityLocalName + ".planning_notification_order_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "planning_notification_order_id") + "," + entityLocalName + ".create_trx" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "create_trx") + "," + entityLocalName + ".mut_trx" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_trx") + "," + entityLocalName + ".mut_ts" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "mut_ts") + " ";
    }

    protected SiteTypeMap fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        SiteTypeMap siteTypeMap = new SiteTypeMap();
        siteTypeMap.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        siteTypeMap.setSiteTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        siteTypeMap.setPlanningNotificationOrderId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        siteTypeMap.setCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        siteTypeMap.setMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        siteTypeMap.setMutTs(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return siteTypeMap;
    }

    public static SiteTypeMap fillSiteTypeMapFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        SiteTypeMap siteTypeMap = new SiteTypeMap();
        siteTypeMap.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        siteTypeMap.setSiteTypeId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        siteTypeMap.setPlanningNotificationOrderId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        siteTypeMap.setCreateTrx(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        siteTypeMap.setMutTrx(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        siteTypeMap.setMutTs(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return siteTypeMap;
    }

    public static SiteTypeMap fillSiteTypeMapFromResultSet(ResultSet rs) throws SQLException {
        return JdbcSiteTypeMapDAO.fillSiteTypeMapFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 6;
    }

    @Override
    public void deleteInstance(final Long siteTypeId, final Long planningNotificationOrderId) {
        String sql = "DELETE FROM site_type_map WHERE site_type_id = ? AND planning_notification_order_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, siteTypeId);
                statement.setLong(currIndex++, planningNotificationOrderId);
                statement.execute();
                return null;
            }
        });
    }

    @Override
    public void deleteByPlanningNotificationOrder(final Long planningNotificationOrderId) {
        String sql = "DELETE FROM site_type_map WHERE planning_notification_order_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, planningNotificationOrderId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(SiteTypeMap dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<SiteTypeMap> dtos) {
        Iterator<SiteTypeMap> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, SiteTypeMap siteTypeMap) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)siteTypeMap.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)siteTypeMap.getSiteTypeId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)siteTypeMap.getPlanningNotificationOrderId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)4, (Number)(siteTypeMap.getCreateTrx() != null ? siteTypeMap.getCreateTrx() : (Long)ThreadLocalManager.getBoundResource((String)"at.cdes.impl.db.trx::TrxId")));
        JDBCHelper.setLong((PreparedStatement)statement, (int)5, (Number)((Long)ThreadLocalManager.getBoundResource((String)"at.cdes.impl.db.trx::TrxId")));
        JDBCHelper.setLong((PreparedStatement)statement, (int)6, (Number)System.currentTimeMillis());
    }

    @Override
    public List<SiteTypeMap> getBySiteType(SiteType siteType) {
        return this.getBySiteType(siteType.getId());
    }

    @Override
    public List<SiteTypeMap> getBySiteType(final Long siteTypeId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"site_type_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, siteTypeId);
            }
        });
    }

    @Override
    public List<SiteTypeMap> getByPlanningNotificationOrder(PlanningNotificationOrder planningNotificationOrder) {
        return this.getByPlanningNotificationOrder(planningNotificationOrder.getWorkflowEntityId());
    }

    @Override
    public List<SiteTypeMap> getByPlanningNotificationOrder(final Long planningNotificationOrderId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"planning_notification_order_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, planningNotificationOrderId);
            }
        });
    }

    @Override
    public List<SiteTypeMap> getBySiteTypes(Collection<Long> siteTypeId) {
        if (siteTypeId.isEmpty()) {
            return new ArrayList<SiteTypeMap>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[siteTypeId.size()];
        int n = 0;
        Iterator<Long> it = siteTypeId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"site_type_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<SiteTypeMap> getByPlanningNotificationOrders(Collection<Long> planningNotificationOrderId) {
        if (planningNotificationOrderId.isEmpty()) {
            return new ArrayList<SiteTypeMap>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[planningNotificationOrderId.size()];
        int n = 0;
        Iterator<Long> it = planningNotificationOrderId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"planning_notification_order_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

