/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.archive;

import at.cdes.api.dto.Attachment;
import at.cdes.api.dto.DocumentReference;
import at.cdes.api.joinDto.DocumentArchiveJoin;
import at.cdes.api.joinDto.DocumentArchivePathJoin;
import at.cdes.api.voc.DocumentVersionStatus;
import java.io.File;
import java.util.ResourceBundle;

public class ArchiveHelper {
    public static final int PATH_RELATIVE_TO_REVIEW_PROTOCOLL = 0;
    public static final int PATH_RELATIVE_TO_INDEX_WITH_HISTORY = 1;
    public static final int PATH_RELATIVE_TO_INDEX_NO_HISTORY = 2;

    public static String getDocumentVersionFilename(DocumentArchivePathJoin archivePathJoin, String objectReleaseCode, String objectTypeCode, ResourceBundle resourceBundle, int initialPoint, boolean pdfPreview, boolean prettyNameLong) {
        Long documentVersionId = archivePathJoin.getDocumentVersionId();
        Integer status = archivePathJoin.getDocumentVersionStatus();
        String postfix = "";
        if (status != null && status.intValue() == DocumentVersionStatus.DELETED.getValue()) {
            postfix = "_" + resourceBundle.getString("archiveFileNameDeletedToken") + "_" + documentVersionId;
        }
        String filename = null;
        filename = archivePathJoin instanceof DocumentArchiveJoin && prettyNameLong ? archivePathJoin.getDocumentVersionName() + "_" + ((DocumentArchiveJoin)archivePathJoin).getDocumentContent() : archivePathJoin.getDocumentVersionName();
        filename = filename.replace("/", "_");
        String path = ArchiveHelper.getPathPrefix(initialPoint, archivePathJoin, objectReleaseCode, objectTypeCode, resourceBundle) + resourceBundle.getString("archiveFileDocumentsDirName") + File.separator + filename + postfix + (pdfPreview ? ".pdf" : "." + archivePathJoin.getDocumentVersionFiletype());
        return path;
    }

    public static String getDocumentReferenceFilename(DocumentReference documentReference, DocumentArchiveJoin archiveJoin, ResourceBundle resourceBundle, int initialPoint) {
        String attachmentFileType = documentReference.getAttachmentFiletype();
        String path = ArchiveHelper.getPathPrefix(initialPoint, (DocumentArchivePathJoin)archiveJoin, archiveJoin.getObjectReleaseCode(), archiveJoin.getObjectTypeCode(), resourceBundle) + resourceBundle.getString("archiveFileDocumentReferenceDirName") + File.separator + documentReference.getId() + (attachmentFileType != null ? "." + attachmentFileType : "");
        return path;
    }

    public static String getAttachmentFilename(DocumentArchivePathJoin archiveJoin, String objectReleaseCode, String objectTypeCode, ResourceBundle resourceBundle, int initialPoint, Attachment attachment) {
        String path = ArchiveHelper.getPathPrefix(initialPoint, archiveJoin, objectReleaseCode, objectTypeCode, resourceBundle) + resourceBundle.getString("archiveFileAttachmentDirName") + File.separator + attachment.getId() + (attachment.getFiletype() != null ? "." + attachment.getFiletype() : "");
        return path;
    }

    public static String getRedliningFilename(DocumentArchivePathJoin archiveJoin, String objectReleaseCode, String objectTypeCode, ResourceBundle resourceBundle, int initialPoint) {
        Integer status = archiveJoin.getDocumentVersionStatus();
        boolean deleted = status != null && status.intValue() == DocumentVersionStatus.DELETED.getValue();
        String path = ArchiveHelper.getPathPrefix(initialPoint, archiveJoin, objectReleaseCode, objectTypeCode, resourceBundle) + resourceBundle.getString("archiveFileRedliningDirName") + File.separator + archiveJoin.getDocumentVersionName() + (deleted ? "_" + archiveJoin.getDocumentVersionId() : "") + ".pdf";
        return path;
    }

    public static String getReviewProtocollFilename(DocumentArchiveJoin archiveJoin, ResourceBundle resourceBundle, int initialPoint) {
        String path = ArchiveHelper.getPathPrefix(initialPoint, (DocumentArchivePathJoin)archiveJoin, archiveJoin.getObjectReleaseCode(), archiveJoin.getObjectTypeCode(), resourceBundle) + resourceBundle.getString("archiveFileReviewProtocolDirName") + "_" + archiveJoin.getDocumentName() + ".pdf";
        return path;
    }

    private static String getBasePath(ResourceBundle resourceBundle) {
        return resourceBundle.getString("archiveFileBasePath") + File.separator;
    }

    public static String getHTMLRessourcePath(ResourceBundle resourceBundle, String fileName) {
        return ArchiveHelper.getBasePath(resourceBundle) + "ressources" + File.separator + fileName;
    }

    private static String getDocumentVersionBasePath(DocumentArchivePathJoin archivePathJoin, String objectReleaseCode, String objectTypeCode, ResourceBundle resourceBundle) {
        return ArchiveHelper.getBasePath(resourceBundle) + objectReleaseCode + (objectTypeCode != null ? objectTypeCode : "") + File.separator + archivePathJoin.getDocumentName() + File.separator;
    }

    private static String getPathPrefix(int initialPoint, DocumentArchivePathJoin archivePathJoin, String objectReleaseCode, String objectTypeCode, ResourceBundle resourceBundle) {
        switch (initialPoint) {
            case 2: {
                return "";
            }
            case 1: {
                return ArchiveHelper.getDocumentVersionBasePath(archivePathJoin, objectReleaseCode, objectTypeCode, resourceBundle);
            }
            case 0: {
                return "../";
            }
        }
        return null;
    }

    public static String getDocumentVersionDirectoryPath(DocumentArchivePathJoin archivePathJoin, String objectReleaseCode, String objectTypeCode, ResourceBundle resourceBundle, int initialPoint) {
        String path = ArchiveHelper.getPathPrefix(initialPoint, archivePathJoin, objectReleaseCode, objectTypeCode, resourceBundle) + resourceBundle.getString("archiveFileDocumentsDirName") + File.separator;
        return path;
    }
}

