/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.person;

import at.cdes.api.dto.PersonSearchModel;
import at.cdes.api.guiService.PersonService;
import at.cdes.api.person.compositeDto.PersonInfo;
import at.cdes.impl.export.person.PersonListExporter;
import java.util.List;
import java.util.Map;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.util.sched.cache.ScratchFile;
import org.clazzes.util.sched.impl.HasLoggingCallable;

public class PersonListPdfCallable
extends HasLoggingCallable<ScratchFile> {
    private PersonListExporter personListExporter;
    private PersonService personService;
    private PersonSearchModel searchModel;
    private Boolean showDetails;
    private Map<String, Double> columnToWidth;
    private List<ColumnSortSpec> columnSortSpecs;
    private boolean enableCustomerLogo;

    public PersonListPdfCallable(PersonListExporter personListExporter, PersonService personService, PersonSearchModel searchModel, Boolean showDetails, Map<String, Double> columnToWidth, List<ColumnSortSpec> columnSortSpecs, Boolean enableCustomerLogo) {
        this.personListExporter = personListExporter;
        this.personService = personService;
        this.searchModel = searchModel;
        this.showDetails = showDetails;
        this.columnToWidth = columnToWidth;
        this.columnSortSpecs = columnSortSpecs;
        this.enableCustomerLogo = enableCustomerLogo;
    }

    public ScratchFile call() throws Exception {
        PersonInfo personInfo = this.personService.getPersonJoins(this.searchModel);
        ScratchFile scratchFile = this.personListExporter.export(personInfo, this.showDetails, this.columnToWidth, this.columnSortSpecs, this.enableCustomerLogo);
        return scratchFile;
    }
}

