/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.service;

import at.cdes.api.dto.PersonInCharge;
import at.cdes.api.dto.PlanningNotificationOrder;
import at.cdes.api.dto.PlanningNotificationOrderTag;
import at.cdes.api.dto.PlanningNotificationOrderTagMap;
import at.cdes.api.dto.StatutoryDuty;
import at.cdes.api.dto.SubjectArea;
import at.cdes.api.service.GwtDelegateService;
import at.cdes.impl.dao.PersonInChargeDAO;
import at.cdes.impl.dao.PlanningNotificationOrderDAO;
import at.cdes.impl.dao.PlanningNotificationOrderTagDAO;
import at.cdes.impl.dao.PlanningNotificationOrderTagMapDAO;
import at.cdes.impl.dao.StatutoryDutyDAO;
import at.cdes.impl.dao.SubjectAreaDAO;
import java.util.ArrayList;
import java.util.List;

public class GwtDelegateServiceImpl
implements GwtDelegateService {
    private PlanningNotificationOrderDAO planningNotificationOrderDAO;
    private PlanningNotificationOrderTagDAO planningNotificationOrderTagDAO;
    private PlanningNotificationOrderTagMapDAO planningNotificationOrderTagMapDAO;
    private StatutoryDutyDAO statutoryDutyDAO;
    private PersonInChargeDAO personInChargeDAO;
    private SubjectAreaDAO subjectAreaDAO;

    public void setPlanningNotificationOrderDAO(PlanningNotificationOrderDAO planningNotificationOrderDAO) {
        this.planningNotificationOrderDAO = planningNotificationOrderDAO;
    }

    public void setPlanningNotificationOrderTagDAO(PlanningNotificationOrderTagDAO planningNotificationOrderTagDAO) {
        this.planningNotificationOrderTagDAO = planningNotificationOrderTagDAO;
    }

    public void setPlanningNotificationOrderTagMapDAO(PlanningNotificationOrderTagMapDAO planningNotificationOrderTagMapDAO) {
        this.planningNotificationOrderTagMapDAO = planningNotificationOrderTagMapDAO;
    }

    public void setStatutoryDutyDAO(StatutoryDutyDAO statutoryDutyDAO) {
        this.statutoryDutyDAO = statutoryDutyDAO;
    }

    public void setPersonInChargeDAO(PersonInChargeDAO personInChargeDAO) {
        this.personInChargeDAO = personInChargeDAO;
    }

    public void setSubjectAreaDAO(SubjectAreaDAO subjectAreaDAO) {
        this.subjectAreaDAO = subjectAreaDAO;
    }

    public List<StatutoryDuty> getStatutoryDutiesByNetworkId(Integer networkId) {
        if (networkId != null) {
            return this.statutoryDutyDAO.getByNetwork(networkId.longValue());
        }
        return this.statutoryDutyDAO.getAll();
    }

    public List<PersonInCharge> getAllPersonsInCharge() {
        return this.personInChargeDAO.getAll();
    }

    public List<SubjectArea> getAllSubjectAreas() {
        return this.subjectAreaDAO.getAll();
    }

    public PlanningNotificationOrder get(Integer id) {
        return (PlanningNotificationOrder)this.planningNotificationOrderDAO.get(id);
    }

    public void updatePlanningNotificationOrderNewValues(PlanningNotificationOrder planningNotificationOrder) {
        this.planningNotificationOrderDAO.update(planningNotificationOrder);
    }

    public List<PlanningNotificationOrderTag> getAllTags(Integer planningNotificationOrderId) {
        if (planningNotificationOrderId == null) {
            return new ArrayList<PlanningNotificationOrderTag>();
        }
        ArrayList<PlanningNotificationOrderTag> tags = new ArrayList<PlanningNotificationOrderTag>();
        List<PlanningNotificationOrderTagMap> tagMaps = this.planningNotificationOrderTagMapDAO.getByPlanningNotificationOrder(planningNotificationOrderId.longValue());
        for (PlanningNotificationOrderTagMap tagMap : tagMaps) {
            PlanningNotificationOrderTag tag = (PlanningNotificationOrderTag)this.planningNotificationOrderTagDAO.get(tagMap.getPlanningNotificationOrderTagId());
            tags.add(tag);
        }
        return tags;
    }
}

