/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.util.file;

import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.clazzes.util.http.UrlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = -4949222700880328195L;
    private static final Logger log = LoggerFactory.getLogger(FileUploadServlet.class);
    private String formFieldName;

    public void setFormFieldName(String formFieldName) {
        this.formFieldName = formFieldName;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            try {
                String result = this.handleMultiPartUpload(req);
                if (result == null) {
                    resp.sendError(500, "Invalid request");
                }
                resp.setDateHeader("Date", System.currentTimeMillis());
                resp.setContentType("text/html");
                resp.getWriter().write("<html><body>" + result + "</body></html>");
            }
            catch (FileUploadException e) {
                throw new IOException("Error processing multipart request", e);
            }
        } else {
            log.error("Client sent POST request with wrong mimetype: " + req.getContentType());
            resp.sendError(500);
        }
    }

    protected String handleMultiPartUpload(HttpServletRequest req) throws IOException, FileUploadException {
        Long projectId;
        Map paramMap;
        ServletFileUpload upload = new ServletFileUpload();
        FileItemIterator fileIt = upload.getItemIterator(req);
        byte[] data = null;
        String projectIdString = null;
        String qs = req.getQueryString();
        if (qs != null && (paramMap = UrlHelper.parseQuery((String)qs)) != null) {
            projectIdString = UrlHelper.getStringParameter((Map)paramMap, (String)"projectId");
        }
        Long l = projectId = projectIdString != null ? Long.valueOf(Long.parseLong(projectIdString)) : null;
        while (fileIt.hasNext()) {
            int pos;
            String filename;
            FileItemStream item = fileIt.next();
            if (item.isFormField() || !this.formFieldName.equals(item.getFieldName()) || (filename = item.getName()) == null || filename.length() == 0) continue;
            if (log.isDebugEnabled()) {
                log.debug("Processing filename [" + filename + "]");
            }
            if ((pos = filename.lastIndexOf(47)) >= 0) {
                filename = filename.substring(pos + 1);
            }
            if ((pos = filename.lastIndexOf(92)) >= 0) {
                filename = filename.substring(pos + 1);
            }
            InputStream inputStream = item.openStream();
            data = IOUtils.toByteArray((InputStream)inputStream);
        }
        if (data == null) {
            log.error("Recevied request with no data.");
            return null;
        }
        byte[] base64Data = Base64.getEncoder().encode(data);
        String base64String = new String(base64Data, "UTF-8");
        String htmlString = StringEscapeUtils.escapeHtml((String)base64String);
        return htmlString;
    }

    public String getServletInfo() {
        return FileUploadServlet.class.getSimpleName();
    }
}

