/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.DocumentType;
import at.cdes.api.joinDto.LabelContentDocTypeJoin;
import at.cdes.impl.dao.DocumentTypeDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcDocumentTypeDAO;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcDocumentTypeDAO
extends AbstractJdbcDocumentTypeDAO
implements DocumentTypeDAO {
    @Override
    public List<DocumentType> getByProject(final Long projectId) {
        String sql = "SELECT " + JdbcDocumentTypeDAO.getSelectClauseForDto() + "FROM   (((project JOIN document_number_part_group              ON project.document_number_part_group_id = document_number_part_group.id)JOIN master_data_set                         ON document_number_part_group.master_data_set_id = master_data_set.id)JOIN document_type                           ON document_type.master_data_set_id = master_data_set.id)WHERE project.id = ?";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<DocumentType>>(){

            public List<DocumentType> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)projectId);
                ResultSet rs = statement.executeQuery();
                ArrayList<DocumentType> ret = new ArrayList<DocumentType>();
                while (rs.next()) {
                    DocumentType documentType = JdbcDocumentTypeDAO.fillDocumentTypeFromResultSet(rs);
                    ret.add(documentType);
                }
                return ret;
            }
        });
    }

    @Override
    public List<DocumentType> getBySubProject(final Long subProjectId) {
        String sql = "SELECT " + JdbcDocumentTypeDAO.getSelectClauseForDto() + "FROM  ((((sub_project JOIN project                                 ON sub_project.project_id = project.id) JOIN document_number_part_group              ON project.document_number_part_group_id = document_number_part_group.id)JOIN master_data_set                         ON document_number_part_group.master_data_set_id = master_data_set.id)JOIN document_type                           ON document_type.master_data_set_id = master_data_set.id)WHERE sub_project.id = ?";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<DocumentType>>(){

            public List<DocumentType> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)subProjectId);
                ResultSet rs = statement.executeQuery();
                ArrayList<DocumentType> ret = new ArrayList<DocumentType>();
                while (rs.next()) {
                    DocumentType documentType = JdbcDocumentTypeDAO.fillDocumentTypeFromResultSet(rs);
                    ret.add(documentType);
                }
                return ret;
            }
        });
    }

    @Override
    public List<LabelContentDocTypeJoin> getLabelContentJoins(Long networkId, Long labelContentId) {
        String sql = "SELECT " + JdbcDocumentTypeDAO.getLabelContentDocTypeJoinSelectClause() + "FROM master_data_set JOIN document_type               ON document_type.master_data_set_id = master_data_set.id LEFT JOIN document_type_label_content ON document_type_label_content.document_type_id = document_type.id WHERE master_data_set.network_id = ? AND (    document_type_label_content.label_content_id IS NULL OR document_type_label_content.label_content_id = ?) ORDER BY master_data_set.name ASC, document_type.code ASC";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcDocumentTypeDAO::fillLabelContentDocTypeJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)labelContentId);
        });
    }
}

