/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.CdesRole;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.NetworkPerson;
import at.cdes.api.dto.OrganisationPerson;
import at.cdes.impl.dao.NetworkPersonDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcNetworkPersonDAO
extends AbstrIdDAO<NetworkPerson>
implements NetworkPersonDAO {
    public JdbcNetworkPersonDAO() {
        super(NetworkPerson.class, "id", "network_person", new String[]{"id", "network_id", "organisation_person_id", "role_id", "isMain"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcNetworkPersonDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "organisation_person_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "role_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "isMain") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcNetworkPersonDAO.getSelectClauseForDto("network_person", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcNetworkPersonDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".network_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + "," + entityLocalName + ".organisation_person_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "organisation_person_id") + "," + entityLocalName + ".role_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "role_id") + "," + entityLocalName + ".isMain" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "isMain") + " ";
    }

    protected NetworkPerson fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        NetworkPerson networkPerson = new NetworkPerson();
        networkPerson.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        networkPerson.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        networkPerson.setOrganisationPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        networkPerson.setRoleId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        networkPerson.setMainPerson(JDBCHelper.getBoolean((ResultSet)rs, (int)(++columnIndex)));
        return networkPerson;
    }

    public static NetworkPerson fillNetworkPersonFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        NetworkPerson networkPerson = new NetworkPerson();
        networkPerson.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        networkPerson.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        networkPerson.setOrganisationPersonId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        networkPerson.setRoleId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        networkPerson.setMainPerson(JDBCHelper.getBoolean((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return networkPerson;
    }

    public static NetworkPerson fillNetworkPersonFromResultSet(ResultSet rs) throws SQLException {
        return JdbcNetworkPersonDAO.fillNetworkPersonFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 5;
    }

    @Override
    public void deleteByNetwork(final Long networkId) {
        String sql = "DELETE FROM network_person WHERE network_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, networkId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(NetworkPerson dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<NetworkPerson> dtos) {
        Iterator<NetworkPerson> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, NetworkPerson networkPerson) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)networkPerson.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)networkPerson.getNetworkId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)networkPerson.getOrganisationPersonId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)4, (Number)networkPerson.getRoleId());
        JDBCHelper.setBoolean((PreparedStatement)statement, (int)5, (Boolean)networkPerson.getMainPerson());
    }

    @Override
    public List<NetworkPerson> getByNetwork(Network network) {
        return this.getByNetwork(network.getId());
    }

    @Override
    public List<NetworkPerson> getByNetwork(final Long networkId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkId);
            }
        });
    }

    @Override
    public List<NetworkPerson> getByOrganisationPerson(OrganisationPerson organisationPerson) {
        return this.getByOrganisationPerson(organisationPerson.getId());
    }

    @Override
    public List<NetworkPerson> getByOrganisationPerson(final Long organisationPersonId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"organisation_person_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, organisationPersonId);
            }
        });
    }

    @Override
    public List<NetworkPerson> getByRole(CdesRole cdesRole) {
        return this.getByRole(cdesRole.getId());
    }

    @Override
    public List<NetworkPerson> getByRole(final Long cdesRoleId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"role_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, cdesRoleId);
            }
        });
    }

    @Override
    public List<NetworkPerson> getByNetworks(Collection<Long> networkId) {
        if (networkId.isEmpty()) {
            return new ArrayList<NetworkPerson>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkId.size()];
        int n = 0;
        Iterator<Long> it = networkId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<NetworkPerson> getByOrganisationPersons(Collection<Long> organisationPersonId) {
        if (organisationPersonId.isEmpty()) {
            return new ArrayList<NetworkPerson>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[organisationPersonId.size()];
        int n = 0;
        Iterator<Long> it = organisationPersonId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"organisation_person_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<NetworkPerson> getByRoles(Collection<Long> cdesRoleId) {
        if (cdesRoleId.isEmpty()) {
            return new ArrayList<NetworkPerson>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[cdesRoleId.size()];
        int n = 0;
        Iterator<Long> it = cdesRoleId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"role_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

