/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.ReviewCycleNodePositionReleased;
import at.cdes.api.joinDto.NodePositionJoin;
import at.cdes.impl.dao.ReviewCycleNodePositionReleasedDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcReviewCycleNodePositionReleasedDAO;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcReviewCycleNodePositionReleasedDAO
extends AbstractJdbcReviewCycleNodePositionReleasedDAO
implements ReviewCycleNodePositionReleasedDAO {
    private static final Logger log = LoggerFactory.getLogger(JdbcReviewCycleNodePositionReleasedDAO.class);

    @Override
    public List<ReviewCycleNodePositionReleased> getPositionSignaturesOnLabel(Long reviewCycleCellInstanceReleasedId) {
        String sql = "SELECT " + this.getSelectClauseForDto() + "\nFROM review_cycle_node_position_released\nJOIN realm                               ON realm.id = review_cycle_node_position_released.realm_id\n                                        AND realm.signature_on_label = 1\nJOIN review_cycle_node_instance_released ON review_cycle_node_instance_released.id = review_cycle_node_position_released.review_cycle_node_instance_id\n                                        AND review_cycle_node_instance_released.review_cycle_cell_instance_id = ?\n";
        return QueryHelper.getListWithSqlFiller((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, filler -> filler.addInt(reviewCycleCellInstanceReleasedId));
    }

    @Override
    public List<ReviewCycleNodePositionReleased> getActiveByParticipationId(Long participationId) {
        String sql = "SELECT " + JdbcReviewCycleNodePositionReleasedDAO.getSelectClauseForDto() + "FROM review_cycle_node_position_released JOIN review_cycle_node_instance_released ON review_cycle_node_position_released.review_cycle_node_instance_id = review_cycle_node_instance_released.id JOIN review_cycle_cell_instance_released ON review_cycle_node_instance_released.review_cycle_cell_instance_id = review_cycle_cell_instance_released.id JOIN review_cycle_instance_released      ON review_cycle_cell_instance_released.review_cycle_instance_id = review_cycle_instance_released.id JOIN object_list_release                 ON review_cycle_instance_released.object_list_id = object_list_release.id JOIN object_list                         ON object_list_release.object_list_id = object_list.id WHERE review_cycle_node_position_released.project_participation_id = ? AND object_list_release.version = object_list.version - 1 ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)participationId);
        });
    }

    @Override
    public List<ReviewCycleNodePositionReleased> getByInstanceId(Long instanceId) {
        String sql = "SELECT " + JdbcReviewCycleNodePositionReleasedDAO.getSelectClauseForDto() + "FROM review_cycle_node_position_released JOIN review_cycle_node_instance_released ON review_cycle_node_position_released.review_cycle_node_instance_id = review_cycle_node_instance_released.id JOIN review_cycle_cell_instance_released ON review_cycle_node_instance_released.review_cycle_cell_instance_id = review_cycle_cell_instance_released.id JOIN review_cycle_instance_released      ON review_cycle_cell_instance_released.review_cycle_instance_id = review_cycle_instance_released.id WHERE review_cycle_instance_released.review_cycle_instance_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)instanceId);
        });
    }

    @Override
    public List<ReviewCycleNodePositionReleased> getCurrentByInstanceId(Long instanceId) {
        String sql = "SELECT " + JdbcReviewCycleNodePositionReleasedDAO.getSelectClauseForDto() + "FROM review_cycle_instance JOIN sub_project                         ON review_cycle_instance.sub_project_id = sub_project.id JOIN object_list                         ON object_list.sub_project_id = sub_project.id JOIN object_list_release                 ON     object_list_release.object_list_id = object_list.id AND object_list_release.version = object_list.version - 1 JOIN review_cycle_instance_released      ON     review_cycle_instance_released.object_list_id = object_list_release.id AND review_cycle_instance_released.review_cycle_instance_id = review_cycle_instance.id JOIN review_cycle_cell_instance_released ON review_cycle_cell_instance_released.review_cycle_instance_id = review_cycle_instance_released.id JOIN review_cycle_node_instance_released ON review_cycle_node_instance_released.review_cycle_cell_instance_id = review_cycle_cell_instance_released.id JOIN review_cycle_node_position_released ON review_cycle_node_position_released.review_cycle_node_instance_id = review_cycle_node_instance_released.id WHERE review_cycle_instance.id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)instanceId);
        });
    }

    @Override
    public Map<Long, Integer> getSignedPositionResultCountByVersionIds(final Collection<Long> documentVersionIds) {
        String sql = "SELECT document_version.id, review_cycle_position_result.id FROM document_version JOIN review_cycle_node_instance           ON document_version.active_node_instance_id = review_cycle_node_instance.id JOIN review_cycle_node                    ON review_cycle_node_instance.review_cycle_node_id = review_cycle_node.id LEFT JOIN review_cycle_node_result        ON       review_cycle_node_result.review_cycle_node_id = review_cycle_node.id AND review_cycle_node_result.document_version_id = document_version.id LEFT JOIN review_cycle_position_result    ON       review_cycle_position_result.review_cycle_node_result_id = review_cycle_node_result.id LEFT JOIN review_cycle_result_option      ON review_cycle_position_result.review_cycle_result_option_id = review_cycle_result_option.id WHERE document_version.id IN (" + QueryHelper.getPlaceHolderSequence(documentVersionIds.size()) + ") AND review_cycle_position_result.signature_id IS NOT NULL AND review_cycle_result_option.value > ? ";
        return (Map)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Map<Long, Integer>>(){

            public Map<Long, Integer> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long documentVersionId : documentVersionIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
                }
                JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)-9);
                HashMap<Long, Integer> documentVersionIdToCount = new HashMap<Long, Integer>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    Long documentVersionId = rs.getLong(1);
                    Long positionResultId = rs.getLong(2);
                    int count = documentVersionIdToCount.containsKey(documentVersionId) ? (Integer)documentVersionIdToCount.get(documentVersionId) : 0;
                    documentVersionIdToCount.put(documentVersionId, ++count);
                }
                return documentVersionIdToCount;
            }
        });
    }

    @Override
    public List<NodePositionJoin> getNodePositionJoinsByVersionIds(Collection<Long> documentVersionIds) {
        String sql = "SELECT " + JdbcReviewCycleNodePositionReleasedDAO.getNodePositionJoinSelectClause() + "FROM document_version JOIN document                             ON document_version.document_id = document.id JOIN object_planner                       ON document.object_planner_id = object_planner.id JOIN object                               ON object_planner.object_id = object.id JOIN object_list                          ON object.object_list_id = object_list.id JOIN object_list_release                  ON      object_list_release.sub_project_id = object_list.sub_project_id AND object_list_release.version = object_list.version - 1 JOIN object_release                       ON      object_release.object_id = object.id AND object_release.object_list_release_id = object_list_release.id JOIN object_planner_release               ON      object_planner_release.object_planner_id = object_planner.id AND object_planner_release.object_id = object_release.id JOIN review_cycle_instance_released       ON object_planner_release.review_cycle_instance_id = review_cycle_instance_released.id JOIN review_cycle_node_instance           ON document_version.active_node_instance_id = review_cycle_node_instance.id JOIN review_cycle_node                    ON review_cycle_node_instance.review_cycle_node_id = review_cycle_node.id JOIN (      review_cycle_cell_instance_released JOIN review_cycle_node_instance_released ON review_cycle_node_instance_released.review_cycle_cell_instance_id = review_cycle_cell_instance_released.id) ON       review_cycle_cell_instance_released.review_cycle_instance_id = review_cycle_instance_released.id AND review_cycle_node_instance_released.review_cycle_node_id = review_cycle_node.id JOIN review_cycle_node_position_released  ON review_cycle_node_position_released.review_cycle_node_instance_id = review_cycle_node_instance_released.id LEFT JOIN project_participation                ON review_cycle_node_position_released.project_participation_id = project_participation.id LEFT JOIN organisation                         ON project_participation.organisation_id = organisation.id LEFT JOIN project_participant                  ON       project_participant.participation_id = project_participation.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag = 0 LEFT JOIN organisation_person                  ON project_participant.organisation_person_id = organisation_person.id LEFT JOIN person                               ON organisation_person.person_id = person.id WHERE document_version.id IN (" + QueryHelper.getPlaceHolderSequence(documentVersionIds.size()) + ") AND NOT EXISTS (SELECT 1 FROM review_cycle_position_result JOIN review_cycle_result_option            ON review_cycle_position_result.review_cycle_result_option_id = review_cycle_result_option.id JOIN project_participant local_participant ON review_cycle_position_result.project_participant_id = local_participant.id WHERE local_participant.participation_id = project_participation.id AND review_cycle_position_result.realm_id = review_cycle_node_position_released.realm_id AND review_cycle_position_result.document_version_id = document_version.id AND review_cycle_position_result.signature_id IS NOT NULL AND review_cycle_result_option.value > ?) ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcReviewCycleNodePositionReleasedDAO::fillNodePositionJoinFromResultSet, statement -> {
            int currIndex = 1;
            for (Long documentVersionId : documentVersionIds) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
            }
            JDBCHelper.setInt((PreparedStatement)statement, (int)currIndex++, (Number)-9);
        });
    }
}

