/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.project;

import at.cdes.api.guiService.ProjectService;
import at.cdes.api.project.compositeDto.ParticipationPageInfo;
import at.cdes.api.project.searchModel.ParticipationPageSearchModel;
import at.cdes.impl.export.project.ParticipationPdfExporter;
import java.util.List;
import java.util.Map;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.util.sched.cache.ScratchFile;
import org.clazzes.util.sched.impl.HasLoggingCallable;

public class ParticipationPdfCallable
extends HasLoggingCallable<ScratchFile> {
    private ParticipationPdfExporter exporter;
    private ProjectService projectService;
    private Long organisationPersonId;
    private ParticipationPageSearchModel searchModel;
    private Map<String, Double> columnToWidth;
    private List<ColumnSortSpec> columnSortSpecs;
    private boolean enableCustomerLogo;

    public ParticipationPdfCallable(ParticipationPdfExporter exporter, ProjectService projectService, Long organisationPersonId, ParticipationPageSearchModel searchModel, Map<String, Double> columnToWidth, List<ColumnSortSpec> columnSortSpecs, boolean enableCustomerLogo) {
        this.exporter = exporter;
        this.projectService = projectService;
        this.organisationPersonId = organisationPersonId;
        this.searchModel = searchModel;
        this.columnToWidth = columnToWidth;
        this.columnSortSpecs = columnSortSpecs;
        this.enableCustomerLogo = enableCustomerLogo;
    }

    public ScratchFile call() throws Exception {
        ParticipationPageInfo participationPageInfo = this.projectService.getParticipationPageInfo(this.organisationPersonId, this.searchModel);
        List organisationParticipationInfos = participationPageInfo.getOrganisationParticipationInfos();
        ScratchFile scratchFile = this.exporter.export(this.organisationPersonId, this.searchModel, organisationParticipationInfos, this.columnToWidth, this.columnSortSpecs, this.enableCustomerLogo);
        return scratchFile;
    }
}

