/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.msp;

import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.auth.NTLMScheme;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieNTLMSchema
extends NTLMScheme {
    private static final Logger log = LoggerFactory.getLogger(CookieNTLMSchema.class);

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        HttpClientContext clientContext = (HttpClientContext)context;
        HttpResponse response = clientContext.getResponse();
        Header[] setCookieHeaders = response.getHeaders("Set-Cookie");
        if (setCookieHeaders != null) {
            CookieOrigin origin = clientContext.getCookieOrigin();
            for (Header setCookieHeader : setCookieHeaders) {
                try {
                    List cookieHeaders;
                    List cookies = clientContext.getCookieSpec().parse(setCookieHeader, origin);
                    if (cookies == null || (cookieHeaders = clientContext.getCookieSpec().formatCookies(cookies)) == null) continue;
                    for (Header cookieHeader : cookieHeaders) {
                        if (log.isDebugEnabled()) {
                            log.debug("Propagating cookie [{}] during authentication handshake.", (Object)cookieHeader);
                        }
                        request.addHeader(cookieHeader);
                    }
                }
                catch (MalformedCookieException e) {
                    throw new AuthenticationException("Error propagating cookie during authentication handshake", (Throwable)e);
                }
            }
        }
        return super.authenticate(credentials, request, context);
    }
}

