/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.msp;

import at.cdes.impl.msp.MspPrincipal;
import at.cdes.impl.msp.MspProbe;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.clazzes.util.sec.DomainGroup;
import org.clazzes.util.sec.DomainPasswordLoginService;
import org.clazzes.util.sec.DomainPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MspLoginService
implements DomainPasswordLoginService {
    private static final Logger log = LoggerFactory.getLogger(MspLoginService.class);
    private String defaultDomain;
    private String workstation;
    private MspProbe probeService;

    public void setDefaultDomain(String domain) {
        this.defaultDomain = domain;
    }

    public void setWorkstation(String hostname) throws UnknownHostException {
        if (hostname == null || hostname.isEmpty()) {
            String computername = InetAddress.getLocalHost().getHostName();
            log.info("Using lcoalhost name [{}] as NTLM workstation.", (Object)computername);
            this.workstation = computername;
        } else {
            log.info("Using configured name [{}] as NTLM workstation.", (Object)hostname);
            this.workstation = hostname;
        }
    }

    public void setProbeService(MspProbe probeService) {
        this.probeService = probeService;
    }

    public void changePassword(String arg0, String arg1, String arg2, String arg3) {
        throw new UnsupportedOperationException();
    }

    public void deactivateUser(String arg0, String arg1, String arg2) {
        throw new UnsupportedOperationException();
    }

    public String getDefaultDomain() {
        return this.defaultDomain;
    }

    public List<String> getDomains() {
        return null;
    }

    public List<DomainPrincipal> getGroupMembers(String arg0, String arg1) {
        throw new UnsupportedOperationException();
    }

    public List<DomainGroup> getGroups(String arg0, String arg1) {
        throw new UnsupportedOperationException();
    }

    public int getSupportedFeatures(String arg0) {
        return 0;
    }

    public DomainPrincipal searchUser(String arg0, String arg1) {
        throw new UnsupportedOperationException();
    }

    public void sendPassword(String arg0, String arg1) {
        throw new UnsupportedOperationException();
    }

    public DomainPrincipal tryLogin(String domain, String username, String password) {
        MspPrincipal principal = new MspPrincipal(username, password, this.workstation, domain);
        if (this.probeService != null) {
            log.info("Probing MSP login for user [{}]...", (Object)principal.getName());
            if (!this.probeService.checkCredentials(principal)) {
                log.error("MSP login probe for user [{}] failed.", (Object)principal.getName());
                return null;
            }
            log.info("MSP login probe for user [{}] succeeded.", (Object)principal.getName());
        }
        return principal;
    }
}

