/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.util;

import org.clazzes.util.sec.HashTools;
import org.clazzes.util.sec.HasherFactory;
import org.clazzes.util.sec.PasswordHasherFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordUtil {
    private static final Logger log = LoggerFactory.getLogger(PasswordUtil.class);

    public static String normalizePasswordHash(String hash) {
        if (hash.startsWith("SSHA1")) {
            return "{SSHA1}" + hash.substring("SSHA1".length());
        }
        return hash;
    }

    public static boolean checkPassword(String hash, String password) {
        boolean passwordStatus = HashTools.checkPassword((PasswordHasherFactory)new HasherFactory(), (String)password, (String)PasswordUtil.normalizePasswordHash(hash));
        if (log.isDebugEnabled() && !passwordStatus) {
            log.debug("PasswordUtil checkPassword failed: password = [" + password + "]");
        }
        return passwordStatus;
    }
}

