/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.ObjectListRelease;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.ObjectListReleaseJoin;
import at.cdes.impl.dao.NetworkDAO;
import at.cdes.impl.dao.ObjectListReleaseDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcNetworkDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcObjectListReleaseDAO;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcObjectListReleaseDAO
extends AbstractJdbcObjectListReleaseDAO
implements ObjectListReleaseDAO {
    private NetworkDAO networkDAO;

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    @Override
    public List<ObjectListRelease> getBySubProject(final Long subProjectId) {
        String sql = "SELECT " + JdbcObjectListReleaseDAO.getSelectClauseForDto() + "FROM     ((sub_project JOIN      object_list                  ON object_list.sub_project_id = sub_project.id) JOIN      object_list_release          ON object_list_release.object_list_id = object_list.id)WHERE sub_project.id = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ObjectListRelease>>(){

            public List<ObjectListRelease> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)subProjectId);
                ResultSet rs = statement.executeQuery();
                ArrayList<ObjectListRelease> ret = new ArrayList<ObjectListRelease>();
                while (rs.next()) {
                    ObjectListRelease objectListRelease = JdbcObjectListReleaseDAO.this.fillDtoFromResultSet(rs);
                    ret.add(objectListRelease);
                }
                return ret;
            }
        });
    }

    @Override
    public ObjectListRelease getActiveBySubProject(Long subProjectId) {
        String sql = "SELECT " + JdbcObjectListReleaseDAO.getSelectClauseForDto() + "\nFROM sub_project\nJOIN object_list                  ON object_list.sub_project_id = sub_project.id\nJOIN object_list_release          ON object_list_release.object_list_id = object_list.id\n                                 AND object_list_release.version = (object_list.version - 1)\nWHERE sub_project.id = ?\n";
        return QueryHelper.getUniqueWithSqlFiller((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, filler -> filler.addLong(subProjectId));
    }

    @Override
    public ObjectListRelease getActiveByDocumentVersion(Long documentVersionId) {
        String sql = "SELECT " + JdbcObjectListReleaseDAO.getSelectClauseForDto() + "FROM document_version JOIN document               ON document_version.document_id = document.id JOIN object_planner         ON document.object_planner_id = object_planner.id JOIN object                 ON object_planner.object_id = object.id JOIN object_list            ON object.object_list_id = object_list.id JOIN object_list_release          ON object_list_release.object_list_id = object_list.id                                  AND object_list_release.version = (object_list.version - 1) WHERE document_version.id = ? ";
        return QueryHelper.getUniqueWithSqlFiller((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, filler -> filler.addLong(documentVersionId));
    }

    @Override
    public int getCountBySubProject(final Long subProjectId) {
        String sql = "SELECT COUNT(1) FROM     ((sub_project JOIN      object_list                  ON object_list.sub_project_id = sub_project.id) JOIN      object_list_release          ON object_list_release.object_list_id = object_list.id)WHERE sub_project.id = ? ";
        return (Integer)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Integer>(){

            public Integer perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)subProjectId);
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    Integer count = JDBCHelper.getInt((ResultSet)rs, (int)1);
                    return count;
                }
                return 0;
            }
        });
    }

    @Override
    public int getCountByDocument(final Long documentId) {
        String sql = "SELECT COUNT(1) FROM     ((((document JOIN      object_planner               ON document.object_planner_id = object_planner.id)  JOIN      object                       ON object_planner.object_id = object.id)  JOIN      object_list                  ON object.object_list_id = object_list.id)  JOIN      object_list_release          ON object_list_release.object_list_id = object_list.id)WHERE document.id = ? ";
        return (Integer)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Integer>(){

            public Integer perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)documentId);
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    Integer count = JDBCHelper.getInt((ResultSet)rs, (int)1);
                    return count;
                }
                return 0;
            }
        });
    }

    @Override
    public List<ObjectListReleaseJoin> getObjectListReleaseJoinsBySubProjectId(Long subProjectId) {
        String sql = "SELECT " + JdbcObjectListReleaseDAO.getObjectListReleaseJoinSelectClause() + "FROM object_list_release JOIN signature            ON object_list_release.signature_id = signature.id LEFT JOIN project_participant  ON signature.project_participant_id = project_participant.id LEFT JOIN organisation_person  ON project_participant.organisation_person_id = organisation_person.id LEFT JOIN person signer_person ON organisation_person.person_id = signer_person.id WHERE object_list_release.sub_project_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcObjectListReleaseDAO::fillObjectListReleaseJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
        });
    }

    @Override
    public ObjectListReleaseJoin getObjectListReleaseJoinById(Long objectListReleaseId) {
        String sql = "SELECT " + JdbcObjectListReleaseDAO.getObjectListReleaseJoinSelectClause() + "FROM object_list_release JOIN signature            ON object_list_release.signature_id = signature.id LEFT JOIN project_participant  ON signature.project_participant_id = project_participant.id LEFT JOIN organisation_person  ON project_participant.organisation_person_id = organisation_person.id LEFT JOIN person signer_person ON organisation_person.person_id = signer_person.id WHERE object_list_release.id = ? ";
        return QueryHelper.getUniqueWithSql((JdbcDAOSupport)this, sql, AbstractJdbcObjectListReleaseDAO::fillObjectListReleaseJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectListReleaseId);
        });
    }

    @Override
    public ContextJoin getContextJoin(Long objectListReleaseId) {
        String sql = "SELECT " + this.networkDAO.getContextJoinUnionSelectClause("network", "project", "subProject") + " FROM object_list_release JOIN sub_project        ON object_list_release.sub_project_id = sub_project.id JOIN sub_project_type   ON sub_project.sub_project_type_id = sub_project_type.id JOIN project            ON sub_project.project_id = project.id JOIN network            ON project.network_id = network.id WHERE object_list_release.id = ? ";
        return QueryHelper.getUniqueWithSql((JdbcDAOSupport)this, sql, AbstractJdbcNetworkDAO::fillContextJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectListReleaseId);
        });
    }
}

