/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.sec;

import at.cdes.api.person.PasswordUtils;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.commons.codec.binary.Base64;
import org.clazzes.util.sec.HashTools;

public class PasswordUtilsImpl
implements PasswordUtils {
    private String securityAnswerAlgorithm;
    private Integer securityAnswerIterations;
    private Integer securityAnswerSaltLength;

    public void setSecurityAnswerAlgorithm(String securityAnswerAlgorithm) {
        this.securityAnswerAlgorithm = securityAnswerAlgorithm;
    }

    public void setSecurityAnswerIterations(Integer securityAnswerIterations) {
        this.securityAnswerIterations = securityAnswerIterations;
    }

    public void setSecurityAnswerSaltLength(Integer securityAnswerSaltLength) {
        this.securityAnswerSaltLength = securityAnswerSaltLength;
    }

    public String encryptSecurityAnswer(String content, String password) {
        try {
            AlgorithmParameters params;
            PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray());
            String salt = HashTools.randomSalt((int)this.securityAnswerSaltLength);
            PBEParameterSpec paramSpec = new PBEParameterSpec(salt.getBytes("utf-8"), this.securityAnswerIterations);
            boolean useBC = "PBEWithSHAAndTwofish-CBC".equals(this.securityAnswerAlgorithm);
            SecretKeyFactory skf = useBC ? SecretKeyFactory.getInstance(this.securityAnswerAlgorithm, "BC") : SecretKeyFactory.getInstance(this.securityAnswerAlgorithm);
            SecretKey key = skf.generateSecret(keySpec);
            Cipher ecipher = Cipher.getInstance(key.getAlgorithm());
            if (useBC) {
                params = AlgorithmParameters.getInstance(key.getAlgorithm());
                params.init(paramSpec);
                ecipher.init(1, (Key)key, params);
            } else {
                ecipher.init(1, (Key)key, paramSpec);
                params = ecipher.getParameters();
            }
            byte[] algorithmParametersEncoded = params.getEncoded();
            byte[] encrypted = ecipher.doFinal(content.getBytes("utf-8"));
            String res = new String(Base64.encodeBase64((byte[])encrypted));
            return this.makeString(res, new String(Base64.encodeBase64((byte[])algorithmParametersEncoded)), salt);
        }
        catch (Exception e) {
            throw new RuntimeException("Error generating encrypted password", e);
        }
    }

    public String decryptSecurityAnswer(String encoded, String password) {
        try {
            int eofPart1 = encoded.indexOf("}") + 1;
            String part1 = encoded.substring(0, eofPart1);
            String algo = part1.substring(1, part1.indexOf(";"));
            String largeSuffix = part1.substring(part1.indexOf(";") + 1, part1.indexOf("}"));
            String suffix = largeSuffix.indexOf(";") != -1 ? largeSuffix.substring(largeSuffix.indexOf(";") + 1) : largeSuffix;
            String enc = encoded.substring(eofPart1);
            PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray());
            SecretKey key = SecretKeyFactory.getInstance(algo).generateSecret(keySpec);
            Cipher cipher = Cipher.getInstance(key.getAlgorithm());
            Integer iterations = null;
            if (suffix.contains(";")) {
                String parameterString = suffix.substring(0, suffix.indexOf(";"));
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(algo);
                algorithmParameters.init(Base64.decodeBase64((byte[])parameterString.getBytes("utf-8")));
                String salt1 = suffix.substring(suffix.indexOf(";") + 1);
                cipher.init(2, (Key)key, algorithmParameters);
            } else {
                iterations = 1;
                String salt1 = suffix;
                PBEParameterSpec paramSpec = new PBEParameterSpec(salt1.getBytes("utf-8"), iterations);
                cipher.init(2, (Key)key, paramSpec);
            }
            byte[] original = cipher.doFinal(Base64.decodeBase64((byte[])enc.getBytes("utf-8")));
            String originalString = new String(original, "utf-8");
            return originalString;
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Wrong password.");
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading encrypted password", e);
        }
    }

    private String makeString(String enc, String parameterString, String salt) {
        if (this.securityAnswerAlgorithm.contains(";")) {
            throw new IllegalArgumentException("Illegal algorithm name: [" + this.securityAnswerAlgorithm + "]");
        }
        return "{" + this.securityAnswerAlgorithm + ";" + this.securityAnswerIterations + ";" + parameterString + ";" + salt + "}" + enc;
    }
}

