/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.sec.util;

import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.sec.CdesPrincipal;
import at.cdes.impl.dao.OrganisationPersonDAO;
import org.clazzes.util.aop.ThreadLocalManager;

public class SecurityHelper {
    public static void checkOrganisationPersonIdAgainstPrincipal(CdesPrincipal loginPrincipal, OrganisationPersonDAO organisationPersonDAO, Long organisationPersonId) {
        if (organisationPersonId == null) {
            throw new IllegalArgumentException("No organisationPersonId to check given; please check wether the calling code transfers the id correctly.");
        }
        OrganisationPerson organisationPerson = (OrganisationPerson)organisationPersonDAO.get(organisationPersonId);
        Long loginPersonId = loginPrincipal.getPersonId();
        if (organisationPerson.getPersonId().longValue() != loginPersonId.longValue()) {
            throw new SecurityException("Passed organisationPersonId [" + organisationPersonId + "] refers to personId [" + organisationPerson.getPersonId() + "], which does not match the personId [" + loginPersonId + "] from the login principal.");
        }
    }

    public static void checkOrganisationPersonIdAgainstPrincipal(OrganisationPersonDAO organisationPersonDAO, Long organisationPersonId) {
        CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(loginPrincipal, organisationPersonDAO, organisationPersonId);
    }
}

