/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.DocumentNumberPartGroup;
import at.cdes.api.dto.MasterDataSet;
import at.cdes.api.dto.Network;
import at.cdes.impl.dao.DocumentNumberPartGroupDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcDocumentNumberPartGroupDAO
extends AbstrIdDAO<DocumentNumberPartGroup>
implements DocumentNumberPartGroupDAO {
    public JdbcDocumentNumberPartGroupDAO() {
        super(DocumentNumberPartGroup.class, "id", "document_number_part_group", new String[]{"id", "network_id", "name", "rendererName", "master_data_set_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcDocumentNumberPartGroupDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "rendererName") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "master_data_set_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcDocumentNumberPartGroupDAO.getSelectClauseForDto("document_number_part_group", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcDocumentNumberPartGroupDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".network_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + "," + entityLocalName + ".name" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + "," + entityLocalName + ".rendererName" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "rendererName") + "," + entityLocalName + ".master_data_set_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "master_data_set_id") + " ";
    }

    protected DocumentNumberPartGroup fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        DocumentNumberPartGroup documentNumberPartGroup = new DocumentNumberPartGroup();
        documentNumberPartGroup.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentNumberPartGroup.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentNumberPartGroup.setName(rs.getString(++columnIndex));
        documentNumberPartGroup.setRendererName(rs.getString(++columnIndex));
        documentNumberPartGroup.setMasterDataSetId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return documentNumberPartGroup;
    }

    public static DocumentNumberPartGroup fillDocumentNumberPartGroupFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        DocumentNumberPartGroup documentNumberPartGroup = new DocumentNumberPartGroup();
        documentNumberPartGroup.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentNumberPartGroup.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentNumberPartGroup.setName(rs.getString(columnIndex.incrementAndGet()));
        documentNumberPartGroup.setRendererName(rs.getString(columnIndex.incrementAndGet()));
        documentNumberPartGroup.setMasterDataSetId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return documentNumberPartGroup;
    }

    public static DocumentNumberPartGroup fillDocumentNumberPartGroupFromResultSet(ResultSet rs) throws SQLException {
        return JdbcDocumentNumberPartGroupDAO.fillDocumentNumberPartGroupFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 5;
    }

    @Override
    public void deleteByNetwork(final Long networkId) {
        String sql = "DELETE FROM document_number_part_group WHERE network_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, networkId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(DocumentNumberPartGroup dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<DocumentNumberPartGroup> dtos) {
        Iterator<DocumentNumberPartGroup> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, DocumentNumberPartGroup documentNumberPartGroup) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)documentNumberPartGroup.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)documentNumberPartGroup.getNetworkId());
        statement.setString(3, documentNumberPartGroup.getName());
        statement.setString(4, documentNumberPartGroup.getRendererName());
        JDBCHelper.setLong((PreparedStatement)statement, (int)5, (Number)documentNumberPartGroup.getMasterDataSetId());
    }

    @Override
    public List<DocumentNumberPartGroup> getByNetwork(Network network) {
        return this.getByNetwork(network.getId());
    }

    @Override
    public List<DocumentNumberPartGroup> getByNetwork(final Long networkId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkId);
            }
        });
    }

    @Override
    public List<DocumentNumberPartGroup> getByMasterDataSet(MasterDataSet masterDataSet) {
        return this.getByMasterDataSet(masterDataSet.getId());
    }

    @Override
    public List<DocumentNumberPartGroup> getByMasterDataSet(final Long masterDataSetId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"master_data_set_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, masterDataSetId);
            }
        });
    }

    @Override
    public List<DocumentNumberPartGroup> getByNetworks(Collection<Long> networkId) {
        if (networkId.isEmpty()) {
            return new ArrayList<DocumentNumberPartGroup>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkId.size()];
        int n = 0;
        Iterator<Long> it = networkId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<DocumentNumberPartGroup> getByMasterDataSets(Collection<Long> masterDataSetId) {
        if (masterDataSetId.isEmpty()) {
            return new ArrayList<DocumentNumberPartGroup>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[masterDataSetId.size()];
        int n = 0;
        Iterator<Long> it = masterDataSetId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"master_data_set_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

