/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.PlanningNotificationAttachment;
import at.cdes.api.dto.WorkflowActivityPositionResult;
import at.cdes.api.dto.WorkflowActivityPositionResultMap;
import at.cdes.impl.dao.WorkflowActivityPositionResultMapDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcWorkflowActivityPositionResultMapDAO
extends AbstrIdDAO<WorkflowActivityPositionResultMap>
implements WorkflowActivityPositionResultMapDAO {
    public JdbcWorkflowActivityPositionResultMapDAO() {
        super(WorkflowActivityPositionResultMap.class, "resultId", "workflow_activity_position_result_map", new String[]{"result_id", "attachment_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcWorkflowActivityPositionResultMapDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "result_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "attachment_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcWorkflowActivityPositionResultMapDAO.getSelectClauseForDto("workflow_activity_position_result_map", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcWorkflowActivityPositionResultMapDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".result_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "result_id") + "," + entityLocalName + ".attachment_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "attachment_id") + " ";
    }

    protected WorkflowActivityPositionResultMap fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        WorkflowActivityPositionResultMap workflowActivityPositionResultMap = new WorkflowActivityPositionResultMap();
        workflowActivityPositionResultMap.setResultId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        workflowActivityPositionResultMap.setAttachmentId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return workflowActivityPositionResultMap;
    }

    public static WorkflowActivityPositionResultMap fillWorkflowActivityPositionResultMapFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        WorkflowActivityPositionResultMap workflowActivityPositionResultMap = new WorkflowActivityPositionResultMap();
        workflowActivityPositionResultMap.setResultId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        workflowActivityPositionResultMap.setAttachmentId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return workflowActivityPositionResultMap;
    }

    public static WorkflowActivityPositionResultMap fillWorkflowActivityPositionResultMapFromResultSet(ResultSet rs) throws SQLException {
        return JdbcWorkflowActivityPositionResultMapDAO.fillWorkflowActivityPositionResultMapFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 2;
    }

    @Override
    public void deleteByResult(final Long resultId) {
        String sql = "DELETE FROM workflow_activity_position_result_map WHERE result_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, resultId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(WorkflowActivityPositionResultMap dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<WorkflowActivityPositionResultMap> dtos) {
        Iterator<WorkflowActivityPositionResultMap> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, WorkflowActivityPositionResultMap workflowActivityPositionResultMap) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)workflowActivityPositionResultMap.getResultId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)workflowActivityPositionResultMap.getAttachmentId());
    }

    @Override
    public List<WorkflowActivityPositionResultMap> getByResult(WorkflowActivityPositionResult workflowActivityPositionResult) {
        return this.getByResult(workflowActivityPositionResult.getWorkflowActivityId());
    }

    @Override
    public List<WorkflowActivityPositionResultMap> getByResult(final Long workflowActivityPositionResultId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"result_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, workflowActivityPositionResultId);
            }
        });
    }

    @Override
    public List<WorkflowActivityPositionResultMap> getByAttachment(PlanningNotificationAttachment planningNotificationAttachment) {
        return this.getByAttachment(planningNotificationAttachment.getId());
    }

    @Override
    public List<WorkflowActivityPositionResultMap> getByAttachment(final Long planningNotificationAttachmentId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"attachment_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, planningNotificationAttachmentId);
            }
        });
    }

    @Override
    public List<WorkflowActivityPositionResultMap> getByResults(Collection<Long> workflowActivityPositionResultId) {
        if (workflowActivityPositionResultId.isEmpty()) {
            return new ArrayList<WorkflowActivityPositionResultMap>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[workflowActivityPositionResultId.size()];
        int n = 0;
        Iterator<Long> it = workflowActivityPositionResultId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"result_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<WorkflowActivityPositionResultMap> getByAttachments(Collection<Long> planningNotificationAttachmentId) {
        if (planningNotificationAttachmentId.isEmpty()) {
            return new ArrayList<WorkflowActivityPositionResultMap>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[planningNotificationAttachmentId.size()];
        int n = 0;
        Iterator<Long> it = planningNotificationAttachmentId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"attachment_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

