/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.db;

import javax.sql.DataSource;
import org.clazzes.util.aop.DAOException;
import org.clazzes.util.aop.jdbc.JdbcTransactionInterceptor;
import org.clazzes.util.osgi.ServiceMapListener;
import org.clazzes.util.sql.dao.HibernateHiLoIdGenerator;

public class DBSetup
implements ServiceMapListener {
    private String dataSourceName;
    private JdbcTransactionInterceptor jdbcInterceptor;
    private JdbcTransactionInterceptor reducedIsolationJdbcInterceptor;
    private HibernateHiLoIdGenerator idGenerator;

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public void setJdbcInterceptor(JdbcTransactionInterceptor jdbcInterceptor) {
        this.jdbcInterceptor = jdbcInterceptor;
    }

    public void setReducedIsolationJdbcInterceptor(JdbcTransactionInterceptor reducedIsolationJdbcInterceptor) {
        this.reducedIsolationJdbcInterceptor = reducedIsolationJdbcInterceptor;
    }

    public void setIdGenerator(HibernateHiLoIdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public void serviceBound(String key, Object service) {
        if (!this.dataSourceName.equals(key)) {
            return;
        }
        DataSource dataSource = (DataSource)service;
        this.jdbcInterceptor.setDataSource(dataSource);
        this.reducedIsolationJdbcInterceptor.setDataSource(dataSource);
        this.idGenerator.setDataSource(dataSource);
        this.idGenerator.setIdTableName("hi_value");
        this.idGenerator.setNextIdColumnName("next_value");
        try {
            this.idGenerator.initialize();
        }
        catch (Throwable e) {
            throw new DAOException(e);
        }
    }

    public void serviceUnbound(String key, Object service) {
        this.jdbcInterceptor.setDataSource(null);
        this.reducedIsolationJdbcInterceptor.setDataSource(null);
        this.idGenerator.setDataSource(null);
    }
}

