/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.BaseTask;
import at.cdes.api.dto.TaskMonitoringResult;
import at.cdes.impl.dao.TaskMonitoringResultDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcTaskMonitoringResultDAO
extends AbstrIdDAO<TaskMonitoringResult>
implements TaskMonitoringResultDAO {
    public JdbcTaskMonitoringResultDAO() {
        super(TaskMonitoringResult.class, "id", "task_monitoring_result", new String[]{"id", "task_id", "date"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcTaskMonitoringResultDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "task_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "date") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcTaskMonitoringResultDAO.getSelectClauseForDto("task_monitoring_result", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcTaskMonitoringResultDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".task_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "task_id") + "," + entityLocalName + ".date" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "date") + " ";
    }

    protected TaskMonitoringResult fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        TaskMonitoringResult taskMonitoringResult = new TaskMonitoringResult();
        taskMonitoringResult.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        taskMonitoringResult.setTaskId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        taskMonitoringResult.setDate(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        return taskMonitoringResult;
    }

    public static TaskMonitoringResult fillTaskMonitoringResultFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        TaskMonitoringResult taskMonitoringResult = new TaskMonitoringResult();
        taskMonitoringResult.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        taskMonitoringResult.setTaskId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        taskMonitoringResult.setDate(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return taskMonitoringResult;
    }

    public static TaskMonitoringResult fillTaskMonitoringResultFromResultSet(ResultSet rs) throws SQLException {
        return JdbcTaskMonitoringResultDAO.fillTaskMonitoringResultFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 3;
    }

    public int update(TaskMonitoringResult dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<TaskMonitoringResult> dtos) {
        Iterator<TaskMonitoringResult> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, TaskMonitoringResult taskMonitoringResult) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)taskMonitoringResult.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)taskMonitoringResult.getTaskId());
        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)3, (Double)taskMonitoringResult.getDate());
    }

    @Override
    public List<TaskMonitoringResult> getByTask(BaseTask baseTask) {
        return this.getByTask(baseTask.getId());
    }

    @Override
    public List<TaskMonitoringResult> getByTask(final Long baseTaskId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"task_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, baseTaskId);
            }
        });
    }

    @Override
    public List<TaskMonitoringResult> getByTasks(Collection<Long> baseTaskId) {
        if (baseTaskId.isEmpty()) {
            return new ArrayList<TaskMonitoringResult>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[baseTaskId.size()];
        int n = 0;
        Iterator<Long> it = baseTaskId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"task_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

