/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.ActionInfo;
import at.cdes.api.joinDto.NetworkAction;
import at.cdes.api.joinDto.ObjectPlannerAction;
import at.cdes.api.joinDto.ProjectAction;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.action.GlobalActionHelper;
import at.cdes.impl.dao.action.NetworkActionHelper;
import at.cdes.impl.dao.action.ObjectPlannerActionHelper;
import at.cdes.impl.dao.action.ProjectActionHelper;
import at.cdes.impl.dao.jdbc.AbstractJdbcActionDAO;
import at.cdes.impl.util.ActionHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcActionDAO
extends AbstractJdbcActionDAO
implements ActionDAO {
    private static Map<Action, String> actionShortNames = new HashMap<Action, String>();
    Logger log;

    public JdbcActionDAO() {
        actionShortNames.put(Action.EDIT_PERSON, "editP");
        actionShortNames.put(Action.EDIT_PLAN_DELIVER_CATALOGUE, "ePDC");
        actionShortNames.put(Action.EDIT_PLAN_DELIVER_CATALOGUE_DATES, "ePDCd");
        actionShortNames.put(Action.EDIT_PLAN_DELIVER_CATALOGUE_START_DATE, "ePDCsd");
        actionShortNames.put(Action.EDIT_PLAN_DELIVER_CATALOGUE_END_DATE, "ePDCed");
        actionShortNames.put(Action.EDIT_PLAN_DELIVER_CATALOGUE_DATES_PROJ_CONT, "ePDCdpc");
        actionShortNames.put(Action.PLAN_DELIVER_CATALOGUE_OVERVIEW, "pdcOv");
        actionShortNames.put(Action.UPLOAD_DOCUMENT, "upDoc");
        actionShortNames.put(Action.SHOW_OBJECT_PLANNER, "sObjPl");
        actionShortNames.put(Action.SHOW_PERSON, "showP");
        this.log = LoggerFactory.getLogger(JdbcActionDAO.class);
    }

    private static String getActionShortNameForDebug(at.cdes.api.dto.Action actionFromDatabase) {
        Action action = Action.getByName((String)actionFromDatabase.getName());
        if (actionShortNames.containsKey(action)) {
            return actionShortNames.get(action);
        }
        return actionFromDatabase.getId().toString();
    }

    @Override
    public Set<Action> getObjectPlannerActions(Long organisationPersonId, Long objectPlannerId, Action ... actionNames) {
        ArrayList<Long> objectPlannerIds = new ArrayList<Long>();
        objectPlannerIds.add(objectPlannerId);
        Map<Long, Set<Action>> objectPlannerIdToActions = this.getObjectPlannerActions(organisationPersonId, objectPlannerIds, actionNames);
        HashSet foundActionNames = objectPlannerIdToActions.get(objectPlannerId);
        return foundActionNames != null ? foundActionNames : new HashSet();
    }

    @Override
    public Map<Long, Set<Action>> getObjectPlannerActions(Long organisationPersonId, Collection<Long> objectPlannerIds, Action ... actionNames) {
        long prevMillis = System.currentTimeMillis();
        List<ObjectPlannerAction> globalActions = this.getGlobalActionsForObjectPlanner(organisationPersonId, objectPlannerIds, actionNames);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Queried [" + globalActions.size() + "] global actions in [" + (System.currentTimeMillis() - prevMillis) + "ms]");
            prevMillis = System.currentTimeMillis();
        }
        List<ObjectPlannerAction> networkActions = this.getNetworkActionsForObjectPlanner(organisationPersonId, objectPlannerIds, actionNames);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Queried [" + networkActions.size() + "] network actions in [" + (System.currentTimeMillis() - prevMillis) + "ms]");
            prevMillis = System.currentTimeMillis();
        }
        List<ObjectPlannerAction> projectActions = this.getProjectActionsForObjectPlanner(organisationPersonId, objectPlannerIds, actionNames);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Queried [" + projectActions.size() + "] project actions in [" + (System.currentTimeMillis() - prevMillis) + "ms]");
            prevMillis = System.currentTimeMillis();
        }
        List<ObjectPlannerAction> objectPlannerActions = this.getObjectPlannerActionsForObjectPlanner(organisationPersonId, objectPlannerIds, actionNames);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Queried [" + objectPlannerActions.size() + "] objectPlanner actions in [" + (System.currentTimeMillis() - prevMillis) + "ms]");
            prevMillis = System.currentTimeMillis();
        }
        if (this.log.isDebugEnabled()) {
            String objectPlannerDebugString = this.getObjectPlannerDebugString(objectPlannerIds);
            String actionNameDebugString = this.getActionNameDebugString(actionNames);
            this.log.debug("Allowed actions for orgPerson [" + organisationPersonId + "]" + objectPlannerDebugString + actionNameDebugString);
        }
        return this.constructObjectPlannerToActionMapAndDebug(globalActions, networkActions, projectActions, objectPlannerActions);
    }

    @Override
    public Map<Long, Set<Action>> getObjectPlannerActionsForSubProject(final Long organisationPersonId, final Long subProjectId, final Action ... actionNames) {
        String globalSQL = GlobalActionHelper.getGlobalRuleClauseForObjectPlanner(actionNames.length);
        List globalActions = (List)this.performWithPreparedStatement(globalSQL, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ObjectPlannerAction>>(){

            public List<ObjectPlannerAction> perform(PreparedStatement statement) throws Exception {
                GlobalActionHelper.populateGlobalObjectPlannerRuleClause(statement, 1, organisationPersonId, subProjectId, actionNames);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<ObjectPlannerAction> ret = new ArrayList<ObjectPlannerAction>();
                while (resultSet.next()) {
                    ret.add(GlobalActionHelper.fillObjectPlannerActionFromResultSet(resultSet));
                }
                return ret;
            }
        });
        String networkSQL = NetworkActionHelper.getNetworkRuleClauseForObjectPlanner(actionNames.length);
        List networkActions = (List)this.performWithPreparedStatement(networkSQL, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ObjectPlannerAction>>(){

            public List<ObjectPlannerAction> perform(PreparedStatement statement) throws Exception {
                NetworkActionHelper.populateNetworkRuleClauseForObjectPlanner(statement, 1, organisationPersonId, subProjectId, actionNames);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<ObjectPlannerAction> ret = new ArrayList<ObjectPlannerAction>();
                while (resultSet.next()) {
                    ret.add(NetworkActionHelper.fillObjectPlannerActionFromResultSet(resultSet));
                }
                return ret;
            }
        });
        String projectSQL = ProjectActionHelper.getProjectRuleClauseForObjectPlanner(actionNames.length);
        List projectActions = (List)this.performWithPreparedStatement(projectSQL, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ObjectPlannerAction>>(){

            public List<ObjectPlannerAction> perform(PreparedStatement statement) throws Exception {
                ProjectActionHelper.populateProjectRuleClauseForObjectPlanner(statement, 1, organisationPersonId, subProjectId, actionNames);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<ObjectPlannerAction> ret = new ArrayList<ObjectPlannerAction>();
                while (resultSet.next()) {
                    ret.add(ProjectActionHelper.fillObjectPlannerActionFromResultSet(resultSet));
                }
                return ret;
            }
        });
        String objectPlannerSQL = ObjectPlannerActionHelper.getObjectPlannerRuleClause(actionNames.length);
        List objectPlannerActions = (List)this.performWithPreparedStatement(objectPlannerSQL, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ObjectPlannerAction>>(){

            public List<ObjectPlannerAction> perform(PreparedStatement statement) throws Exception {
                ObjectPlannerActionHelper.populateObjectPlannerRuleClause(statement, 1, organisationPersonId, subProjectId, actionNames);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<ObjectPlannerAction> ret = new ArrayList<ObjectPlannerAction>();
                while (resultSet.next()) {
                    ret.add(ObjectPlannerActionHelper.fillObjectPlannerActionFromResultSet(resultSet));
                }
                return ret;
            }
        });
        if (this.log.isDebugEnabled()) {
            String actionNameDebugString = this.getActionNameDebugString(actionNames);
            this.log.debug("Allowed actions for subPrj [" + subProjectId + "], orgPerson [" + organisationPersonId + "]" + actionNameDebugString);
        }
        return this.constructObjectPlannerToActionMapAndDebug(globalActions, networkActions, projectActions, objectPlannerActions);
    }

    @Override
    public Map<Long, Set<Action>> getNetworkActions(final Long organisationPersonId, final Action ... actionNames) {
        String actionName;
        Long networkId;
        String globalSQL = GlobalActionHelper.getGlobalRuleClauseForAllNetworks(actionNames.length);
        List globalActions = (List)this.performWithPreparedStatement(globalSQL, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<NetworkAction>>(){

            public List<NetworkAction> perform(PreparedStatement statement) throws Exception {
                GlobalActionHelper.populateGlobalRuleClauseForAllNetworks(statement, 1, organisationPersonId, actionNames);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<NetworkAction> ret = new ArrayList<NetworkAction>();
                while (resultSet.next()) {
                    ret.add(GlobalActionHelper.fillNetworkActionFromResultSet(resultSet));
                }
                return ret;
            }
        });
        String networkSQL = NetworkActionHelper.getNetworkRuleClauseForAllNetworks(actionNames.length);
        List networkActions = (List)this.performWithPreparedStatement(networkSQL, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<NetworkAction>>(){

            public List<NetworkAction> perform(PreparedStatement statement) throws Exception {
                NetworkActionHelper.populateNetworkRuleClauseForAllNetworks(statement, 1, organisationPersonId, actionNames);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<NetworkAction> ret = new ArrayList<NetworkAction>();
                while (resultSet.next()) {
                    ret.add(NetworkActionHelper.fillNetworkActionFromResultSet(resultSet));
                }
                return ret;
            }
        });
        HashMap<Long, Set<Action>> networkIdToActions = new HashMap<Long, Set<Action>>();
        for (NetworkAction networkAction : globalActions) {
            networkId = networkAction.getNetworkId();
            actionName = networkAction.getActionName();
            if (!networkIdToActions.containsKey(networkId)) {
                networkIdToActions.put(networkId, new HashSet());
            }
            ((Set)networkIdToActions.get(networkId)).add(Action.getByName((String)actionName));
        }
        for (NetworkAction action : networkActions) {
            networkId = action.getNetworkId();
            actionName = action.getActionName();
            if (!networkIdToActions.containsKey(networkId)) {
                networkIdToActions.put(networkId, new HashSet());
            }
            ((Set)networkIdToActions.get(networkId)).add(Action.getByName((String)actionName));
        }
        return networkIdToActions;
    }

    @Override
    public Set<Action> getGlobalActions(final Long organisationPersonId, final Action ... actionNames) {
        final ArrayList networkIds = new ArrayList();
        String globalSQL = GlobalActionHelper.getGlobalRuleClauseForNetwork(networkIds.size(), actionNames.length);
        List globalActions = (List)this.performWithPreparedStatement(globalSQL, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<NetworkAction>>(){

            public List<NetworkAction> perform(PreparedStatement statement) throws Exception {
                GlobalActionHelper.populateGlobalNetworkRuleClause(statement, 1, organisationPersonId, networkIds, actionNames);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<NetworkAction> ret = new ArrayList<NetworkAction>();
                while (resultSet.next()) {
                    ret.add(GlobalActionHelper.fillNetworkActionFromResultSet(resultSet));
                }
                return ret;
            }
        });
        HashSet<Action> actions = new HashSet<Action>();
        for (NetworkAction networkAction : globalActions) {
            actions.add(Action.getByName((String)networkAction.getActionName()));
        }
        return actions;
    }

    private String getObjectPlannerActionKey(ObjectPlannerAction objectPlannerAction) {
        return objectPlannerAction.getActionId().toString() + "_" + objectPlannerAction.getObjectPlannerId().toString();
    }

    private Map<Long, Set<Action>> constructObjectPlannerToActionMapAndDebug(List<ObjectPlannerAction> globalActions, List<ObjectPlannerAction> networkActions, List<ObjectPlannerAction> projectActions, List<ObjectPlannerAction> objectPlannerActions) {
        String outputString;
        String projectAccessString;
        String checkMemberString;
        String actionString;
        ArrayList<Object> allActions = new ArrayList<Object>();
        allActions.addAll(globalActions);
        allActions.addAll(networkActions);
        HashSet<String> objectPlannerActionKeys = new HashSet<String>();
        for (ObjectPlannerAction objectPlannerAction : objectPlannerActions) {
            String key = this.getObjectPlannerActionKey(objectPlannerAction);
            objectPlannerActionKeys.add(key);
        }
        ArrayList<ObjectPlannerAction> passedProjectActions = new ArrayList<ObjectPlannerAction>();
        for (ObjectPlannerAction projectAction : projectActions) {
            if (projectAction.getDestActionRuleDestinationContextId() == 4L) {
                String string = this.getObjectPlannerActionKey(projectAction);
                if (!objectPlannerActionKeys.contains(string)) continue;
                passedProjectActions.add(projectAction);
                continue;
            }
            passedProjectActions.add(projectAction);
        }
        allActions.addAll(passedProjectActions);
        HashMap<Long, Set<Action>> hashMap = new HashMap<Long, Set<Action>>();
        for (ObjectPlannerAction objectPlannerAction : allActions) {
            Long objectPlannerId = objectPlannerAction.getObjectPlannerId();
            Action actionName = Action.getByName((String)objectPlannerAction.getActionName());
            if (!hashMap.containsKey(objectPlannerId)) {
                hashMap.put(objectPlannerId, new HashSet());
            }
            ((Set)hashMap.get(objectPlannerId)).add(actionName);
        }
        if (this.log.isTraceEnabled()) {
            for (ObjectPlannerAction objectPlannerAction : globalActions) {
                actionString = JdbcActionDAO.getActionShortNameForDebug(objectPlannerAction.getAction());
                String string = checkMemberString = objectPlannerAction.getDestActionRuleCheckMember() != null && objectPlannerAction.getDestActionRuleCheckMember() == true ? "T" : "F";
                projectAccessString = objectPlannerAction.getProjectAccess() == 0 ? "AI" : (objectPlannerAction.getProjectAccess() == 1 ? "RO" : (objectPlannerAction.getProjectAccess() == 2 ? "RW" : "??"));
                outputString = String.format("ObjPl %7s G %7s DCtx=%1s, CM=%1s, Net=%7s, Prj=%2s: GRole=%s", objectPlannerAction.getObjectPlannerId(), actionString, objectPlannerAction.getDestActionRuleDestinationContextId(), checkMemberString, objectPlannerAction.getNetworkId(), projectAccessString, objectPlannerAction.getGlobalRoleId());
                this.log.trace(outputString);
            }
        }
        if (this.log.isTraceEnabled()) {
            for (ObjectPlannerAction objectPlannerAction : networkActions) {
                actionString = JdbcActionDAO.getActionShortNameForDebug(objectPlannerAction.getAction());
                String string = checkMemberString = objectPlannerAction.getDestActionRuleCheckMember() != null && objectPlannerAction.getDestActionRuleCheckMember() == true ? "T" : "F";
                projectAccessString = objectPlannerAction.getProjectAccess() == 0 ? "AI" : (objectPlannerAction.getProjectAccess() == 1 ? "RO" : (objectPlannerAction.getProjectAccess() == 2 ? "RW" : "??"));
                outputString = String.format("ObjPl %7s N %7s DCtx=%1s, CM=%1s, Net=%7s, Prj=%2s: DRole=%s, ARole=%s, NetOrg=%s, NetPer=%s", objectPlannerAction.getObjectPlannerId(), actionString, objectPlannerAction.getDestActionRuleDestinationContextId(), checkMemberString, objectPlannerAction.getNetworkId(), projectAccessString, objectPlannerAction.getDefaultRoleId(), objectPlannerAction.getAdminRoleId(), objectPlannerAction.getNetworkOrganisationOrganisationId(), objectPlannerAction.getNetworkPersonId());
                this.log.trace(outputString);
            }
        }
        if (this.log.isTraceEnabled()) {
            for (ObjectPlannerAction objectPlannerAction : passedProjectActions) {
                actionString = JdbcActionDAO.getActionShortNameForDebug(objectPlannerAction.getAction());
                String string = checkMemberString = objectPlannerAction.getDestActionRuleCheckMember() != null && objectPlannerAction.getDestActionRuleCheckMember() == true ? "T" : "F";
                projectAccessString = objectPlannerAction.getProjectAccess() == 0 ? "AI" : (objectPlannerAction.getProjectAccess() == 1 ? "RO" : (objectPlannerAction.getProjectAccess() == 2 ? "RW" : "??"));
                outputString = String.format("ObjPl %7s P %7s DCtx=%1s, CM=%1s, Net=%7s, Prj=%2s: ORole=%s, Participant=%s", objectPlannerAction.getObjectPlannerId(), actionString, objectPlannerAction.getDestActionRuleDestinationContextId(), checkMemberString, objectPlannerAction.getNetworkId(), projectAccessString, objectPlannerAction.getOrgRoleId(), objectPlannerAction.getProjectParticipantId());
                this.log.trace(outputString);
            }
        }
        return hashMap;
    }

    private String getObjectPlannerDebugString(Collection<Long> objectPlannerIds) {
        String s = ", objectPlannerIds: [";
        boolean first = true;
        for (Long objectPlannerId : objectPlannerIds) {
            s = s + (first ? "" : ", ") + objectPlannerId;
            first = false;
        }
        s = s + "] ";
        return s;
    }

    private String getActionNameDebugString(Action ... actionNames) {
        String actionNameDebugString;
        if (actionNames.length == 0) {
            actionNameDebugString = ", no action restriction.";
        } else if (actionNames.length <= 5) {
            actionNameDebugString = ", actions ";
            for (Action actionName : actionNames) {
                actionNameDebugString = actionNameDebugString + "[" + actionName.getName() + "]";
            }
        } else {
            actionNameDebugString = ", " + actionNames.length + " actions.";
        }
        return actionNameDebugString;
    }

    private String getNetworkDebugString(List<Long> networkIds) {
        String s = "";
        for (int n = 0; n < networkIds.size(); ++n) {
            s = s + networkIds.get(n) + (n < networkIds.size() - 1 ? ", " : "");
        }
        return s;
    }

    @Override
    public Map<Long, Set<Action>> getNetworkToActionMap(Long organisationPersonId, Long networkId, Action ... actionNames) {
        ArrayList<Long> networkIds = new ArrayList<Long>();
        networkIds.add(networkId);
        return this.getNetworkToActionMap(organisationPersonId, networkIds, actionNames);
    }

    @Override
    public Map<Long, Set<Action>> getNetworkToActionMap(final Long organisationPersonId, final List<Long> networkIds, final Action ... actionNames) {
        String outputString;
        String checkMemberString;
        String actionString;
        String actionName;
        Long networkId;
        if (networkIds == null) {
            throw new IllegalArgumentException("Cannot query networkToActionMap without network restriction.  Please provide at least one network.");
        }
        if (networkIds.size() == 0) {
            return new HashMap<Long, Set<Action>>();
        }
        String globalSQL = GlobalActionHelper.getGlobalRuleClauseForNetwork(networkIds.size(), actionNames.length);
        List globalActions = (List)this.performWithPreparedStatement(globalSQL, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<NetworkAction>>(){

            public List<NetworkAction> perform(PreparedStatement statement) throws Exception {
                GlobalActionHelper.populateGlobalNetworkRuleClause(statement, 1, organisationPersonId, networkIds, actionNames);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<NetworkAction> ret = new ArrayList<NetworkAction>();
                while (resultSet.next()) {
                    ret.add(GlobalActionHelper.fillNetworkActionFromResultSet(resultSet));
                }
                return ret;
            }
        });
        String networkSQL = NetworkActionHelper.getNetworkRuleClauseForNetwork(networkIds.size(), actionNames.length);
        List networkActions = (List)this.performWithPreparedStatement(networkSQL, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<NetworkAction>>(){

            public List<NetworkAction> perform(PreparedStatement statement) throws Exception {
                NetworkActionHelper.populateNetworkRuleClauseForNetwork(statement, 1, organisationPersonId, networkIds, actionNames);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<NetworkAction> ret = new ArrayList<NetworkAction>();
                while (resultSet.next()) {
                    ret.add(NetworkActionHelper.fillNetworkActionFromResultSet(resultSet));
                }
                return ret;
            }
        });
        HashMap<Long, Set<Action>> networkIdToActions = new HashMap<Long, Set<Action>>();
        for (NetworkAction action : globalActions) {
            networkId = action.getNetworkId();
            actionName = action.getActionName();
            if (!networkIdToActions.containsKey(networkId)) {
                networkIdToActions.put(networkId, new HashSet());
            }
            ((Set)networkIdToActions.get(networkId)).add(Action.getByName((String)actionName));
        }
        for (NetworkAction action : networkActions) {
            networkId = action.getNetworkId();
            actionName = action.getActionName();
            if (!networkIdToActions.containsKey(networkId)) {
                networkIdToActions.put(networkId, new HashSet());
            }
            ((Set)networkIdToActions.get(networkId)).add(Action.getByName((String)actionName));
        }
        if (this.log.isDebugEnabled()) {
            String networkIdString = this.getNetworkDebugString(networkIds);
            String actionNameDebugString = this.getActionNameDebugString(actionNames);
            this.log.debug("Allowed actions for network [" + networkIdString + "], orgPerson [" + organisationPersonId + "]" + actionNameDebugString);
        }
        if (this.log.isDebugEnabled()) {
            for (NetworkAction action : globalActions) {
                actionString = JdbcActionDAO.getActionShortNameForDebug(action.getAction());
                checkMemberString = action.getDestActionRuleCheckMember() != null && action.getDestActionRuleCheckMember() == true ? "T" : "F";
                outputString = String.format("G %7s DCtx=%1s, CM=%1s, Net=%7s: GRole=%s", actionString, action.getDestActionRuleDestinationContextId(), checkMemberString, action.getNetworkId(), action.getGlobalRoleId());
                this.log.debug(outputString);
            }
        }
        if (this.log.isDebugEnabled()) {
            for (NetworkAction action : networkActions) {
                actionString = JdbcActionDAO.getActionShortNameForDebug(action.getAction());
                checkMemberString = action.getDestActionRuleCheckMember() != null && action.getDestActionRuleCheckMember() == true ? "T" : "F";
                outputString = String.format("N %7s DCtx=%1s, CM=%1s, Net=%7s: DRole=%s, ARole=%s, NetOrg=%s, NetPer=%s", actionString, action.getDestActionRuleDestinationContextId(), checkMemberString, action.getNetworkId(), action.getDefaultRoleId(), action.getAdminRoleId(), action.getNetworkOrganisationOrganisationId(), action.getNetworkPersonId());
                this.log.debug(outputString);
            }
        }
        return networkIdToActions;
    }

    private List<ProjectAction> getGlobalActionsForProject(final Long organisationPersonId, final Collection<Long> projectIds, final Action ... actionNames) {
        String globalSQL = GlobalActionHelper.getGlobalRuleClauseForProject(projectIds != null ? Integer.valueOf(projectIds.size()) : null, actionNames.length);
        List globalActions = (List)this.performWithPreparedStatement(globalSQL, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ProjectAction>>(){

            public List<ProjectAction> perform(PreparedStatement statement) throws Exception {
                GlobalActionHelper.populateGlobalProjectRuleClause(statement, 1, organisationPersonId, projectIds, actionNames);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<ProjectAction> ret = new ArrayList<ProjectAction>();
                while (resultSet.next()) {
                    ret.add(GlobalActionHelper.fillProjectActionFromResultSet(resultSet));
                }
                return ret;
            }
        });
        return globalActions;
    }

    private List<ProjectAction> getNetworkActionsForProject(final Long organisationPersonId, final Collection<Long> projectIds, final Action ... actionNames) {
        String networkSQL = NetworkActionHelper.getNetworkRuleClauseForProject(projectIds != null ? Integer.valueOf(projectIds.size()) : null, actionNames.length);
        List networkActions = (List)this.performWithPreparedStatement(networkSQL, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ProjectAction>>(){

            public List<ProjectAction> perform(PreparedStatement statement) throws Exception {
                NetworkActionHelper.populateNetworkRuleClauseForProject(statement, 1, organisationPersonId, projectIds, actionNames);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<ProjectAction> ret = new ArrayList<ProjectAction>();
                while (resultSet.next()) {
                    ret.add(NetworkActionHelper.fillProjectActionFromResultSet(resultSet));
                }
                return ret;
            }
        });
        return networkActions;
    }

    private List<ProjectAction> getProjectActionsForProject(final Long organisationPersonId, final Collection<Long> projectIds, final Action ... actionNames) {
        String projectSQL = ProjectActionHelper.getProjectRuleClauseForProject(projectIds != null ? Integer.valueOf(projectIds.size()) : null, actionNames.length);
        List projectActions = (List)this.performWithPreparedStatement(projectSQL, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ProjectAction>>(){

            public List<ProjectAction> perform(PreparedStatement statement) throws Exception {
                ProjectActionHelper.populateProjectRuleClauseForProject(statement, 1, organisationPersonId, projectIds, actionNames);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<ProjectAction> ret = new ArrayList<ProjectAction>();
                while (resultSet.next()) {
                    ret.add(ProjectActionHelper.fillProjectActionFromResultSet(resultSet));
                }
                return ret;
            }
        });
        return projectActions;
    }

    @Override
    public Map<Long, Set<Action>> getActionsForProjects(Long organisationPersonId, Collection<Long> projectIds, Action ... actionNames) {
        if (projectIds != null && projectIds.size() == 0 || actionNames == null) {
            return new HashMap<Long, Set<Action>>();
        }
        List<ProjectAction> globalActions = this.getGlobalActionsForProject(organisationPersonId, projectIds, actionNames);
        List<ProjectAction> networkActions = this.getNetworkActionsForProject(organisationPersonId, projectIds, actionNames);
        List<ProjectAction> projectActions = this.getProjectActionsForProject(organisationPersonId, projectIds, actionNames);
        ArrayList<ProjectAction> allActions = new ArrayList<ProjectAction>();
        allActions.addAll(globalActions);
        allActions.addAll(networkActions);
        allActions.addAll(projectActions);
        HashMap<Long, Set<Action>> retMap = new HashMap<Long, Set<Action>>();
        for (ProjectAction projectAction : allActions) {
            Long projectId = projectAction.getProjectId();
            String actionName = projectAction.getActionName();
            if (!retMap.containsKey(projectId)) {
                retMap.put(projectId, new HashSet());
            }
            ((Set)retMap.get(projectId)).add(Action.getByName((String)actionName));
        }
        return retMap;
    }

    @Override
    public Set<Action> getActionsForProject(Long organisationPersonId, Long projectId, Action ... actionNames) {
        ArrayList<Long> projectIds = new ArrayList<Long>();
        projectIds.add(projectId);
        List<ProjectAction> globalActions = this.getGlobalActionsForProject(organisationPersonId, projectIds, actionNames);
        List<ProjectAction> networkActions = this.getNetworkActionsForProject(organisationPersonId, projectIds, actionNames);
        List<ProjectAction> projectActions = this.getProjectActionsForProject(organisationPersonId, projectIds, actionNames);
        HashSet<Action> retSet = new HashSet<Action>();
        for (ProjectAction action : globalActions) {
            retSet.add(Action.getByName((String)action.getActionName()));
        }
        for (ProjectAction action : networkActions) {
            retSet.add(Action.getByName((String)action.getActionName()));
        }
        for (ProjectAction action : projectActions) {
            retSet.add(Action.getByName((String)action.getActionName()));
        }
        this.logProjectActions(actionNames, organisationPersonId, projectId, globalActions, networkActions, projectActions);
        return retSet;
    }

    @Override
    public Map<Action, ActionInfo> getActionsForProjectMap(Long organisationPersonId, Long projectId, Action ... actionNames) {
        Action action;
        ArrayList<Long> projectIds = new ArrayList<Long>();
        projectIds.add(projectId);
        List<ProjectAction> globalActions = this.getGlobalActionsForProject(organisationPersonId, projectIds, actionNames);
        List<ProjectAction> networkActions = this.getNetworkActionsForProject(organisationPersonId, projectIds, actionNames);
        List<ProjectAction> projectActions = this.getProjectActionsForProject(organisationPersonId, projectIds, actionNames);
        HashMap<Action, ActionInfo> retMap = new HashMap<Action, ActionInfo>();
        for (ProjectAction globalAction : globalActions) {
            action = Action.getByName((String)globalAction.getActionName());
            if (action == null) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.warn("globalAction [" + globalAction.getActionName() + "] not includet in enum of at.cdes.api.voc.action!");
                continue;
            }
            if (!retMap.containsKey(action)) {
                retMap.put(action, ActionHelper.constructActionInfo(globalAction.getAction()));
            }
            ((ActionInfo)retMap.get(action)).setGlobalContext(Boolean.valueOf(true));
        }
        for (ProjectAction networkAction : networkActions) {
            action = Action.getByName((String)networkAction.getActionName());
            if (action == null) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.warn("networkAction [" + networkAction.getActionName() + "] not includet in enum of at.cdes.api.voc.action!");
                continue;
            }
            if (!retMap.containsKey(action)) {
                retMap.put(action, ActionHelper.constructActionInfo(networkAction.getAction()));
            }
            ((ActionInfo)retMap.get(action)).setNetworkContext(Boolean.valueOf(true));
        }
        for (ProjectAction projectAction : projectActions) {
            action = Action.getByName((String)projectAction.getActionName());
            if (action == null) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.warn("projectAction [" + projectAction.getActionName() + "] not includet in enum of at.cdes.api.voc.action!");
                continue;
            }
            if (!retMap.containsKey(action)) {
                retMap.put(action, ActionHelper.constructActionInfo(projectAction.getAction()));
            }
            ((ActionInfo)retMap.get(action)).setProjectContext(Boolean.valueOf(true));
        }
        this.logProjectActions(actionNames, organisationPersonId, projectId, globalActions, networkActions, projectActions);
        return retMap;
    }

    private void logProjectActions(Action[] actionNames, Long organisationPersonId, Long projectId, List<ProjectAction> globalActions, List<ProjectAction> networkActions, List<ProjectAction> projectActions) {
        String outputString;
        String projectAccessString;
        String checkMemberString;
        String actionString;
        if (this.log.isDebugEnabled()) {
            String actionNameDebugString = this.getActionNameDebugString(actionNames);
            this.log.debug("Allowed actions for prj [" + projectId + "], orgPerson [" + organisationPersonId + "]" + actionNameDebugString);
        }
        if (this.log.isDebugEnabled()) {
            for (ProjectAction action : globalActions) {
                actionString = JdbcActionDAO.getActionShortNameForDebug(action.getAction());
                String string = checkMemberString = action.getDestActionRuleCheckMember() != null && action.getDestActionRuleCheckMember() == true ? "T" : "F";
                projectAccessString = action.getProjectAccess() == 0 ? "AI" : (action.getProjectAccess() == 1 ? "RO" : (action.getProjectAccess() == 2 ? "RW" : "??"));
                outputString = String.format("G %7s DCtx=%1s, CM=%1s, Net=%7s, Prj=(%7s, %2s): GRole=%s", actionString, action.getDestActionRuleDestinationContextId(), checkMemberString, action.getNetworkId(), action.getProjectId(), projectAccessString, action.getGlobalRoleId());
                this.log.debug(outputString);
            }
        }
        if (this.log.isDebugEnabled()) {
            for (ProjectAction action : networkActions) {
                actionString = JdbcActionDAO.getActionShortNameForDebug(action.getAction());
                String string = checkMemberString = action.getDestActionRuleCheckMember() != null && action.getDestActionRuleCheckMember() == true ? "T" : "F";
                projectAccessString = action.getProjectAccess() == 0 ? "AI" : (action.getProjectAccess() == 1 ? "RO" : (action.getProjectAccess() == 2 ? "RW" : "??"));
                outputString = String.format("N %7s DCtx=%1s, CM=%1s, Net=%7s, Prj=(%7s, %2s): DRole=%s, ARole=%s, NetOrg=%s, NetPer=%s", actionString, action.getDestActionRuleDestinationContextId(), checkMemberString, action.getNetworkId(), action.getProjectId(), projectAccessString, action.getDefaultRoleId(), action.getAdminRoleId(), action.getNetworkOrganisationOrganisationId(), action.getNetworkPersonId());
                this.log.debug(outputString);
            }
        }
        if (this.log.isDebugEnabled()) {
            for (ProjectAction action : projectActions) {
                actionString = JdbcActionDAO.getActionShortNameForDebug(action.getAction());
                String string = checkMemberString = action.getDestActionRuleCheckMember() != null && action.getDestActionRuleCheckMember() == true ? "T" : "F";
                projectAccessString = action.getProjectAccess() == 0 ? "AI" : (action.getProjectAccess() == 1 ? "RO" : (action.getProjectAccess() == 2 ? "RW" : "??"));
                outputString = String.format("P %7s DCtx=%1s, CM=%1s, Net=%7s, Prj=(%7s, %2s): ORole=%s, Participant=%s", actionString, action.getDestActionRuleDestinationContextId(), checkMemberString, action.getNetworkId(), action.getProjectId(), projectAccessString, action.getOrgRoleId(), action.getProjectParticipantId());
                this.log.debug(outputString);
            }
        }
    }

    private List<ObjectPlannerAction> getGlobalActionsForObjectPlanner(final Long organisationPersonId, final Collection<Long> objectPlannerIds, final Action ... actionNames) {
        String globalSQL = GlobalActionHelper.getGlobalRuleClauseForObjectPlannerGivenObjectPlanners(objectPlannerIds.size(), actionNames.length);
        List globalActions = (List)this.performWithPreparedStatement(globalSQL, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ObjectPlannerAction>>(){

            public List<ObjectPlannerAction> perform(PreparedStatement statement) throws Exception {
                GlobalActionHelper.populateGlobalObjectPlannerRuleClause(statement, 1, organisationPersonId, objectPlannerIds, actionNames);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<ObjectPlannerAction> ret = new ArrayList<ObjectPlannerAction>();
                while (resultSet.next()) {
                    ret.add(GlobalActionHelper.fillObjectPlannerActionFromResultSet(resultSet));
                }
                return ret;
            }
        });
        return globalActions;
    }

    private List<ObjectPlannerAction> getNetworkActionsForObjectPlanner(final Long organisationPersonId, final Collection<Long> objectPlannerIds, final Action ... actionNames) {
        String networkSQL = NetworkActionHelper.getNetworkRuleClauseForObjectPlannerGivenObjectPlanners(objectPlannerIds.size(), actionNames.length);
        List networkActions = (List)this.performWithPreparedStatement(networkSQL, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ObjectPlannerAction>>(){

            public List<ObjectPlannerAction> perform(PreparedStatement statement) throws Exception {
                NetworkActionHelper.populateNetworkRuleClauseForObjectPlanner(statement, 1, organisationPersonId, objectPlannerIds, actionNames);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<ObjectPlannerAction> ret = new ArrayList<ObjectPlannerAction>();
                while (resultSet.next()) {
                    ret.add(NetworkActionHelper.fillObjectPlannerActionFromResultSet(resultSet));
                }
                return ret;
            }
        });
        return networkActions;
    }

    private List<ObjectPlannerAction> getProjectActionsForObjectPlanner(final Long organisationPersonId, final Collection<Long> objectPlannerIds, final Action ... actionNames) {
        String projectSQL = ProjectActionHelper.getProjectRuleClauseForObjectPlanner(objectPlannerIds.size(), actionNames.length);
        List projectActions = (List)this.performWithPreparedStatement(projectSQL, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ObjectPlannerAction>>(){

            public List<ObjectPlannerAction> perform(PreparedStatement statement) throws Exception {
                ProjectActionHelper.populateProjectRuleClauseForObjectPlanner(statement, 1, organisationPersonId, objectPlannerIds, actionNames);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<ObjectPlannerAction> ret = new ArrayList<ObjectPlannerAction>();
                while (resultSet.next()) {
                    ret.add(ProjectActionHelper.fillObjectPlannerActionFromResultSet(resultSet));
                }
                return ret;
            }
        });
        return projectActions;
    }

    private List<ObjectPlannerAction> getObjectPlannerActionsForObjectPlanner(final Long organisationPersonId, final Collection<Long> objectPlannerIds, final Action ... actionNames) {
        String objectPlannerSQL = ObjectPlannerActionHelper.getObjectPlannerRuleClauseGivenObjectPlanners(objectPlannerIds.size(), actionNames.length);
        List objectPlannerActions = (List)this.performWithPreparedStatement(objectPlannerSQL, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ObjectPlannerAction>>(){

            public List<ObjectPlannerAction> perform(PreparedStatement statement) throws Exception {
                ObjectPlannerActionHelper.populateObjectPlannerRuleClause(statement, 1, organisationPersonId, objectPlannerIds, actionNames);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<ObjectPlannerAction> ret = new ArrayList<ObjectPlannerAction>();
                while (resultSet.next()) {
                    ret.add(ObjectPlannerActionHelper.fillObjectPlannerActionFromResultSet(resultSet));
                }
                return ret;
            }
        });
        return objectPlannerActions;
    }
}

