/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Certificate;
import at.cdes.api.dto.CertificateSearchModel;
import at.cdes.api.joinDto.CertificateJoin;
import at.cdes.api.joinDto.CertificateRequestJoin;
import at.cdes.impl.dao.CertificateDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcCertificateDAO;
import at.cdes.impl.dao.unionComponent.CertificateJoinComponent;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.SearchHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcCertificateDAO
extends AbstractJdbcCertificateDAO
implements CertificateDAO {
    private static final Logger log = LoggerFactory.getLogger(JdbcCertificateDAO.class);

    private String getCertificateSQL() {
        return "SELECT " + this.getCertificateJoinUnionSelectClause(CertificateJoinComponent.CERTIFICATES, "certificate", "ca", "organisationPerson", "person", "organisation", "certificateRequest", "issuer", "issuerPerson", "invitator", "invitatorPerson", "network", "networkOrganisation") + "FROM (((((((((((certificate JOIN organisation_person                               ON certificate.organisation_person_id = organisation_person.id) JOIN person                                            ON organisation_person.person_id = person.id) JOIN organisation                                      ON organisation_person.organisation_id = organisation.id) LEFT JOIN ca                                                ON certificate.ca_cert_id = ca.id) LEFT JOIN network                                           ON ca.network_id = network.id) LEFT JOIN network_organisation                              ON network_organisation.organisation_id = organisation.id) LEFT JOIN certificate_request                               ON certificate.certificate_request_id = certificate_request.id) LEFT JOIN organisation_person issuer                        ON certificate.created_by_id = issuer.id) LEFT JOIN person issuer_person                              ON issuer.person_id = issuer_person.id) LEFT JOIN organisation_person invitator                     ON certificate_request.created_by_id = invitator.id) LEFT JOIN person invitator_person                           ON invitator.person_id = invitator_person.id) ";
    }

    @Override
    public List<CertificateJoin> getCertificateJoin(final CertificateSearchModel searchModel) {
        String sql = this.getCertificateSQL() + "WHERE 1=1 ";
        if (searchModel.getNetworkId() != null) {
            sql = sql + "AND network.id = ? ";
        }
        if (SearchHelper.isStringFilled(searchModel.getPersonName())) {
            sql = sql + "AND (    CONCAT(person.givenName, ' ', person.surName) LIKE ? OR CONCAT(person.surName, ' ', person.givenName) LIKE ?) ";
        }
        if (SearchHelper.isStringFilled(searchModel.getOrganisationName())) {
            sql = sql + "AND organisation.name LIKE ? ";
        }
        if (SearchHelper.isStringFilled(searchModel.getIssuerName())) {
            sql = sql + "AND (    CONCAT(issuer_person.givenName, ' ', issuer_person.surName) LIKE ? OR CONCAT(issuer_person.surName, ' ', issuer_person.givenName) LIKE ?) ";
        }
        if (searchModel.getFrom() != null) {
            sql = sql + "AND (certificate.cert_valid_to >= ? ";
            sql = sql + ") ";
        }
        if (searchModel.getTo() != null) {
            sql = sql + "AND (certificate.cert_valid_from <= ? ";
            sql = sql + ") ";
        }
        if (SearchHelper.isStringFilled(searchModel.getIssuerName())) {
            sql = sql + "AND (    CONCAT(invitator_person.givenName, ' ', invitator_person.surName) LIKE ? OR CONCAT(invitator_person.surName, ' ', invitator_person.givenName) LIKE ?) ";
        }
        sql = sql + "AND (    1=0 ";
        if (searchModel.getShowValid() != null && searchModel.getShowValid().booleanValue()) {
            sql = sql + "OR ((certificate.cert_valid_from <= ? AND certificate.cert_valid_to >= ?) AND certificate.may_login = 1 AND certificate.may_sign = 1 AND (person.invalidated IS NULL OR person.invalidated = 0)) ";
        }
        if (searchModel.getShowValidExpiredSoon() != null && searchModel.getShowValidExpiredSoon().booleanValue()) {
            sql = sql + "OR ((certificate.cert_valid_from <= ? AND certificate.cert_valid_to >= ? AND certificate.cert_valid_to <= ?) AND certificate.may_login = 1 AND certificate.may_sign = 1 AND (person.invalidated IS NULL OR person.invalidated = 0)) ";
        }
        if (searchModel.getShowExpired() != null && searchModel.getShowExpired().booleanValue()) {
            sql = sql + "OR certificate.cert_valid_to <= ? OR ((certificate.may_login = 0 OR certificate.may_sign = 0) AND certificate.cert_valid_to IS NOT NULL)";
        }
        sql = sql + ") ";
        sql = sql + "UNION ALL ";
        sql = sql + "SELECT " + this.getCertificateJoinUnionSelectClause(CertificateJoinComponent.INVITATIONS, "organisationPerson", "person", "organisation", "certificateRequest", "invitator", "invitatorPerson", "network") + "FROM ((((((      certificate_request JOIN organisation_person                              ON certificate_request.created_for = organisation_person.id) JOIN person                                           ON organisation_person.person_id = person.id) JOIN organisation                                     ON organisation_person.organisation_id = organisation.id) LEFT JOIN network                                          ON certificate_request.network_id = network.id) LEFT JOIN organisation_person invitator                    ON certificate_request.created_by_id = invitator.id) LEFT JOIN person invitator_person                          ON invitator.person_id = invitator_person.id) WHERE 1=1 ";
        if (searchModel.getNetworkId() != null) {
            sql = sql + "AND network.id = ? ";
        }
        if (SearchHelper.isStringFilled(searchModel.getPersonName())) {
            sql = sql + "AND (    CONCAT(person.givenName, ' ', person.surName) LIKE ? OR CONCAT(person.surName, ' ', person.givenName) LIKE ?) ";
        }
        if (SearchHelper.isStringFilled(searchModel.getOrganisationName())) {
            sql = sql + "AND organisation.name LIKE ? ";
        }
        if (searchModel.getFrom() != null) {
            sql = sql + "AND certificate_request.request_datetime <= ? ";
        }
        if (searchModel.getTo() != null) {
            sql = sql + "AND certificate_request.request_datetime >= ? ";
        }
        sql = sql + "AND (    1=0 ";
        if (searchModel.getShowInvitations() != null && searchModel.getShowInvitations().booleanValue()) {
            sql = sql + "OR (certificate_request.request_type = ? AND certificate_request.created IS NOT NULL) ";
        }
        if (searchModel.getShowRequested() != null && searchModel.getShowRequested().booleanValue()) {
            sql = sql + "OR (certificate_request.request_type = ? AND certificate_request.request_datetime IS NOT NULL) ";
        }
        sql = sql + ") ";
        if (searchModel.getShowPersonsWithoutCertificate() != null && searchModel.getShowPersonsWithoutCertificate().booleanValue()) {
            sql = sql + "UNION ALL ";
            sql = searchModel.getNetworkId() != null ? sql + "SELECT " + this.getCertificateJoinUnionSelectClause(CertificateJoinComponent.WITHOUT_CERTIFICATE, "organisationPerson", "person", "organisation", "networkOrganisation", "certificate", "ca") + "FROM ((((((( organisation_person JOIN person                     ON organisation_person.person_id = person.id) JOIN organisation               ON organisation_person.organisation_id = organisation.id) LEFT JOIN network_organisation       ON network_organisation.organisation_id = organisation.id) LEFT JOIN network                    ON network_organisation.network_id = network.id) LEFT JOIN certificate                ON certificate.organisation_person_id = organisation_person.id) LEFT JOIN certificate_request        ON certificate.certificate_request_id = certificate_request.id) LEFT JOIN ca                         ON certificate.ca_cert_id = ca.id) " : sql + "SELECT " + this.getCertificateJoinUnionSelectClause(CertificateJoinComponent.WITHOUT_CERTIFICATE, "organisationPerson", "person", "organisation", "networkOrganisation", "certificate", "ca") + "FROM (((((( organisation_person JOIN person                     ON organisation_person.person_id = person.id) JOIN organisation               ON organisation_person.organisation_id = organisation.id) LEFT JOIN network_organisation       ON network_organisation.organisation_id = organisation.id) LEFT JOIN certificate                ON certificate.organisation_person_id = organisation_person.id) LEFT JOIN certificate_request        ON certificate.certificate_request_id = certificate_request.id) LEFT JOIN ca                         ON certificate.ca_cert_id = ca.id) ";
            sql = sql + "WHERE person.invalidated = 0 AND NOT EXISTS (SELECT 1 FROM   certificate_request certificate_request_local WHERE  certificate_request_local.created_for = organisation_person.id AND  (     certificate_request_local.request_type LIKE ? OR certificate_request_local.request_type LIKE ?)) AND NOT EXISTS (SELECT 1 FROM   certificate certificate_local WHERE  certificate_local.organisation_person_id = organisation_person.id AND  certificate_local.cert_valid_from <= ? AND  certificate_local.cert_valid_to >= ? AND  certificate_local.may_sign = 1) ";
            if (searchModel.getNetworkId() != null) {
                sql = sql + "AND network_organisation.network_id = ? ";
            }
            if (SearchHelper.isStringFilled(searchModel.getPersonName())) {
                sql = sql + "AND (    CONCAT(person.givenName, ' ', person.surName) LIKE ? OR CONCAT(person.surName, ' ', person.givenName) LIKE ?) ";
            }
            if (SearchHelper.isStringFilled(searchModel.getOrganisationName())) {
                sql = sql + "AND organisation.name LIKE ? ";
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Will query Certificates: " + sql);
        }
        if (log.isDebugEnabled()) {
            this.printSearchModelToDebug(searchModel);
        }
        long beforeMillis = System.currentTimeMillis();
        List certificateJoins = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<CertificateJoin>>(){

            public List<CertificateJoin> perform(PreparedStatement statement) throws Exception {
                JdbcCertificateDAO.this.populateCertificateStatement(statement, searchModel);
                ResultSet rs = statement.executeQuery();
                ArrayList<CertificateJoin> ret = new ArrayList<CertificateJoin>();
                while (rs.next()) {
                    CertificateJoin joinDto = AbstractJdbcCertificateDAO.fillCertificateJoinFromResultSet(rs);
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)(AbstractJdbcCertificateDAO.getNumberOfCertificateJoinAttributes() + 1)));
                    ret.add(joinDto);
                }
                return ret;
            }
        });
        long afterMillis = System.currentTimeMillis();
        double seconds = ((double)afterMillis - (double)beforeMillis) / 1000.0;
        return certificateJoins;
    }

    @Override
    public List<CertificateJoin> getCertificateJoinById(final List<Long> certificateIds) {
        String sql = this.getCertificateSQL() + "WHERE certificate.id IN (" + QueryHelper.getPlaceHolderSequence(certificateIds.size()) + ") ORDER BY certificate.id ASC";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<CertificateJoin>>(){

            public List<CertificateJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long certificateId : certificateIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)certificateId);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<CertificateJoin> ret = new ArrayList<CertificateJoin>();
                while (rs.next()) {
                    CertificateJoin joinDto = AbstractJdbcCertificateDAO.fillCertificateJoinFromResultSet(rs);
                    ret.add(joinDto);
                }
                return ret;
            }
        });
    }

    @Override
    public List<CertificateJoin> getCertificateJoinByPerson(final Long personId) {
        String sql = this.getCertificateSQL() + "WHERE person.id = ? AND certificate.cert_valid_from <= ? AND certificate.cert_valid_to >= ? AND certificate.may_sign = 1 AND (person.invalidated IS NULL OR person.invalidated = 0) ORDER BY certificate.cert_valid_to DESC";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<CertificateJoin>>(){

            public List<CertificateJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                Long currentUtcMillis = System.currentTimeMillis();
                Double currentUtcSeconds = currentUtcMillis.doubleValue() / 1000.0;
                JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)currentUtcSeconds);
                JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)currentUtcSeconds);
                ResultSet rs = statement.executeQuery();
                ArrayList<CertificateJoin> ret = new ArrayList<CertificateJoin>();
                while (rs.next()) {
                    CertificateJoin joinDto = AbstractJdbcCertificateDAO.fillCertificateJoinFromResultSet(rs);
                    ret.add(joinDto);
                }
                return ret;
            }
        });
    }

    @Override
    public List<Certificate> getValidCertificatesByPerson(final Long personId, final boolean checkValidFrom) {
        String sql = "SELECT " + JdbcCertificateDAO.getSelectClauseForDto() + "FROM ((certificate JOIN organisation_person           ON certificate.organisation_person_id = organisation_person.id) JOIN person                        ON organisation_person.person_id = person.id) WHERE person.id = ? AND certificate.cert_valid_to >= ? AND certificate.may_sign = 1 AND (person.invalidated IS NULL OR person.invalidated = 0) ";
        if (checkValidFrom) {
            sql = sql + "AND certificate.cert_valid_from <= ? ";
        }
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Certificate>>(){

            public List<Certificate> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                Long currentUtcMillis = System.currentTimeMillis();
                Double currentUtcSeconds = currentUtcMillis.doubleValue() / 1000.0;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)currentUtcSeconds);
                if (checkValidFrom) {
                    JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)currentUtcSeconds);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<Certificate> certificates = new ArrayList<Certificate>();
                while (rs.next()) {
                    Certificate certificate = JdbcCertificateDAO.fillCertificateFromResultSet(rs);
                    certificates.add(certificate);
                }
                return certificates;
            }
        });
    }

    @Override
    public List<Certificate> getCertificatesByPerson(final Long personId) {
        String sql = "SELECT " + JdbcCertificateDAO.getSelectClauseForDto() + "FROM ((certificate JOIN organisation_person           ON certificate.organisation_person_id = organisation_person.id) JOIN person                        ON organisation_person.person_id = person.id) WHERE person.id = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Certificate>>(){

            public List<Certificate> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                ResultSet rs = statement.executeQuery();
                ArrayList<Certificate> certificates = new ArrayList<Certificate>();
                while (rs.next()) {
                    Certificate certificate = JdbcCertificateDAO.fillCertificateFromResultSet(rs);
                    certificates.add(certificate);
                }
                return certificates;
            }
        });
    }

    private String getCertificateJoinUnionSelectClause(CertificateJoinComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForCertificateJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : "") + component.getValue() + " ";
    }

    private void printSearchModelToDebug(CertificateSearchModel searchModel) {
        log.debug("networkId = [" + searchModel.getNetworkId() + "]");
    }

    private void populateCertificateStatement(PreparedStatement statement, CertificateSearchModel searchModel) throws SQLException {
        String searchString;
        String searchString2;
        int currIndex = 1;
        if (searchModel.getNetworkId() != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getNetworkId());
        }
        if (SearchHelper.isStringFilled(searchModel.getPersonName())) {
            searchString2 = SearchHelper.convertForSearch(searchModel.getPersonName());
            statement.setString(currIndex++, searchString2);
            statement.setString(currIndex++, searchString2);
        }
        if (SearchHelper.isStringFilled(searchModel.getOrganisationName())) {
            searchString2 = SearchHelper.convertForSearch(searchModel.getOrganisationName());
            statement.setString(currIndex++, searchString2);
        }
        if (SearchHelper.isStringFilled(searchModel.getIssuerName())) {
            searchString2 = SearchHelper.convertForSearch(searchModel.getIssuerName());
            statement.setString(currIndex++, searchString2);
            statement.setString(currIndex++, searchString2);
        }
        if (searchModel.getFrom() != null) {
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)searchModel.getFrom().doubleValue());
        }
        if (searchModel.getTo() != null) {
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)searchModel.getTo().doubleValue());
        }
        if (SearchHelper.isStringFilled(searchModel.getIssuerName())) {
            searchString2 = SearchHelper.convertForSearch(searchModel.getIssuerName());
            statement.setString(currIndex++, searchString2);
            statement.setString(currIndex++, searchString2);
        }
        Long currentUtcMillis = System.currentTimeMillis();
        Double currentUtcSeconds = currentUtcMillis.doubleValue() / 1000.0;
        if (searchModel.getShowValid() != null && searchModel.getShowValid().booleanValue()) {
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)currentUtcSeconds);
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)currentUtcSeconds);
        }
        if (searchModel.getShowValidExpiredSoon() != null && searchModel.getShowValidExpiredSoon().booleanValue()) {
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)currentUtcSeconds);
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)currentUtcSeconds);
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)(currentUtcSeconds + 2592000.0));
        }
        if (searchModel.getShowExpired() != null && searchModel.getShowExpired().booleanValue()) {
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)currentUtcSeconds);
        }
        if (searchModel.getNetworkId() != null) {
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getNetworkId());
        }
        if (SearchHelper.isStringFilled(searchModel.getPersonName())) {
            searchString = SearchHelper.convertForSearch(searchModel.getPersonName());
            statement.setString(currIndex++, searchString);
            statement.setString(currIndex++, searchString);
        }
        if (SearchHelper.isStringFilled(searchModel.getOrganisationName())) {
            searchString = SearchHelper.convertForSearch(searchModel.getOrganisationName());
            statement.setString(currIndex++, searchString);
        }
        if (searchModel.getFrom() != null) {
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)searchModel.getFrom().doubleValue());
        }
        if (searchModel.getTo() != null) {
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)searchModel.getTo().doubleValue());
        }
        if (searchModel.getShowInvitations() != null && searchModel.getShowInvitations().booleanValue()) {
            statement.setString(currIndex++, "Invitation");
        }
        if (searchModel.getShowRequested() != null && searchModel.getShowRequested().booleanValue()) {
            statement.setString(currIndex++, "Request");
        }
        if (searchModel.getShowPersonsWithoutCertificate() != null && searchModel.getShowPersonsWithoutCertificate().booleanValue()) {
            statement.setString(currIndex++, "invitation");
            statement.setString(currIndex++, "request");
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)(new Double(System.currentTimeMillis()) / 1000.0));
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)(new Double(System.currentTimeMillis()) / 1000.0));
            if (searchModel.getNetworkId() != null) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getNetworkId());
            }
            if (SearchHelper.isStringFilled(searchModel.getPersonName())) {
                searchString = SearchHelper.convertForSearch(searchModel.getPersonName());
                statement.setString(currIndex++, searchString);
                statement.setString(currIndex++, searchString);
            }
            if (SearchHelper.isStringFilled(searchModel.getOrganisationName())) {
                searchString = SearchHelper.convertForSearch(searchModel.getOrganisationName());
                statement.setString(currIndex++, searchString);
            }
        }
    }

    @Override
    public Certificate getSignerCertificate(final Long organisationPersonId) {
        String sql = "SELECT " + JdbcCertificateDAO.getSelectClauseForDto() + "FROM certificate WHERE certificate.organisation_person_id = ? AND certificate.may_sign = 1 AND certificate.private_key is not null AND certificate.certificate is not null AND certificate.cert_valid_to >= ? ";
        return (Certificate)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Certificate>(){

            public Certificate perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)organisationPersonId);
                JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)2, (Double)(new Double(System.currentTimeMillis()) / 1000.0));
                ResultSet rs = statement.executeQuery();
                ArrayList<Certificate> candidates = new ArrayList<Certificate>();
                Double maxValidTo = null;
                while (rs.next()) {
                    Certificate certificate = JdbcCertificateDAO.fillCertificateFromResultSet(rs);
                    candidates.add(certificate);
                    maxValidTo = maxValidTo != null ? Math.max(maxValidTo, certificate.getCertValidTo()) : certificate.getCertValidTo();
                }
                for (Certificate candidate : candidates) {
                    if (!candidate.getCertValidTo().equals(maxValidTo)) continue;
                    return candidate;
                }
                return null;
            }
        });
    }

    @Override
    public List<Certificate> getCaLessCertificates() {
        String sql = "SELECT " + JdbcCertificateDAO.getSelectClauseForDto() + "FROM certificate WHERE   certificate.certificate IS NOT NULL AND   certificate.ca_cert_id IS NULL AND EXISTS (SELECT 1 FROM certificate_request WHERE certificate.certificate_request_id = certificate_request.id AND (    certificate_request.request_type IS NULL OR certificate_request.request_type = ? OR certificate_request.request_type = ? OR certificate_request.request_type = ?))";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Certificate>>(){

            public List<Certificate> perform(PreparedStatement statement) throws Exception {
                statement.setString(1, "Accepted");
                statement.setString(2, "pkcs10");
                statement.setString(3, "spkac");
                ResultSet rs = statement.executeQuery();
                ArrayList<Certificate> ret = new ArrayList<Certificate>();
                while (rs.next()) {
                    Certificate certificate = JdbcCertificateDAO.fillCertificateFromResultSet(rs);
                    ret.add(certificate);
                }
                return ret;
            }
        });
    }

    @Override
    public int[] updateCertificateToCaMapping(final Map<Long, Long> certificateIdToCaId) {
        String sql = "UPDATE certificate SET ca_cert_id = ? WHERE id = ?";
        return (int[])this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<int[]>(){

            public int[] perform(PreparedStatement statement) throws Exception {
                for (Long certificateId : certificateIdToCaId.keySet()) {
                    Long caId = (Long)certificateIdToCaId.get(certificateId);
                    JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)caId);
                    JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)certificateId);
                    statement.addBatch();
                }
                return statement.executeBatch();
            }
        });
    }

    @Override
    public List<CertificateRequestJoin> getCertificateRequestJoinsWithRequestsByPerson(final Long personId) {
        String sql = "SELECT " + JdbcCertificateDAO.getCertificateRequestJoinSelectClause() + "FROM (((         certificate LEFT JOIN certificate_request      ON certificate.certificate_request_id = certificate_request.id) JOIN organisation_person      ON certificate.organisation_person_id = organisation_person.id) JOIN person                   ON organisation_person.person_id = person.id) WHERE person.id = ? UNION ALL SELECT " + this.getSelectClauseForCertificateRequestJoinUnion("certificateRequest") + " FROM (           certificate_request JOIN organisation_person      ON certificate_request.created_for = organisation_person.id) WHERE organisation_person.person_id = ? ORDER BY organisation_person_id DESC, cert_valid_to DESC";
        List retRequestJoins = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<CertificateRequestJoin>>(){

            public List<CertificateRequestJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                ResultSet rs = statement.executeQuery();
                ArrayList<CertificateRequestJoin> requestJoins = new ArrayList<CertificateRequestJoin>();
                while (rs.next()) {
                    CertificateRequestJoin certificateRequestJoin = JdbcCertificateDAO.fillCertificateRequestJoinFromResultSet(rs);
                    requestJoins.add(certificateRequestJoin);
                }
                return requestJoins;
            }
        });
        return retRequestJoins;
    }
}

