/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.reviewCycle;

import at.cdes.api.dto.BaseLabelTextField;
import at.cdes.api.dto.Label;
import at.cdes.api.dto.LabelContent;
import at.cdes.api.dto.LabelDocumentVersionTextField;
import at.cdes.api.dto.LabelFreeTextField;
import at.cdes.api.dto.LabelSignatureTextField;
import at.cdes.api.dto.ReviewCycleInstance;
import at.cdes.api.joinDto.LabelContentJoin;
import at.cdes.api.review.compositeDto.LabelTextField;
import at.cdes.api.review.voc.LabelAlignment;
import at.cdes.api.review.voc.LabelFontStyle;
import at.cdes.api.review.voc.LabelTextFieldType;
import at.cdes.impl.dao.BaseLabelTextFieldDAO;
import at.cdes.impl.dao.LabelContentDAO;
import at.cdes.impl.dao.LabelDAO;
import at.cdes.impl.dao.LabelDocumentVersionTextFieldDAO;
import at.cdes.impl.dao.LabelFreeTextFieldDAO;
import at.cdes.impl.dao.LabelSignatureTextFieldDAO;
import at.cdes.impl.dao.ReviewCycleInstanceDAO;
import at.cdes.impl.digest.FileDigester;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.SyncWithDBResult;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.clazzes.util.io.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelUtils {
    private FileDigester fileDigester;
    private LabelDAO labelDAO;
    private LabelContentDAO labelContentDAO;
    private BaseLabelTextFieldDAO baseLabelTextFieldDAO;
    private LabelSignatureTextFieldDAO labelSignatureTextFieldDAO;
    private LabelDocumentVersionTextFieldDAO labelDocumentVersionTextFieldDAO;
    private LabelFreeTextFieldDAO labelFreeTextFieldDAO;
    private String labelRepository;
    private ReviewCycleInstanceDAO reviewCycleInstanceDAO;
    private static final Logger log = LoggerFactory.getLogger(LabelUtils.class);

    public void setFileDigester(FileDigester fileDigester) {
        this.fileDigester = fileDigester;
    }

    public void setLabelDAO(LabelDAO labelDAO) {
        this.labelDAO = labelDAO;
    }

    public void setLabelContentDAO(LabelContentDAO labelContentDAO) {
        this.labelContentDAO = labelContentDAO;
    }

    public void setBaseLabelTextFieldDAO(BaseLabelTextFieldDAO baseLabelTextFieldDAO) {
        this.baseLabelTextFieldDAO = baseLabelTextFieldDAO;
    }

    public void setLabelSignatureTextFieldDAO(LabelSignatureTextFieldDAO labelSignatureTextFieldDAO) {
        this.labelSignatureTextFieldDAO = labelSignatureTextFieldDAO;
    }

    public void setLabelDocumentVersionTextFieldDAO(LabelDocumentVersionTextFieldDAO labelDocumentVersionTextFieldDAO) {
        this.labelDocumentVersionTextFieldDAO = labelDocumentVersionTextFieldDAO;
    }

    public void setLabelFreeTextFieldDAO(LabelFreeTextFieldDAO labelFreeTextFieldDAO) {
        this.labelFreeTextFieldDAO = labelFreeTextFieldDAO;
    }

    public void setLabelRepository(String labelRepository) {
        this.labelRepository = labelRepository;
    }

    public void setReviewCycleInstanceDAO(ReviewCycleInstanceDAO reviewCycleInstanceDAO) {
        this.reviewCycleInstanceDAO = reviewCycleInstanceDAO;
    }

    public void syncLabelTextFields(List<LabelTextField> newLabelTextFields, List<LabelContentJoin> oldLabelContentJoins) {
        List<BaseLabelTextField> newBaseLabelTextFields = this.getBaseLabelTextFieldsByLabelTextFields(newLabelTextFields);
        List<LabelSignatureTextField> newSignatureTextFields = this.getLabelSignatureTextFieldsByLabelTextFields(newLabelTextFields);
        List<LabelDocumentVersionTextField> newDocumentVersionTextFields = this.getLabelDocumentVersionTextFieldsByLabelTextFields(newLabelTextFields);
        List<LabelFreeTextField> newFreeTextFields = this.getLabelFreeTextFieldsByLabelTextFields(newLabelTextFields);
        List<BaseLabelTextField> oldBaseLabelTextFields = this.getBaseLabelTextFieldsByJoins(oldLabelContentJoins);
        List<LabelSignatureTextField> oldSignatureTextFields = this.getLabelSignatureTextFieldsByJoins(oldLabelContentJoins);
        List<LabelDocumentVersionTextField> oldDocumentVersionTextFields = this.getLabelDocumentVersionTextFieldsByJoins(oldLabelContentJoins);
        List<LabelFreeTextField> oldFreeTextFields = this.getLabelFreeTextFieldsByJoins(oldLabelContentJoins);
        SyncWithDBResult<BaseLabelTextField> baseLabelTextFieldResult = QueryHelper.syncWithDatabase(this.baseLabelTextFieldDAO, newBaseLabelTextFields, oldBaseLabelTextFields, true);
        newBaseLabelTextFields = baseLabelTextFieldResult.getInstances();
        this.setLabelSignatureTextFieldIds(newSignatureTextFields, newBaseLabelTextFields);
        this.setLabelFreeTextFieldIds(newFreeTextFields, newBaseLabelTextFields);
        this.setLabelDocumentVersionTextFieldIds(newDocumentVersionTextFields, newBaseLabelTextFields);
        Map<Long, LabelDocumentVersionTextField> idToOldDocumentVersionTextField = this.groupDocumentVersionTextFieldsById(oldDocumentVersionTextFields);
        Map<Long, LabelSignatureTextField> idToOldSignatureTextField = this.groupSignatureTextFieldsById(oldSignatureTextFields);
        Map<Long, LabelFreeTextField> idToOldFreeTextField = this.groupFreeTextFieldsById(oldFreeTextFields);
        Map<Long, LabelDocumentVersionTextField> idToNewDocumentVersionTextField = this.groupDocumentVersionTextFieldsById(newDocumentVersionTextFields);
        Map<Long, LabelSignatureTextField> idToNewSignatureTextField = this.groupSignatureTextFieldsById(newSignatureTextFields);
        Map<Long, LabelFreeTextField> idToNewFreeTextField = this.groupFreeTextFieldsById(newFreeTextFields);
        QueryHelper.syncWithDatabaseByMap(this.labelDocumentVersionTextFieldDAO, idToNewDocumentVersionTextField, idToOldDocumentVersionTextField);
        QueryHelper.syncWithDatabaseByMap(this.labelSignatureTextFieldDAO, idToNewSignatureTextField, idToOldSignatureTextField);
        QueryHelper.syncWithDatabaseByMap(this.labelFreeTextFieldDAO, idToNewFreeTextField, idToOldFreeTextField);
        ArrayList<Long> baseTextFieldIdsToDelete = new ArrayList<Long>();
        for (BaseLabelTextField oldBaseLabelTextField : oldBaseLabelTextFields) {
            Long textFieldId = oldBaseLabelTextField.getId();
            if (idToNewDocumentVersionTextField.containsKey(textFieldId) || idToNewSignatureTextField.containsKey(textFieldId) || idToNewFreeTextField.containsKey(textFieldId)) continue;
            baseTextFieldIdsToDelete.add(textFieldId);
        }
        if (baseTextFieldIdsToDelete.size() > 0) {
            this.baseLabelTextFieldDAO.deleteBatch(baseTextFieldIdsToDelete);
        }
    }

    private List<BaseLabelTextField> getBaseLabelTextFieldsByLabelTextFields(List<LabelTextField> labelTextFields) {
        ArrayList<BaseLabelTextField> baseLabelTextFields = new ArrayList<BaseLabelTextField>();
        for (LabelTextField labelTextField : labelTextFields) {
            LabelFontStyle labelFontStyle = labelTextField.getFontStyle();
            LabelAlignment labelAlignment = labelTextField.getAlignment();
            BaseLabelTextField baseLabelTextField = new BaseLabelTextField();
            baseLabelTextField.setId(labelTextField.getId());
            baseLabelTextField.setLabelId(labelTextField.getLabelId());
            baseLabelTextField.setReviewCycleId(labelTextField.getReviewCycleId());
            baseLabelTextField.setLlx(labelTextField.getLlx());
            baseLabelTextField.setLly(labelTextField.getLly());
            baseLabelTextField.setUrx(labelTextField.getUrx());
            baseLabelTextField.setUry(labelTextField.getUry());
            baseLabelTextField.setFont(labelTextField.getFont());
            baseLabelTextField.setFontStyle(labelFontStyle != null ? Integer.valueOf(labelFontStyle.getValue()) : null);
            baseLabelTextField.setFontPtsize(labelTextField.getFontPtsize());
            baseLabelTextField.setAlignment(labelAlignment != null ? Integer.valueOf(labelAlignment.getValue()) : null);
            baseLabelTextFields.add(baseLabelTextField);
        }
        return baseLabelTextFields;
    }

    private List<LabelSignatureTextField> getLabelSignatureTextFieldsByLabelTextFields(List<LabelTextField> labelTextFields) {
        ArrayList<LabelSignatureTextField> labelSignatureTextFields = new ArrayList<LabelSignatureTextField>();
        for (LabelTextField labelTextField : labelTextFields) {
            LabelTextFieldType textFieldType = labelTextField.getFieldType();
            if (textFieldType == LabelTextFieldType.SIGNATURE) {
                LabelSignatureTextField labelSignatureTextField = new LabelSignatureTextField();
                labelSignatureTextField.setLabelTextFieldId(labelTextField.getId());
                labelSignatureTextField.setReviewCycleNodeId(labelTextField.getReviewCycleNodeId());
                labelSignatureTextField.setComment(labelTextField.getComment());
                labelSignatureTextField.setUsedForRealm(Boolean.valueOf(labelTextField.getUsedForRealm() != null ? labelTextField.getUsedForRealm() : false));
                labelSignatureTextField.setRealmSequence(labelTextField.getRealmSequence());
                labelSignatureTextFields.add(labelSignatureTextField);
                continue;
            }
            labelSignatureTextFields.add(null);
        }
        return labelSignatureTextFields;
    }

    private List<LabelFreeTextField> getLabelFreeTextFieldsByLabelTextFields(List<LabelTextField> labelTextFields) {
        ArrayList<LabelFreeTextField> labelFreeTextFields = new ArrayList<LabelFreeTextField>();
        for (LabelTextField labelTextField : labelTextFields) {
            LabelTextFieldType textFieldType = labelTextField.getFieldType();
            if (textFieldType == LabelTextFieldType.FREE) {
                LabelFreeTextField labelFreeTextField = new LabelFreeTextField();
                labelFreeTextField.setLabelTextFieldId(labelTextField.getId());
                labelFreeTextField.setContent(labelTextField.getContent());
                labelFreeTextFields.add(labelFreeTextField);
                continue;
            }
            labelFreeTextFields.add(null);
        }
        return labelFreeTextFields;
    }

    private List<LabelDocumentVersionTextField> getLabelDocumentVersionTextFieldsByLabelTextFields(List<LabelTextField> labelTextFields) {
        ArrayList<LabelDocumentVersionTextField> labelDocumentVersionTextFields = new ArrayList<LabelDocumentVersionTextField>();
        for (LabelTextField labelTextField : labelTextFields) {
            LabelTextFieldType textFieldType = labelTextField.getFieldType();
            if (textFieldType == LabelTextFieldType.DOCUMENT_VERSION) {
                LabelDocumentVersionTextField labelDocumentVersionTextField = new LabelDocumentVersionTextField();
                labelDocumentVersionTextField.setLabelTextFieldId(labelTextField.getId());
                labelDocumentVersionTextField.setContent(labelTextField.getContent());
                labelDocumentVersionTextFields.add(labelDocumentVersionTextField);
                continue;
            }
            labelDocumentVersionTextFields.add(null);
        }
        return labelDocumentVersionTextFields;
    }

    private List<BaseLabelTextField> getBaseLabelTextFieldsByJoins(List<LabelContentJoin> labelContentJoins) {
        ArrayList<BaseLabelTextField> baseLabelTextFields = new ArrayList<BaseLabelTextField>();
        for (LabelContentJoin labelContentJoin : labelContentJoins) {
            if (labelContentJoin.getBaseLabelTextFieldId() == null) continue;
            baseLabelTextFields.add(labelContentJoin.getBaseLabelTextField());
        }
        return baseLabelTextFields;
    }

    private List<LabelSignatureTextField> getLabelSignatureTextFieldsByJoins(List<LabelContentJoin> labelContentJoins) {
        ArrayList<LabelSignatureTextField> labelSignatureTextFields = new ArrayList<LabelSignatureTextField>();
        for (LabelContentJoin labelContentJoin : labelContentJoins) {
            if (labelContentJoin.getLabelSignatureTextFieldLabelTextFieldId() != null) {
                labelSignatureTextFields.add(labelContentJoin.getLabelSignatureTextField());
                continue;
            }
            labelSignatureTextFields.add(null);
        }
        return labelSignatureTextFields;
    }

    private List<LabelFreeTextField> getLabelFreeTextFieldsByJoins(List<LabelContentJoin> labelContentJoins) {
        ArrayList<LabelFreeTextField> labelFreeTextFields = new ArrayList<LabelFreeTextField>();
        for (LabelContentJoin labelContentJoin : labelContentJoins) {
            if (labelContentJoin.getLabelFreeTextFieldLabelTextFieldId() != null) {
                labelFreeTextFields.add(labelContentJoin.getLabelFreeTextField());
                continue;
            }
            labelFreeTextFields.add(null);
        }
        return labelFreeTextFields;
    }

    private List<LabelDocumentVersionTextField> getLabelDocumentVersionTextFieldsByJoins(List<LabelContentJoin> labelContentJoins) {
        ArrayList<LabelDocumentVersionTextField> labelDocumentVersionTextFields = new ArrayList<LabelDocumentVersionTextField>();
        for (LabelContentJoin labelContentJoin : labelContentJoins) {
            if (labelContentJoin.getLabelDocumentVersionTextFieldLabelTextFieldId() != null) {
                labelDocumentVersionTextFields.add(labelContentJoin.getLabelDocumentVersionTextField());
                continue;
            }
            labelDocumentVersionTextFields.add(null);
        }
        return labelDocumentVersionTextFields;
    }

    private void setLabelSignatureTextFieldIds(List<LabelSignatureTextField> labelSignatureTextFields, List<BaseLabelTextField> baseLabelTextFields) {
        for (int n = 0; n < labelSignatureTextFields.size(); ++n) {
            LabelSignatureTextField labelSignatureTextField = labelSignatureTextFields.get(n);
            if (labelSignatureTextField == null) continue;
            labelSignatureTextField.setLabelTextFieldId(baseLabelTextFields.get(n).getId());
        }
    }

    private void setLabelFreeTextFieldIds(List<LabelFreeTextField> labelFreeTextFields, List<BaseLabelTextField> baseLabelTextFields) {
        for (int n = 0; n < labelFreeTextFields.size(); ++n) {
            LabelFreeTextField labelFreeTextField = labelFreeTextFields.get(n);
            if (labelFreeTextField == null) continue;
            labelFreeTextField.setLabelTextFieldId(baseLabelTextFields.get(n).getId());
        }
    }

    private void setLabelDocumentVersionTextFieldIds(List<LabelDocumentVersionTextField> labelDocumentVersionTextFields, List<BaseLabelTextField> baseLabelTextFields) {
        for (int n = 0; n < labelDocumentVersionTextFields.size(); ++n) {
            LabelDocumentVersionTextField labelDocumentVersionTextField = labelDocumentVersionTextFields.get(n);
            if (labelDocumentVersionTextField == null) continue;
            labelDocumentVersionTextField.setLabelTextFieldId(baseLabelTextFields.get(n).getId());
        }
    }

    private Map<Long, LabelSignatureTextField> groupSignatureTextFieldsById(List<LabelSignatureTextField> textFields) {
        HashMap<Long, LabelSignatureTextField> idToItem = new HashMap<Long, LabelSignatureTextField>();
        for (LabelSignatureTextField textField : textFields) {
            if (textField == null) continue;
            idToItem.put(textField.getLabelTextFieldId(), textField);
        }
        return idToItem;
    }

    private Map<Long, LabelDocumentVersionTextField> groupDocumentVersionTextFieldsById(List<LabelDocumentVersionTextField> textFields) {
        HashMap<Long, LabelDocumentVersionTextField> idToItem = new HashMap<Long, LabelDocumentVersionTextField>();
        for (LabelDocumentVersionTextField textField : textFields) {
            if (textField == null) continue;
            idToItem.put(textField.getLabelTextFieldId(), textField);
        }
        return idToItem;
    }

    private Map<Long, LabelFreeTextField> groupFreeTextFieldsById(List<LabelFreeTextField> textFields) {
        HashMap<Long, LabelFreeTextField> idToItem = new HashMap<Long, LabelFreeTextField>();
        for (LabelFreeTextField textField : textFields) {
            if (textField == null) continue;
            idToItem.put(textField.getLabelTextFieldId(), textField);
        }
        return idToItem;
    }

    public String saveLabelFile(Label label, byte[] data, String transferFileName) {
        try {
            Long organisationId = label.getOrganisationId();
            Long reviewCycleId = label.getReviewCycleId();
            Long labelSaveId = reviewCycleId != null ? reviewCycleId : label.getId();
            String orgPath = organisationId.toString();
            Path dirPath = Paths.get(this.labelRepository, orgPath);
            if (!Files.exists(dirPath, new LinkOption[0])) {
                Files.createDirectories(dirPath, new FileAttribute[0]);
            }
            String fileName = this.generateLabelName(labelSaveId, IOUtil.getFileExtension((String)transferFileName));
            Path fileNamePath = Paths.get(this.labelRepository, orgPath, fileName);
            Files.write(fileNamePath, data, new OpenOption[0]);
            String dbFileName = orgPath + File.separator + fileName;
            return dbFileName;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void copyLabelFile(String fileName, Label targetLabel, LabelContent targetLabelContent, boolean pdf) {
        if (fileName != null) {
            try {
                Path pdfPath = Paths.get(this.labelRepository, fileName);
                Long targetLabelId = targetLabel.getId();
                String targetLabelName = this.generateLabelName(targetLabelId, IOUtil.getFileExtension((String)fileName));
                Path targetPdfPath = Paths.get(this.labelRepository, targetLabelName);
                Files.copy(pdfPath, targetPdfPath, new CopyOption[0]);
                if (pdf) {
                    targetLabelContent.setFilename(targetLabelName);
                    targetLabelContent.setFiletype(IOUtil.getFileExtension((String)fileName));
                    targetLabelContent.setFiledigest(this.fileDigester.getDigest(Paths.get(this.labelRepository, targetLabelName)));
                } else {
                    targetLabelContent.setOrigFilename(targetLabelName);
                    targetLabelContent.setOrigFiletype(IOUtil.getFileExtension((String)fileName));
                    targetLabelContent.setOrigFiledigest(this.fileDigester.getDigest(Paths.get(this.labelRepository, targetLabelName)));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Label file could not be copied: [" + fileName + "], targetLabelId [" + targetLabel.getId() + "]");
            }
        }
    }

    private String generateLabelName(Long id, String type) {
        return id.toString() + "-" + System.currentTimeMillis() + (type != null ? "." + type : "");
    }

    public void copyLabelTextFields(Long sourceLabelContentId, Long destLabelContentId) {
        List<BaseLabelTextField> sourceBaseLabelTextFields = this.baseLabelTextFieldDAO.getByLabel(sourceLabelContentId);
        HashMap<Long, BaseLabelTextField> idToSourceBaseLabelTextField = new HashMap<Long, BaseLabelTextField>();
        for (BaseLabelTextField sourceBaseLabelTextField : sourceBaseLabelTextFields) {
            idToSourceBaseLabelTextField.put(sourceBaseLabelTextField.getId(), sourceBaseLabelTextField);
        }
        List<Long> sourceLabelTextFieldIds = QueryHelper.getPersistentIds(sourceBaseLabelTextFields);
        List<LabelSignatureTextField> sourceSignatureTextFields = this.labelSignatureTextFieldDAO.getByLabelTextFields(sourceLabelTextFieldIds);
        List<LabelDocumentVersionTextField> sourceDocumentVersionTextFields = this.labelDocumentVersionTextFieldDAO.getByLabelTextFields(sourceLabelTextFieldIds);
        List<LabelFreeTextField> sourceFreeTextFields = this.labelFreeTextFieldDAO.getByLabelTextFields(sourceLabelTextFieldIds);
        ArrayList<BaseLabelTextField> signatureBaseFields = new ArrayList<BaseLabelTextField>();
        ArrayList<LabelSignatureTextField> signatureFields = new ArrayList<LabelSignatureTextField>();
        for (LabelSignatureTextField sourceSignatureTextField : sourceSignatureTextFields) {
            Long sourceId = sourceSignatureTextField.getLabelTextFieldId();
            BaseLabelTextField soureBaseField = (BaseLabelTextField)idToSourceBaseLabelTextField.get(sourceId);
            signatureBaseFields.add(this.copyBaseLabelTextField(soureBaseField, destLabelContentId));
            signatureFields.add(this.copySignatureTextField(sourceSignatureTextField));
        }
        if (signatureFields.size() > 0) {
            this.baseLabelTextFieldDAO.saveBatch(signatureBaseFields);
            for (int n = 0; n < signatureBaseFields.size(); ++n) {
                ((LabelSignatureTextField)signatureFields.get(n)).setLabelTextFieldId(((BaseLabelTextField)signatureBaseFields.get(n)).getId());
            }
            this.labelSignatureTextFieldDAO.saveBatch(signatureFields);
        }
        ArrayList<BaseLabelTextField> documentVersionBaseFields = new ArrayList<BaseLabelTextField>();
        ArrayList<LabelDocumentVersionTextField> documentVersionFields = new ArrayList<LabelDocumentVersionTextField>();
        for (LabelDocumentVersionTextField sourceDocumentVersionTextField : sourceDocumentVersionTextFields) {
            Long sourceId = sourceDocumentVersionTextField.getLabelTextFieldId();
            BaseLabelTextField soureBaseField = (BaseLabelTextField)idToSourceBaseLabelTextField.get(sourceId);
            documentVersionBaseFields.add(this.copyBaseLabelTextField(soureBaseField, destLabelContentId));
            documentVersionFields.add(this.copyDocumentVersionTextField(sourceDocumentVersionTextField));
        }
        if (documentVersionFields.size() > 0) {
            this.baseLabelTextFieldDAO.saveBatch(documentVersionBaseFields);
            for (int n = 0; n < documentVersionBaseFields.size(); ++n) {
                ((LabelDocumentVersionTextField)documentVersionFields.get(n)).setLabelTextFieldId(((BaseLabelTextField)documentVersionBaseFields.get(n)).getId());
            }
            this.labelDocumentVersionTextFieldDAO.saveBatch(documentVersionFields);
        }
        ArrayList<BaseLabelTextField> freeBaseFields = new ArrayList<BaseLabelTextField>();
        ArrayList<LabelFreeTextField> freeFields = new ArrayList<LabelFreeTextField>();
        for (LabelFreeTextField sourceFreeTextField : sourceFreeTextFields) {
            Long sourceId = sourceFreeTextField.getLabelTextFieldId();
            BaseLabelTextField soureBaseField = (BaseLabelTextField)idToSourceBaseLabelTextField.get(sourceId);
            freeBaseFields.add(this.copyBaseLabelTextField(soureBaseField, destLabelContentId));
            freeFields.add(this.copyFreeTextField(sourceFreeTextField));
        }
        if (freeFields.size() > 0) {
            this.baseLabelTextFieldDAO.saveBatch(freeBaseFields);
            for (int n = 0; n < freeBaseFields.size(); ++n) {
                ((LabelFreeTextField)freeFields.get(n)).setLabelTextFieldId(((BaseLabelTextField)freeBaseFields.get(n)).getId());
            }
            this.labelFreeTextFieldDAO.saveBatch(freeFields);
        }
    }

    private BaseLabelTextField copyBaseLabelTextField(BaseLabelTextField source, Long destLabelContentId) {
        BaseLabelTextField copy = new BaseLabelTextField();
        copy.setAlignment(source.getAlignment());
        copy.setFont(source.getFont());
        copy.setFontPtsize(source.getFontPtsize());
        copy.setFontStyle(source.getFontStyle());
        copy.setLabelId(source.getLabelId());
        copy.setLlx(source.getLlx());
        copy.setLly(source.getLly());
        copy.setReviewCycleId(source.getReviewCycleId());
        copy.setUrx(source.getUrx());
        copy.setUry(source.getUry());
        copy.setLabelId(destLabelContentId);
        return copy;
    }

    private LabelSignatureTextField copySignatureTextField(LabelSignatureTextField source) {
        LabelSignatureTextField copy = new LabelSignatureTextField();
        copy.setComment(source.getComment());
        copy.setRealmSequence(source.getRealmSequence());
        copy.setReviewCycleNodeId(source.getReviewCycleNodeId());
        copy.setUsedForRealm(source.getUsedForRealm());
        return copy;
    }

    private LabelDocumentVersionTextField copyDocumentVersionTextField(LabelDocumentVersionTextField source) {
        LabelDocumentVersionTextField copy = new LabelDocumentVersionTextField();
        copy.setContent(source.getContent());
        return copy;
    }

    private LabelFreeTextField copyFreeTextField(LabelFreeTextField source) {
        LabelFreeTextField copy = new LabelFreeTextField();
        copy.setContent(source.getContent());
        return copy;
    }

    public void deleteLabel(Long labelId) {
        List<ReviewCycleInstance> reviewCycleInstances = this.reviewCycleInstanceDAO.getByLabel(labelId);
        if (reviewCycleInstances.size() > 0) {
            for (ReviewCycleInstance reviewCycleInstance : reviewCycleInstances) {
                reviewCycleInstance.setLabelId(null);
            }
            this.reviewCycleInstanceDAO.updateBatch(reviewCycleInstances);
        }
        List<LabelContent> labelContents = this.labelContentDAO.getByLabel(labelId);
        for (LabelContent labelContent : labelContents) {
            this.deleteLabelContent(labelContent.getId());
        }
        this.labelDAO.delete(labelId);
    }

    public void deleteLabelContent(Long labelContentId) {
        List<BaseLabelTextField> baseLabelTextFields = this.baseLabelTextFieldDAO.getByLabel(labelContentId);
        List<Long> textFieldIds = QueryHelper.getPersistentIds(baseLabelTextFields);
        List<LabelSignatureTextField> signatureTextFields = this.labelSignatureTextFieldDAO.getByLabelTextFields(textFieldIds);
        List<LabelDocumentVersionTextField> documentVersionTextFields = this.labelDocumentVersionTextFieldDAO.getByLabelTextFields(textFieldIds);
        List<LabelFreeTextField> freeTextFields = this.labelFreeTextFieldDAO.getByLabelTextFields(textFieldIds);
        if (signatureTextFields.size() > 0) {
            this.labelSignatureTextFieldDAO.deleteBatch(textFieldIds);
        }
        if (documentVersionTextFields.size() > 0) {
            this.labelDocumentVersionTextFieldDAO.deleteBatch(textFieldIds);
        }
        if (freeTextFields.size() > 0) {
            this.labelFreeTextFieldDAO.deleteBatch(textFieldIds);
        }
        if (textFieldIds.size() > 0) {
            this.baseLabelTextFieldDAO.deleteBatch(textFieldIds);
        }
        LabelContent labelContent = (LabelContent)this.labelContentDAO.get(labelContentId);
        String pdfPath = labelContent.getFilename();
        String origPath = labelContent.getOrigFilename();
        try {
            if (pdfPath != null) {
                Path fullPdfPath = Paths.get(this.labelRepository, pdfPath);
                Files.delete(fullPdfPath);
            }
        }
        catch (Exception e) {
            log.warn("Failed to delete file [" + pdfPath + "]");
        }
        try {
            if (origPath != null) {
                Path fullOrigPath = Paths.get(this.labelRepository, origPath);
                Files.delete(fullOrigPath);
            }
        }
        catch (Exception e) {
            log.warn("Failed to delete file [" + origPath + "]");
        }
        this.labelContentDAO.delete(labelContentId);
    }

    public String generateLabelCopyName(Label label) {
        String name;
        Long organisationId = label.getOrganisationId();
        List<Label> labels = this.labelDAO.getByOrganisation(organisationId);
        boolean findingUniqueName = true;
        String nameCopy = name = label.getName();
        String postfix = "~";
        int count = 0;
        while (findingUniqueName && count < 99) {
            boolean foundSameName = false;
            for (Label l : labels) {
                if (!l.getName().equals(name + postfix + count)) continue;
                foundSameName = true;
            }
            if (foundSameName) {
                ++count;
                continue;
            }
            nameCopy = name + postfix + count;
            findingUniqueName = false;
        }
        if (nameCopy == null || findingUniqueName) {
            return null;
        }
        return nameCopy;
    }
}

