/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.MasterDataSet;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.ObjectType;
import at.cdes.impl.dao.GenObjectTypeDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcObjectTypeDAO
extends AbstrIdDAO<ObjectType>
implements GenObjectTypeDAO {
    public AbstractJdbcObjectTypeDAO() {
        super(ObjectType.class, "id", "object_type", new String[]{"id", "code", "name", "comment", "network_id", "master_data_set_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcObjectTypeDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "code") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "comment") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "master_data_set_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcObjectTypeDAO.getSelectClauseForDto("object_type", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcObjectTypeDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".code" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "code") + "," + entityLocalName + ".name" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + "," + entityLocalName + ".comment" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "comment") + "," + entityLocalName + ".network_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + "," + entityLocalName + ".master_data_set_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "master_data_set_id") + " ";
    }

    protected ObjectType fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        ObjectType objectType = new ObjectType();
        objectType.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectType.setCode(rs.getString(++columnIndex));
        objectType.setName(rs.getString(++columnIndex));
        objectType.setComment(rs.getString(++columnIndex));
        objectType.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectType.setMasterDataSetId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return objectType;
    }

    public static ObjectType fillObjectTypeFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        ObjectType objectType = new ObjectType();
        objectType.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        objectType.setCode(rs.getString(columnIndex.incrementAndGet()));
        objectType.setName(rs.getString(columnIndex.incrementAndGet()));
        objectType.setComment(rs.getString(columnIndex.incrementAndGet()));
        objectType.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        objectType.setMasterDataSetId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return objectType;
    }

    public static ObjectType fillObjectTypeFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcObjectTypeDAO.fillObjectTypeFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 6;
    }

    @Override
    public void deleteByNetworkId(final Long networkId) {
        String sql = "DELETE FROM object_type WHERE network_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, networkId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(ObjectType dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<ObjectType> dtos) {
        Iterator<ObjectType> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, ObjectType objectType) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)objectType.getId());
        statement.setString(2, objectType.getCode());
        statement.setString(3, objectType.getName());
        statement.setString(4, objectType.getComment());
        JDBCHelper.setLong((PreparedStatement)statement, (int)5, (Number)objectType.getNetworkId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)6, (Number)objectType.getMasterDataSetId());
    }

    @Override
    public List<ObjectType> getByNetwork(Network network) {
        return this.getByNetwork(network.getId());
    }

    @Override
    public List<ObjectType> getByNetwork(final Long networkId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkId);
            }
        });
    }

    @Override
    public List<ObjectType> getByMasterDataSet(MasterDataSet masterDataSet) {
        return this.getByMasterDataSet(masterDataSet.getId());
    }

    @Override
    public List<ObjectType> getByMasterDataSet(final Long masterDataSetId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"master_data_set_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, masterDataSetId);
            }
        });
    }

    @Override
    public List<ObjectType> getByNetworks(Collection<Long> networkId) {
        if (networkId.isEmpty()) {
            return new ArrayList<ObjectType>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkId.size()];
        int n = 0;
        Iterator<Long> it = networkId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<ObjectType> getByMasterDataSets(Collection<Long> masterDataSetId) {
        if (masterDataSetId.isEmpty()) {
            return new ArrayList<ObjectType>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[masterDataSetId.size()];
        int n = 0;
        Iterator<Long> it = masterDataSetId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"master_data_set_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

