/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.sec;

import at.cdes.api.dto.Person;
import at.cdes.api.sec.PasswordStatus;
import at.cdes.api.sec.PasswordStatusChecker;
import at.cdes.impl.dao.PersonDAO;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordStatusCheckerImpl
implements PasswordStatusChecker {
    private static final Logger log = LoggerFactory.getLogger(PasswordStatusCheckerImpl.class);
    private Long passwordMaxAge;
    private Long passwordExpireInterval;
    private Long passwordExpireExtendInterval;
    private PersonDAO personDAO;

    public void setPasswordMaxAge(Long passwordMaxAge) {
        this.passwordMaxAge = passwordMaxAge;
    }

    public void setPasswordExpireInterval(Long passwordExpireInterval) {
        this.passwordExpireInterval = passwordExpireInterval;
    }

    public void setPasswordExpireExtendInterval(Long passwordExpireExtendInterval) {
        this.passwordExpireExtendInterval = passwordExpireExtendInterval;
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }

    public PasswordStatus checkPasswordStatus(Long personId, Long lastPasswordChangeTs) {
        if (this.passwordMaxAge == 0L) {
            return PasswordStatus.VALID;
        }
        if (lastPasswordChangeTs == null) {
            Person person = (Person)this.personDAO.get(personId);
            lastPasswordChangeTs = person.getLastPasswordChangeTs();
        }
        if (lastPasswordChangeTs == null) {
            return PasswordStatus.WARN;
        }
        Long days = ChronoUnit.DAYS.between(Instant.ofEpochMilli(lastPasswordChangeTs), Instant.now());
        if (days < this.passwordMaxAge - this.passwordExpireInterval) {
            return PasswordStatus.VALID;
        }
        if (days <= this.passwordMaxAge) {
            return PasswordStatus.WARN;
        }
        return PasswordStatus.EXPIRED;
    }

    public Long extendLastPasswordChangeTs(Long personId) {
        Person person = (Person)this.personDAO.get(personId);
        Long lastPasswordChangeTs = person.getLastPasswordChangeTs();
        Long days = ChronoUnit.DAYS.between(Instant.ofEpochMilli(lastPasswordChangeTs), Instant.now());
        if (days > this.passwordMaxAge) {
            Instant newPasswordChangeTsInst = ChronoUnit.DAYS.addTo(Instant.now(), this.passwordExpireExtendInterval - this.passwordMaxAge);
            lastPasswordChangeTs = newPasswordChangeTsInst.toEpochMilli();
        }
        return lastPasswordChangeTs;
    }
}

