/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.planning;

import at.cdes.api.compositeDto.PlanningNotificationOrderReferenceInfo;
import at.cdes.api.dto.MetaTag;
import at.cdes.api.dto.PlanningNotificationAttachment;
import at.cdes.api.dto.PlanningNotificationOrderTag;
import at.cdes.api.dto.PlanningNotificationTextMetaInformation;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.searchModel.PlanningNotificationOrderSearchModel;
import at.cdes.api.dto.searchModel.PlanningNotificationSearchModel;
import at.cdes.api.dto.searchModel.PlanningReviewProtocolSearchModel;
import at.cdes.api.guiService.PlanningNotificationService;
import at.cdes.api.guiService.UtilService;
import at.cdes.api.joinDto.WorkflowActivityPositionResultJoin;
import at.cdes.api.joinDto.WorkflowNodeJoin;
import at.cdes.api.planning.compositeDto.FlatReportInfo;
import at.cdes.api.planning.compositeDto.PlanningNotificationReportColumnSettings;
import at.cdes.api.planning.compositeDto.PlanningNotificationReportExportInfo;
import at.cdes.api.planning.compositeDto.PlanningNotificationReportInfo;
import at.cdes.api.planning.voc.PlanningNotificationReportFileType;
import at.cdes.api.planning.voc.PlanningNotificationReportType;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.export.planning.PlanningExportHelper;
import at.cdes.impl.export.planning.PlanningReportLocalStyles;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.odf.OdfFromHtmlConverter;
import at.cdes.impl.util.odf.OdfHelper;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.style.AutomaticStyles;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.util.aop.ThreadLocalManager;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.style.StyleFooterElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMasterPageElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeMasterStyles;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class PlanningReportHelper {
    private static final Logger log = LoggerFactory.getLogger(PlanningReportHelper.class);
    private static Map<String, String> clientColumnToReportColumn = new HashMap<String, String>();

    public static void constructPlanningNotificationHeader(OdfContext context, OdfTextDocument document, String standardParagraphStyle, Collection<Project> projects, boolean enableCustomerLogo) throws Exception {
        Styles styles = context.getStylesOfficeStyles();
        String leftHeaderTextStyle = styles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[0]);
        StyleTableCellPropertiesElement headerCellStyleRaw = styles.constructTableCellPropertiesWithPaddingAndBorders("0.125cm", "none", "0.125cm", "none", "0cm", "none", "0.3cm", "none");
        String headerCellStyle = styles.getTableCellStyle(new OdfStylePropertiesBase[]{headerCellStyleRaw});
        String projectString = "";
        Iterator<Project> projectIterator = projects.iterator();
        while (projectIterator.hasNext()) {
            Project project = projectIterator.next();
            projectString = projectString + "(" + project.getCode() + ") " + project.getName();
            if (!projectIterator.hasNext()) continue;
            projectString = projectString + ", ";
        }
        OdfHelper.constructHeader(context, document, standardParagraphStyle, projectString, enableCustomerLogo);
    }

    public static void constructPlanningNotificationFooter(OdfContext context, OdfTextDocument document, String standardParagraphStyle, Bundle bundle, String reportName, String organisationName) {
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
        AutomaticStyles styles = context.getStylesAutomaticStyles();
        String leftFooterTextStyle = styles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{styles.constructTextPropertiesWithFontSize("8pt")});
        String rightFooterTextStyle = styles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{styles.constructTextPropertiesWithFontSize("8pt"), styles.constructParagraphPropertiesWithTextAlign("end")});
        String footerCellStyle = styles.getTableCellStyle(new OdfStylePropertiesBase[]{styles.constructTableCellPropertiesWithPaddingAndBorders("0.125cm", "none", "0.125cm", "none", "0cm", "none", "0cm", "none")});
        OdfOfficeMasterStyles masterStyles = document.getOfficeMasterStyles();
        Iterator masterPages = masterStyles.getMasterPages();
        while (masterPages.hasNext()) {
            StyleMasterPageElement masterPage = (StyleMasterPageElement)masterPages.next();
            StyleFooterElement footerElement = masterPage.newStyleFooterElement();
            TableTableElement footerTableElement = footerElement.newTableTableElement();
            TableFactory.appendColumnWithOptimalSize((Styles)styles, (TableTableElement)footerTableElement);
            TableFactory.appendColumnWithOptimalSize((Styles)styles, (TableTableElement)footerTableElement);
            reportName = reportName != null ? reportName : "";
            String bundleVersionString = bundle.getVersion().toString();
            String versionString = MessageFormat.format(resourceBundle.getString("planningNotificationReportVersionString"), reportName, bundleVersionString);
            TableTableRowElement footerRowElementOne = TableFactory.appendRow((TableTableElement)footerTableElement, null);
            TableFactory.appendCell((String)footerCellStyle, (String)leftFooterTextStyle, (TableTableRowElement)footerRowElementOne, (String[])new String[]{versionString});
            TableTableRowElement footerRowElementTwo = TableFactory.appendRow((TableTableElement)footerTableElement, null);
            TableFactory.appendCell((String)footerCellStyle, (String)leftFooterTextStyle, (TableTableRowElement)footerRowElementTwo, (String[])new String[]{"c.des"});
            TableTableRowElement footerRowElementThree = TableFactory.appendRow((TableTableElement)footerTableElement, null);
            TableFactory.appendCell((String)footerCellStyle, (String)leftFooterTextStyle, (TableTableRowElement)footerRowElementThree, (String[])new String[]{organisationName});
            TableFactory.appendPageOfPagesCell((String)footerCellStyle, (String)rightFooterTextStyle, (TableTableRowElement)footerRowElementThree, (String)resourceBundle.getString("page"));
        }
    }

    public static String formatUtcMillisAsYearToDay(Long utcMillis) {
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
        String dateFormatPattern = resourceBundle.getString("yearToDayFormat");
        return utcMillis != null ? DateHelper.formatUtcMillis(utcMillis, "Europe/Vienna", dateFormatPattern) : "";
    }

    public static void setColumnWidth(Map<String, Double> absoluteColumnWidths, String key, Double value, Boolean show) {
        if (show != null && show.booleanValue()) {
            absoluteColumnWidths.put(key, value);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void ensureAbsoluteColumnWidth(Map<String, Double> relativeColumnWidths, Map<String, Double> minAbsWidths, Double totalWidth) {
        void var9_15;
        if (log.isDebugEnabled()) {
            log.debug("ensureAbsoluteColumnWidth called for totalWidth = [" + totalWidth + "]");
        }
        Double relWidthSum = 0.0;
        for (String column : relativeColumnWidths.keySet()) {
            if (log.isDebugEnabled()) {
                log.debug("... Relative column width for column [" + column + "] is [" + relativeColumnWidths.get(column) + "]");
            }
            relWidthSum = relWidthSum + relativeColumnWidths.get(column);
        }
        Double minAbsWidthSum = 0.0;
        HashSet<String> incompleteMinAbsWidthColumns = new HashSet<String>();
        Double completeMinAbsColumnWidthSum = 0.0;
        for (String string : minAbsWidths.keySet()) {
            Double d = minAbsWidths.get(string);
            Double actualRelativeWidth = relativeColumnWidths.get(string);
            if (d == null || actualRelativeWidth == null) continue;
            Double relAbsWidth = actualRelativeWidth / relWidthSum * totalWidth;
            if (log.isDebugEnabled()) {
                log.debug("... absWidthColumn [" + string + "] has planned absWidth [" + relAbsWidth + "] and minAbsWidth [" + d + "]");
            }
            if (relAbsWidth < d) {
                minAbsWidthSum = minAbsWidthSum + minAbsWidths.get(string);
                incompleteMinAbsWidthColumns.add(string);
                continue;
            }
            completeMinAbsColumnWidthSum = completeMinAbsColumnWidthSum + relAbsWidth;
        }
        if (log.isDebugEnabled()) {
            log.debug("... relWidthSum = [" + relWidthSum + "]; minAbsWidthSum = [" + minAbsWidthSum + "]; completeMinAbsColumnWidthSum = [" + completeMinAbsColumnWidthSum + "]");
        }
        if (incompleteMinAbsWidthColumns.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("No columns need to be enlarged, so nothing to do for us here, will abort now.");
            }
            return;
        }
        Double minAbsSum = 0.0;
        for (String string : incompleteMinAbsWidthColumns) {
            Double absoluteWidth = minAbsWidths.get(string);
            Double relativeWidth = absoluteWidth / totalWidth * relWidthSum;
            relativeColumnWidths.put(string, relativeWidth);
            minAbsSum = minAbsSum + absoluteWidth;
            if (!log.isDebugEnabled()) continue;
            log.debug("... Corrected relative column width of minAbsColumn [" + string + "] to [" + relativeWidth + "]");
        }
        minAbsSum = minAbsSum + completeMinAbsColumnWidthSum;
        Double d = totalWidth - minAbsSum;
        Double d2 = 0.0;
        for (String column : relativeColumnWidths.keySet()) {
            if (minAbsWidths.containsKey(column) || relativeColumnWidths.get(column) == null) continue;
            Double d3 = var9_15.doubleValue() + relativeColumnWidths.get(column);
        }
        if (log.isDebugEnabled()) {
            log.debug("... Remaining absolute width for the other columns is [" + d + "]; remaining relative width sum is [" + var9_15 + "]");
        }
        for (String column : relativeColumnWidths.keySet()) {
            if (!minAbsWidths.containsKey(column) && relativeColumnWidths.get(column) != null) {
                Double fraction = relativeColumnWidths.get(column) / var9_15.doubleValue();
                Double newAbsWidth = fraction * d;
                Double newRelWidth = newAbsWidth / totalWidth * relWidthSum;
                relativeColumnWidths.put(column, newRelWidth);
                if (!log.isDebugEnabled()) continue;
                log.debug("... Correcting column [" + column + "] to newRelWidth = [" + newRelWidth + "]");
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("... Keeping relative width of column [" + column + "] = [" + relativeColumnWidths.get(column) + "]");
        }
        if (log.isDebugEnabled()) {
            log.debug("Done correcting column widths.");
        }
    }

    public static List<FlatReportInfo> getFlatReportInfos(PlanningNotificationService planningNotificationService, PlanningNotificationReportExportInfo exportInfo, ActionDAO actionDAO, boolean duplicateRows) {
        PlanningNotificationSearchModel notificationSearchModel = PlanningReportHelper.getPlanningNotificationSearchModel(exportInfo);
        PlanningNotificationOrderSearchModel orderSearchModel = PlanningReportHelper.getPlanningNotificationOrderSearchModel(exportInfo);
        PlanningReviewProtocolSearchModel reviewSearchModel = PlanningReportHelper.getPlanningReviewProtocolSearchModel(exportInfo);
        List<PlanningNotificationReportInfo> reportInfos = planningNotificationService.getPlanningNotificationReportJoins(notificationSearchModel, orderSearchModel, reviewSearchModel, null);
        Long organisationPersonId = exportInfo.getOrganisationPersonId();
        reportInfos = PlanningReportHelper.filterReportInfosForPrivileges(reportInfos, organisationPersonId, actionDAO);
        if (exportInfo.getColumnSettings().getShowWorkflowNode() == null) {
            exportInfo.getColumnSettings().setShowWorkflowNode(Boolean.valueOf(false));
        }
        exportInfo.getColumnSettings().setExportWorkflowNodesFlat(Boolean.valueOf(!duplicateRows && exportInfo.getFileType() != PlanningNotificationReportFileType.PDF_LIST && exportInfo.getColumnSettings().getShowWorkflowNode() != false));
        List<FlatReportInfo> flatReportInfos = PlanningReportHelper.constructFlatReportInfos(reportInfos, duplicateRows, exportInfo.getColumnSettings().getExportWorkflowNodesFlat());
        return flatReportInfos;
    }

    public static boolean duplicateRows(PlanningNotificationReportColumnSettings columnSettings) {
        return columnSettings.getShowWorkflowNodeName() != null && columnSettings.getShowWorkflowNodeName() != false || columnSettings.getShowReviewBaulos() != null && columnSettings.getShowReviewBaulos() != false || columnSettings.getShowTokenInitiator() != null && columnSettings.getShowTokenInitiator() != false || columnSettings.getShowReviewer() != null && columnSettings.getShowReviewer() != false || columnSettings.getShowIssued() != null && columnSettings.getShowIssued() != false || columnSettings.getShowReviewComment() != null && columnSettings.getShowReviewComment() != false || columnSettings.getShowResult() != null && columnSettings.getShowResult() != false || columnSettings.getShowAttachment() != null && columnSettings.getShowAttachment() != false;
    }

    private static List<FlatReportInfo> constructFlatReportInfos(List<PlanningNotificationReportInfo> reportInfos, boolean duplicateRows, boolean exportWorkflowNodesFlat) {
        ArrayList<FlatReportInfo> flatReportInfos = new ArrayList<FlatReportInfo>();
        for (PlanningNotificationReportInfo reportInfo : reportInfos) {
            ArrayList<PlanningNotificationReportInfo> reportInfosNew = new ArrayList<PlanningNotificationReportInfo>();
            if (exportWorkflowNodesFlat) {
                List workflowNodeJoins = reportInfo.getWorkflowNodeJoins();
                Collections.sort(workflowNodeJoins, new Comparator<WorkflowNodeJoin>(){

                    @Override
                    public int compare(WorkflowNodeJoin joinOne, WorkflowNodeJoin joinTwo) {
                        return joinOne.getWorkflowNodeTemplatePosition() - joinTwo.getWorkflowNodeTemplatePosition();
                    }
                });
                Map workflowNodeIdToPositions = reportInfo.getWorkflowNodeIdToPositions();
                Map workflowNodePositionIdToBaulose = reportInfo.getWorkflowNodePositionIdToBaulose();
                PlanningNotificationReportInfo reportInfoNew = null;
                boolean notAnyPositions = true;
                for (int n = 0; workflowNodeJoins != null && n < workflowNodeJoins.size(); ++n) {
                    WorkflowNodeJoin workflowNodeJoin = (WorkflowNodeJoin)workflowNodeJoins.get(n);
                    List workflowNodePositionJoins = (List)workflowNodeIdToPositions.get(workflowNodeJoin.getWorkflowNodeId());
                    for (int z = 0; z == 0 || z < workflowNodePositionJoins.size(); ++z) {
                        ArrayList<WorkflowNodeJoin> workflowNodeJoinsNew;
                        notAnyPositions = false;
                        WorkflowNodeJoin workflowNodePositionJoin = null;
                        if (workflowNodePositionJoins.size() > 0) {
                            workflowNodePositionJoin = (WorkflowNodeJoin)workflowNodePositionJoins.get(z);
                        }
                        if (n == 0) {
                            reportInfoNew = new PlanningNotificationReportInfo(reportInfo.getReportJoin(), reportInfo.getMetaTagIdToDateMetaInformations(), reportInfo.getMetaTagIdToTextMetaInformations(), reportInfo.getRemovableMetaInformationIds(), reportInfo.getProjects(), reportInfo.getReferenceInfos(), reportInfo.getBaulosMetaInformations(), reportInfo.getTags(), reportInfo.getAllowedProjectActions(), reportInfo.getWorkflowInitialized(), reportInfo.getWorkflowNodeJoins(), null, reportInfo.getWorkflowNodePositionIdToOwnerTokens(), reportInfo.getWorkflowNodePositionIdToBaulose(), reportInfo.getWorkflowNodeInitiatorPositionIdToHasResults(), reportInfo.getWorkflowActivityPositionResultJoins(), reportInfo.getWorkflowActivityIdToBaulose(), reportInfo.getWorkflowActivityIdToAttachments(), reportInfo.getMatchingBaulosIds());
                            workflowNodeJoinsNew = new ArrayList();
                            HashMap<Long, ArrayList<WorkflowNodeJoin>> workflowNodeIdToPositionsNew = new HashMap<Long, ArrayList<WorkflowNodeJoin>>();
                            if (workflowNodePositionJoin != null) {
                                workflowNodeJoinsNew.add(workflowNodePositionJoin);
                            }
                            workflowNodeIdToPositionsNew.put(workflowNodeJoin.getWorkflowNodeId(), workflowNodeJoinsNew);
                            reportInfoNew.setWorkflowNodeIdToPositions(workflowNodeIdToPositionsNew);
                            reportInfosNew.add(reportInfoNew);
                            continue;
                        }
                        workflowNodeJoinsNew = new ArrayList<WorkflowNodeJoin>();
                        if (workflowNodePositionJoin != null) {
                            workflowNodeJoinsNew.add(workflowNodePositionJoin);
                        }
                        for (int y = 0; y < reportInfosNew.size(); ++y) {
                            ((PlanningNotificationReportInfo)reportInfosNew.get(y)).getWorkflowNodeIdToPositions().put(workflowNodeJoin.getWorkflowNodeId(), workflowNodeJoinsNew);
                        }
                    }
                }
                if (!notAnyPositions) {
                    for (PlanningNotificationReportInfo reportInfoForFlat : reportInfosNew) {
                        flatReportInfos.add(new FlatReportInfo(true, true, reportInfoForFlat, null));
                    }
                    continue;
                }
                flatReportInfos.add(new FlatReportInfo(true, true, reportInfo, null));
                continue;
            }
            List resultJoins = reportInfo.getWorkflowActivityPositionResultJoins();
            if (resultJoins != null && resultJoins.size() > 0) {
                if (duplicateRows) {
                    for (WorkflowActivityPositionResultJoin resultJoin : resultJoins) {
                        flatReportInfos.add(new FlatReportInfo(true, false, reportInfo, resultJoin));
                    }
                    continue;
                }
                flatReportInfos.add(new FlatReportInfo(true, false, reportInfo, null));
                continue;
            }
            flatReportInfos.add(new FlatReportInfo(true, false, reportInfo, null));
        }
        return flatReportInfos;
    }

    public static Map<String, Double> getFlatReportColumnWidths(List<MetaTag> metaTags, PlanningNotificationReportColumnSettings columnSettings) {
        HashMap<String, Double> absoluteColumnWidths = new HashMap<String, Double>();
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "title", 7.0, columnSettings.getShowTitle());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "notificationComment", 5.0, columnSettings.getShowNotificationComment());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "project", 5.0, columnSettings.getShowProject());
        if (columnSettings.getMetaTagIdToShow() != null) {
            for (MetaTag metaTag : metaTags) {
                String cssClass = metaTag.getCssClass();
                PlanningReportHelper.setColumnWidth(absoluteColumnWidths, cssClass, 6.0, (Boolean)columnSettings.getMetaTagIdToShow().get(cssClass));
            }
        }
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "serialNumber", 2.0, columnSettings.getShowSerialNumber());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "text", 12.0, columnSettings.getShowText());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "subjectArea", 4.0, columnSettings.getShowSubjectArea());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "authorizedInspector", 4.0, columnSettings.getShowAuthorizedInspector());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "reference", 4.0, columnSettings.getShowReference());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "statutoryDuty", 4.0, columnSettings.getShowStatutoryDuty());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "invalidated", 4.0, columnSettings.getShowInvalidated());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "documentPosition", 3.0, columnSettings.getShowDocumentPosition());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "documentPage", 3.0, columnSettings.getShowDocumentPage());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "source", 3.0, columnSettings.getShowSource());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "personInCharge", 3.0, columnSettings.getShowPersonInCharge());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "statutoryDutyFrom", 4.0, columnSettings.getShowStatutoryDutyFrom());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "statutoryDutyTo", 4.0, columnSettings.getShowStatutoryDutyTo());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "statutoryDutyInterval", 4.0, columnSettings.getShowStatutoryDutyInterval());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "statutoryDutyLeadTime", 4.0, columnSettings.getShowStatutoryDutyLeadTime());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "statutoryDutyExpired", 4.0, columnSettings.getShowStatutoryDutyExpired());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "submitAuthority", 4.0, columnSettings.getShowSubmitAuthority());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "tag", 4.0, columnSettings.getShowTags());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "orderComment", 5.0, columnSettings.getShowOrderComment());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "environmentallyRelevant", 4.0, columnSettings.getShowEnvironmentallyRelevant());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "workflowNode", 8.0, columnSettings.getShowWorkflowNode());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "state", 4.0, columnSettings.getShowState());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "workflowNodeName", 4.0, columnSettings.getShowWorkflowNodeName());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "reviewBaulos", 4.0, columnSettings.getShowReviewBaulos());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "tokenInitiator", 5.0, columnSettings.getShowTokenInitiator());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "reviewer", 5.0, columnSettings.getShowReviewer());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "issued", 4.0, columnSettings.getShowIssued());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "reviewComment", 5.0, columnSettings.getShowReviewComment());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "result", 4.0, columnSettings.getShowResult());
        PlanningReportHelper.setColumnWidth(absoluteColumnWidths, "attachment", 3.0, columnSettings.getShowAttachment());
        return absoluteColumnWidths;
    }

    private static boolean doShow(Boolean show, Boolean reportTypeALL) {
        return reportTypeALL != false || show != null && show == true;
    }

    public static List<FancyOdfTableColumn<FlatReportInfo>> constructFlatReportColumns(final PlanningReportLocalStyles localStyles, List<MetaTag> metaTags, PlanningNotificationReportColumnSettings columnSettings, Boolean reportTypeALL, final UtilService utilService, final Styles contentAutomaticStyles) {
        final ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        final String dataCellStyle = localStyles.getDataCellStyle();
        final String internetLinkStyle = localStyles.getInternetLinkStyle();
        ArrayList<FancyOdfTableColumn<FlatReportInfo>> columns = new ArrayList<FancyOdfTableColumn<FlatReportInfo>>();
        if (PlanningReportHelper.doShow(columnSettings.getShowSerialNumber(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("serialNumber", resourceBundle.getString("planningNotificationOrderSerialNumberColumnCaption")){

                protected String getString(FlatReportInfo data) {
                    if (data.getShowReportInfo()) {
                        Long serialNumber = data.getReportInfo().getReportJoin().getPlanningNotificationOrderSerialNumber();
                        return serialNumber != null ? serialNumber.toString() : "";
                    }
                    return "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowText(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("text", resourceBundle.getString("planningNotificationOrderTextColumnCaption")){

                protected String getString(FlatReportInfo data) {
                    if (data.getShowReportInfo()) {
                        return data.getReportInfo().getReportJoin().getPlanningNotificationOrderText();
                    }
                    return "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowTitle(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("title", resourceBundle.getString("planningNotificationListTitleColumnCaption")){

                protected String getString(FlatReportInfo data) {
                    return data.getShowReportInfo() ? data.getReportInfo().getReportJoin().getPlanningNotificationTitle() : "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowNotificationComment(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("notificationComment", resourceBundle.getString("planningNotificationListCommentColumnCaption")){

                protected String getString(FlatReportInfo data) {
                    return data.getShowReportInfo() ? data.getReportInfo().getReportJoin().getPlanningNotificationComment() : "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowProject(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("project", resourceBundle.getString("planningNotificationListProjectColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])this.getProjectStrings(data));
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String[])this.getProjectStrings(dataOne), (String[])this.getProjectStrings(dataTwo), (boolean)descending);
                }

                private String[] getProjectStrings(FlatReportInfo data) {
                    if (data.getShowReportInfo()) {
                        List projects = data.getReportInfo().getProjects();
                        String[] projectNames = new String[2 * projects.size()];
                        for (int n = 0; n < projects.size(); ++n) {
                            projectNames[2 * n] = ((Project)projects.get(n)).getCode();
                            projectNames[2 * n + 1] = ((Project)projects.get(n)).getName();
                        }
                        return projectNames;
                    }
                    return new String[0];
                }
            });
        }
        Collections.sort(metaTags, new Comparator<MetaTag>(){

            @Override
            public int compare(MetaTag metaTagOne, MetaTag metaTagTwo) {
                return metaTagOne.getPosition() - metaTagTwo.getPosition();
            }
        });
        for (final MetaTag metaTag : metaTags) {
            Long metaTagId = metaTag.getId();
            if (columnSettings.getMetaTagIdToShow() == null || !PlanningReportHelper.doShow((Boolean)columnSettings.getMetaTagIdToShow().get(metaTagId), reportTypeALL)) continue;
            columns.add(new FancyOdfTableColumn<FlatReportInfo>(metaTag.getCssClass(), metaTag.getName()){

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    List<String> tokens = this.getTokens(data);
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, tokens);
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, this.getTokens(dataOne), this.getTokens(dataTwo), (boolean)descending);
                }

                private List<String> getTokens(FlatReportInfo data) {
                    if (data.getShowReportInfo()) {
                        return PlanningExportHelper.getMetaTagTokens(resourceBundle, metaTag, data.getReportInfo().getMetaTagIdToTextMetaInformations(), data.getReportInfo().getMetaTagIdToDateMetaInformations());
                    }
                    return new ArrayList<String>();
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowDocumentPosition(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("documentPosition", resourceBundle.getString("planningNotificationOrderDocumentPositionColumnCaption")){

                protected String getString(FlatReportInfo data) {
                    return data.getShowReportInfo() ? data.getReportInfo().getReportJoin().getPlanningNotificationOrderDocumentPosition() : "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowDocumentPage(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("documentPage", resourceBundle.getString("planningNotificationOrderDocumentPageColumnCaption")){

                protected String getString(FlatReportInfo data) {
                    return data.getShowReportInfo() ? data.getReportInfo().getReportJoin().getPlanningNotificationOrderDocumentPage() : "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowSubjectArea(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("subjectArea", resourceBundle.getString("planningNotificationOrderSubjectAreaColumnCaption")){

                protected String getString(FlatReportInfo data) {
                    return data.getShowReportInfo() ? data.getReportInfo().getReportJoin().getSubjectAreaName() : "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowAuthorizedInspector(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("authorizedInspector", resourceBundle.getString("planningNotificationOrderAuthorizedInspectorColumnCaption")){

                protected String getString(FlatReportInfo data) {
                    return data.getShowReportInfo() ? data.getReportInfo().getReportJoin().getPlanningNotificationOrderAuthorizedInspector() : "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowReference(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("reference", resourceBundle.getString("planningNotificationOrderReferenceColumnCaption")){

                protected String getString(FlatReportInfo data) {
                    if (data.getShowReportInfo()) {
                        List referenceInfos = data.getReportInfo().getReferenceInfos();
                        Collections.sort(referenceInfos, new Comparator<PlanningNotificationOrderReferenceInfo>(){

                            @Override
                            public int compare(PlanningNotificationOrderReferenceInfo referenceInfoOne, PlanningNotificationOrderReferenceInfo referenceInfoTwo) {
                                return (int)(referenceInfoOne.getPlanningNotificationOrder().getSerialNumber() - referenceInfoTwo.getPlanningNotificationOrder().getSerialNumber());
                            }
                        });
                        String result = "";
                        for (int n = 0; n < referenceInfos.size(); ++n) {
                            PlanningNotificationOrderReferenceInfo referenceInfo = (PlanningNotificationOrderReferenceInfo)referenceInfos.get(n);
                            result = result + referenceInfo.getPlanningNotificationOrder().getSerialNumber().toString();
                            if (n >= referenceInfos.size() - 1) continue;
                            result = result + ", ";
                        }
                        return result;
                    }
                    return "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowSource(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("source", resourceBundle.getString("planningNotificationOrderSourceColumnCaption")){

                protected String getString(FlatReportInfo data) {
                    return data.getShowReportInfo() ? data.getReportInfo().getReportJoin().getPlanningNotificationOrderSource() : "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowSubmitAuthority(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("submitAuthority", resourceBundle.getString("planningNotificationOrderSubmitAuthorityColumnCaption")){

                protected String getString(FlatReportInfo data) {
                    if (data.getShowReportInfo()) {
                        Boolean submitAuthority = data.getReportInfo().getReportJoin().getPlanningNotificationOrderSubmitAuthority();
                        return submitAuthority != null && submitAuthority == true ? resourceBundle.getString("yes") : resourceBundle.getString("no");
                    }
                    return "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowTags(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("tag", resourceBundle.getString("planningNotificationOrderTagColumnCaption")){

                protected String getString(FlatReportInfo data) {
                    if (data.getShowReportInfo()) {
                        String tagString = "";
                        List tags = data.getReportInfo().getTags();
                        for (int n = 0; n < tags.size(); ++n) {
                            tagString = tagString + ((PlanningNotificationOrderTag)tags.get(n)).getLabel();
                            if (n >= tags.size() - 1) continue;
                            tagString = tagString + ", ";
                        }
                        return tagString;
                    }
                    return "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowInvalidated(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("invalidated", resourceBundle.getString("planningNotificationOrderInvalidatedColumnCaption")){

                protected String getString(FlatReportInfo data) {
                    if (data.getShowReportInfo()) {
                        Boolean invalidated = data.getReportInfo().getReportJoin().getWorkflowEntityInvalidated();
                        return invalidated != null && invalidated == true ? resourceBundle.getString("yes") : resourceBundle.getString("no");
                    }
                    return "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowStatutoryDuty(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("statutoryDuty", resourceBundle.getString("planningNotificationOrderStatutoryDutyColumnCaption")){

                protected String getString(FlatReportInfo data) {
                    return data.getShowReportInfo() ? data.getReportInfo().getReportJoin().getStatutoryDutyName() : "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowPersonInCharge(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("personInCharge", resourceBundle.getString("planningNotificationOrderPersonInChargeColumnCaption")){

                protected String getString(FlatReportInfo data) {
                    return data.getShowReportInfo() ? data.getReportInfo().getReportJoin().getPersonInChargeName() : "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowStatutoryDutyFrom(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("statutoryDutyFrom", resourceBundle.getString("planningNotificationOrderStatutoryDutyFromColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultLongCompare((Collator)collator, (Long)dataOne.getReportInfo().getReportJoin().getPlanningNotificationOrderStatutoryDutyFrom(), (Long)dataTwo.getReportInfo().getReportJoin().getPlanningNotificationOrderStatutoryDutyFrom(), (boolean)descending);
                }

                private String getOutput(FlatReportInfo data) {
                    if (data.getShowReportInfo()) {
                        String dateFormatPattern = resourceBundle.getString("yearToDayFormat");
                        Long utcMillis = data.getReportInfo().getReportJoin().getPlanningNotificationOrderStatutoryDutyFrom();
                        return utcMillis != null ? DateHelper.formatUtcMillis(utcMillis, "Europe/Vienna", dateFormatPattern) : "";
                    }
                    return "";
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowStatutoryDutyTo(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("statutoryDutyTo", resourceBundle.getString("planningNotificationOrderStatutoryDutyToColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultLongCompare((Collator)collator, (Long)dataOne.getReportInfo().getReportJoin().getPlanningNotificationOrderStatutoryDutyTo(), (Long)dataTwo.getReportInfo().getReportJoin().getPlanningNotificationOrderStatutoryDutyTo(), (boolean)descending);
                }

                private String getOutput(FlatReportInfo data) {
                    if (data.getShowReportInfo()) {
                        String dateFormatPattern = resourceBundle.getString("yearToDayFormat");
                        Long utcMillis = data.getReportInfo().getReportJoin().getPlanningNotificationOrderStatutoryDutyTo();
                        return utcMillis != null ? DateHelper.formatUtcMillis(utcMillis, "Europe/Vienna", dateFormatPattern) : "";
                    }
                    return "";
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowStatutoryDutyInterval(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("statutoryDutyInterval", resourceBundle.getString("planningNotificationOrderStatutoryDutyIntervalColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Integer intervalOne = dataOne.getReportInfo().getReportJoin().getPlanningNotificationOrderStatutoryDutyInterval();
                    Integer intervalTwo = dataTwo.getReportInfo().getReportJoin().getPlanningNotificationOrderStatutoryDutyInterval();
                    return FancyOdfTableColumn.defaultLongCompare((Collator)collator, (Long)(intervalOne != null ? Long.valueOf(intervalOne.longValue()) : null), (Long)(intervalTwo != null ? Long.valueOf(intervalTwo.longValue()) : null), (boolean)descending);
                }

                private String getOutput(FlatReportInfo data) {
                    if (data.getShowReportInfo()) {
                        Integer interval = data.getReportInfo().getReportJoin().getPlanningNotificationOrderStatutoryDutyInterval();
                        return interval != null ? interval.toString() : "";
                    }
                    return "";
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowStatutoryDutyLeadTime(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("statutoryDutyLeadTime", resourceBundle.getString("planningNotificationOrderStatutoryDutyLeadTimeColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getOutput(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Integer leadTimeOne = dataOne.getReportInfo().getReportJoin().getPlanningNotificationOrderStatutoryDutyLeadTime();
                    Integer leadTimeTwo = dataTwo.getReportInfo().getReportJoin().getPlanningNotificationOrderStatutoryDutyLeadTime();
                    return FancyOdfTableColumn.defaultLongCompare((Collator)collator, (Long)(leadTimeOne != null ? Long.valueOf(leadTimeOne.longValue()) : null), (Long)(leadTimeTwo != null ? Long.valueOf(leadTimeTwo.longValue()) : null), (boolean)descending);
                }

                private String getOutput(FlatReportInfo data) {
                    if (data.getShowReportInfo()) {
                        Integer leadTime = data.getReportInfo().getReportJoin().getPlanningNotificationOrderStatutoryDutyLeadTime();
                        return leadTime != null ? leadTime.toString() : "";
                    }
                    return "";
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowStatutoryDutyExpired(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("statutoryDutyExpired", resourceBundle.getString("planningNotificationOrderStatutoryDutyExpiredColumnCaption")){

                protected String getString(FlatReportInfo data) {
                    if (data.getShowReportInfo()) {
                        Boolean expired = data.getReportInfo().getReportJoin().getPlanningNotificationOrderStatutoryDutyExpired();
                        return expired != null && expired == true ? resourceBundle.getString("yes") : resourceBundle.getString("no");
                    }
                    return "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowWorkflowNode() != false && !PlanningReportHelper.doShow(columnSettings.getExportWorkflowNodesFlat(), reportTypeALL), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("workflowNode", resourceBundle.getString("planningNotificationOrderWorkflowNodeColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo flatReportInfo) {
                    List<WorkflowNodeJoin> workflowNodeJoins = this.getWorkflowNodeJoins(flatReportInfo);
                    String dataTextStyle = localStyles.getDataTextStyle(flatReportInfo.getReportInfo());
                    if (flatReportInfo.getShowReportInfo()) {
                        String dataItalicTextStyle = localStyles.getDataItalicStyle(flatReportInfo.getReportInfo());
                        String dataRedTextStyle = localStyles.getDataRedStyle(flatReportInfo.getReportInfo());
                        String dataCaptionTextStyle = localStyles.getDataCaptionStyle(flatReportInfo.getReportInfo());
                        PlanningExportHelper.appendWorkflowNodeCell(rowElement, resourceBundle, workflowNodeJoins, flatReportInfo.getReportInfo().getWorkflowNodeIdToPositions(), flatReportInfo.getReportInfo().getWorkflowNodePositionIdToBaulose(), dataCellStyle, dataTextStyle, dataItalicTextStyle, dataRedTextStyle, dataCaptionTextStyle);
                    } else {
                        TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                    }
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
                }

                private List<WorkflowNodeJoin> getWorkflowNodeJoins(FlatReportInfo flatReportInfo) {
                    if (flatReportInfo.getShowReportInfo()) {
                        List workflowNodeJoins = flatReportInfo.getReportInfo().getWorkflowNodeJoins();
                        if (workflowNodeJoins != null) {
                            Collections.sort(workflowNodeJoins, new Comparator<WorkflowNodeJoin>(){

                                @Override
                                public int compare(WorkflowNodeJoin joinOne, WorkflowNodeJoin joinTwo) {
                                    return joinOne.getWorkflowNodeTemplatePosition() - joinTwo.getWorkflowNodeTemplatePosition();
                                }
                            });
                            return workflowNodeJoins;
                        }
                        return new ArrayList<WorkflowNodeJoin>();
                    }
                    return new ArrayList<WorkflowNodeJoin>();
                }

                private String getOutput(FlatReportInfo orderInfo) {
                    return "Not implemented.";
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getExportWorkflowNodesFlat(), false)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("workflowNode1", "Baulos"){

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    return 0;
                }
            });
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("workflowNode2", "Erf\u00fcllungstermin"){

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    return 0;
                }
            });
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("workflowNode3", "Durchf\u00fchrung"){

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo flatReportInfo) {
                    List<WorkflowNodeJoin> workflowNodeJoins = this.getWorkflowNodeJoins(flatReportInfo);
                    String dataTextStyle = localStyles.getDataTextStyle(flatReportInfo.getReportInfo());
                    if (flatReportInfo.getShowReportInfo() && flatReportInfo.isFlatWorkflowNodes()) {
                        String dataItalicTextStyle = localStyles.getDataItalicStyle(flatReportInfo.getReportInfo());
                        String dataRedTextStyle = localStyles.getDataRedStyle(flatReportInfo.getReportInfo());
                        String dataCaptionTextStyle = localStyles.getDataCaptionStyle(flatReportInfo.getReportInfo());
                        PlanningExportHelper.appendWorkflowNodesFlatCell(rowElement, resourceBundle, workflowNodeJoins, flatReportInfo.getReportInfo().getWorkflowNodeIdToPositions(), flatReportInfo.getReportInfo().getWorkflowNodePositionIdToBaulose(), dataCellStyle, dataTextStyle, dataItalicTextStyle, dataRedTextStyle, dataCaptionTextStyle);
                    } else {
                        TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                    }
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getOutput(dataOne), (String)this.getOutput(dataTwo), (boolean)descending);
                }

                private List<WorkflowNodeJoin> getWorkflowNodeJoins(FlatReportInfo flatReportInfo) {
                    if (flatReportInfo.getShowReportInfo()) {
                        List workflowNodeJoins = flatReportInfo.getReportInfo().getWorkflowNodeJoins();
                        if (workflowNodeJoins != null) {
                            Collections.sort(workflowNodeJoins, new Comparator<WorkflowNodeJoin>(){

                                @Override
                                public int compare(WorkflowNodeJoin joinOne, WorkflowNodeJoin joinTwo) {
                                    return joinOne.getWorkflowNodeTemplatePosition() - joinTwo.getWorkflowNodeTemplatePosition();
                                }
                            });
                            return workflowNodeJoins;
                        }
                        return new ArrayList<WorkflowNodeJoin>();
                    }
                    return new ArrayList<WorkflowNodeJoin>();
                }

                private String getOutput(FlatReportInfo orderInfo) {
                    return "Not implemented.";
                }
            });
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("workflowNode4", "Kommentar"){

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    return 0;
                }
            });
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("workflowNode5", "Zustimmung Durchf\u00fchrung"){

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    return 0;
                }
            });
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("workflowNode6", "Kommentar"){

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    return 0;
                }
            });
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("workflowNode7", "Freigabe"){

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    return 0;
                }
            });
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("workflowNode8", "Kommentar"){

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    return 0;
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowState(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("state", resourceBundle.getString("planningNotificationOrderStateColumnCaption")){

                protected String getString(FlatReportInfo data) {
                    if (data.getShowReportInfo()) {
                        String workflowEntityStatusName = data.getReportInfo().getReportJoin().getWorkflowEntityStatusName();
                        if (workflowEntityStatusName == null) {
                            return resourceBundle.getString("workflowStatusNotInitialized");
                        }
                        return data.getReportInfo().getReportJoin().getWorkflowEntityStatusName();
                    }
                    return "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowOrderComment(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("orderComment", resourceBundle.getString("planningNotificationOrderCommentColumnCaption")){

                protected String getString(FlatReportInfo data) {
                    return data.getShowReportInfo() ? data.getReportInfo().getReportJoin().getPlanningNotificationOrderComment() : "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowEnvironmentallyRelevant(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("environmentallyRelevant", resourceBundle.getString("planningNotificationOrderEnvironmentallyRelevantColumnCaption")){

                protected String getString(FlatReportInfo data) {
                    if (data.getShowReportInfo()) {
                        Boolean environmentallyRelevant = data.getReportInfo().getReportJoin().getPlanningNotificationOrderEnvironmentallyRelevant();
                        return environmentallyRelevant != null && environmentallyRelevant == true ? resourceBundle.getString("yes") : resourceBundle.getString("no");
                    }
                    return "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowWorkflowNodeName(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("workflowNodeName", resourceBundle.getString("workflowActivityResultWorkflowNodeNameColumnCaption")){

                protected String getString(FlatReportInfo flatReportInfo) {
                    return flatReportInfo.getResultJoin() != null ? flatReportInfo.getResultJoin().getWorkflowActivityWorkflowNodeName() : "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowReviewBaulos(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("reviewBaulos", resourceBundle.getString("workflowActivityResultBaulosColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, this.getOutput(data));
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, this.getOutput(dataOne), this.getOutput(dataTwo), (boolean)descending);
                }

                private List<String> getOutput(FlatReportInfo flatReportInfo) {
                    Long workflowActivityId;
                    Map workflowActivityIdToBaulose;
                    List baulose;
                    ArrayList<String> tokens = new ArrayList<String>();
                    if (flatReportInfo.getResultJoin() != null && (baulose = (List)(workflowActivityIdToBaulose = flatReportInfo.getReportInfo().getWorkflowActivityIdToBaulose()).get(workflowActivityId = flatReportInfo.getResultJoin().getWorkflowActivityId())) != null && baulose.size() > 0) {
                        for (PlanningNotificationTextMetaInformation baulos : baulose) {
                            tokens.add(baulos.getValue());
                        }
                    }
                    return tokens;
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowTokenInitiator(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("tokenInitiator", resourceBundle.getString("workflowActivityResultTokenInitiatorColumnCaption")){

                protected String getString(FlatReportInfo flatReportInfo) {
                    return flatReportInfo.getResultJoin() != null ? flatReportInfo.getResultJoin().getWorkflowActivityTokenInitiator() : "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowReviewer(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("reviewer", resourceBundle.getString("workflowActivityResultReviewerColumnCaption")){

                protected String getString(FlatReportInfo flatReportInfo) {
                    return flatReportInfo.getResultJoin() != null ? flatReportInfo.getResultJoin().getWorkflowActivityPositionResultReviewer() : "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowIssued(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("issued", resourceBundle.getString("workflowActivityResultIssuedColumnCaption")){

                protected String getString(FlatReportInfo flatReportInfo) {
                    if (flatReportInfo.getResultJoin() != null) {
                        String dateFormatPattern = resourceBundle.getString("yearToSecondFormat");
                        Double issued = flatReportInfo.getResultJoin().getWorkflowActivityIssued();
                        return DateHelper.formatUtcSeconds(issued, "Europe/Vienna", dateFormatPattern);
                    }
                    return "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowReviewComment(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("reviewComment", resourceBundle.getString("workflowActivityResultCommentColumnCaption")){

                protected String getString(FlatReportInfo flatReportInfo) {
                    String unsafeComment = flatReportInfo.getResultJoin() != null ? flatReportInfo.getResultJoin().getWorkflowActivityPositionResultComment() : "";
                    return unsafeComment;
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo flatReportInfo) {
                    String dataTextStyle = localStyles.getDataTextStyle(flatReportInfo.getReportInfo());
                    TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                    String unsafeComment = this.getString(flatReportInfo);
                    String safeComment = utilService.getSafeHtml(unsafeComment, true);
                    OdfFromHtmlConverter.convert((Node)cellElement, safeComment, dataTextStyle, contentAutomaticStyles);
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowResult(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("result", resourceBundle.getString("workflowActivityResultResultColumnCaption")){

                protected String getString(FlatReportInfo flatReportInfo) {
                    return flatReportInfo.getResultJoin() != null ? flatReportInfo.getResultJoin().getWorkflowActivityPositionResultResult() : "";
                }

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo data) {
                    String dataTextStyle = localStyles.getDataTextStyle(data.getReportInfo());
                    TableFactory.appendCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement, (String[])new String[]{this.getString(data)});
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, (String)this.getString(dataOne), (String)this.getString(dataTwo), (boolean)descending);
                }
            });
        }
        if (PlanningReportHelper.doShow(columnSettings.getShowAttachment(), reportTypeALL)) {
            columns.add(new FancyOdfTableColumn<FlatReportInfo>("attachment", resourceBundle.getString("workflowActivityResultAttachmentColumnCaption")){

                public void appendCell(TableTableRowElement rowElement, FlatReportInfo flatReportInfo) {
                    Map workflowActivityIdToAttachments = flatReportInfo.getReportInfo().getWorkflowActivityIdToAttachments();
                    Long workflowActivityId = flatReportInfo.getResultJoin() != null ? flatReportInfo.getResultJoin().getWorkflowActivityId() : null;
                    List attachments = workflowActivityId != null ? (List)workflowActivityIdToAttachments.get(workflowActivityId) : null;
                    String dataTextStyle = localStyles.getDataTextStyle(flatReportInfo.getReportInfo());
                    if (attachments != null) {
                        PlanningExportHelper.constructAttachmentLinkCell(rowElement, dataTextStyle, dataCellStyle, internetLinkStyle, attachments);
                    } else {
                        TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                    }
                }

                public int compare(FlatReportInfo dataOne, FlatReportInfo dataTwo, boolean descending) {
                    return FancyOdfTableColumn.defaultStringCompare((Collator)collator, this.getOutput(dataOne), this.getOutput(dataTwo), (boolean)descending);
                }

                private List<String> getOutput(FlatReportInfo flatReportInfo) {
                    List attachments;
                    ArrayList<String> tokens = new ArrayList<String>();
                    Map workflowActivityIdToAttachments = flatReportInfo.getReportInfo().getWorkflowActivityIdToAttachments();
                    Long workflowActivityId = flatReportInfo.getResultJoin() != null ? flatReportInfo.getResultJoin().getWorkflowActivityId() : null;
                    List list = attachments = workflowActivityId != null ? (List)workflowActivityIdToAttachments.get(workflowActivityId) : null;
                    if (attachments != null) {
                        for (PlanningNotificationAttachment attachment : attachments) {
                            tokens.add(attachment.getOriginalName());
                        }
                    }
                    return tokens;
                }
            });
        }
        return columns;
    }

    public static void convertReportColumnSortSpecsFromClientToServer(List<ColumnSortSpec> specs, Map<Long, MetaTag> metaTagIdToMetaTag) {
        for (ColumnSortSpec spec : specs) {
            MetaTag metaTag;
            String prop = spec.getProperty();
            if (prop == null) continue;
            if (clientColumnToReportColumn.containsKey(prop)) {
                spec.setProperty(clientColumnToReportColumn.get(prop));
                continue;
            }
            if (!prop.startsWith("_metaTag")) continue;
            String metaTagIdAsString = prop.substring("_metaTag".length());
            Long metaTagId = null;
            try {
                metaTagId = Long.valueOf(metaTagIdAsString);
            }
            catch (NumberFormatException e) {
                metaTagId = null;
            }
            if (metaTagId == null || (metaTag = metaTagIdToMetaTag.get(metaTagId)) == null) continue;
            spec.setProperty(metaTag.getCssClass());
        }
    }

    public static List<PlanningNotificationReportInfo> filterReportInfosForPrivileges(List<PlanningNotificationReportInfo> reportInfos, Long organisationPersonId, ActionDAO actionDAO) {
        ArrayList<PlanningNotificationReportInfo> filteredReportInfos = new ArrayList<PlanningNotificationReportInfo>();
        HashSet<Long> projectIds = new HashSet<Long>();
        for (PlanningNotificationReportInfo reportInfo : reportInfos) {
            List projects = reportInfo.getProjects();
            for (Project project : projects) {
                projectIds.add(project.getId());
            }
        }
        Map<Long, Set<Action>> projectIdToAllowedActions = actionDAO.getActionsForProjects(organisationPersonId, projectIds, Action.GENERATE_PLANNING_NOTIFICATION_REPORT);
        for (PlanningNotificationReportInfo reportInfo : reportInfos) {
            List projects = reportInfo.getProjects();
            boolean oneProjectMatches = false;
            for (Project project : projects) {
                Set<Action> allowedActions = projectIdToAllowedActions.get(project.getId());
                oneProjectMatches |= allowedActions != null && allowedActions.contains(Action.GENERATE_PLANNING_NOTIFICATION_REPORT);
            }
            if (!oneProjectMatches) continue;
            filteredReportInfos.add(reportInfo);
        }
        return filteredReportInfos;
    }

    static PlanningNotificationSearchModel getPlanningNotificationSearchModel(PlanningNotificationReportExportInfo exportInfo) {
        if (exportInfo.getType() == PlanningNotificationReportType.ALL) {
            PlanningNotificationSearchModel searchModel = new PlanningNotificationSearchModel();
            searchModel.setProjectId(exportInfo.getProjectId());
            searchModel.setDateMetaTagIdToFrom(new HashMap());
            searchModel.setDateMetaTagIdToTo(new HashMap());
            searchModel.setTextMetaTagIdToValue(new HashMap());
            return searchModel;
        }
        return exportInfo.getPlanningNotificationSearchModel();
    }

    static PlanningNotificationOrderSearchModel getPlanningNotificationOrderSearchModel(PlanningNotificationReportExportInfo exportInfo) {
        if (exportInfo.getType() == PlanningNotificationReportType.ALL) {
            PlanningNotificationOrderSearchModel searchModel = new PlanningNotificationOrderSearchModel();
            searchModel.setOrganisationPersonId(exportInfo.getOrganisationPersonId());
            return searchModel;
        }
        return exportInfo.getOrderSearchModel();
    }

    static PlanningReviewProtocolSearchModel getPlanningReviewProtocolSearchModel(PlanningNotificationReportExportInfo exportInfo) {
        if (exportInfo.getType() == PlanningNotificationReportType.ALL) {
            PlanningReviewProtocolSearchModel searchModel = new PlanningReviewProtocolSearchModel();
            return searchModel;
        }
        return exportInfo.getReviewSearchModel();
    }

    static {
        clientColumnToReportColumn.put("planningNotificationOrderSerialNumber", "serialNumber");
        clientColumnToReportColumn.put("planningNotificationOrderText", "text");
        clientColumnToReportColumn.put("_planningNotificationTitle", "title");
        clientColumnToReportColumn.put("_planningNotification", "title");
        clientColumnToReportColumn.put("_project", "project");
        clientColumnToReportColumn.put("subjectAreaName", "subjectArea");
        clientColumnToReportColumn.put("planningNotificationOrderAuthorizedInspector", "authorizedInspector");
        clientColumnToReportColumn.put("_reference", "reference");
        clientColumnToReportColumn.put("statutoryDutyName", "statutoryDuty");
        clientColumnToReportColumn.put("workflowEntityInvalidated", "invalidated");
        clientColumnToReportColumn.put("planningNotificationOrderDocumentPosition", "documentPosition");
        clientColumnToReportColumn.put("planningNotificationOrderDocumentPage", "documentPage");
        clientColumnToReportColumn.put("planningNotificationOrderSource", "source");
        clientColumnToReportColumn.put("personInChargeName", "personInCharge");
        clientColumnToReportColumn.put("planningNotificationOrderStatutoryDutyFrom", "statutoryDutyFrom");
        clientColumnToReportColumn.put("planningNotificationOrderStatutoryDutyTo", "statutoryDutyTo");
        clientColumnToReportColumn.put("planningNotificationOrderStatutoryDutyInterval", "statutoryDutyInterval");
        clientColumnToReportColumn.put("planningNotificationOrderStatutoryDutyLeadTime", "statutoryDutyLeadTime");
        clientColumnToReportColumn.put("_siteTypeString", "siteType");
        clientColumnToReportColumn.put("planningNotificationOrderStatutoryDutyExpired", "statutoryDutyExpired");
        clientColumnToReportColumn.put("planningNotificationOrderSubmitAuthority", "submitAuthority");
        clientColumnToReportColumn.put("_tagString", "tag");
        clientColumnToReportColumn.put("_planningNotificationComment", "notificationComment");
        clientColumnToReportColumn.put("planningNotificationOrderComment", "orderComment");
        clientColumnToReportColumn.put("planningNotificationOrderEnvironmentallyRelevant", "environmentallyRelevant");
        clientColumnToReportColumn.put("_workflowNode", "workflowNode");
        clientColumnToReportColumn.put("_workflowEntityStatusName", "state");
    }
}

