/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.planning;

import at.cdes.api.compositeDto.PlanningNotificationInfo;
import at.cdes.api.compositeDto.PlanningNotificationOrderInfo;
import at.cdes.api.compositeDto.PlanningNotificationOrderReferenceInfo;
import at.cdes.api.dto.PlanningNotification;
import at.cdes.api.dto.PlanningNotificationOrderTag;
import at.cdes.api.dto.PlanningNotificationTextMetaInformation;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.SiteType;
import at.cdes.api.dto.WorkflowActivityPositionResult;
import at.cdes.api.dto.WorkflowEntity;
import at.cdes.api.dto.WorkflowNodePosition;
import at.cdes.api.dto.WorkflowToken;
import at.cdes.api.dto.searchModel.PlanningNotificationSearchModel;
import at.cdes.api.joinDto.PlanningNotificationJoin;
import at.cdes.api.joinDto.PlanningNotificationOrderExtraJoin;
import at.cdes.api.joinDto.PlanningNotificationOrderJoin;
import at.cdes.api.joinDto.PlanningNotificationReportJoin;
import at.cdes.api.joinDto.ProjectJoin;
import at.cdes.api.joinDto.WorkflowJoin;
import at.cdes.api.joinDto.WorkflowNodeJoin;
import at.cdes.api.planning.compositeDto.PlanningNotificationReportInfo;
import at.cdes.api.planning.compositeDto.WorkflowInfo;
import at.cdes.api.planning.compositeDto.WorkflowNodeInfo;
import at.cdes.api.planning.compositeDto.WorkflowNodePositionInfo;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.unionComponent.PlanningNotificationOrderExtraComponent;
import at.cdes.impl.util.ActionHelper;
import at.cdes.impl.util.SearchHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PlanningNotificationQueryHelper {
    public static Set<Long> getRequiredMetaTagIds(PlanningNotificationSearchModel searchModel) {
        Map searchTextMetaTagIdToValue = searchModel.getTextMetaTagIdToValue() != null ? searchModel.getTextMetaTagIdToValue() : new HashMap();
        Map searchDateMetaTagIdToFrom = searchModel.getDateMetaTagIdToFrom() != null ? searchModel.getDateMetaTagIdToFrom() : new HashMap();
        Map searchDateMetaTagIdToTo = searchModel.getDateMetaTagIdToTo() != null ? searchModel.getDateMetaTagIdToTo() : new HashMap();
        HashSet<Long> requiredMetaTagIds = new HashSet<Long>();
        for (Long metaTagId : searchTextMetaTagIdToValue.keySet()) {
            if (!SearchHelper.isStringFilled((String)searchTextMetaTagIdToValue.get(metaTagId))) continue;
            requiredMetaTagIds.add(metaTagId);
        }
        for (Long metaTagId : searchDateMetaTagIdToFrom.keySet()) {
            if (searchDateMetaTagIdToFrom.get(metaTagId) == null) continue;
            requiredMetaTagIds.add(metaTagId);
        }
        for (Long metaTagId : searchDateMetaTagIdToTo.keySet()) {
            if (searchDateMetaTagIdToTo.get(metaTagId) == null) continue;
            requiredMetaTagIds.add(metaTagId);
        }
        return requiredMetaTagIds;
    }

    public static Map<Long, List<PlanningNotificationJoin>> getPlanningNotificationJoinsAsMap(List<PlanningNotificationJoin> planningNotificationJoins) {
        HashMap<Long, List<PlanningNotificationJoin>> planningNotificationIdToJoins = new HashMap<Long, List<PlanningNotificationJoin>>();
        for (PlanningNotificationJoin join : planningNotificationJoins) {
            Long planningNotificationId = join.getPlanningNotificationId();
            if (!planningNotificationIdToJoins.containsKey(planningNotificationId)) {
                planningNotificationIdToJoins.put(planningNotificationId, new ArrayList());
            }
            ((List)planningNotificationIdToJoins.get(planningNotificationId)).add(join);
        }
        return planningNotificationIdToJoins;
    }

    public static Map<Long, List<PlanningNotificationReportJoin>> getPlanningNotificationReportJoinsAsMap(List<PlanningNotificationReportJoin> planningNotificationReportJoins) {
        HashMap<Long, Long> planningNotificationIdToWorkflowEntityId = new HashMap<Long, Long>();
        HashMap<Long, List<PlanningNotificationReportJoin>> planningNotificationIdToJoins = new HashMap<Long, List<PlanningNotificationReportJoin>>();
        for (PlanningNotificationReportJoin join : planningNotificationReportJoins) {
            Long planningNotificationId = join.getPlanningNotificationId();
            Long workflowEntityId = join.getWorkflowEntityId();
            if (!planningNotificationIdToWorkflowEntityId.containsKey(planningNotificationId)) {
                planningNotificationIdToWorkflowEntityId.put(planningNotificationId, workflowEntityId);
            } else {
                Long formerWorkflowEntityId = (Long)planningNotificationIdToWorkflowEntityId.get(planningNotificationId);
                if (formerWorkflowEntityId.longValue() != workflowEntityId.longValue()) continue;
            }
            if (!planningNotificationIdToJoins.containsKey(planningNotificationId)) {
                planningNotificationIdToJoins.put(planningNotificationId, new ArrayList());
            }
            ((List)planningNotificationIdToJoins.get(planningNotificationId)).add(join);
        }
        return planningNotificationIdToJoins;
    }

    public static void populatePlanningNotificationInfosWithAllowedActions(ActionDAO actionDAO, List<PlanningNotificationInfo> retValues, Long organisationPersonId, Set<Long> allProjectIds, Action ... actions) {
        Map<Long, Set<Action>> projectIdToAllowedAction = actionDAO.getActionsForProjects(organisationPersonId, allProjectIds, actions);
        for (PlanningNotificationInfo planningNotificationInfo : retValues) {
            List projects = planningNotificationInfo.getProjects();
            ArrayList<String> allowedActions = new ArrayList<String>();
            for (Project project : projects) {
                Set<Action> currentActions = projectIdToAllowedAction.get(project.getId());
                if (currentActions == null) continue;
                allowedActions.addAll(ActionHelper.convertEnumToString(currentActions));
            }
            planningNotificationInfo.setAllowedProjectActions(allowedActions);
        }
    }

    public static List<PlanningNotificationInfo> populatePlanningNotificationInfoAttributes(Map<Long, List<PlanningNotificationJoin>> planningNotificationIdToJoins, Set<Long> requiredMetaTagIds, Set<Long> allProjectIds) {
        ArrayList<PlanningNotificationInfo> retValues = new ArrayList<PlanningNotificationInfo>();
        for (Long planningNotificationId : planningNotificationIdToJoins.keySet()) {
            List<PlanningNotificationJoin> currJoins = planningNotificationIdToJoins.get(planningNotificationId);
            PlanningNotification planningNotification = null;
            HashMap metaTagIdToDateMetaInformations = new HashMap();
            HashMap metaTagIdToTextMetaInformations = new HashMap();
            HashMap<Long, Project> idToProject = new HashMap<Long, Project>();
            HashMap metaTagIdToJoins = new HashMap();
            for (PlanningNotificationJoin planningNotificationJoin : currJoins) {
                if (planningNotification == null) {
                    planningNotification = planningNotificationJoin.getPlanningNotification();
                }
                Long metaTagId = planningNotificationJoin.getMetaInformationMetaTagId();
                if (planningNotificationJoin.getPlanningNotificationDateMetaInformationMetaInformationId() != null) {
                    if (!metaTagIdToDateMetaInformations.containsKey(metaTagId)) {
                        metaTagIdToDateMetaInformations.put(metaTagId, new ArrayList());
                    }
                    ((List)metaTagIdToDateMetaInformations.get(metaTagId)).add(planningNotificationJoin.getPlanningNotificationDateMetaInformation());
                }
                if (planningNotificationJoin.getPlanningNotificationTextMetaInformationMetaInformationId() != null) {
                    if (!metaTagIdToTextMetaInformations.containsKey(metaTagId)) {
                        metaTagIdToTextMetaInformations.put(metaTagId, new ArrayList());
                    }
                    ((List)metaTagIdToTextMetaInformations.get(metaTagId)).add(planningNotificationJoin.getPlanningNotificationTextMetaInformation());
                }
                if (planningNotificationJoin.getProjectId() != null) {
                    idToProject.put(planningNotificationJoin.getProjectId(), planningNotificationJoin.getProject());
                    allProjectIds.add(planningNotificationJoin.getProjectId());
                }
                if (metaTagId == null) continue;
                if (!metaTagIdToJoins.containsKey(metaTagId)) {
                    metaTagIdToJoins.put(metaTagId, new ArrayList());
                }
                ((List)metaTagIdToJoins.get(metaTagId)).add(planningNotificationJoin);
            }
            boolean allFound = true;
            for (Long requiredMetaTagId : requiredMetaTagIds) {
                if (metaTagIdToJoins.containsKey(requiredMetaTagId)) continue;
                allFound = false;
                break;
            }
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(idToProject.values());
            if (!allFound) continue;
            PlanningNotificationInfo planningNotificationInfo = new PlanningNotificationInfo();
            planningNotificationInfo.setPlanningNotification(planningNotification);
            planningNotificationInfo.setProjects(arrayList);
            planningNotificationInfo.setMetaTagIdToDateMetaInformation(metaTagIdToDateMetaInformations);
            planningNotificationInfo.setMetaTagIdToTextMetaInformation(metaTagIdToTextMetaInformations);
            retValues.add(planningNotificationInfo);
        }
        return retValues;
    }

    public static List<PlanningNotificationInfo> populatePlanningNotificationReportInfoAttributes(Map<Long, List<PlanningNotificationReportJoin>> planningNotificationIdToJoins, Set<Long> requiredMetaTagIds, Set<Long> allProjectIds) {
        ArrayList<PlanningNotificationInfo> retValues = new ArrayList<PlanningNotificationInfo>();
        for (Long planningNotificationId : planningNotificationIdToJoins.keySet()) {
            List<PlanningNotificationReportJoin> currJoins = planningNotificationIdToJoins.get(planningNotificationId);
            PlanningNotification planningNotification = null;
            HashMap metaTagIdToDateMetaInformations = new HashMap();
            HashMap metaTagIdToTextMetaInformations = new HashMap();
            HashMap<Long, Project> idToProject = new HashMap<Long, Project>();
            HashMap metaTagIdToJoins = new HashMap();
            for (PlanningNotificationReportJoin planningNotificationReportJoin : currJoins) {
                if (planningNotification == null) {
                    planningNotification = planningNotificationReportJoin.getPlanningNotification();
                }
                Long metaTagId = planningNotificationReportJoin.getMetaInformationMetaTagId();
                if (planningNotificationReportJoin.getPlanningNotificationDateMetaInformationMetaInformationId() != null) {
                    if (!metaTagIdToDateMetaInformations.containsKey(metaTagId)) {
                        metaTagIdToDateMetaInformations.put(metaTagId, new ArrayList());
                    }
                    ((List)metaTagIdToDateMetaInformations.get(metaTagId)).add(planningNotificationReportJoin.getPlanningNotificationDateMetaInformation());
                }
                if (planningNotificationReportJoin.getPlanningNotificationTextMetaInformationMetaInformationId() != null) {
                    if (!metaTagIdToTextMetaInformations.containsKey(metaTagId)) {
                        metaTagIdToTextMetaInformations.put(metaTagId, new ArrayList());
                    }
                    ((List)metaTagIdToTextMetaInformations.get(metaTagId)).add(planningNotificationReportJoin.getPlanningNotificationTextMetaInformation());
                }
                if (planningNotificationReportJoin.getProjectId() != null) {
                    idToProject.put(planningNotificationReportJoin.getProjectId(), planningNotificationReportJoin.getProject());
                    allProjectIds.add(planningNotificationReportJoin.getProjectId());
                }
                if (metaTagId == null) continue;
                if (!metaTagIdToJoins.containsKey(metaTagId)) {
                    metaTagIdToJoins.put(metaTagId, new ArrayList());
                }
                ((List)metaTagIdToJoins.get(metaTagId)).add(planningNotificationReportJoin);
            }
            boolean allFound = true;
            for (Long requiredMetaTagId : requiredMetaTagIds) {
                if (metaTagIdToJoins.containsKey(requiredMetaTagId)) continue;
                allFound = false;
                break;
            }
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(idToProject.values());
            if (!allFound) continue;
            PlanningNotificationInfo planningNotificationInfo = new PlanningNotificationInfo();
            planningNotificationInfo.setPlanningNotification(planningNotification);
            planningNotificationInfo.setProjects(arrayList);
            planningNotificationInfo.setMetaTagIdToDateMetaInformation(metaTagIdToDateMetaInformations);
            planningNotificationInfo.setMetaTagIdToTextMetaInformation(metaTagIdToTextMetaInformations);
            retValues.add(planningNotificationInfo);
        }
        return retValues;
    }

    public static List<Long> getIdsFromPlanningNotificationOrderJoins(List<PlanningNotificationOrderJoin> orderJoins) {
        HashSet<Long> workflowEntityIdSet = new HashSet<Long>();
        for (PlanningNotificationOrderJoin orderJoin : orderJoins) {
            workflowEntityIdSet.add(orderJoin.getPlanningNotificationOrderWorkflowEntityId());
        }
        ArrayList<Long> workflowEntityIds = new ArrayList<Long>();
        workflowEntityIds.addAll(workflowEntityIdSet);
        return workflowEntityIds;
    }

    public static List<Long> getIdsFromPlanningNotificationReportJoins(List<PlanningNotificationReportJoin> reportJoins) {
        HashSet<Long> workflowEntityIdSet = new HashSet<Long>();
        for (PlanningNotificationReportJoin reportJoin : reportJoins) {
            workflowEntityIdSet.add(reportJoin.getPlanningNotificationOrderWorkflowEntityId());
        }
        ArrayList<Long> workflowEntityIds = new ArrayList<Long>();
        workflowEntityIds.addAll(workflowEntityIdSet);
        return workflowEntityIds;
    }

    public static Map<Long, List<ProjectJoin>> extractWorkflowEntityIdToProjectJoin(List<PlanningNotificationOrderExtraJoin> extraJoins) {
        HashMap<Long, List<ProjectJoin>> workflowEntityIdToProjectJoin = new HashMap<Long, List<ProjectJoin>>();
        for (PlanningNotificationOrderExtraJoin extraJoin : extraJoins) {
            Long workflowEntityId = extraJoin.getPlanningNotificationOrderWorkflowEntityId();
            int unionClause = extraJoin.getUnionClause();
            if (unionClause != PlanningNotificationOrderExtraComponent.PROJECT.getValue()) continue;
            Long projectId = extraJoin.getProjectId();
            String projectCode = extraJoin.getProjectCode();
            String projectName = extraJoin.getProjectName();
            if (projectId == null) continue;
            if (!workflowEntityIdToProjectJoin.containsKey(workflowEntityId)) {
                workflowEntityIdToProjectJoin.put(workflowEntityId, new ArrayList());
            }
            Long projectConfigId = extraJoin.getProjectConfigId();
            Boolean workflowBaulosForAllNodes = extraJoin.getProjectConfigWorkflowBaulosForAllNodes();
            ProjectJoin projectJoin = new ProjectJoin();
            projectJoin.setProjectId(projectId);
            projectJoin.setProjectCode(projectCode);
            projectJoin.setProjectName(projectName);
            projectJoin.setProjectConfigId(projectConfigId);
            projectJoin.setProjectConfigWorkflowBaulosForAllNodes(workflowBaulosForAllNodes);
            ((List)workflowEntityIdToProjectJoin.get(workflowEntityId)).add(projectJoin);
        }
        return workflowEntityIdToProjectJoin;
    }

    public static Map<Long, List<PlanningNotificationTextMetaInformation>> extractWorkflowEntityIdToBaulose(List<PlanningNotificationOrderExtraJoin> extraJoins) {
        HashMap<Long, List<PlanningNotificationTextMetaInformation>> workflowEntityIdToBaulose = new HashMap<Long, List<PlanningNotificationTextMetaInformation>>();
        for (PlanningNotificationOrderExtraJoin extraJoin : extraJoins) {
            PlanningNotificationTextMetaInformation baulos;
            Long workflowEntityId = extraJoin.getPlanningNotificationOrderWorkflowEntityId();
            int unionClause = extraJoin.getUnionClause();
            if (unionClause != PlanningNotificationOrderExtraComponent.BAULOS.getValue() || (baulos = extraJoin.getBaulosTextMetaInformation()).getMetaInformationId() == null) continue;
            if (!workflowEntityIdToBaulose.containsKey(workflowEntityId)) {
                workflowEntityIdToBaulose.put(workflowEntityId, new ArrayList());
            }
            ((List)workflowEntityIdToBaulose.get(workflowEntityId)).add(baulos);
        }
        return workflowEntityIdToBaulose;
    }

    public static Map<Long, List<PlanningNotificationOrderTag>> extractWorkflowEntityIdToTags(List<PlanningNotificationOrderExtraJoin> extraJoins) {
        HashMap<Long, List<PlanningNotificationOrderTag>> workflowEntityIdToTags = new HashMap<Long, List<PlanningNotificationOrderTag>>();
        for (PlanningNotificationOrderExtraJoin extraJoin : extraJoins) {
            PlanningNotificationOrderTag tag;
            Long workflowEntityId = extraJoin.getPlanningNotificationOrderWorkflowEntityId();
            int unionClause = extraJoin.getUnionClause();
            if (unionClause != PlanningNotificationOrderExtraComponent.TAG.getValue() || (tag = extraJoin.getPlanningNotificationOrderTag()).getId() == null) continue;
            if (!workflowEntityIdToTags.containsKey(workflowEntityId)) {
                workflowEntityIdToTags.put(workflowEntityId, new ArrayList());
            }
            ((List)workflowEntityIdToTags.get(workflowEntityId)).add(tag);
        }
        return workflowEntityIdToTags;
    }

    public static Map<Long, List<SiteType>> extractWorkflowEntityIdToSiteTypes(List<PlanningNotificationOrderExtraJoin> extraJoins) {
        HashMap<Long, List<SiteType>> workflowEntityIdToSiteTypes = new HashMap<Long, List<SiteType>>();
        for (PlanningNotificationOrderExtraJoin extraJoin : extraJoins) {
            SiteType siteType;
            Long workflowEntityId = extraJoin.getPlanningNotificationOrderWorkflowEntityId();
            int unionClause = extraJoin.getUnionClause();
            if (unionClause != PlanningNotificationOrderExtraComponent.SITE_TYPE.getValue() || (siteType = extraJoin.getSiteType()).getId() == null) continue;
            if (!workflowEntityIdToSiteTypes.containsKey(workflowEntityId)) {
                workflowEntityIdToSiteTypes.put(workflowEntityId, new ArrayList());
            }
            ((List)workflowEntityIdToSiteTypes.get(workflowEntityId)).add(siteType);
        }
        return workflowEntityIdToSiteTypes;
    }

    public static void setupAdditionalDataForOrderQuery(List<WorkflowNodeJoin> workflowNodeJoins, Map<Long, List<WorkflowNodeJoin>> workflowEntityIdToWorkflowNodes, Map<Long, List<WorkflowNodeJoin>> workflowNodeIdToPositions, Map<Long, List<PlanningNotificationTextMetaInformation>> workflowPositionIdToBaulose) {
        Long workflowNodePositionId;
        Long workflowNodeId;
        Long workflowEntityId;
        HashMap<Long, WorkflowNodeJoin> workflowNodeIdToJoin = new HashMap<Long, WorkflowNodeJoin>();
        HashMap workflowEntityIdToNodeIds = new HashMap();
        HashMap<Long, WorkflowNodeJoin> workflowNodePositionIdToJoin = new HashMap<Long, WorkflowNodeJoin>();
        HashMap workflowNodeIdToPositionIds = new HashMap();
        HashMap<Long, PlanningNotificationTextMetaInformation> metaInformationIdToBaulos = new HashMap<Long, PlanningNotificationTextMetaInformation>();
        HashMap workflowNodePositionIdToMetaInformationIds = new HashMap();
        for (WorkflowNodeJoin workflowNodeJoin : workflowNodeJoins) {
            WorkflowNodeJoin copy;
            workflowEntityId = workflowNodeJoin.getWorkflowEntityId();
            workflowNodeId = workflowNodeJoin.getWorkflowNodeId();
            workflowNodePositionId = workflowNodeJoin.getWorkflowNodePositionId();
            Long metaInformationId = workflowNodeJoin.getPlanningNotificationTextMetaInformationMetaInformationId();
            if (workflowNodeId != null && !workflowNodeIdToJoin.containsKey(workflowNodeId)) {
                copy = new WorkflowNodeJoin();
                copy.setWorkflowNode(workflowNodeJoin.getWorkflowNode());
                copy.setWorkflowNodeTemplate(workflowNodeJoin.getWorkflowNodeTemplate());
                workflowNodeIdToJoin.put(workflowNodeId, copy);
            }
            if (!workflowEntityIdToNodeIds.containsKey(workflowEntityId)) {
                workflowEntityIdToNodeIds.put(workflowEntityId, new HashSet());
            }
            if (workflowNodeId != null) {
                ((Set)workflowEntityIdToNodeIds.get(workflowEntityId)).add(workflowNodeId);
            }
            if (workflowNodePositionId != null && !workflowNodePositionIdToJoin.containsKey(workflowNodePositionId)) {
                copy = new WorkflowNodeJoin();
                copy.setWorkflowNodePosition(workflowNodeJoin.getWorkflowNodePosition());
                copy.setProjectParticipation(workflowNodeJoin.getProjectParticipation());
                copy.setProjectParticipant(workflowNodeJoin.getProjectParticipant());
                copy.setOrganisationPerson(workflowNodeJoin.getOrganisationPerson());
                copy.setOrganisation(workflowNodeJoin.getOrganisation());
                copy.setPerson(workflowNodeJoin.getPerson());
                copy.setWorkflowNodeTemplate(workflowNodeJoin.getWorkflowNodeTemplate());
                copy.setRoleType(workflowNodeJoin.getRoleType());
                workflowNodePositionIdToJoin.put(workflowNodePositionId, copy);
            }
            if (!workflowNodeIdToPositionIds.containsKey(workflowNodeId)) {
                workflowNodeIdToPositionIds.put(workflowNodeId, new HashSet());
            }
            if (workflowNodePositionId != null) {
                ((Set)workflowNodeIdToPositionIds.get(workflowNodeId)).add(workflowNodePositionId);
            }
            if (metaInformationId != null && !metaInformationIdToBaulos.containsKey(metaInformationId)) {
                metaInformationIdToBaulos.put(metaInformationId, workflowNodeJoin.getPlanningNotificationTextMetaInformation());
            }
            if (!workflowNodePositionIdToMetaInformationIds.containsKey(workflowNodePositionId)) {
                workflowNodePositionIdToMetaInformationIds.put(workflowNodePositionId, new HashSet());
            }
            if (metaInformationId == null) continue;
            ((Set)workflowNodePositionIdToMetaInformationIds.get(workflowNodePositionId)).add(metaInformationId);
        }
        for (WorkflowNodeJoin workflowNodeJoin : workflowNodeJoins) {
            workflowEntityId = workflowNodeJoin.getWorkflowEntityId();
            workflowNodeId = workflowNodeJoin.getWorkflowNodeId();
            workflowNodePositionId = workflowNodeJoin.getWorkflowNodePositionId();
            if (workflowEntityId != null && !workflowEntityIdToWorkflowNodes.containsKey(workflowEntityId)) {
                Set workflowNodeIds = (Set)workflowEntityIdToNodeIds.get(workflowEntityId);
                ArrayList<WorkflowNodeJoin> nodeJoins = new ArrayList<WorkflowNodeJoin>();
                for (Long currNodeId : workflowNodeIds) {
                    nodeJoins.add((WorkflowNodeJoin)workflowNodeIdToJoin.get(currNodeId));
                }
                workflowEntityIdToWorkflowNodes.put(workflowEntityId, nodeJoins);
            }
            if (workflowNodeId != null && !workflowNodeIdToPositions.containsKey(workflowNodeId)) {
                Set workflowNodePositionIds = (Set)workflowNodeIdToPositionIds.get(workflowNodeId);
                ArrayList<WorkflowNodeJoin> positionJoins = new ArrayList<WorkflowNodeJoin>();
                for (Long currPositionId : workflowNodePositionIds) {
                    positionJoins.add((WorkflowNodeJoin)workflowNodePositionIdToJoin.get(currPositionId));
                }
                workflowNodeIdToPositions.put(workflowNodeId, positionJoins);
            }
            if (workflowNodePositionId == null || workflowPositionIdToBaulose.containsKey(workflowNodePositionId)) continue;
            Set metaInformationIds = (Set)workflowNodePositionIdToMetaInformationIds.get(workflowNodePositionId);
            ArrayList<PlanningNotificationTextMetaInformation> textMetaInformations = new ArrayList<PlanningNotificationTextMetaInformation>();
            for (Long metaInformationId : metaInformationIds) {
                textMetaInformations.add((PlanningNotificationTextMetaInformation)metaInformationIdToBaulos.get(metaInformationId));
            }
            workflowPositionIdToBaulose.put(workflowNodePositionId, textMetaInformations);
        }
    }

    public static List<PlanningNotificationOrderInfo> setupPlanningNotificationOrderInfos(List<PlanningNotificationOrderJoin> orderJoins, Map<Long, List<ProjectJoin>> workflowEntityIdToProjectJoin, Map<Long, List<PlanningNotificationOrderReferenceInfo>> workflowEntityIdToReferenceInfos, Map<Long, List<PlanningNotificationTextMetaInformation>> workflowEntityIdToBaulose, Map<Long, List<PlanningNotificationOrderTag>> workflowEntityIdToTags, Map<Long, List<SiteType>> workflowEntityIdToSiteTypes, Map<Long, List<WorkflowNodeJoin>> workflowEntityIdToWorkflowNodes, Map<Long, List<WorkflowNodeJoin>> workflowNodeIdToPositions, Map<Long, List<PlanningNotificationTextMetaInformation>> workflowPositionIdToBaulose, Map<Long, Set<Action>> projectIdToAllowedActions) {
        ArrayList<PlanningNotificationOrderInfo> orderInfos = new ArrayList<PlanningNotificationOrderInfo>();
        for (PlanningNotificationOrderJoin orderJoin : orderJoins) {
            Long workflowEntityId = orderJoin.getPlanningNotificationOrderWorkflowEntityId();
            PlanningNotificationOrderInfo orderInfo = new PlanningNotificationOrderInfo();
            orderInfo.setOrderJoin(orderJoin);
            orderInfo.setWorkflowInitialized(Boolean.valueOf(false));
            List<Object> projectJoins = workflowEntityIdToProjectJoin.containsKey(workflowEntityId) ? workflowEntityIdToProjectJoin.get(workflowEntityId) : new ArrayList();
            boolean privilegeFound = false;
            for (ProjectJoin projectJoin : projectJoins) {
                Long projectId = projectJoin.getProjectId();
                Set<Action> allowedActions = projectIdToAllowedActions.get(projectId);
                if (allowedActions == null || !allowedActions.contains(Action.PLANNING_NOTIFICATION_OVERVIEW)) continue;
                privilegeFound = true;
                break;
            }
            if (!privilegeFound) continue;
            List<Object> referenceInfos = workflowEntityIdToReferenceInfos.containsKey(workflowEntityId) ? workflowEntityIdToReferenceInfos.get(workflowEntityId) : new ArrayList();
            List<Object> list = workflowEntityIdToBaulose.containsKey(workflowEntityId) ? workflowEntityIdToBaulose.get(workflowEntityId) : new ArrayList();
            List<Object> tags = workflowEntityIdToTags.containsKey(workflowEntityId) ? workflowEntityIdToTags.get(workflowEntityId) : new ArrayList();
            List<Object> siteTypes = workflowEntityIdToSiteTypes.containsKey(workflowEntityId) ? workflowEntityIdToSiteTypes.get(workflowEntityId) : new ArrayList();
            orderInfo.setProjectJoins(projectJoins);
            orderInfo.setReferenceInfos(referenceInfos);
            orderInfo.setBaulosMetaInformations(list);
            orderInfo.setTags(tags);
            orderInfo.setSiteTypes(siteTypes);
            List<WorkflowNodeJoin> currWorkflowNodeJoins = workflowEntityIdToWorkflowNodes.get(workflowEntityId);
            orderInfo.setWorkflowNodeJoins(currWorkflowNodeJoins);
            HashMap<Long, List<WorkflowNodeJoin>> currWorkflowNodeIdToPositions = new HashMap<Long, List<WorkflowNodeJoin>>();
            HashMap<Long, List<PlanningNotificationTextMetaInformation>> currWorkflowNodePositionIdToBaulose = new HashMap<Long, List<PlanningNotificationTextMetaInformation>>();
            for (WorkflowNodeJoin currWorkflowNodeJoin : currWorkflowNodeJoins) {
                Long currWorkflowNodeId = currWorkflowNodeJoin.getWorkflowNodeId();
                List<WorkflowNodeJoin> currWorkflowNodePositions = workflowNodeIdToPositions.get(currWorkflowNodeId);
                currWorkflowNodeIdToPositions.put(currWorkflowNodeId, currWorkflowNodePositions);
                for (WorkflowNodeJoin currWorkflowNodePositionJoin : currWorkflowNodePositions) {
                    Long currWorkflowNodePositionId = currWorkflowNodePositionJoin.getWorkflowNodePositionId();
                    List<PlanningNotificationTextMetaInformation> currBaulose = workflowPositionIdToBaulose.get(currWorkflowNodePositionId);
                    currWorkflowNodePositionIdToBaulose.put(currWorkflowNodePositionId, currBaulose);
                }
            }
            orderInfo.setWorkflowNodeIdToPositions(currWorkflowNodeIdToPositions);
            orderInfo.setWorkflowNodePositionIdToBaulose(currWorkflowNodePositionIdToBaulose);
            ArrayList<String> allowedActions = new ArrayList<String>();
            for (ProjectJoin projectJoin : orderInfo.getProjectJoins()) {
                Set<Action> currActions = projectIdToAllowedActions.get(projectJoin.getProjectId());
                if (currActions == null) continue;
                allowedActions.addAll(ActionHelper.convertEnumToString(currActions));
            }
            orderInfo.setAllowedProjectActions(allowedActions);
            orderInfos.add(orderInfo);
        }
        return orderInfos;
    }

    public static List<PlanningNotificationReportInfo> setupPlanningNotificationReportInfos(List<PlanningNotificationReportJoin> reportJoins, Map<Long, PlanningNotificationInfo> planningNotificationIdToInfo, Map<Long, List<ProjectJoin>> workflowEntityIdToProjectJoins, Map<Long, List<PlanningNotificationOrderReferenceInfo>> workflowEntityIdToReferenceInfos, Map<Long, List<PlanningNotificationTextMetaInformation>> workflowEntityIdToBaulose, Map<Long, List<PlanningNotificationOrderTag>> workflowEntityIdToTags, Map<Long, List<WorkflowNodeJoin>> workflowEntityIdToWorkflowNodes, Map<Long, List<WorkflowNodeJoin>> workflowNodeIdToPositions, Map<Long, List<PlanningNotificationTextMetaInformation>> workflowPositionIdToBaulose, Map<Long, Set<Action>> projectIdToAllowedActions) {
        HashSet<Long> alreadyProcessedWorkflowEntityIds = new HashSet<Long>();
        ArrayList<PlanningNotificationReportInfo> reportInfos = new ArrayList<PlanningNotificationReportInfo>();
        for (PlanningNotificationReportJoin reportJoin : reportJoins) {
            Long workflowEntityId = reportJoin.getPlanningNotificationOrderWorkflowEntityId();
            Long planningNotificationId = reportJoin.getPlanningNotificationId();
            if (!planningNotificationIdToInfo.containsKey(planningNotificationId)) continue;
            List<Object> projectJoins = workflowEntityIdToProjectJoins.containsKey(workflowEntityId) ? workflowEntityIdToProjectJoins.get(workflowEntityId) : new ArrayList();
            boolean privilegeFound = false;
            for (ProjectJoin projectJoin : projectJoins) {
                Long projectId = projectJoin.getProjectId();
                Set<Action> allowedActions = projectIdToAllowedActions.get(projectId);
                if (allowedActions == null || !allowedActions.contains(Action.PLANNING_NOTIFICATION_OVERVIEW)) continue;
                privilegeFound = true;
                break;
            }
            if (!privilegeFound || alreadyProcessedWorkflowEntityIds.contains(workflowEntityId)) continue;
            alreadyProcessedWorkflowEntityIds.add(workflowEntityId);
            PlanningNotificationReportInfo reportInfo = new PlanningNotificationReportInfo();
            reportInfo.setReportJoin(reportJoin);
            reportInfo.setWorkflowInitialized(Boolean.valueOf(false));
            List<Object> list = workflowEntityIdToReferenceInfos.containsKey(workflowEntityId) ? workflowEntityIdToReferenceInfos.get(workflowEntityId) : new ArrayList();
            List<Object> baulosMetaInformations = workflowEntityIdToBaulose.containsKey(workflowEntityId) ? workflowEntityIdToBaulose.get(workflowEntityId) : new ArrayList();
            List<Object> tags = workflowEntityIdToTags.containsKey(workflowEntityId) ? workflowEntityIdToTags.get(workflowEntityId) : new ArrayList();
            ArrayList<Project> projects = new ArrayList<Project>();
            for (ProjectJoin projectJoin : projectJoins) {
                projects.add(projectJoin.getProject());
            }
            reportInfo.setProjects(projects);
            reportInfo.setReferenceInfos(list);
            reportInfo.setBaulosMetaInformations(baulosMetaInformations);
            reportInfo.setTags(tags);
            List<WorkflowNodeJoin> currWorkflowNodeJoins = workflowEntityIdToWorkflowNodes.get(workflowEntityId);
            reportInfo.setWorkflowNodeJoins(currWorkflowNodeJoins);
            HashMap<Long, List<WorkflowNodeJoin>> hashMap = new HashMap<Long, List<WorkflowNodeJoin>>();
            HashMap<Long, List<PlanningNotificationTextMetaInformation>> currWorkflowNodePositionIdToBaulose = new HashMap<Long, List<PlanningNotificationTextMetaInformation>>();
            for (WorkflowNodeJoin currWorkflowNodeJoin : currWorkflowNodeJoins) {
                Long currWorkflowNodeId = currWorkflowNodeJoin.getWorkflowNodeId();
                List<WorkflowNodeJoin> currWorkflowNodePositions = workflowNodeIdToPositions.get(currWorkflowNodeId);
                hashMap.put(currWorkflowNodeId, currWorkflowNodePositions);
                for (WorkflowNodeJoin currWorkflowNodePositionJoin : currWorkflowNodePositions) {
                    Long currWorkflowNodePositionId = currWorkflowNodePositionJoin.getWorkflowNodePositionId();
                    List<PlanningNotificationTextMetaInformation> currBaulose = workflowPositionIdToBaulose.get(currWorkflowNodePositionId);
                    currWorkflowNodePositionIdToBaulose.put(currWorkflowNodePositionId, currBaulose);
                }
            }
            reportInfo.setWorkflowNodeIdToPositions(hashMap);
            reportInfo.setWorkflowNodePositionIdToBaulose(currWorkflowNodePositionIdToBaulose);
            ArrayList<String> allowedActions = new ArrayList<String>();
            for (Project project : reportInfo.getProjects()) {
                Set<Action> currActions = projectIdToAllowedActions.get(project.getId());
                if (currActions == null) continue;
                allowedActions.addAll(ActionHelper.convertEnumToString(currActions));
            }
            reportInfo.setAllowedProjectActions(allowedActions);
            reportInfos.add(reportInfo);
        }
        return reportInfos;
    }

    public static List<WorkflowInfo> getWorkflowInfos(List<WorkflowJoin> workflowJoins) {
        ArrayList<WorkflowInfo> retInfos = new ArrayList<WorkflowInfo>();
        Map<Long, List<WorkflowJoin>> workflowIdToJoins = PlanningNotificationQueryHelper.groupWorkflowJoinsByWorkflow(workflowJoins);
        for (Long workflowId : workflowIdToJoins.keySet()) {
            List<WorkflowJoin> currWorkflowJoins = workflowIdToJoins.get(workflowId);
            WorkflowJoin someJoin = currWorkflowJoins.get(0);
            WorkflowInfo workflowInfo = new WorkflowInfo();
            workflowInfo.setWorkflow(someJoin.getWorkflow());
            ArrayList<WorkflowEntity> workflowEntities = new ArrayList<WorkflowEntity>();
            Map<Long, List<WorkflowJoin>> workflowEntityIdToJoins = PlanningNotificationQueryHelper.groupWorkflowJoinsByWorkflowEntity(currWorkflowJoins);
            for (Long workflowEntityId : workflowEntityIdToJoins.keySet()) {
                workflowEntities.add(workflowEntityIdToJoins.get(workflowEntityId).get(0).getWorkflowEntity());
            }
            workflowInfo.setWorkflowEntities(workflowEntities);
            List<WorkflowNodeInfo> nodeInfos = PlanningNotificationQueryHelper.getWorkflowNodeInfosByJoins(currWorkflowJoins);
            workflowInfo.setNodeInfos(nodeInfos);
            retInfos.add(workflowInfo);
        }
        return retInfos;
    }

    private static List<WorkflowNodeInfo> getWorkflowNodeInfosByJoins(List<WorkflowJoin> currWorkflowJoins) {
        ArrayList<WorkflowNodeInfo> nodeInfos = new ArrayList<WorkflowNodeInfo>();
        Map<Long, List<WorkflowJoin>> workflowNodeIdToJoins = PlanningNotificationQueryHelper.groupWorkflowJoinsByWorkflowNode(currWorkflowJoins);
        for (Long workflowNodeId : workflowNodeIdToJoins.keySet()) {
            List<WorkflowJoin> workflowNodeJoins = workflowNodeIdToJoins.get(workflowNodeId);
            WorkflowJoin someNodeJoin = workflowNodeJoins.get(0);
            WorkflowNodeInfo nodeInfo = new WorkflowNodeInfo();
            nodeInfo.setWorkflowNode(someNodeJoin.getWorkflowNode());
            nodeInfo.setTemplate(someNodeJoin.getWorkflowNodeTemplate());
            List<WorkflowNodePositionInfo> workflowNodePositionInfos = PlanningNotificationQueryHelper.getWorkflowNodePositionInfosByJoins(workflowNodeJoins);
            nodeInfo.setPositionInfos(workflowNodePositionInfos);
            nodeInfos.add(nodeInfo);
        }
        return nodeInfos;
    }

    private static List<WorkflowNodePositionInfo> getWorkflowNodePositionInfosByJoins(List<WorkflowJoin> workflowNodeJoins) {
        ArrayList<WorkflowNodePositionInfo> nodePositionInfos = new ArrayList<WorkflowNodePositionInfo>();
        Map<Long, List<WorkflowJoin>> workflowNodePositionIdToJoins = PlanningNotificationQueryHelper.groupWorkflowJoinsByWorkflowNodePosition(workflowNodeJoins);
        for (Long workflowNodePositionId : workflowNodePositionIdToJoins.keySet()) {
            List<WorkflowJoin> workflowNodePositionJoins = workflowNodePositionIdToJoins.get(workflowNodePositionId);
            WorkflowNodePositionInfo nodePositionInfo = new WorkflowNodePositionInfo();
            WorkflowNodePosition workflowNodePosition = workflowNodePositionJoins.get(0).getWorkflowNodePosition();
            nodePositionInfo.setWorkflowNodePosition(workflowNodePosition);
            HashMap<Long, WorkflowToken> idToOwnerToken = new HashMap<Long, WorkflowToken>();
            HashMap<Long, WorkflowToken> idToInitiatorToken = new HashMap<Long, WorkflowToken>();
            HashMap<Long, WorkflowActivityPositionResult> idToResult = new HashMap<Long, WorkflowActivityPositionResult>();
            for (WorkflowJoin workflowNodePositionJoin : workflowNodePositionJoins) {
                Long resultId;
                WorkflowToken token = workflowNodePositionJoin.getWorkflowToken();
                Long tokenId = token.getId();
                if (tokenId != null) {
                    if (token.getOwnerPositionId() != null && token.getOwnerPositionId().longValue() == workflowNodePositionId.longValue()) {
                        idToOwnerToken.put(tokenId, token);
                    }
                    if (token.getInitiatorPositionId() != null && token.getInitiatorPositionId().longValue() == workflowNodePositionId.longValue()) {
                        idToInitiatorToken.put(tokenId, token);
                    }
                }
                if ((resultId = workflowNodePositionJoin.getWorkflowActivityPositionResultWorkflowActivityId()) == null) continue;
                idToResult.put(resultId, workflowNodePositionJoin.getWorkflowActivityPositionResult());
            }
            ArrayList ownerTokens = new ArrayList();
            ArrayList initiatorTokens = new ArrayList();
            ArrayList results = new ArrayList();
            ownerTokens.addAll(idToOwnerToken.values());
            initiatorTokens.addAll(idToInitiatorToken.values());
            results.addAll(idToResult.values());
            nodePositionInfo.setOwnerTokens(ownerTokens);
            nodePositionInfo.setInitiatorTokens(initiatorTokens);
            nodePositionInfo.setWorkflowActivityPositionResults(results);
            nodePositionInfos.add(nodePositionInfo);
        }
        return nodePositionInfos;
    }

    private static Map<Long, List<WorkflowJoin>> groupWorkflowJoinsByWorkflow(List<WorkflowJoin> workflowJoins) {
        HashMap<Long, List<WorkflowJoin>> workflowIdToJoins = new HashMap<Long, List<WorkflowJoin>>();
        for (WorkflowJoin workflowJoin : workflowJoins) {
            Long workflowId = workflowJoin.getWorkflowId();
            if (!workflowIdToJoins.containsKey(workflowId)) {
                workflowIdToJoins.put(workflowId, new ArrayList());
            }
            ((List)workflowIdToJoins.get(workflowId)).add(workflowJoin);
        }
        return workflowIdToJoins;
    }

    private static Map<Long, List<WorkflowJoin>> groupWorkflowJoinsByWorkflowEntity(List<WorkflowJoin> workflowJoins) {
        HashMap<Long, List<WorkflowJoin>> workflowEntityIdToJoins = new HashMap<Long, List<WorkflowJoin>>();
        for (WorkflowJoin workflowJoin : workflowJoins) {
            Long workflowEntityId = workflowJoin.getWorkflowEntityId();
            if (!workflowEntityIdToJoins.containsKey(workflowEntityId)) {
                workflowEntityIdToJoins.put(workflowEntityId, new ArrayList());
            }
            ((List)workflowEntityIdToJoins.get(workflowEntityId)).add(workflowJoin);
        }
        return workflowEntityIdToJoins;
    }

    private static Map<Long, List<WorkflowJoin>> groupWorkflowJoinsByWorkflowNode(List<WorkflowJoin> workflowJoins) {
        HashMap<Long, List<WorkflowJoin>> workflowNodeIdToJoins = new HashMap<Long, List<WorkflowJoin>>();
        for (WorkflowJoin workflowJoin : workflowJoins) {
            Long workflowNodeId = workflowJoin.getWorkflowNodeId();
            if (!workflowNodeIdToJoins.containsKey(workflowNodeId)) {
                workflowNodeIdToJoins.put(workflowNodeId, new ArrayList());
            }
            ((List)workflowNodeIdToJoins.get(workflowNodeId)).add(workflowJoin);
        }
        return workflowNodeIdToJoins;
    }

    private static Map<Long, List<WorkflowJoin>> groupWorkflowJoinsByWorkflowNodePosition(List<WorkflowJoin> workflowJoins) {
        HashMap<Long, List<WorkflowJoin>> workflowNodePositionIdToJoins = new HashMap<Long, List<WorkflowJoin>>();
        for (WorkflowJoin workflowJoin : workflowJoins) {
            Long workflowNodePositionId = workflowJoin.getWorkflowNodePositionId();
            if (!workflowNodePositionIdToJoins.containsKey(workflowNodePositionId)) {
                workflowNodePositionIdToJoins.put(workflowNodePositionId, new ArrayList());
            }
            ((List)workflowNodePositionIdToJoins.get(workflowNodePositionId)).add(workflowJoin);
        }
        return workflowNodePositionIdToJoins;
    }
}

