/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.email;

import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.voc.EmailSendMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

public class EmailHelper {
    public static boolean doSendEmail(OrganisationPerson organisationPerson) {
        EmailSendMode sendMode = EmailSendMode.getByValue((int)organisationPerson.getEmailSendMode());
        return sendMode != null && sendMode != EmailSendMode.NEVER && (organisationPerson.getRetiredFlag() == null || organisationPerson.getRetiredFlag() != true);
    }

    public static Double getNextEmailSendTime(OrganisationPerson organisationPerson) {
        EmailSendMode sendMode = EmailSendMode.getByValue((int)organisationPerson.getEmailSendMode());
        if (sendMode == null || sendMode == EmailSendMode.NEVER || organisationPerson.getRetiredFlag() != null && organisationPerson.getRetiredFlag().booleanValue()) {
            return null;
        }
        if (sendMode == EmailSendMode.ALWAYS || organisationPerson.getEmailSendTime() == null) {
            return (double)System.currentTimeMillis() / 1000.0;
        }
        Calendar now = Calendar.getInstance();
        int minuteOfDay = now.get(11) * 60 + now.get(12);
        GregorianCalendar ret = new GregorianCalendar(now.get(1), now.get(2), now.get(5), organisationPerson.getEmailSendTime() / 60, organisationPerson.getEmailSendTime() % 60);
        if (organisationPerson.getEmailSendTime() < minuteOfDay) {
            ((Calendar)ret).add(5, 1);
        }
        return (double)ret.getTimeInMillis() / 1000.0;
    }

    public static List<String> extractMailAddresses(String mailString) {
        String[] mailAddresses;
        ArrayList<String> retAddresses = new ArrayList<String>();
        if (mailString.contains(";")) {
            mailString = mailString.replaceAll(";", ",");
        }
        for (String mailAddress : mailAddresses = mailString.split(",")) {
            String trimmedMailAddress = mailAddress.trim();
            if (trimmedMailAddress.length() <= 0) continue;
            retAddresses.add(trimmedMailAddress);
        }
        return retAddresses;
    }
}

