/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.DigestCalculator;
import at.cdes.api.dto.ObjectList;
import at.cdes.api.dto.ObjectListRelease;
import at.cdes.api.dto.Signature;
import at.cdes.api.dto.SubProject;
import at.cdes.api.joinDto.ObjectListReleaseJoin;
import at.cdes.impl.dao.GenObjectListReleaseDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcObjectListReleaseDAO
extends AbstrIdDAO<ObjectListRelease>
implements GenObjectListReleaseDAO {
    public AbstractJdbcObjectListReleaseDAO() {
        super(ObjectListRelease.class, "id", "object_list_release", new String[]{"id", "version", "sub_project_id", "object_list_id", "digest", "digest_calculator_id", "signature_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcObjectListReleaseDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "version") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "sub_project_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "object_list_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "digest") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "digest_calculator_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "signature_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcObjectListReleaseDAO.getSelectClauseForDto("object_list_release", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcObjectListReleaseDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".version" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "version") + "," + entityLocalName + ".sub_project_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "sub_project_id") + "," + entityLocalName + ".object_list_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "object_list_id") + "," + entityLocalName + ".digest" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "digest") + "," + entityLocalName + ".digest_calculator_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "digest_calculator_id") + "," + entityLocalName + ".signature_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "signature_id") + " ";
    }

    protected ObjectListRelease fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        ObjectListRelease objectListRelease = new ObjectListRelease();
        objectListRelease.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectListRelease.setVersion(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        objectListRelease.setSubProjectId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectListRelease.setObjectListId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectListRelease.setDigest(rs.getString(++columnIndex));
        objectListRelease.setDigestCalculatorId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectListRelease.setSignatureId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return objectListRelease;
    }

    public static ObjectListRelease fillObjectListReleaseFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        ObjectListRelease objectListRelease = new ObjectListRelease();
        objectListRelease.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        objectListRelease.setVersion(JDBCHelper.getInt((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        objectListRelease.setSubProjectId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        objectListRelease.setObjectListId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        objectListRelease.setDigest(rs.getString(columnIndex.incrementAndGet()));
        objectListRelease.setDigestCalculatorId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        objectListRelease.setSignatureId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return objectListRelease;
    }

    public static ObjectListRelease fillObjectListReleaseFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcObjectListReleaseDAO.fillObjectListReleaseFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 7;
    }

    public static ObjectListReleaseJoin fillObjectListReleaseJoinFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        ObjectListReleaseJoin objectListReleaseJoin = new ObjectListReleaseJoin();
        objectListReleaseJoin.setObjectListReleaseId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectListReleaseJoin.setObjectListReleaseVersion(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        objectListReleaseJoin.setObjectListReleaseSubProjectId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectListReleaseJoin.setObjectListReleaseObjectListId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectListReleaseJoin.setObjectListReleaseDigest(rs.getString(++columnIndex));
        objectListReleaseJoin.setObjectListReleaseDigestCalculatorId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectListReleaseJoin.setObjectListReleaseSignatureId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectListReleaseJoin.setSignatureId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectListReleaseJoin.setSignatureTime(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        objectListReleaseJoin.setSignerPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectListReleaseJoin.setSignerPersonGivenName(rs.getString(++columnIndex));
        objectListReleaseJoin.setSignerPersonSurName(rs.getString(++columnIndex));
        return objectListReleaseJoin;
    }

    public static int getNumberOfObjectListReleaseJoinAttributes() {
        return 12;
    }

    protected String getSelectClauseForObjectListReleaseJoinUnion(String ... localNames) {
        String result = "";
        HashSet<String> localNamesSet = new HashSet<String>();
        for (int n = 0; n < localNames.length; ++n) {
            localNamesSet.add(localNames[n]);
        }
        result = localNamesSet.contains("objectListRelease") ? result + "object_list_release.id, object_list_release.version, object_list_release.sub_project_id, object_list_release.object_list_id, object_list_release.digest, object_list_release.digest_calculator_id, object_list_release.signature_id" : result + "NULL, NULL, NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("signature") ? result + "signature.id, signature.time" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("signerPerson") ? result + "signer_person.id, signer_person.givenName, signer_person.surName" : result + "NULL, NULL, NULL";
        return result;
    }

    public int update(ObjectListRelease dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<ObjectListRelease> dtos) {
        Iterator<ObjectListRelease> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    public static String getObjectListReleaseJoinSelectClause() {
        return "object_list_release.id, object_list_release.version, object_list_release.sub_project_id, object_list_release.object_list_id, object_list_release.digest, object_list_release.digest_calculator_id, object_list_release.signature_id, signature.id, signature.time, signer_person.id, signer_person.givenName, signer_person.surName ";
    }

    public static String getPrefixedObjectListReleaseJoinSelectClause() {
        return "object_list_release.id AS object_list_release_id, object_list_release.version AS object_list_release_version, object_list_release.sub_project_id AS object_list_release_sub_project_id, object_list_release.object_list_id AS object_list_release_object_list_id, object_list_release.digest AS object_list_release_digest, object_list_release.digest_calculator_id AS object_list_release_digest_calculator_id, object_list_release.signature_id AS object_list_release_signature_id, signature.id AS signature_id, signature.time AS signature_time, signer_person.id AS signer_person_id, signer_person.givenName AS signer_person_givenName, signer_person.surName AS signer_person_surName ";
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, ObjectListRelease objectListRelease) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)objectListRelease.getId());
        JDBCHelper.setInt((PreparedStatement)statement, (int)2, (Number)objectListRelease.getVersion());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)objectListRelease.getSubProjectId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)4, (Number)objectListRelease.getObjectListId());
        statement.setString(5, objectListRelease.getDigest());
        JDBCHelper.setLong((PreparedStatement)statement, (int)6, (Number)objectListRelease.getDigestCalculatorId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)7, (Number)objectListRelease.getSignatureId());
    }

    @Override
    public List<ObjectListRelease> getBySubProject(SubProject subProject) {
        return this.getBySubProject(subProject.getId());
    }

    @Override
    public List<ObjectListRelease> getBySubProject(final Long subProjectId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"sub_project_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, subProjectId);
            }
        });
    }

    @Override
    public List<ObjectListRelease> getByObjectList(ObjectList objectList) {
        return this.getByObjectList(objectList.getId());
    }

    @Override
    public List<ObjectListRelease> getByObjectList(final Long objectListId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"object_list_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, objectListId);
            }
        });
    }

    @Override
    public List<ObjectListRelease> getByDigestCalculator(DigestCalculator digestCalculator) {
        return this.getByDigestCalculator(digestCalculator.getId());
    }

    @Override
    public List<ObjectListRelease> getByDigestCalculator(final Long digestCalculatorId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"digest_calculator_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, digestCalculatorId);
            }
        });
    }

    @Override
    public List<ObjectListRelease> getBySignature(Signature signature) {
        return this.getBySignature(signature.getId());
    }

    @Override
    public List<ObjectListRelease> getBySignature(final Long signatureId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"signature_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, signatureId);
            }
        });
    }

    @Override
    public List<ObjectListRelease> getBySubProjects(Collection<Long> subProjectId) {
        if (subProjectId.isEmpty()) {
            return new ArrayList<ObjectListRelease>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[subProjectId.size()];
        int n = 0;
        Iterator<Long> it = subProjectId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"sub_project_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<ObjectListRelease> getByObjectLists(Collection<Long> objectListId) {
        if (objectListId.isEmpty()) {
            return new ArrayList<ObjectListRelease>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[objectListId.size()];
        int n = 0;
        Iterator<Long> it = objectListId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"object_list_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<ObjectListRelease> getByDigestCalculators(Collection<Long> digestCalculatorId) {
        if (digestCalculatorId.isEmpty()) {
            return new ArrayList<ObjectListRelease>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[digestCalculatorId.size()];
        int n = 0;
        Iterator<Long> it = digestCalculatorId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"digest_calculator_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<ObjectListRelease> getBySignatures(Collection<Long> signatureId) {
        if (signatureId.isEmpty()) {
            return new ArrayList<ObjectListRelease>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[signatureId.size()];
        int n = 0;
        Iterator<Long> it = signatureId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"signature_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

